!= deepconv/arare 絤ή׻Ѽץ ()
!
!= deepconv/arare main program for moist atmospheric convection (3D)
!
! Authors::   ̰ϯ(SUGIYAMA Ko-ichiro), ODAKA Masatsugu
! Version::   $Id: arare.f90,v 1.21 2011-06-21 06:14:52 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program deepconv_arare
  !
  ! ϳإǥ deepconv/arare 絤ή׻Ѽץ ()
  !

  ! ⥸塼  use statement 
  !

  ! gtool5 Ϣ 
  ! gtool5 modules
  !
  use dc_types,      only: STRING, DP
  use dc_message,    only: MessageNotify
  use gtool_history, only: HistoryPut
  use gtool_historyauto, only: HistoryAutoPut

  ! ⥸塼
  ! Initialize module
  !
  use mpi_wrapper, only : MPIWrapperInit, MPIWrapperFinalize, myrank
  use argset,   only: argset_init
  use clockset, only: ClocksetInit, ClocksetClose, ClocksetPredict, &
    &                 ClockSetPreStart, ClockSetLoopStart, ClockSetPreStop, ClockSetLoopStop
  use gridset,  only: gridset_init, imin, imax, jmin, jmax, kmin, kmax, nx, ny, nz, ncmax
  use timeset,  only: timeset_init, TimesetProgress, &
    &                 TimeA, TimeN, TimeB, NstepShort, &
    &                 EndTime, RestartTime, &
    &                 DelTimeLong, DelTimeShort, DelTimeOutput
  use axesset,  only: axesset_init, xyz_avr_pqz, xyz_avr_xqz, xyz_avr_xyr
  use constants,only: constants_init
  use composition, only: composition_init, SpcWetSymbol
  use fileset,  only: fileset_init
  use basicset, only: xyzf_QMixBZ, xyz_DensBZ, xyz_EffMolWtBZ, &
    &                 xyz_PTempBZ, xyz_TempBZ, xyz_PressBZ, &
    &                 xyz_VelSoundBZ, xyz_ExnerBZ 
  use ChemCalc, only: ChemCalc_init
  use namelist_util, only: NmlutilInit, namelist_filename

  ! ⥸塼
  ! Utility modules
  !
  use cflcheck, only : CFLCheckTimeShort, &
    &                  CFLCheckTimeLongVelX, &
    &                  CFLCheckTimeLongVelY, &
    &                  CFLCheckTimeLongVelZ
  use timefilter, only : AsselinFilter
  use damping, only: Damping_init, DampSponge_xyz, DampSponge_xyr, &
    &                DampSponge_pyz,DampSponge_xqz

  ! ϳز׻Ѵؿ⥸塼
  ! Dynamical processes module
  !
  use DynamicsHEVI, only: Dynamics_Init,  &
    &                      Dynamics_Long_forcing, Dynamics_Short_forcing
  use fillnegative,only: FillNegative_init

  ! ήȻ׻ѥ⥸塼
  ! Turbulent diffusion module
  !
  use Turbulence_kw1978,  only: Turbulence_kw1978_Init, Turbulence_KW1978_forcing

  ! Ͷ׻ѥ⥸塼
  ! Radiative forceing module
  !
  use Radiation_simple,  only: Radiation_simple_init, xyz_RadHeatConst, xyz_RadHeatVary
  use radiation_heatbalance, only: Radiation_heatbalance_init, Radiation_heatbalance_forcing

  ! Υեå׻ѥ⥸塼
  ! Surface flux module
  !
  use Surfaceflux_Diff, only: Surfaceflux_Diff_init, Surfaceflux_Diff_forcing
  use Surfaceflux_Bulk, only: Surfaceflux_Bulk_init, Surfaceflux_Bulk_forcing

  ! ׻ѥ⥸塼
  ! Moist processes modules
  !
  use Cloudphys_K1969, only: Cloudphys_K1969_Init, Cloudphys_K1969_forcing, &
    &                        Cloudphys_K1969_FallRain
  use Cloudphys_marscond, only: cloudphys_marscond_Init, cloudphys_marscond_forcing


  ! եϥ⥸塼
  ! File I/O module
  !
  use RestartFileIO, only : ReStartFileio_init, ReStartFileio_Finalize, &
    &                       ReStartFileio_BZ_Get, ReStartFileio_Var_Get, rstat
  use HistoryFileIO, only: HistoryFileio_init, HistoryFileio_Finalize
  
  implicit none

  ! ѿ
  ! Internal variables
  !
  real(DP), allocatable :: pyz_VelXBl(:,:,:)    
                             ! $ u (t-\Delta t) $  ; zonal wind
  real(DP), allocatable :: pyz_VelXNl(:,:,:)    
                             ! $ u (t) $           ; zonal wind
  real(DP), allocatable :: xyz_VelXNl(:,:,:)    
                             ! $ u (t) $           ; zonal wind
  real(DP), allocatable :: pyz_VelXAl(:,:,:)    
                             ! $ u (t+\Delta t) $  ; zonal wind
  real(DP), allocatable :: pyz_VelXNs(:,:,:)    
                             ! $ u (\tau) $  ; zonal wind
  real(DP), allocatable :: pyz_VelXAs(:,:,:)    
                             ! $ u (\tau +\Delta \tau) $  ; zonal wind
  real(DP), allocatable :: xqz_VelYBl(:,:,:)    
                             ! $ v (t-\Delta t) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYNl(:,:,:)    
                             ! $ v (t) $  ; meridonal wind
  real(DP), allocatable :: xyz_VelYNl(:,:,:)    
                             ! $ v (t) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYAl(:,:,:)    
                             ! $ v (t+\Delta t) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYNs(:,:,:)   
                             ! $ v (\tau -\tau) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYAs(:,:,:)
                             ! $ v (\tau) $  ; meridonal wind
  real(DP), allocatable :: xyr_VelZBl(:,:,:)    
                             ! $ w (t-\Delta t) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZNl(:,:,:)    
                             ! $ w (t) $ ľ ; vertical wind
  real(DP), allocatable :: xyz_VelZNl(:,:,:)    
                             ! $ w (t) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZAl(:,:,:)    
                             ! $ w (t+\Delta t) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZNs(:,:,:)    
                             ! $ w (\tau) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZAs(:,:,:) 
                             ! $ w (\tau +\Delta \tau)  ľ ; vertical wind
  real(DP), allocatable :: xyz_ExnerBl(:,:,:)   
                             ! $ \pi (t-\Delta t) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerNl(:,:,:)   
                             ! $ \pi (t) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerAl(:,:,:)
                             ! $ \pi (t+\Delta t) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerNs(:,:,:)   
                             ! $ \pi (\tau -\Delta \tau) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerAs(:,:,:)   
                             ! $ \pi (\tau) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_PTempBl(:,:,:) 
                             ! $ \theta (t-\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PTempNl(:,:,:) 
                             ! $ \theta (t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PTempAl(:,:,:) 
                             ! $ \theta (t+\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PTempNs(:,:,:) 
                             ! $ \theta (t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PTempAs(:,:,:) 
                             ! $ \theta (t+\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_CDensBl(:,:,:) 
                             ! $ \theta (t-\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_CDensNl(:,:,:) 
                             ! $ \theta (t) $  ; Potential temp.
  real(DP), allocatable :: xyz_CDensAl(:,:,:) 
                             ! $ \theta (t+\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_CDensNs(:,:,:) 
                             ! $ \theta (t) $  ; Potential temp.
  real(DP), allocatable :: xyz_CDensAs(:,:,:) 
                             ! $ \theta (t+\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_KmBl(:,:,:)
                             ! $ Km (t-\Delta t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KmNl(:,:,:)
                             ! $ K_m (t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KmAl(:,:,:)
                             ! $ K_m (t+\Delta t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KhBl(:,:,:)      
                             ! $ K_h (t-\Delta t) $ ήȻ
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KhNl(:,:,:)
                             ! $ K_h (t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KhAl(:,:,:)
                             ! $ K_h (t+\Delta t) $ ήȻ
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyzf_QMixBl(:,:,:,:) 
                             ! $ q (t-\Delta t) $ ̤κ
                             ! Mixing ratio of moist variables.
  real(DP), allocatable :: xyzf_QMixNl(:,:,:,:) 
                             ! $ q (t) $ ̤κ 
                             ! Mixing ratio of moist variables
  real(DP), allocatable :: xyzf_QMixAl(:,:,:,:) ! 
                             ! $ q (t+\Delta t) $ ̤κ 
                             !Mixing ratio of moist variables

  real(DP), allocatable :: pyz_DVelXDtNl(:,:,:)
  real(DP), allocatable :: xqz_DVelYDtNl(:,:,:)
  real(DP), allocatable :: xyr_DVelZDtNl(:,:,:)
  real(DP), allocatable :: xyz_DPTempDtNl(:,:,:)
  real(DP), allocatable :: xyz_DExnerDtNl(:,:,:)
  real(DP), allocatable :: xyz_DExnerDtNs(:,:,:)
  real(DP), allocatable :: xyzf_DQMixDtNl(:,:,:,:)
  real(DP), allocatable :: xyz_DKmDtNl(:,:,:)
  real(DP), allocatable :: xyz_DCDensDtNl(:,:,:)
  
  integer :: t, f   ! do 롼ѿ ; do loop variable 

  integer           :: IDTurbMethod = 0
  integer, parameter:: IDTurbMethodKW1978 = 2
  integer           :: IDRadMethod = 0
  integer, parameter:: IDRadMethodHeatConst = 1
  integer, parameter:: IDRadMethodHeatVary  = 2
  integer, parameter:: IDRadMethodHeatBalance = 3
  integer           :: IDSurfaceMethod = 0
  integer, parameter:: IDSurfaceMethodDiff = 1
  integer, parameter:: IDSurfaceMethodBulk = 2
  integer           :: IDCloudMethod = 0
  integer, parameter:: IDCloudMethodK1969 = 1
  integer, parameter:: IDCloudMethodMarsCond = 2


  !------------------------------------------
  ! ³ ; Initialize procedure 
  !
  call MainInit

  !------------------------------------------
  ! ʬ time integration 
  !
  if (myrank == 0) call MessageNotify( "M", "main", "Time Integration Start" )

  ! CPU ַ¬
  ! Start CPU time counting 
  !
  call ClocksetLoopStart
  
  ! ȯŸ롼פΥ
  !
  do while (TimeA <= EndTime + DelTimeLong) 
!    write(*,*) "LONG: ", TimeN, TimeA
    
    !-------------------------------
    ! ʪ: ή
    !
    select case ( IDTurbMethod )
      
    case ( IDTurbMethodKW1978 )
      call turbulence_KW1978_forcing(                      &
        &   pyz_VelXBl,  xqz_VelYBl,  xyr_VelZBl,          &!(in)
        &   xyz_PTempBl, xyz_ExnerBl, xyzf_QMixBl,         &!(in)
        &   xyz_KmBl,    xyz_KhBl,    xyz_CDensBl,         &!(in)
        &   pyz_DVelXDtNl, xqz_DVelYDtNl,  xyr_DVelZDtNl,  &!(inout)
        &   xyz_DPTempDtNl,xyz_DExnerDtNl, xyzf_DQMixDtNl, &!(inout)
        &   xyz_DKmDtNl,   xyz_DCDensDtNl,                 &!(inout)
        &   xyz_KmAl, xyz_KhAl                             &!(out)
        & )
    end select
    
    !-------------------------------
    ! ʪ: 
    !
    select case (IDRadMethod)
      
    case (IDRadMethodHeatConst)

      xyz_DPTempDtNl = xyz_DPTempDtNl + xyz_RadHeatConst
      call HistoryAutoPut(TimeN, 'PTempRad', xyz_RadHeatConst(1:nx,1:ny,1:nz))

    case (IDRadMethodHeatVary)

      xyz_DPTempDtNl = xyz_DPTempDtNl + xyz_RadHeatVary
      call HistoryAutoPut(TimeN, 'PTempRad', xyz_RadHeatVary(1:nx,1:ny,1:nz))

    case (IDRadMethodHeatBalance)
      call radiation_heatbalance_forcing( &
        &   xyz_ExnerNl, xyz_PTempNl, & !(in)
        &   xyz_DPTempDtNl, xyz_DExnerDtNl  & !(inout)
        & )

    end select

    !--------------------------------
    ! Ǯư͢
    !
    select case (IDSurfaceMethod)

    case (IDSurfaceMethodDiff)
      call Surfaceflux_Diff_forcing(   &
        &   xyz_PTempNl, xyzf_QMixNl, & !(in)
        &   xyz_DPTempDtNl, xyzf_DQMixDtNl   & !(out)
        & )
     
    case (IDSurfaceMethodBulk)
      call Surfaceflux_Bulk_forcing( &
        &   pyz_VelXNl, xqz_VelYNl, xyz_PTempNl, &!(in)
        &   xyz_ExnerNl, xyzf_QMixNl,            &!(in)
        &   pyz_DVelXDtNl, xqz_DVelYDtNl,        &!(inout)
        &   xyz_DPTempDtNl, xyzf_DQMixDtNl       &!(inout)
        & )
    end select


    !-----------------------------------------
    ! ŷ
    ! 
    !
    select case (IDCloudMethod)
    case (IDCloudMethodK1969)
      call CloudPhys_K1969_FallRain( & 
        &   xyzf_QMixNl,       & !(in)
        &   xyzf_DQMixDtNl     & !(inout)
        & )
    end select
    
    !-----------------------------------------
    ! ήȻ.
    ! Advection and diffusion
    !
    call Dynamics_Long_forcing(       &
      &   pyz_VelXBl,  pyz_VelXNl,    & ! (in)
      &   xqz_VelYBl,  xqz_VelYNl,    & ! (in)
      &   xyr_VelZBl,  xyr_VelZNl,    & ! (in)
      &   xyz_PTempBl, xyz_PTempNl,   & ! (in) 
      &   xyzf_QMixBl, xyzf_QMixNl,   & ! (in) mixing ratio  [kg/kg]
      &   xyz_KmBl,    xyz_KmNl,      & ! (in)
      &   xyz_CDensBl, xyz_CDensNl,   & ! (in) Cloud density [kg/m^-3]
      &   pyz_DVelXDtNl,              & ! (inout)
      &   xqz_DVelYDtNl,              & ! (inout)
      &   xyr_DVelZDtNl,              & ! (inout)
      &   xyz_DPTempDtNl,             & ! (inout)
      &   xyzf_DQMixDtNl,             & ! (inout)
      &   xyz_DKmDtNl,                & ! (inout)
      &   xyz_DCDensDtNl,             & ! (inout)
      &   xyz_PTempAl,                & ! (out)
      &   xyzf_QMixAl                 & ! (out)
      & )

    !------------------------------------------
    ! ŷ
    ! 
    select case (IDCloudMethod)
    case (IDCloudMethodK1969)
      call Cloudphys_K1969_forcing(   &
        &   xyz_ExnerNl,              &!(in)
        &   xyz_PTempAl, xyzf_QMixAl  &!(inout)
        & )
    end select

    ! û֥ƥåפνͺ.
    ! Initial values set up for time integration with short time step.
    !
    pyz_VelXNs  = pyz_VelXBl
    xqz_VelYNs  = xqz_VelYBl
    xyr_VelZNs  = xyr_VelZBl
    xyz_ExnerNs = xyz_ExnerBl
    xyz_PTempNs = xyz_PTempBl
    xyz_CDensNs = xyz_CDensBl

    ! û֥ƥåפλʬ. 顼ˡ.
    ! Time integration with short time step.
    !
    Euler: do t = 1, NstepShort
!      write(*,*) "SHORT", t

      ! ׻ξ. ŷ̤ɾϤǹԤ. 
      ! 
      select case (IDCloudMethod)
      case (IDCloudMethodMarsCond)

        call cloudphys_marscond_forcing(  &
          &   xyz_PTempNs,         &  !(in) 
          &   xyz_ExnerNs,         &  !(in) ʡؿ
          &   xyz_CDensNs,         &  !(in) 
          &   xyz_DPTempDtNl,      &  !(in)    
          &   xyz_DExnerDtNl,      &  !(in)    
          &   xyz_DCDensDtNl,      &  !(in)    
          &   xyz_PTempAs,         &  !(out) 
          &   xyz_CDensAs,         &  !(out) ̩
          &   xyz_DExnerDtNs       &  !(out) 
          & )

      end select

      ! ۲ˡ: ® u, v η׻.
      ! Time integration horizontal velocity (u).
      !
      call Dynamics_Short_forcing(         &
        &   pyz_VelXNs,          & ! (in)
        &   xqz_VelYNs,          & ! (in)
        &   xyr_VelZNs,          & ! (in)
        &   xyz_ExnerNs,         & ! (in)
        &   pyz_DVelXDtNl,       & ! (in)
        &   xqz_DVelYDtNl,       & ! (in)
        &   xyr_DVelZDtNl,       & ! (in)
        &   xyz_DExnerDtNs,      & ! (in)
        &   pyz_VelXAs,          & ! (out)
        &   xqz_VelYAs,          & ! (out)
        &   xyr_VelZAs,          & ! (out)
        &   xyz_ExnerAs          & ! (out)
        & )

      ! û֥ƥåפΥ롼פ󤹤ν
      ! Renew prognostic variables for next short time step integration.
      !
      xyz_ExnerNs  = xyz_ExnerAs
      pyz_VelXNs   = pyz_VelXAs
      xqz_VelYNs   = xqz_VelYAs
      xyr_VelZNs   = xyr_VelZAs
      xyz_PTempNs  = xyz_PTempAs
      xyz_CDensNs  = xyz_CDensAs
      xyz_DExnerDtNs = 0.0d0

    end do Euler
    
    ! ǽŪû֥ƥåפǤͤĹ֥ƥåפǤͤȤߤʤ
    ! Renew prognostic variables for next long time step integration.
    !
    xyz_ExnerAl  = xyz_ExnerAs
    pyz_VelXAl   = pyz_VelXAs
    xqz_VelYAl   = xqz_VelYAs
    xyr_VelZAl   = xyr_VelZAs
    select case (IDCloudMethod)
    case (IDCloudMethodMarsCond)
      xyz_PTempAl = xyz_PTempAs
      xyz_CDensAl = xyz_CDensAs
    end select
   
    !
    ! clear tendency
    !
    pyz_DVelXDtNl = 0.0d0
    xqz_DVelYDtNl = 0.0d0
    xyr_DVelZDtNl = 0.0d0
    xyz_DKmDtNl   = 0.0d0
    xyz_DPTempDtNl = 0.0d0
    xyz_DExnerDtNl = 0.0d0
    xyz_DCDensDtNl = 0.0d0
    xyzf_DQMixDtNl = 0.0d0

    ! ֥ե륿. 
    ! Time filter. 
    !
    if (RestartTime /= 0.0d0 .OR. TimeN /= 0.0d0) then 
      call AsselinFilter( &
        & pyz_VelXAl,     & ! (in)
        & pyz_VelXNl,     & ! (inout)
        & pyz_VelXBl      & ! (in)
        & )
      call AsselinFilter( &
        & xqz_VelYAl,     & ! (in)
        & xqz_VelYNl,     & ! (inout)
        & xqz_VelYBl      & ! (in)
        & )
      call AsselinFilter( &
        & xyr_VelZAl,     & ! (in)
        & xyr_VelZNl,     & ! (inout)
        & xyr_VelZBl      & ! (in)
        & )
      call AsselinFilter( &
        & xyz_PTempAl,  & ! (in)
        & xyz_PTempNl,  & ! (inout)
        & xyz_PTempBl   & ! (in)
        & )
      call AsselinFilter( &
        &  xyz_ExnerAl,   & ! (in)
        &  xyz_ExnerNl,   & ! (inout)
        &  xyz_ExnerBl    & ! (in)
        & )         
      call AsselinFilter( &
        & xyz_KmAl,       & ! (in)
        & xyz_KmNl,       & ! (inout)
        & xyz_KmBl        & ! (in)
        & )
      call AsselinFilter( &
        & xyz_CDensAl,       & ! (in)
        & xyz_CDensNl,       & ! (inout)
        & xyz_CDensBl        & ! (in)
        & )
      do f = 1, ncmax
        call AsselinFilter(         &
          &   xyzf_QMixAl(:,:,:,f), &
          &   xyzf_QMixNl(:,:,:,f), &
          &   xyzf_QMixBl(:,:,:,f)  &
          & )
      end do
    end if

    ! ݥ
    ! Numerical dumping.
    !
    call DampSponge_pyz( pyz_VelXAl,  pyz_VelXBl )
    call DampSponge_xqz( xqz_VelYAl,  xqz_VelYBl )
    call DampSponge_xyr( xyr_VelZAl,  xyr_VelZBl )
    call DampSponge_xyz( xyz_PTempAl, xyz_PTempBl )
    call DampSponge_xyz( xyz_ExnerAl, xyz_ExnerBl )
    call DampSponge_xyz( xyz_KmAl,    xyz_KmBl )
    
    ! ήФ CFL Υå 
    ! CFL condtion check for advection
    !
!    call CFLCheckTimeLongVelX( pyz_VelXNl ) !(in)
!    call CFLCheckTimeLongVelY( xqz_VelYNl ) !(in)
!    call CFLCheckTimeLongVelZ( xyr_VelZNl ) !(in)

    ! ҥȥե.
    ! Out put to history file.
    !
    xyz_VelXNl = xyz_avr_pqz(pyz_VelXNl)
    xyz_VelYNl = xyz_avr_xqz(xqz_VelYNl)
    xyz_VelZNl = xyz_avr_xyr(xyr_VelZNl)

    call HistoryAutoPut(TimeN, 'PTemp', xyz_PTempNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'PTempAll', xyz_PTempNl(1:nx, 1:ny, 1:nz) + xyz_PTempBZ(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'Exner', xyz_ExnerNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'ExnerAll', xyz_ExnerNl(1:nx, 1:ny, 1:nz) + xyz_ExnerBZ(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'VelX',  xyz_VelXNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'VelY',  xyz_VelYNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'VelZ',  xyz_VelZNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'Km',    xyz_KmNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'Kh',    xyz_KhNl(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'CDens', xyz_CDensNl(1:nx, 1:ny, 1:nz))
    do f = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f)), xyzf_QMixNl(1:nx, 1:ny, 1:nz, f))
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'All', xyzf_QMixNl(1:nx, 1:ny, 1:nz, f) + xyzf_QMixBZ(1:nx, 1:ny, 1:nz, f))
    end do
    
    !----------------------------------------------------
    ! ꥹȥեκ
    ! Make restartfile.
    !    
    if (TimeN /= RestartTime .AND. &
      & mod((TimeA - RestartTime), DelTimeOutput) == 0) then 

      ! ե
      !
      call HistoryPut( 't',     TimeN,       rstat)
      call HistoryPut( 'VelX',  pyz_VelXNl,  rstat)
      call HistoryPut( 'VelY',  xqz_VelYNl,  rstat)
      call HistoryPut( 'VelZ',  xyr_VelZNl,  rstat)
      call HistoryPut( 'Exner', xyz_ExnerNl, rstat)
      call HistoryPut( 'PTemp', xyz_PTempNl, rstat)
      call HistoryPut( 'Km',    xyz_KmNl,    rstat)
      call HistoryPut( 'Kh',    xyz_KhNl,    rstat)
      call HistoryPut( 'CDens', xyz_CDensNl, rstat)
      call HistoryPut( 'QMix',  xyzf_QMixNl, rstat)    

      call HistoryPut( 't',     TimeA,       rstat)
      call HistoryPut( 'VelX',  pyz_VelXAl,  rstat)
      call HistoryPut( 'VelY',  xqz_VelYAl,  rstat)
      call HistoryPut( 'VelZ',  xyr_VelZAl,  rstat)
      call HistoryPut( 'Exner', xyz_ExnerAl, rstat)
      call HistoryPut( 'PTemp', xyz_PTempAl, rstat)
      call HistoryPut( 'Km',    xyz_KmAl,    rstat)
      call HistoryPut( 'Kh',    xyz_KhAl,    rstat)
      call HistoryPut( 'CDens', xyz_CDensAl, rstat)
      call HistoryPut( 'QMix',  xyzf_QMixAl, rstat) 

      ! Show CPU time 
      ! 
      call ClocksetPredict
      
    end if

    ! Ĺ֥ƥåפΥ롼פ󤹤ν.
    ! Renew prognostic variables for next long time step integration.
    !
    pyz_VelXBl  = pyz_VelXNl;  pyz_VelXNl  = pyz_VelXAl
    xqz_VelYBl  = xqz_VelYNl;  xqz_VelYNl  = xqz_VelYAl
    xyr_VelZBl  = xyr_VelZNl;  xyr_VelZNl  = xyr_VelZAl
    xyz_PTempBl = xyz_PTempNl; xyz_PTempNl = xyz_PTempAl
    xyz_ExnerBl = xyz_ExnerNl; xyz_ExnerNl = xyz_ExnerAl
    xyz_KmBl    = xyz_KmNl;    xyz_KmNl    = xyz_KmAl
    xyz_KhBl    = xyz_KhNl;    xyz_KhNl    = xyz_KhAl
    xyz_CDensBl = xyz_CDensNl; xyz_CDensNl = xyz_CDensAl
    xyzf_QMixBl = xyzf_QMixNl; xyzf_QMixNl = xyzf_QMixAl

    ! οʹ
    ! Progress time
    !
    call TimesetProgress

  end do

  !----------------------------------------------------
  ! ϥեΥ
  ! Close out put files.
  !
  call HistoryFileio_finalize
  call ReStartFileio_finalize

  !----------------------------------------------------
  ! MPI END
  !
  call MPIWrapperFinalize

  !----------------------------------------------------
  ! CPU Time
  ! 
  call ClocksetLoopStop
  call ClocksetClose
  
contains
!-----------------------------------------------------------------------
  subroutine VariableAllocate
    !
    !Ȥ, , ͤȤƥ.
    !

    !ۤηػ
    implicit none

    !
    allocate( pyz_VelXBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( pyz_VelXNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_VelXNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( pyz_VelXAl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( pyz_VelXNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( pyz_VelXAs(imin:imax,jmin:jmax,kmin:kmax) )

    pyz_VelXBl  = 0.0d0;    pyz_VelXNl  = 0.0d0;    pyz_VelXAl  = 0.0d0
    pyz_VelXNs  = 0.0d0;    pyz_VelXAs = 0.0d0    
    xyz_VelXNl  = 0.0d0

    allocate( xqz_VelYBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xqz_VelYNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_VelYNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xqz_VelYAl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xqz_VelYNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xqz_VelYAs(imin:imax,jmin:jmax,kmin:kmax) )

    xqz_VelYBl  = 0.0d0;    xqz_VelYNl  = 0.0d0;    xqz_VelYAl  = 0.0d0
    xqz_VelYNs  = 0.0d0;    xqz_VelYAs = 0.0d0    
    xyz_VelYNl  = 0.0d0

    allocate( xyr_VelZBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_VelZNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_VelZNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_VelZAl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_VelZNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_VelZAs(imin:imax,jmin:jmax,kmin:kmax) )

    xyr_VelZBl  = 0.0d0;    xyr_VelZNl  = 0.0d0;    xyr_VelZAl  = 0.0d0
    xyr_VelZNs  = 0.0d0;    xyr_VelZAs = 0.0d0
    xyz_VelZNl  = 0.0d0

    allocate( xyz_ExnerBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_ExnerNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_ExnerAl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_ExnerNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_ExnerAs(imin:imax,jmin:jmax,kmin:kmax) )

    xyz_ExnerBl = 0.0d0;    xyz_ExnerNl = 0.0d0;    xyz_ExnerAl = 0.0d0
    xyz_ExnerNs = 0.0d0;    xyz_ExnerAs = 0.0d0

    allocate( xyz_PTempBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_PTempNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_PTempAl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_PTempNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_PTempAs(imin:imax,jmin:jmax,kmin:kmax) )

    xyz_PTempBl = 0.0d0;  xyz_PTempNl = 0.0d0;  xyz_PTempAl = 0.0d0
    xyz_PTempNs = 0.0d0;  xyz_PTempAs = 0.0d0

    allocate( xyz_CDensBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_CDensNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_CDensAl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_CDensNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_CDensAs(imin:imax,jmin:jmax,kmin:kmax) )

    xyz_CDensBl = 0.0d0;  xyz_CDensNl = 0.0d0;  xyz_CDensAl = 0.0d0
    xyz_CDensNs = 0.0d0;  xyz_CDensAs = 0.0d0

    allocate( xyz_KmBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_KmNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_KmAl(imin:imax,jmin:jmax,kmin:kmax) )

    xyz_KmBl    = 0.0d0;    xyz_KmNl    = 0.0d0;    xyz_KmAl    = 0.0d0

    allocate( xyz_KhBl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_KhNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_KhAl(imin:imax,jmin:jmax,kmin:kmax) )

    xyz_KhBl    = 0.0d0;    xyz_KhNl    = 0.0d0;    xyz_KhAl    = 0.0d0

    allocate( xyzf_QMixBl(imin:imax,jmin:jmax,kmin:kmax,ncmax) )
    allocate( xyzf_QMixNl(imin:imax,jmin:jmax,kmin:kmax,ncmax) )
    allocate( xyzf_QMixAl(imin:imax,jmin:jmax,kmin:kmax,ncmax) )

    xyzf_QMixBl = 0.0d0;   xyzf_QMixNl = 0.0d0;   xyzf_QMixAl = 0.0d0

    allocate( pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xqz_DVelYDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_DKmDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_DPTempDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_DExnerDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_DExnerDtNs(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_DCDensDtNl(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyzf_DQMixDtNl(imin:imax,jmin:jmax,kmin:kmax,ncmax) )

    pyz_DVelXDtNl = 0.0d0
    xqz_DVelYDtNl = 0.0d0
    xyr_DVelZDtNl = 0.0d0
    xyz_DKmDtNl   = 0.0d0
    xyz_DPTempDtNl = 0.0d0
    xyz_DExnerDtNl = 0.0d0
    xyz_DExnerDtNs = 0.0d0
    xyz_DCDensDtNl = 0.0d0
    xyzf_DQMixDtNl = 0.0d0

  end subroutine VariableAllocate
  
  !-----------------------------------------------------------------------
  subroutine MainInit
    
    implicit none

    character(STRING) :: cfgfile
                             ! NAMELIST ե̾ ; NAMELIST fine name

    ! MPI
    !
    call MPIWrapperInit

    ! ַ¬
    !
    call ClocksetInit
    call ClocksetPreStart
    
    ! NAMELIST ե̾ɤ߹
    ! Loading NAMELIST file.
    !
    call argset_init( cfgfile ) !(out)

    ! NAMELIST ե̾Υ⥸塼ؤϿ
    ! Loading NAMELIST file.
    !
    call NmlutilInit( cfgfile ) !(in)
    
    ! ʬν
    ! Initialization of time integration.
    !
    call timeset_init

    ! ʻν
    ! Initialization of grid arrangement.
    !
    call gridset_init
    
    ! ط׻롼ν
    ! Initialization of chemical routines.
    !
    call chemcalc_init
    
    ! ξν
    ! Initialization of constant variables.
    !
    call constants_init

    ! ξν
    ! Initialization of axis variables.
    !
    call axesset_init
    
    ! I/O ե̾ν
    ! Initialization of output file name. 
    !
    call fileset_init
    
    ! ͭѿν
    ! Initialization of common variables for moist process.
    !
    call composition_init

    ! ҥȥ꡼ե롦ꥹȥեν
    ! Initialize restart & history files.
    !
    call HistoryFileio_init
    call ReStartFileio_init

    ! ໤ν
    ! Initialization of numerical friction coefficient.
    !
    call Damping_Init
   
    ! ѿν
    ! Initialization of internal variables.
    !
    call VariableAllocate

    ! ͤ 
    ! * ReStartFile ꤵƤˤϥեɤ߹. 
    !   ꤵƤʤˤϥǥեȤδܾȾ. 
    !
    ! Initial value set up.
    ! * Read restartfile if it is specified. If not, make default basic
    !   state and disturbance.
    !
    if (myrank == 0) call MessageNotify( "M", "main", "Initial value setup." )

    ! ܾ, νͤ netCDF ե뤫.
    ! 
    call ReStartFileio_BZ_Get
    call ReStartFileio_Var_Get(     &
      & pyz_VelXBl,  pyz_VelXNl,    & ! (out)
      & xqz_VelYBl,  xqz_VelYNl,    & ! (out)
      & xyr_VelZBl,  xyr_VelZNl,    & ! (out)
      & xyz_PTempBl, xyz_PTempNl,   & ! (out)
      & xyz_ExnerBl, xyz_ExnerNl,   & ! (out)
      & xyzf_QMixBl, xyzf_QMixNl,   & ! (out)
      & xyz_KmBl,    xyz_KmNl,      & ! (out)
      & xyz_KhBl,    xyz_KhNl,      & ! (out)
      & xyz_CDensBl, xyz_CDensNl    & ! (out)
      & )
    
    ! ϳإ⥸塼ν
    ! Initialization of dynamical modules
    !
    call Dynamics_init
    
    ! μ̤Ŷ׻ν
    ! Initialization of negative moist value correction.
    !
    call FillNegative_Init
   
    ! ʪ
    !
    call deepconv_main

    !-------------------------------------------------------------
    ! ܾΥե
    !
    call HistoryPut( 'DensBZ',   xyz_DensBZ     , rstat)
    call HistoryPut( 'ExnerBZ',  xyz_ExnerBZ    , rstat)
    call HistoryPut( 'PTempBZ',  xyz_PTempBZ  , rstat)
    call HistoryPut( 'VelSoundBZ', xyz_VelSoundBZ , rstat)
    call HistoryPut( 'TempBZ',    xyz_TempBZ     , rstat)
    call HistoryPut( 'PressBZ',   xyz_PressBZ    , rstat)
    call HistoryPut( 'QMixBZ',    xyzf_QMixBZ  , rstat)
    call HistoryPut( 'EffMolWtBZ', xyz_EffMolWtBZ, rstat)
    
    ! ȤФ CFL Υå
    ! CFL condtion check for sound wave.
    !
!    call CFLCheckTimeShort( &
!      & xyz_VelSoundBZ   & ! (in)
!      & )

    ! CPU time
    !
    call ClocksetPreStop
    
  end subroutine MainInit
  

  subroutine deepconv_main

    use dc_message,    only: MessageNotify
    use dc_iounit,     only : FileOpen    

    implicit none

    integer  :: unit     !ֹ
    character(STRING)  :: FlagTurbMethod     = ""
    character(STRING)  :: FlagRadMethod      = ""
    character(STRING)  :: FlagCloudMethod = ""
    character(STRING)  :: FlagSurfaceMethod = ""

    NAMELIST /deepconv_main_nml / &
      & FlagTurbMethod,           &
      & FlagRadMethod,            &
      & FlagCloudMethod,       &
      & FlagSurfaceMethod

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=deepconv_main_nml)
    close(unit)

    if (FlagTurbMethod == "KW1978") then
      IDTurbMethod = IDTurbMethodKW1978 
      call turbulence_kw1978_init
    end if

    if (FlagRadMethod == "HeatConst") then 
      IDRadMethod = IDRadMethodHeatConst 
      call Radiation_Simple_init

    elseif (FlagRadMethod == "HeatVary") then 
      IDRadMethod = IDRadMethodHeatVary
      call Radiation_Simple_init

    elseif (FlagRadMethod == "HeatBalance") then 
      IDRadMethod = IDRadMethodHeatBalance
      call radiation_heatbalance_init
    end if

    if (FlagSurfaceMethod == "Diff") then 
      IDSurfaceMethod = IDSurfaceMethodDiff
      call Surfaceflux_Diff_init

    elseif (FlagSurfaceMethod == "Bulk") then 
      IDSurfaceMethod = IDSurfaceMethodBulk
      call Surfaceflux_Bulk_init

    end if

    if (FlagCloudMethod == "K1969") then 
      IDCloudMethod = IDCloudMethodK1969
      call cloudphys_K1969_init

    elseif (FlagCloudMethod == "MarsCond") then 
      IDCloudMethod = IDCloudMethodMarsCond
      call cloudphys_marscond_init
    end if

    if (myrank == 0) then 
      call MessageNotify( "M", "main", "FlagTurbMethod    = %c", c1=trim(FlagTurbMethod))
      call MessageNotify( "M", "main", "IDTurbMethod      = %d", i=(/IDTurbMethod/))
      call MessageNotify( "M", "main", "FlagRadMethod     = %c", c1=trim(FlagRadMethod))
      call MessageNotify( "M", "main", "IDRadMethod       = %d", i=(/IDRadMethod/))
      call MessageNotify( "M", "main", "FlagSurfaceMethod = %c", c1=trim(FlagSurfaceMethod))
      call MessageNotify( "M", "main", "IDSurfaceMethod   = %d", i=(/IDSurfaceMethod/))
      call MessageNotify( "M", "main", "FlagCloudMethod   = %c", c1=trim(FlagCloudMethod))
      call MessageNotify( "M", "main", "IDCloudMethod     = %d", i=(/IDCloudMethod/))
    end if

  end subroutine deepconv_main

      
end program deepconv_arare
