!= Module HistoryFileIO
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: historyfileio.f90,v 1.6 2011-06-17 19:07:26 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ե. Ĺ֥ƥåפͤ.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module HistoryFileIO
  !
  !ե. Ĺ֥ƥåפͤ.
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use gtool_historyauto, only: HistoryAutoCreate, HistoryAutoClose, &
    & HistoryAutoAddAttr, HistoryAutoAddWeight, HistoryAutoPutAxis, &
    & HistoryAutoAddVariable

  ! ե
  ! File I/O support
  !
  use dc_iounit, only: FileOpen
  
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN,  &  ! .   Keywords. 
    &                 STDOUT     ! ɸϤֹ. Unit number of standard output
  use mpi_wrapper, only: FLAG_LIB_MPI
  use namelist_util, only: namelist_filename

  use axesset,  only: x_X, y_Y, z_Z
  use gridset,  only: nx, ny, nz, ncmax
  use fileset,  only: filetitle,        &!ǡɽ
    &                 filesource,       &!ǡ
    &                 FileInstitution    !ǽѹԡȿ
  use timeset,  only: Restarttime, EndTime
  use composition, only: SpcWetSymbol

  !ۤηػ
  implicit none
  
  !°λ
  private

  !³
  public HistoryFileIO_init
  public HistoryFileIO_finalize

  ! ѿ
  ! Private variables
  !
  character(STRING), parameter:: module_name = 'historyfileio'
                              ! ⥸塼̾. 
                              ! Module name
  character(STRING), parameter:: version = &
    & '$Name: arare5-20110623-2 $' // &
    & '$Id: historyfileio.f90,v 1.6 2011-06-17 19:07:26 sugiyama Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains 

!!!------------------------------------------------------------------------
  subroutine HistoryFileIO_init
    !
    ! history_file_io ⥸塼νԤޤ. 
    !--
    ! NAMELIST#history_file_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "history_file_io" module is initialized. 
    !--
    ! "NAMELIST#history_file_io_nml" is loaded in this procedure. 
    !++
    !

    ! ⥸塼 ; USE statements
    !

    ! gtool5 netCDF ǡϥ󥿡ե (絬ϥǥ)
    ! Interface of Input/Output of gtool5 netCDF data (For large models)
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    
    !ѿ
    real(DP), parameter       :: TimeDisp = 1.0e5 !ϴֳ֤Υǥե
    integer :: l

    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------
    call HistoryAutoCreate(                             &
      & title = FileTitle,                              &
      & source = FileSource,                            &
      & institution = FileInstitution,                  &
      & dims=(/'x','y','z','t'/),                       &
      & dimsizes=(/nx, ny, nz, 0/),                     &
      & longnames=(/'x-coordinate',                     &
      &             'y-coordinate',                     &
      &             'z-coordinate',                     &
      &             'time        '/),                   &
      & units=(/'m  ','m  ','m  ','sec'/),              &
      & xtypes=(/'double','double','double','double'/), &
      & origin   = Restarttime,                         & 
      & terminus = EndTime,                             &
      & interval = TimeDisp,                            &       
      & flag_mpi_split = FLAG_LIB_MPI,                  &
!      & file_prefix = "deepconv",                & 
      & namelist_filename = namelist_filename)  

    call HistoryAutoAddAttr( &
      & varname = 'x', attrname = 'standard_name', &   ! (in)
      & value = 'x-coordinate' )                       ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'y', attrname = 'standard_name', &   ! (in)
      & value = 'y-coordinate' )                       ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'z', attrname = 'standard_name', &   ! (in)
      & value = 'z-coordinate' )                       ! (in)
    
    call HistoryAutoPutAxis('x', x_X(1:nx))
    call HistoryAutoPutAxis('y', y_Y(1:ny))
    call HistoryAutoPutAxis('z', z_Z(1:nz))

    !  ; Print
    !
!    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    !̵Ϥξ
    call HistoryAutoAddVariable(  &
      & varname='Exner',      &  
      & dims=(/'x','y','z','t'/), &
      & longname='disturbunce of nondimensional pressure', &
      & units=' ',            &        
      & xtype='double' )

    !̵
    call HistoryAutoAddVariable(  &
      & varname='ExnerAll',      &  
      & dims=(/'x','y','z','t'/), &
      & longname='nondimensional pressure', &
      & units=' ',            &        
      & xtype='double' )
    
    !̤ξ
    call HistoryAutoAddVariable(  &
      & varname='PTemp',    &
      & dims=(/'x','y','z','t'/), &
      & longname='disturbunce of potential temperature',  &
      & units='K',            &
      & xtype='double' )

    !̤ξ
    call HistoryAutoAddVariable(  &
      & varname='PTempAll',    &
      & dims=(/'x','y','z','t'/), &
      & longname='potential temperature',  &
      & units='K',            &
      & xtype='double' )

    !ʿ®
    call HistoryAutoAddVariable(  &
      & varname='VelX',       &
      & dims=(/'x','y','z','t'/), &
      & longname='zonal velocity', &
      & units='m.s-1',      &
      & xtype='double' )

    !ʿ®
    call HistoryAutoAddVariable(  &
      & varname='VelY',       &
      & dims=(/'x','y','z','t'/), &
      & longname='zonal velocity', &
      & units='m.s-1',      &
      & xtype='double' )

    !ľ®
    call HistoryAutoAddVariable(  &
      & varname='VelZ',       &
      & dims=(/'x','y','z','t'/), &
      & longname='vertical velocity', &
      & units='m.s-1',      &
      & xtype='double' )

    !Ǵ(ư)
    call HistoryAutoAddVariable(  &
      & varname='Km',         &
      & dims=(/'x','y','z','t'/), &
      & longname='turbulet diffusion coefficient', &
      & units='m2.s-1',            &
      & xtype='double' )
  
    !Ǵ(Ǯ)
    call HistoryAutoAddVariable(  &
      & varname='Kh',         &
      & dims=(/'x','y','z','t'/), &
      & longname='turbulet diffusion coefficient for heat', &
      & units='m2.s-1',            &
      & xtype='double')

    !Ǵ(Ǯ)
    call HistoryAutoAddVariable(  &
      & varname='CDens',          &
      & dims=(/'x','y','z','t'/), &
      & longname='Cloud density', &
      & units='kg.m-3',           &
      & xtype='double')
  
    !
    do l = 1, ncmax
      call HistoryAutoAddVariable(                         &
        & varname=trim(SpcWetSymbol(l)),                   &
        & dims=(/'x','y','z','t'/),                        &
        & longname=trim(SpcWetSymbol(l))//' Mixing Ratio', &
        & units='kg.kg-1',                                 &
        & xtype='double')

      call HistoryAutoAddVariable(                         &
        & varname=trim(SpcWetSymbol(l))//'All',            &
        & dims=(/'x','y','z','t'/),                        &
        & longname=trim(SpcWetSymbol(l))//' Mixing Ratio', &
        & units='kg.kg-1',                                 &
        & xtype='double')
    end do
    
  end subroutine HistoryFileIO_init


  subroutine HistoryFileIO_finalize
    !
    ! ҥȥǡեϤνλԤޤ. 
    !
    ! Terminate history data files output. 

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    call HistoryAutoClose

  end subroutine HistoryFileIO_finalize
  
end module HistoryFileIO
