!= Module BasicEnvInit
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: initialdata_toon2002.f90,v 1.1 2011-06-17 19:13:50 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥեȤδܾꤹ뤿ѿȷ⥸塼
!   * BasicEnvFile_init: ܾͤ netCDF ե뤫
!   * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
module initialdata_Toon2002
  !
  !ǥեȤδܾꤹ뤿Υ֥롼. 
  !ܾ׻, BasicSet ⥸塼ͤ. 
  !
  !ѥν꤫, ܾ(hogeBasicZ ѿ)
  !׻ʬBasicSet ⥸塼뤫ڤΥƤ. 
  !ECCM Ϥ, BasicSet Τ˰¸뤬 hogeBasicZ  use ʤ
  !֥롼Ѥ뤿Ǥ. 
  !

  !⥸塼ɤ߹
  use dc_types,   only: STRING, DP
  use dc_iounit,   only : FileOpen      
  use dc_message, only: MessageNotify
!  use mpi_wrapper, only: myrank         
  use gridset,  only: kmin,       &! Z β
    &                 kmax,       &! Z ξ
    &                 nz
  use axesset, only:  z_Z,        &!顼ʻǤι
    &                 z_dz         !Z γʻֳ
  use constants, only: &
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 Grav,          &!ϲ®
    &                 TempSfc,       &!ɽ̲
    &                 PressSfc        !ɽ̰
 
  !ۤηػ
  implicit none

  !ǥեȤ private
  private

  real(DP), parameter  :: AntA    = 27.4d0 
  real(DP), parameter  :: AntB    = 3103.0d0
  real(DP), parameter  :: TempLTP = 135.0d0


  !
  public  initialdata_Toon2002_basic

contains

!!!------------------------------------------------------------------------------!!!

  subroutine initialdata_toon2002_basic( z_Temp, z_Press )

    implicit none
    
    real(DP), intent(out):: z_Press(kmin:kmax)           !
    real(DP), intent(out):: z_Temp(kmin:kmax)            !
    real(DP)             :: TempLCL
    real(DP)             :: Temp_0,  Temp_1
    real(DP)             :: Press_0, Press_1
    real(DP)             :: LCL, LTP
    integer              :: k


    ! Ǯ, Ǯ, ٤׻,
    ! ΰΩļѤƲ, Ϥ׻
    ! ǮȼǮ(LCL)ȿˡǷ׻
    !
    Press_0 = PressSfc
    Temp_0 = TempSfc
    do
      ! ˰² (press0 Ф): ǽɽ̤Ǥ˰².
      ! ln(p) = A - B/T
      Temp_1 = AntB / (AntA - dlog(Press_0))
      
      ! ǮŪ˷᤿ 
      !
      Press_1 = PressSfc * (Temp_1/TempSfc) **(CpDry / GasRDry)


      if (abs(Temp_1 - Temp_0) < epsilon(0.0d0)) then
        LCL = (TempSfc * CpDry) / Grav &
          & * (1.0d0 - (Press_1 / PressSfc)**(GasRDry / CpDry))
        TempLCL = temp_1

        exit
      else
        Temp_0 = Temp_1
        Press_0 = Press_1
      end if
    end do


    ! Ǯ(LTP)׻
    !
    LTP = LCL + GasRDry * AntB / Grav * dlog(TempLCL / TempLTP)
  
    z_Temp(1)  = TempSfc  - Grav * z_Z(1) / CpDry 
    z_Press(1) = PressSfc - (Grav * PressSfc * z_dz(1) * 5.0d-1) / (GasRDry * TempSfc)
    do k = 2, nz
      if (z_z(k) < LCL) then 
        z_Temp(k) = TempSfc - Grav * z_Z(k) / CpDry 

      elseif (z_z(k) >= LCL .AND. z_z(k) < LTP) then 
        z_Temp(k)  = TempLCL * exp(-Grav * (z_Z(k) - LCL) / (GasRDry * AntB))

      elseif (z_z(k) >= LTP) then 
        z_Temp(k) = TempLTP

      end if
    end do

    do k = 2, nz
      z_Press(k) = z_Press(k-1) - (Grav * z_Press(k-1) * z_dz(k-1)) &
        & / ( GasRDry * z_Temp(k-1) )
    end do

  end subroutine initialdata_toon2002_basic
  
end module initialdata_Toon2002
