!= Module CFLCheck
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: cflcheck.f90,v 1.2 2011-10-04 05:19:02 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20120229 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! CFL Υå򤹤뤿Υѥå⥸塼
!   * ȤФ CFL å
!   * Ϥ줿®٤Ф CFL å
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!Error Handling  gtool5 Ѥ褦ѹ
!

module CFLCheck
  !
  !CFL Υå򤹤뤿Υѥå⥸塼
  !  * ȤФ CFL å
  !  * Ϥ줿®٤Ф CFL å
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_message, only: MessageNotify

  use gridset, only: imin,    &! x β
    &                imax,    &! x ξ
    &                jmin,    &! z β
    &                jmax,    &! z ξ
    &                kmin,    &! z β
    &                kmax      ! z ξ
  use axesset, only: xyz_dX,  &! x γʻֳ
    &                xyz_dY,  &! y γʻֳ
    &                xyz_dZ    ! z γʻֳ
  use timeset, only: DelTimeShort,  &!û֥ƥå
    &                DelTimeLong     !Ĺ֥ƥå

  !ۤηػ
  implicit none

  !private °λ
  private

  !
  character(*), parameter:: module_name = 'cflcheck'
                              ! ⥸塼̾.
                              ! Module name
  
  !ؿ public °
  public CFLCheckTimeShort
  public CFLCheckTimeLongVelX
  public CFLCheckTimeLongVelY
  public CFLCheckTimeLongVelZ
  
contains  

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeShort( xyz_VelSound )
    !
    !ȤФ CFL å
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyz_VelSound(imin:imax,jmin:jmax, kmin:kmax)
                                        !®
    real(DP)             :: xyz_CFL(imin:imax,jmin:jmax, kmin:kmax)
                                        !
!    real(DP)             :: DxyzMin      !ǾʻҴֳ
    
    !® CFL 
!    DxyzMin = min(min(minval(xyz_dx), minval(xyz_dy)), minval(xyz_dz))
!    CFL = DelTimeShort * maxval(xyz_VelSound) / DxyzMin

    xyz_CFL = DelTimeShort * xyz_VelSound       &
      &       * ((1.0d0 / (xyz_dx ** 2.0d0) + 1.0d0 / (xyz_dy ** 2.0d0)) ** 0.5d0)

    !å
    call MessageNotify( "M", &
      & module_name, &
      & "Sound Wave Velocity = %f", d=(/maxval(xyz_VelSound)/) )
!    call MessageNotify( "M", &
!      & module_name, &
!      & "min(DelX, DelY, DelZ) = %f", d=(/DxyzMin/) )
    call MessageNotify( "M", &
      & module_name, &
      & "DelTimeShort = %f", d=(/DelTimeShort/) )

    !ٹå
    if ( maxval(xyz_CFL) >= 1.0) then 
      call MessageNotify( "E", &
        & module_name, &
        & "CFL Condition is broken, DelTimeShort * VelSound > min(DelX, DelZ)")
    else
      call MessageNotify( "M", &
        & module_name, &
        & "Courant number for DelTimeSort = %f", d=(/maxval(xyz_CFL)/) )
    end if
  
  end subroutine CFLCheckTimeShort


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelX( pyz_VelX )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: CFL

    !CFL 
    CFL = (2.0d0 * DelTimeLong) * maxval(abs(pyz_VelX/xyz_dx))
  
    !å
    call MessageNotify( "M", &
      & module_name, &
      & "Courant number of VelX for DelTimeLong = %f", d=(/CFL/) )

!    if (CFL > 1.0d0) stop 

  end subroutine CFLCheckTimeLongVelX
    

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelY( xqz_VelY )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xqz_VelY(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: CFL

    !CFL 
    CFL = (2.0d0 * DelTimeLong) * maxval(abs(xqz_VelY/xyz_dy))
  
    !å
    call MessageNotify( "M", &
      & module_name, &
      & "Courant number of VelY for DelTimeLong = %f", d=(/CFL/) )

!    if (CFL > 1.0d0) stop 

  end subroutine CFLCheckTimeLongVelY


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelZ( xyr_VelZ )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyr_VelZ(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: CFL
    
    !CFL 
    CFL = (2.0d0 * DelTimeLong) * maxval(abs(xyr_VelZ/xyz_dz)) 
    
    !å
    call MessageNotify( "M", &
      & module_name, &
      & "Courant number of VelZ for DelTimeLong = %f", d=(/CFL/) )
    
!    if (CFL > 1.0d0) stop 

  end subroutine CFLCheckTimeLongVelZ
  
end module CFLCheck
