!= Module BasicSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: basicset.f90,v 1.9 2011-10-04 05:17:35 sugiyama Exp $
! Tag Name::  $Name: arare5-20120229 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ǥեȤδܾꤹ뤿ѿȷ⥸塼
! * BasicEnvFile_init: ܾͤ netCDF ե뤫
! * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module basicset
  !
  !ǥեȤδܾꤹ뤿ѿȷ⥸塼
  !, hogeBZ Ȥʤ, ͤϤ뤳Ȥ
  !Ԥ. 
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use gridset,    only: imin,       &!  X β
    &                   imax,       &!  X ξ
    &                   jmin,       &!  Z β
    &                   jmax,       &!  Z ξ
    &                   kmin,       &!  Z β
    &                   kmax,       &!  Z ξ
    &                   ncmax           ! ؼο
  use axesset,  only: xyr_avr_xyz
  use composition, only: GasNum,       &!Το
    &                 IdxG,         &!Τź
    &                 MolWtWet       !Žʬʬ

  !ۤηػ
  implicit none

  !save °
  private

  !Public Interface
  real(DP), allocatable, save, public :: xyz_DensBZ(:,:,:)    !̩
  real(DP), allocatable, save, public :: xyz_PressBZ(:,:,:)   !̵
  real(DP), allocatable, save, public :: xyz_ExnerBZ(:,:,:)   !̵
  real(DP), allocatable, save, public :: xyz_TempBZ(:,:,:)    !
  real(DP), allocatable, save, public :: xyz_PTempBZ(:,:,:) !
  real(DP), allocatable, save, public :: xyz_VPTempBZ(:,:,:) !
  real(DP), allocatable, save, public :: xyz_VelSoundBZ(:,:,:)!®
  real(DP), allocatable, save, public :: xyzf_QMixBZ(:,:,:,:)!Žʬ
  real(DP), allocatable, save, public :: xyz_EffMolWtBZ(:,:,:)!ʬ̸
  real(DP), allocatable, save, public :: xyz_QMixBZPerMolWt(:,:,:)
                              !ܾκ / ʬ 
  real(DP), allocatable, save, public :: xyr_QMixBZPerMolWt(:,:,:)
                              !ܾκ / ʬ 
  real(DP), allocatable, save, public :: xyz_QMixBZ(:,:,:)
                              !ܾκ
  real(DP), allocatable, save, public :: xyr_QMixBZ(:,:,:)
                              !ܾκ

  public basicset_init

contains

!!!-----------------------------------------------------------------!!!
  subroutine basicset_init(                                     &
    &   xyz_Press, xyz_Exner, xyz_Temp, xyz_PTemp, xyz_Dens,    & 
    &   xyz_VelSound, xyzf_QMix, xyz_EffMolWt &
    & )
    !
    ! ܾͤ. 
    ! dry ξϺ䴥ʬȶŷʬ¸ۤ˻ȤʤΤ,
    ! ѿ optional ˤƤ. 
    !
    
    !ѿ
    real(DP), intent(in) :: xyz_Press(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_Dens(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_VelSound(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in), optional :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax,ncmax)
    real(DP), intent(in), optional :: xyz_EffMolWt(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_QMixBZPerMolWt(imin:imax,jmin:jmax,kmin:kmax,GasNum)
    integer              :: s

    ! ν
    call basicset_array_init
    
    !ͤ
    xyz_PressBZ    = xyz_Press
    xyz_ExnerBZ    = xyz_Exner
    xyz_TempBZ     = xyz_Temp
    xyz_PTempBZ  = xyz_PTemp
    xyz_DensBZ     = xyz_Dens
    xyz_VelSoundBZ = xyz_VelSound
    if (present(xyz_EffMolWt)) xyz_EffMolWtBZ = xyz_EffMolWt

    if (present(xyzf_QMix)) then 
      xyzf_QMixBZ = xyzf_QMix
      xyzf_QMixBZPerMolWt = 0.0d0

      do s = 1, GasNum
        xyzf_QMixBZPerMolWt(:,:,:,s) = &
          & xyzf_QMixBZ(:,:,:,IdxG(s)) / MolWtWet(IdxG(s))
      end do

      xyz_QMixBZPerMolWt = sum(xyzf_QMixBZPerMolWt, 4) 
      xyr_QMixBZPerMolWt = xyr_avr_xyz( sum(xyzf_QMixBZPerMolWt, 4) )
      xyz_QMixBZ         = sum(xyzf_QMixBZ, 4) 
      xyr_QMixBZ         = xyr_avr_xyz( sum(xyzf_QMixBZ, 4) )     
    end if

    xyz_VPTempBZ = xyz_PTempBZ / xyz_EffMolWtBZ

  end subroutine basicset_init


  subroutine basicset_array_init
    !
    ! *BZ ν
    !

    allocate( & 
      & xyz_DensBZ(imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_PressBZ(imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_ExnerBZ(imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_TempBZ(imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_PTempBZ (imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_VPTempBZ (imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_VelSoundBZ(imin:imax,jmin:jmax,kmin:kmax), &
      & xyzf_QMixBZ(imin:imax,jmin:jmax,kmin:kmax,ncmax), &
      & xyz_EffMolWtBZ(imin:imax,jmin:jmax,kmin:kmax)  &
      & )
    allocate( &
      & xyr_QMixBZPerMolWt(imin:imax,jmin:jmax,kmin:kmax),           &
      & xyz_QMixBZPerMolWt(imin:imax,jmin:jmax,kmin:kmax),           &
      & xyr_QMixBZ(imin:imax,jmin:jmax,kmin:kmax),                   &
      & xyz_QMixBZ(imin:imax,jmin:jmax,kmin:kmax)                    &
      & )

    ! ͤγ
    xyz_DensBZ     = 0.0d0
    xyz_PressBZ    = 0.0d0   
    xyz_ExnerBZ    = 0.0d0   
    xyz_TempBZ     = 0.0d0   
    xyz_PTempBZ    = 0.0d0
    xyz_VPTempBZ   = 0.0d0
    xyz_VelSoundBZ = 0.0d0
    xyzf_QMixBZ    = 0.0d0
    xyz_EffMolWtBZ = 1.0d0 ! dry ξɬ 1.0

    xyr_QMixBZPerMolWt = 0.0d0
    xyz_QMixBZPerMolWt = 0.0d0
    xyr_QMixBZ = 0.0d0
    xyz_QMixBZ = 0.0d0
    
  end subroutine basicset_array_init
  
end module basicset
