!= Module HeatFlux
!
! Authors::   ODAKA Masatsugu 
! Version::   $Id: surfaceflux_diff.f90,v 1.11 2012-01-12 11:53:09 sugiyama Exp $
! Tag Name::  $Name: arare5-20120229 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
! Υեåˤ벹٤ȶŷʬѲΨХ륯ˡ
! ŤƷ׻⥸塼.  (1994) Ѥ줿ˡǤ.
!
! Ǯեå Fh ȶŷʪΥեå Fq Ȥ, ٤ȶŷʪ
! ѲΨ H, Q 
!
!   H = Fh/z_1  
!   Q = Fq/z_1  
!
! ɽ.  z_1 ϺǲؤγʻҴֳ֤Ǥ.  
!
! Ǯեå Fh ȶŷʪΥեå Fq ϰʲμˤä
! ׻.
!
!   Fh = - Cd|V| * (_1_1 - T_sfc)
!   Fh = - Cd|V| * (Q_1 - Q*(T_sfc))
!
!  _1, Q_1, _1 Ϻǲؤβ٤ȶŷʪκ椪̵
! ϴؿ, T_sfc ϲβ, Q*(T_sfc)  T_sfc Ƿޤ˰º
! Ǥ. 
!
! Х륯 Cd ϰȤ. ̵ϴؿ _1 ϴܾͤѤ.
! ® |V| 
!
!   V = ( V^2 + V_0^2 )^(1/2)
!
! ȷ׻. 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module Surfaceflux_diff
  !
  !ǤΥեåη׻⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use gridset,  only: imin,         & !x β
    &                 imax,         & !x ξ
    &                 jmin,         & !y β
    &                 jmax,         & !y ξ
    &                 kmin,         & !z β
    &                 kmax,         & !z ξ
    &                 nx, ny, nz, ncmax
  use axesset, only:  z_dz            !z γʻֳ
  use basicset, only: xyz_ExnerBZ,  & !ʡؿδܾ
    &                 xyz_PTempBZ     !̤δܾ
  use namelist_util, only: namelist_filename
  use timeset, only:  TimeN
  use composition,only: SpcWetSymbol, GasNum
  use DExnerDt, only  : xyz_DExnerDt_xyz_xyzf

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public surfaceflux_diff_init
  public surfaceflux_diff_forcing

  !ѿ
  real(DP), save  :: Kappa = 800.0d0

contains
!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Diff_init
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    integer    :: l, unit

    !---------------------------------------------------------------    
    ! NAMELIST 
    !
    NAMELIST /surfaceflux_diff_nml/ Kappa
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=surfaceflux_diff_nml)
    close(unit)  

    if (myrank == 0) then 
      call MessageNotify( "M", "SurfaceFlux", "Kappa = %f", d=(/Kappa/))
    end if

    call HistoryAutoAddVariable(  &
      & varname='PTempFlux',         &
      & dims=(/'x','y','z','t'/), &
      & longname='surface flux of potential temperature', &
      & units='kg.kg-1.s-1',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerFlux',      &
      & dims=(/'x','y','z','t'/), &
      & longname='surface flux of Exner function', &
      & units='kg.kg-1.s-1',            &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Flux', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Surface Flux term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')
    end do

  end subroutine Surfaceflux_Diff_init


!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Diff_forcing( &
    &   xyz_PTemp, xyzf_QMix,          &
    &   xyz_DPTempDt, xyz_DExnerDt,    &
    &   xyzf_DQMixDt                   &
    & )
    ! 
    ! Υեåˤ벹٤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)   :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
                                           !̤ξʬ    
    real(DP), intent(in)   :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                           !̤ξʬ    
    real(DP), intent(inout):: xyz_DPTempDt(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout):: xyz_DExnerDt(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout):: xyzf_DQMixDt(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)               :: xyz_DPTempDt0(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyz_DExnerDt0(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyzf_DQMixDt0(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)               :: xyz_Heatflux(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyz_Exnerflux(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyzf_QMixflux(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                            !ɽǮեå
    integer, parameter     :: kz = 1        !ź
    integer                :: l             !롼ѿ

    ! 
    !
    xyz_HeatFlux  = 0.0d0
    xyz_ExnerFlux = 0.0d0
    xyzf_QMixFlux = 0.0d0

    xyz_DPTempDt0 = xyz_DPTempDt
    xyz_DExnerDt0 = xyz_DExnerDt
    xyzf_DQMixDt0 = xyzf_DQMixDt

    !ɽǮեåˤǮΨ׻
    !  * ñ̤ K/s
    !  * ʡؿϴܾͤɽ.     
    !  * ʻ xz Ǥ, ʪΰκǲüź kz = 1

    xyz_HeatFlux(:,:,kz) =                                  &
      &  - Kappa * xyz_PTemp(:,:,kz) * xyz_ExnerBZ(:,:,kz)  &
      &    / ( ( z_dz(kz) * 5.0d-1 ) ** 2.0d0 ) 

    do l = 1, GasNum
      xyzf_QMixFlux(:,:,kz,l) =                       &
        & max(                                        &
        &       0.0d0,                                &
        &     - Kappa * xyzf_QMix(:,:,kz,l)           &
        &        / ( ( z_dz(kz) * 5.0d-1 ) ** 2.0d0 ) &
        &    )
    end do

    xyz_DPTempDt = xyz_DPTempDt0 + xyz_Heatflux
    xyzf_DQMixDt = xyzf_DQMixDt0 + xyzf_Qmixflux

    xyz_ExnerFlux = xyz_DExnerDt_xyz_xyzf( xyz_HeatFlux, xyzf_QMixFlux )
    xyz_DExnerDt = xyz_DExnerDt0 + xyz_ExnerFlux

    call HistoryAutoPut(TimeN, 'PTempFlux', xyz_HeatFlux(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerFlux', xyz_ExnerFlux(1:nx,1:ny,1:nz))
    do l = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(l))//'_Flux', xyzf_Qmixflux(1:nx,1:ny,1:nz,l))
    end do    

    ! Set margin
    !
!    call SetMargin_xyz(xyz_DPTempDt)
!    call SetMargin_xyzf(xyzf_DQMixDt)

  end subroutine Surfaceflux_Diff_forcing
  
end module Surfaceflux_diff
