!= Module ReStartFileIO
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: restartfileio.f90,v 1.14 2011-10-15 08:47:20 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20120229 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ꥹѤξξ netCDF ե˽Ϥ뤿Υ롼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!®٤ɾʻҰ֤, ȤϤƤɸͤŪǤʤȤ
!
!== Future Plans
!

module ReStartFileIO
  !
  !ꥹѤξξ netCDF ե˽Ϥ뤿Υ롼
  !

  !⥸塼ɤ߹
  use gtool_history
  use dc_types,  only : DP, STRING
  use dc_message,only : MessageNotify
  use dc_string, only : toChar
  use dc_iounit, only : FileOpen
  use mpi_wrapper,   only: myrank, FLAG_LIB_MPI
  use axesset,  only: x_X,        &!X ɸ(顼ʻ)
    &                 y_Y,        &!Y ɸ(顼ʻ)
    &                 z_Z          !Z ɸ(顼ʻ)
  use gridset,  only: &
    &                 imin,           &!X β
    &                 imax,           &!X ξ
    &                 jmin,           &!Y β
    &                 jmax,           &!Y ξ
    &                 kmin,           &!Z β
    &                 kmax,           &!Z ξ
    &                 ncmax              !Žʬο
  use timeset,  only: DelTimeLong, RestartTime 
  use fileset,  only: &
    &                 filetitle,        &!ǡɽ
    &                 filesource,       &!ǡ
    &                 FileInstitution    !ǽѹԡȿ
  use basicset, only: basicset_init 
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none
  
  !ؿ public ˻
  public ReStartFileIO_init
  public ReStartFileio_Finalize
  public ReStartFileio_BZ_Get
  public ReStartFileio_Var_Get

  type(GT_HISTORY), save, public   :: rstat
  character(STRING), save, private :: InputFile  = "input.nc"
  character(STRING), save, private :: OutputFile = "output.nc"
  
contains

  subroutine ReStartFileio_Init
    !
    !ꥹȥեν񤭽Ф
    !
   
    !ۤηػ
    implicit none

    !ѿ
    real(4)            :: SpcID(ncmax)
    integer            :: N, L, M
    integer            :: s    
    integer            :: unit     !ֹ
     
    !NAMELIST 
    NAMELIST /restartfileio_nml/ InputFile, OutputFile
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=restartfileio_nml)
    close(unit)
    
    !ǧ
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & "restartfileioIO_init", "InputFile  = %c", c1=trim(InputFile) )
      call MessageNotify( "M", &
        & "restartfileioIO_init", "OutputFile = %c", c1=trim(OutputFile) )
    end if

    SpcID = 0.0d0
    do s = 1, ncmax
      SpcID(s) = real( s, 4 )
    end do
    
    N = size(x_X, 1)
    L = size(y_Y, 1)
    M = size(z_Z, 1)
    
    !-------------------------------------------------------------    
    ! ҥȥ꡼
    !-------------------------------------------------------------  
    call HistoryCreate(                              &
      & file = Outputfile,                          &
      & title = filetitle,                           &
      & source = filesource,                         &
      & institution = FileInstitution,               &
      & dims=(/'x','y','z','s','t'/),                &
      & dimsizes=(/N, L, M, ncmax, 0/),                 &
      & longnames=(/'X-coordinate',                  &
      &             'Y-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Species Num ',                  &
      &             'Time        '/),                &
      & units=(/'m  ','m  ','m  ','1  ','sec'/),     &
      & xtypes=(/'double', 'double', 'double', 'double', 'double'/), &
      & flag_mpi_split = FLAG_LIB_MPI,               &
      & origin=0.0, interval=1.0,                    &
      & history=rstat, quiet=.true. )
    
    !-------------------------------------------------------------  
    ! ѿ
    !-------------------------------------------------------------
    call HistoryPut('x', x_X, rstat )
    call HistoryPut('y', y_Y, rstat )
    call HistoryPut('z', z_Z, rstat )
    call HistoryPut('s', real(SpcID, 4), rstat )

    !̵Ϥδܾ
    call HistoryAddVariable(                             &
      & varname='ExnerBZ', dims=(/'x','y','z'/),      &
      & longname='nondimensional pressure', units='1',&
      & xtype='double', history=rstat )
    
    !̤δܾ
    call HistoryAddVariable(                            &
      & varname='PTempBZ', dims=(/'x','y','z'/),    &
      & longname='potential temperature',            &
      & units='K', xtype='double', history=rstat ) 
    
    !̩٤δܾ
    call HistoryAddVariable(                            &
      & varname='DensBZ', dims=(/'x','y','z'/),      &
      & longname='density',                          &
      & units='Kg.m-3', xtype='double', history=rstat )
    
    !®٤δܾ
    call HistoryAddVariable(                            &
      & varname='VelSoundBZ', dims=(/'x','y','z'/),  &
      & longname='sound velocity',                   &
      & units='m.s-2', xtype='double', history=rstat )

    !٤δܾ
    call HistoryAddVariable(                            &
      & varname='TempBZ', dims=(/'x','y','z'/),  &
      & longname='Temperature of basic state',       &
      & units='K', xtype='double', history=rstat ) 
    
    !Ϥδܾ
    call HistoryAddVariable(                            &
      & varname='PressBZ', dims=(/'x','y','z'/),  &
      & longname='Pressure of basic state',             &
      & units='Pa', xtype='double', history=rstat ) 
    
    !δܾ
    call HistoryAddVariable(                            &
      & varname='QMixBZ', dims=(/'x','y','z','s'/),  &
      & longname='Mixing ratio of Condensible volatiles',        &
      & units='kg.kg-1', xtype='double', history=rstat ) 
    
    !ʬ̸
    call HistoryAddVariable(                         &
      & varname='EffMolWtBZ', dims=(/'x','y','z'/),  &
      & longname='Effect of Mole Weight',            &
      & units='1', xtype='double', history=rstat ) 

    !ʬ̸
    call HistoryAddVariable(                        &
      & varname='HumBZ', dims=(/'x','y','z','s'/),  &
      & longname='Humidity',                        &
      & units='1', xtype='double', history=rstat ) 
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelX', dims=(/'x','y','z','t'/),        &
      & longname='zonal velocity',                   &
      & units='m.s-1',                                 &
      & xtype='double', history=rstat )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelY', dims=(/'x','y','z','t'/),        &
      & longname='meridional velocity',              &
      & units='m.s-1',                                 &
      & xtype='double', history=rstat )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelZ', dims=(/'x','y','z','t'/),        &
      & longname='vertical velocity',                &
      & units='m.s-1',                                 &
      & xtype='double', history=rstat )
    
    !̵
    call HistoryAddVariable(                         &
      & varname='Exner', dims=(/'x','y','z','t'/),       &
      & longname='nondimensional pressure',          &
      & units='1',                                   &
      & xtype='double', history=rstat )
    
    !̤ξ
    call HistoryAddVariable(                         &
      & varname='PTemp', dims=(/'x','y','z','t'/),     &
      & longname='virtual potential temperature',    &
      & units='K',                                   &
      & xtype='double', history=rstat )
    
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Km', dims=(/'x','y','z','t'/),      &
      & longname='Km',                               &
      & units='m2.s-1',                              &
      & xtype='double', history=rstat )
    
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Kh', dims=(/'x','y','z','t'/),      &
      & longname='Kh',                               &
      & units='m2.s-1',                              &
      & xtype='double', history=rstat )

    !̩
    call HistoryAddVariable(                         &
      & varname='CDens', dims=(/'x','y','z','t'/),   &
      & longname='CDens',                            &
      & units='m2.s-1',                              &
      & xtype='double', history=rstat )
    
    !
    call HistoryAddVariable(                         &
      & varname='QMix', dims=(/'x','y','z','s','t'/),&
      & longname='Mixing Ratio',                     &
      & units='kg.kg-1"',                            & 
      & xtype='double', history=rstat )
    
  end subroutine ReStartFileio_Init
  
  
  subroutine ReStartFileIO_Finalize
    !
    !ꥹȥեΥ
    !
    
    !⥸塼ɤ߹
    use gtool_history
    
    !ۤηػ
    implicit none
    
    !եĤ
    call HistoryClose(rstat, quiet=.true.)
    
  end subroutine ReStartFileIO_Finalize
  

  subroutine ReStartFileio_Var_Get(   &
    & pyz_VelXB,  pyz_VelXN,    & ! (in)
    & xqz_VelYB,  xqz_VelYN,    & ! (in)
    & xyr_VelZB,  xyr_VelZN,    & ! (in)
    & xyz_PTempB, xyz_PTempN,   & ! (in)
    & xyz_ExnerB, xyz_ExnerN,   & ! (in)
    & xyzf_QMixB, xyzf_QMixN,   & ! (in)
    & xyz_KmB,    xyz_KmN,      & ! (in)
    & xyz_KhB,    xyz_KhN,      & ! (in)
    & xyz_CDensB, xyz_CDensN  )
    !
    !ꥹȥե뤫
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(out) :: pyz_VelXN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xqz_VelYN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyr_VelZN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_ExnerN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_PTempN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_KmN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_KhN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_CDensN &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyzf_QMixN &
      &              (imin:imax,jmin:jmax,kmin:kmax,ncmax)
    real(DP), intent(out) :: pyz_VelXB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xqz_VelYB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyr_VelZB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_ExnerB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_PTempB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_KmB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_KhB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_CDensB &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyzf_QMixB &
      &              (imin:imax,jmin:jmax,kmin:kmax,ncmax)

    character(STRING)    :: name               !ѿ̾
    character(STRING)    :: TimeN = ""
    character(STRING)    :: TimeB = ""

    !-------------------------------------------------------------
    ! Get a Value from netCDF File
    !-------------------------------------------------------------    
    if (RestartTime /= 0.0d0) then
      timeB = 't=' // toChar( RestartTime - DelTimeLong)
      timeN = 't=' // toChar( RestartTime  )
    else
      timeB = 't=' // toChar( RestartTime )
      timeN = 't=' // toChar( RestartTime )
    end if

!    write(*,*) TimeN, TimeB

    name = "PTemp"
    call HistoryGet( InputFile, name, xyz_PTempB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyz_PTempN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )

    name = "VelX"
    call HistoryGet( InputFile, name, pyz_VelXB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, pyz_VelXN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )

    name = "VelY"
    call HistoryGet( InputFile, name, xqz_VelYB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xqz_VelYN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )

    name = "VelZ"
    call HistoryGet( InputFile, name, xyr_VelZB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyr_VelZN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )

    name = "Exner"
    call HistoryGet( InputFile, name, xyz_ExnerB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyz_ExnerN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )

    name = "Km"
    call HistoryGet( InputFile, name, xyz_KmB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyz_KmN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )
    
    name = "Kh"
    call HistoryGet( InputFile, name, xyz_KhB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyz_KhN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )

    name = "CDens"
    call HistoryGet( InputFile, name, xyz_CDensB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyz_CDensN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )
      
    name = "QMix"
    call HistoryGet( InputFile, name, xyzf_QMixB, range=TimeB, flag_mpi_split = FLAG_LIB_MPI )
    call HistoryGet( InputFile, name, xyzf_QMixN, range=TimeN, flag_mpi_split = FLAG_LIB_MPI )
    
  end subroutine ReStartFileio_Var_Get
       


  subroutine ReStartFileio_BZ_Get()
    !
    !ꥹȥե뤫
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP)              :: Var3D &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP)              :: Var4D &
      &              (imin:imax,jmin:jmax,kmin:kmax,ncmax)
    real(DP)              :: xyz_ExnerBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾΥʡؿ
    real(DP)              :: xyz_DensBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾ̩
    real(DP)              :: xyz_PTempBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾβ
    real(DP)              :: xyz_VelSoundBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾβ®
    real(DP)              :: xyz_PressBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾΰ
    real(DP)              :: xyz_TempBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾβ
    real(DP)              :: xyzf_QMixBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                               !ܾκ
    real(DP)              :: xyz_EffMolWtBZ &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
                                               !ܾʬ̸
    character(STRING)    :: name               !ѿ̾

    !-------------------------------------------------------------
    ! ܾμ
    !
    name = "DensBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_DensBZ = Var3D
    
    name = "ExnerBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_ExnerBZ = Var3D
    
    name = "PTempBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_PTempBZ = Var3D
    
    name = "VelSoundBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_VelSoundBZ = Var3D
    
    name = "TempBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_TempBZ = Var3D
    
    name = "PressBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_PressBZ = Var3D
    
    name = "QMixBZ"
    call HistoryGet( InputFile, name, Var4D, flag_mpi_split = FLAG_LIB_MPI )
    xyzf_QMixBZ = Var4D
    
    name = "EffMolWtBZ"
    call HistoryGet( InputFile, name, Var3D, flag_mpi_split = FLAG_LIB_MPI )
    xyz_EffMolWtBZ = Var3D
    
    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call basicset_init(       &
      & xyz_PressBZ,   &
      & xyz_ExnerBZ,   &
      & xyz_TempBZ,    &
      & xyz_PTempBZ, &
      & xyz_DensBZ,    &
      & xyz_VelSoundBZ,&
      & xyzf_QMixBZ,  &
      & xyz_EffMolWtBZ &
      & )
    
  end subroutine ReStartFileio_BZ_Get
       
end module ReStartFileIO
