!= Module Differentiate_Center2
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: differentiate_center2.f90,v 1.3 2006/09/21 03:01:02 odakker Exp $ 
! Tag Name::  $Name: arare4-20060928 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!2 ٤ʬ黻ԤδؿޤȤ᤿ѥå⥸塼
!ʿ Arakawa-C, ľ Lorentz åɤǤʬ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!Ū DelX ⤷ DelZ Υ줿ʻ֤ǤʬƤʤ. 
!ʻ 2 ʬ, 4 ʬΥ줿ʻ֤ͤȤ褦ʬ, 
!餫٤뤿Ǥ. 
!
!== Future Plans
!

module differentiate_center2
  !
  !2 ٤ʬ黻ԤδؿޤȤ᤿ѥå⥸塼
  !ʿ Arakawa-C, ľ Lorentz åɤǤʬ׻
  !

  !⥸塼ɤ߹
  use gridset,    only: DimXMin,  &!  X β
    &                   DimXMax,  &!  X ξ
    &                   DimZMin,  &!  Z β
    &                   DimZMax,  &!  Z ξ
    &                   DelX,     &! X γʻֳ
    &                   DelZ       ! Z γʻֳ

  !ۤηػ
  implicit none

  !private °
  private

  !
  public xz_dx_pz
  public xz_dz_xr
  public pz_dx_xz
  public pz_dz_pr
  public xr_dx_pr
  public xr_dz_xz
  public pr_dz_pz
  public pr_dx_xr

contains 

!!!---------------------------------------------------------------------
  function xz_dx_pz( pz_var ) 
    !
    ! x, z ȾʻҤ줿Ǥ x  2 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xz_dx_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    xz_dx_pz = 1.0d-16 
    xz_dx_pz(DimXMin+1 : DimXMax, DimZMin : DimZMax) =        &
      &  (                                                    &
      &     pz_var(DimXMin+1 : DimXMax, DimZMin : DimZMax)    &
      &   - pz_var(DimXMin   : DimXMax-1, DimZMin : DimZMax)  &
      &  ) / DelX

  end function xz_dx_pz


!!!---------------------------------------------------------------------
  function xz_dz_xr(xr_var) 
    !
    ! x, z ȾʻҤ줿Ǥ z  2 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xz_dz_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    xz_dz_xr = 1.0d-16 
    xz_dz_xr(DimXMin:DimXMax,DimZMin+1:DimZMax) =         &
      &  (                                                &
      &     xr_var(DimXMin:DimXMax,DimZMin+1:DimZMax)     &
      &   - xr_var(DimXMin:DimXMax,DimZMin:DimZMax-1)     &
      &  ) / DelZ

  end function xz_dz_xr


!!!---------------------------------------------------------------------
  function pz_dx_xz( xz_var ) 
    !
    ! z ȾʻҤ줿Ǥ x  2 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ    
    real(8), intent(in) :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pz_dx_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ    

    pz_dx_xz = 1.0d-16
    pz_dx_xz(DimXMin:DimXMax-1,DimZMin:DimZMax) =         &
      &  (                                                &
      &     xz_var(DimXMin+1:DimXMax,DimZMin:DimZMax)     &
      &   - xz_var(DimXMin:DimXMax-1,DimZMin:DimZMax)     &
      &  ) / DelX

  end function pz_dx_xz
  

!!!---------------------------------------------------------------------
  function pz_dz_pr( pr_var ) 
    !
    ! z ȾʻҤ줿Ǥ z  2 ʬ黻
    !

    !ۤηػ
    implicit none
  
    real(8), intent(in) :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: pz_dz_pr(DimXMin:DimXMax, DimZMin:DimZMax)
    
    pz_dz_pr = 1.0d-16 
    pz_dz_pr(DimXMin:DimXMax,DimZMin+1:DimZMax) =       & 
      &  (                                              &
      &      pr_var(DimXMin:DimXMax,DimZMin+1:DimZMax)  &
      &   -  pr_var(DimXMin:DimXMax,DimZMin:DimZMax-1)  &
      &  ) / DelZ

  end function pz_dz_pr
  

!!!---------------------------------------------------------------------  
  function xr_dx_pr( pr_var ) 
    !
    ! x ȾʻҤ줿Ǥ x  2 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xr_dx_pr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ    

    xr_dx_pr = 1.0d-16 
    xr_dx_pr(DimXMin+1:DimXMax,DimZMin:DimZMax) =        & 
      &  (                                               &
      &      pr_var(DimXMin+1:DimXMax,DimZMin:DimZMax)   &
      &   -  pr_var(DimXMin:DimXMax-1,DimZMin:DimZMax)   &
      &  ) / DelX

  end function xr_dx_pr
  

!!!---------------------------------------------------------------------  
  function xr_dz_xz( xz_var ) 
    !
    ! x ȾʻҤ줿Ǥ z  2 ʬ黻
    !

    !ۤηػ
    use gridset
    implicit none

    !ѿ
    real(8), intent(in) :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xr_dz_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ

    xr_dz_xz = 1.0d-16 
    xr_dz_xz(DimXMin:DimXMax,DimZMin:DimZMax-1) =         &
      &  (                                                &
      &     xz_var(DimXMin:DimXMax,DimZMin+1:DimZMax)     &
      &   - xz_var(DimXMin:DimXMax,DimZMin:DimZMax-1)     &
      &  ) / DelZ

  end function xr_dz_xz


!!!---------------------------------------------------------------------  
  function pr_dx_xr( xr_var ) 
    !
    ! ʻǤ x  2 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pr_dx_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    pr_dx_xr = 1.0d-16 
    pr_dx_xr(DimXMin:DimXMax-1,DimZMin:DimZMax) =        & 
      &  (                                               &
      &      xr_var(DimXMin+1:DimXMax,DimZMin:DimZMax)   &
      &   -  xr_var(DimXMin:DimXMax-1,DimZMin:DimZMax)   &
      &  ) / DelX

  end function pr_dx_xr
  

!!!---------------------------------------------------------------------  
  function pr_dz_pz( pz_var ) 
    !
    ! ʻǤ z  2 ʬ黻
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pr_dz_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ    

    pr_dz_pz = 1.0d-16 
    pr_dz_pz(DimXMin:DimXMax,DimZMin:DimZMax-1) =    & 
      &  (                                           &
      &      pz_var(DimXMin:DimXMax,DimZMin+1:DimZMax)  &
      &   -  pz_var(DimXMin:DimXMax,DimZMin:DimZMax-1)  &
      &  ) / DelZ

  end function pr_dz_pz
  
end module differentiate_center2
