!= Module MoistAdjust
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: moistadjust.f90,v 1.13 2006/09/21 02:35:11 odakker Exp $
! Tag Name::  $Name: arare4-20060928 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!˰Ĵˡ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

Module MoistAdjust
  !
  !˰ĴˡԤΥѥå⥸塼
  !  * ˰¾Ȥؼ, 층Ū˼¹Ԥ
  !  * ȿˤĤƤ, 줾βȿ˼¹Ԥ. 

  !⥸塼ɤ߹
  use gridset, only:  SpcNum,           &!ؼο
    &                 DimXMin,          &! x β
    &                 DimXMax,          &! x ξ
    &                 DimZMin,          &! z β
    &                 DimZMax            ! z ξ
  use basicset, only: CpDry,            &
    &                 MolWtWet,         &
    &                 SpcWetID,         &
    &                 SpcWetSymbol,     &
    &                 xz_ExnerBasicZ,   &
    &                 xz_PotTempBasicZ, &
    &                 xza_MixRtBasicZ,  &  
    &                 PressBasis,       &!̤δవ         [Pa]
    &                 CpDry,            &!ʬʿ갵Ǯ [J/K kg]
    &                 MolWtDry,         &!ʬʿʬ   [kg/mol]
    &                 GasRDry            !ʬε     [J/K kg]
  use average,  only: xz_avr_pz, xz_avr_xr, pz_avr_xz, xr_avr_xz
  use ChemData, only: ChemData_OneSpcID
  use ChemCalc, only: xz_SvapPress, xz_LatentHeat, ReactHeatNH4SH
  use MoistFunc,only: xz_DMixRtSatDPotTemp, xz_DelMixRtNH4SH
  use StoreSet, only: StoreCond

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ° public ѹ
  public MoistAdjust_Init        !롼
  public MoistAdjustPrm          !ѿ. ϥ롼Ѥ뤿
  public MoistAdjustSvapPress    !˰¾Ѥ˰¼Ĵ(ʰ)
  public MoistAdjustNH4SH        !ȿΰʿѤ˰¼Ĵ

  !ѿ
  integer      :: LoopNum      = 0
  integer      :: GasNum(10)   = 0
  integer      :: CloudNum(10) = 0
  integer      :: NH3Num   = 0
  integer      :: H2SNum   = 0
  integer      :: NH4SHNum = 0
  
  save LoopNum, CloudNum, GasNum
  save NH3Num, H2SNum, NH4SHNum
  
contains

!!!------------------------------------------------------------------!!!
  subroutine MoistAdjust_Init( )
    !
    !׻Ѥ벽ؼ ID Ф
    !  * ȶŽ(γ) ID . 
    !  * NH4SH ȿ׻뤿, NH4SH  NH3, H2S  ID.

    !ۤηػ
    implicit none

    !ѿ
    integer                  :: s
    integer                  :: n1

    !-----------------------------------------------------------
    ! γȵΤ ID Ȥ
    !-----------------------------------------------------------
    !
    LoopNum = 0

    !ؼ椫γΤ, źʬ̤ݴ.
    SelectCloud: do s = 1, SpcNum

      ! NH4SH ˤĤƤ̵
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 
        cycle SelectCloud
      end if

      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      if (n1 /= 0) then
        LoopNum          = LoopNum + 1
        CloudNum(LoopNum)= s
        GasNum(LoopNum)  = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID(SpcWetSymbol(s)(1:n1-3) // '-g'))
      end if
    end do SelectCloud
    
    !-----------------------------------------------------------
    ! β˥, ӥ˥βǤ ID 
    !-----------------------------------------------------------
    NH3Num   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('NH3-g'))
    H2SNum   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('H2S-g'))
    NH4SHNum = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('NH4SH-s'))

    !-----------------------------------------------------------
    ! ǧ
    !-----------------------------------------------------------
    if ( LoopNum == 0 ) then 
      write(*,*) "MoistAdjust: CloudNum = 0, please comment out of MoistAdjust"
!      stop
    end if

    write(*,*) "MoistAdjust_Init, LoopNum:  ", LoopNum
    write(*,*) "MoistAdjust_Init, CloudNum: ", CloudNum
    write(*,*) "MoistAdjust_Init, GasNum:   ", GasNum    
    write(*,*) "MoistAdjust_Init, NH3Num:   ", NH3Num
    write(*,*) "MoistAdjust_Init, H2SNum:   ", H2SNum
    write(*,*) "MoistAdjust_Init, NH4SHNum: ", NH4SHNum

  end subroutine MoistAdjust_Init


  subroutine MoistAdjustPrm( M1, M2, M3, M4, M5, M6 )
    
    implicit none
    integer, intent(out) ::  M1, M2(10), M3(10), M4, M5, M6

    M1 = LoopNum
    M2 = CloudNum
    M3 = GasNum    
    M4 = NH3Num
    M5 = H2SNum
    M6 = NH4SHNum

    write(*,*) M1, M2, M3, M4, M5, M6 
  end subroutine MoistAdjustPrm


!!!------------------------------------------------------------------!!!
  subroutine MoistAdjustSvapPress(xz_Exner, xz_PotTemp, xza_MixRt)
    !
    ! ˰¾Ѥ˰Ĵˡμ¹
    ! ץǤ, ͽ᤿ȿɤԤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !ʡؿ
    real(8),intent(inout):: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !
    real(8),intent(inout):: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                          !
    integer, parameter   :: ItrNum = 4                    !ȿɤβ

    real(8) :: xz_MixRtV_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtV_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtC_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtC_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PotTemp_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PotTemp_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtSat(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8) :: xz_Evap(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8) :: xz_Gamma(DimXMin:DimXMax, DimZMin:DimZMax) 
    integer :: i, s                                       ! ź  

    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    xz_MixRtV_pre  = 0.0d0
    xz_MixRtV_nxt  = 0.0d0
    xz_MixRtC_pre  = 0.0d0
    xz_MixRtC_nxt  = 0.0d0
    xz_PotTemp_pre = 0.0d0
    xz_PotTemp_nxt = 0.0d0
    
    xz_ExnerAll    = 0.0d0
    xz_TempAll     = 0.0d0
    xz_DelMixRt    = 0.0d0
    xz_MixRtSat    = 0.0d0 
    xz_Gamma       = 0.0d0
    
    !---------------------------------------------------------------------
    ! ˰Ĵˡμ¹
    !   롼פ󤹤Τ, ˤĤƤ.  
    !---------------------------------------------------------------------
    LoopSvapPress: do s = 1, LoopNum
      
      !˰ˡǤϰϤѲʤ. 
      xz_ExnerAll = xz_Exner + xz_ExnerBasicZ
          
      !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
      xz_MixRtV_pre  = xza_MixRt(:,:,GasNum(s))   + xza_MixRtBasicZ(:,:,GasNum(s))
      xz_MixRtC_pre  = xza_MixRt(:,:,CloudNum(s)) + xza_MixRtBasicZ(:,:,CloudNum(s))
      xz_PotTemp_pre = xz_PotTemp
          
      Adjusting: do i = 1, ItrNum
        !---------------------------------------------------------------
        ! ˰¾˰º
        !---------------------------------------------------------------
        !
        xz_TempAll = ( xz_PotTemp_pre + xz_PotTempBasicZ ) * xz_ExnerAll

        !˰¾˰º׻(ܾ줫κ). 
        xz_MixRtSat =                                                    &
          & xz_SvapPress(SpcWetID(CloudNum(s)), xz_TempAll)              &
          &  * MolWtWet(CloudNum(s))                                     &
          &  / (MolWtDry * PressBasis * (xz_ExnerAll ** (CpDry / GasRDry)) )

!        write(*,*) "A", minval( xz_SvapPress(SpcWetID(CloudNum(s)), xz_TempAll) ), maxval( xz_SvapPress(SpcWetID(CloudNum(s)), xz_TempAll) )
!        write(*,*) "B", minval( xz_MixRtSat ), maxval( xz_MixRtSat )
        
        !ʲ줿Ǯ
        xz_Gamma = xz_LatentHeat(SpcWetID(CloudNum(s)), xz_TempAll) &
          &        / (xz_ExnerAll * CpDry)
        
!        write(*,*) "C", minval( xz_Gamma ), maxval( xz_Gamma )

        !ŷ̤. 
        !  ŷ뤬ˤ, xz_MixRtV_pre - xz_MixRtSat ɬͤȤʤ.
        !  ȯˤ, ȯ̤ - MixRtC Ķ뤳ȤϤʤ. 
        xz_DelMixRt = &
          & ( xz_MixRtV_pre - xz_MixRtSat ) &
          &   / (1.0d0 + xz_Gamma * xz_DMixRtSatDPotTemp( &
          &           SpcWetID(CloudNum(s)), MolWtWet(CloudNum(s)), xz_TempAll, xz_ExnerAll & 
          &        ) )

!        Write(*,*) "D1", &
!          & minval( xz_DMixRtSatDPotTemp( &
!          &           SpcWetID(CloudNum(s)), MolWtWet(CloudNum(s)), xz_TempAll, xz_ExnerAll & 
!          &        ) ),      &
!          & maxval( xz_DMixRtSatDPotTemp( &
!          &           SpcWetID(CloudNum(s)), MolWtWet(CloudNum(s)), xz_TempAll, xz_ExnerAll & 
!          &        ) )
!        write(*,*) "D2", minval( xz_MixRtV_pre - xz_MixRtSat ), maxval( xz_MixRtV_pre - xz_MixRtSat )
!        write(*,*) "D3", minval( xz_DelMixRt ), maxval( xz_DelMixRt )

        xz_Cond = max( 0.0d0, min( xz_MixRtV_pre,   xz_DelMixRt ) )
        xz_Evap = max( 0.0d0, min( xz_MixRtC_pre, - xz_DelMixRt ) )

!        write(*,*) "E", minval( xz_Cond ), maxval( xz_Cond )
!        write(*,*) "F", minval( xz_Evap ), maxval( xz_Evap )

        !꿿˶ᤤͤ׻
        xz_PotTemp_nxt = xz_PotTemp_pre + xz_Gamma * ( xz_Cond - xz_Evap )
        xz_MixRtV_nxt  = xz_MixRtV_pre  - xz_Cond + xz_Evap
        xz_MixRtC_nxt  = xz_MixRtC_pre  + xz_Cond - xz_Evap
        
        !֤Τѿ
        xz_PotTemp_pre = xz_PotTemp_nxt
        xz_MixRtV_pre  = xz_MixRtV_nxt
        xz_MixRtC_pre  = xz_MixRtC_nxt

      end do Adjusting

      call StoreCond( xz_PotTemp_nxt - xz_PotTemp ) 
      
      xz_PotTemp                 = xz_PotTemp_nxt                 
      xza_MixRt(:,:,GasNum(s))   = xz_MixRtV_nxt - xza_MixRtBasicZ(:,:,GasNum(s))
      xza_MixRt(:,:,CloudNum(s)) = xz_MixRtC_nxt - xza_MixRtBasicZ(:,:,CloudNum(s))
      
    end do LoopSvapPress
    
  end subroutine MoistAdjustSvapPress


!!!--------------------------------------------------------------------------!!!
  subroutine MoistAdjustNH4SH(xz_Exner, xz_PotTemp, xza_MixRt ) 
    !
    ! NH3 + H2S --> NH4SH ȿΰʿ Kp Ѥ˰¼Ĵˡ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !ʡؿ
    real(8),intent(inout):: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !
    real(8),intent(inout):: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                          !Žʬκ
    real(8) :: xz_PotTemp_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PotTemp_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH3_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH3_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtH2S_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtH2S_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH4SH_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH4SH_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    
    real(8) :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_Gamma(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8) :: xz_Evap(DimXMin:DimXMax, DimZMin:DimZMax)  
    
    integer            :: i
    integer, parameter :: ItrNum = 2
            
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    xz_PotTemp_nxt = 0.0d0
    xz_MixRtNH3_nxt   = 0.0d0
    xz_MixRtH2S_nxt   = 0.0d0
    xz_MixRtNH4SH_nxt = 0.0d0
    
    xz_Gamma     = 0.0d0
    xz_DelMixRt  = 0.0d0

    !˰ˡǤϰϤѲʤ. 
    xz_ExnerAll = xz_Exner + xz_ExnerBasicZ
    xz_PressAll = PressBasis * (xz_ExnerAll ** (CpDry / GasRDry))
        
    !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
    xz_MixRtNH3_pre(:,:)    = xza_MixRt(:,:,NH3Num)   + xza_MixRtBasicZ(:,:,NH3Num)
    xz_MixRtH2S_pre(:,:)    = xza_MixRt(:,:,H2SNum)   + xza_MixRtBasicZ(:,:,H2SNum)
    xz_MixRtNH4SH_pre(:,:)  = xza_MixRt(:,:,NH4SHNum) + xza_MixRtBasicZ(:,:,NH4SHNum)
    xz_PotTemp_pre          = xz_PotTemp
    
    AdjustNH4SH: do i = 1, ItrNum
      !---------------------------------------------------------------
      ! ѿν
      !---------------------------------------------------------------
      !
      xz_TempAll = ( xz_PotTemp_pre + xz_PotTempBasicZ ) * xz_ExnerAll
      
      !ʲ줿ȿǮ (NH4SH kg ФǮ)
      xz_Gamma = ReactHeatNH4SH / ( xz_ExnerAll * CpDry )

      !NH4SH 
      xz_DelMixRt =                                                           &
        &    xz_DelMixRtNH4SH(                                                &
        &          xz_TempAll, xz_PressAll, xz_MixRtNH3_pre, xz_MixRtH2S_pre, &
        &          MolWtWet(NH3Num), MolWtWet(H2SNum)                         &
        &      )

      xz_Cond = max( 0.0d0, xz_DelMixRt )
      xz_Evap = max( 0.0d0, min( - xz_DelMixRt, xz_MixRtNH4SH_pre ) )

      !---------------------------------------------------------------
      ! 꿿˶ᤤͤ˰¾˰º
      !---------------------------------------------------------------
      ! NH4SH κ
      xz_MixRtNH4SH_nxt  = xz_MixRtNH4SH_pre + xz_Cond - xz_Evap
      
      ! DelPress 򸵤, NH3  H2S κ
      xz_MixRtNH3_nxt = xz_MixRtNH3_pre - ( xz_Cond - xz_Evap )      &
        &                 * MolWtWet(NH3Num) / MolWtWet(NH4SHNum)
      xz_MixRtH2S_nxt = xz_MixRtH2S_pre - ( xz_Cond - xz_Evap )      &
        &                 * MolWtWet(H2SNum) / MolWtWet(NH4SHNum)
          
      !̤
      xz_PotTemp_nxt = xz_PotTemp_pre + xz_Gamma * ( xz_Cond - xz_Evap )
      
      !롼פ󤹤ѿѲ
      xz_PotTemp_pre     = xz_PotTemp_nxt
      xz_MixRtNH3_pre   = xz_MixRtNH3_nxt 
      xz_MixRtH2S_pre   = xz_MixRtH2S_nxt 
      xz_MixRtNH4SH_pre = xz_MixRtNH4SH_nxt 

    end do AdjustNH4SH

    call StoreCond( xz_PotTemp_nxt - xz_PotTemp ) 

    xz_PotTemp              = xz_PotTemp_nxt                 
    xza_MixRt(:,:,NH3Num)   = xz_MixRtNH3_nxt   - xza_MixRtBasicZ(:,:,NH3Num)
    xza_MixRt(:,:,H2SNum)   = xz_MixRtH2S_nxt   - xza_MixRtBasicZ(:,:,H2SNum)
    xza_MixRt(:,:,NH4SHNum) = xz_MixRtNH4SH_nxt - xza_MixRtBasicZ(:,:,NH4SHNum)
    
  end subroutine MoistAdjustNH4SH

  
end Module MoistAdjust
