!= Subroutine ECCM
!
! Authors::   ODAKA Masatsugu
! Version::   $Id: eccm.f90,v 1.13 2006/09/21 03:01:00 odakker Exp $
! Tag Name::  $Name: arare4-20060928 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǮŪ˾徺뵤βٸΨ׻, ſ尵ʿդ鰵Ϥ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * Ǯ, ʿʬ̤
!  * 顼٤­ʤΤ, 󥲥å. 
!
!== Future Plans
!

module ECCM

  !⥸塼ɤ߹
  use gridset,  only: DimZMin,       &!  Z β
    &                 DimZMax,       &!  Z ξ 
    &                 RegZMin,       &!
    &                 SpcNum,        &!
    &                 DelZ            !
  use basicset,only:  MolWtDry,      &!
!    &                 MolWtWet,      &!
    &                 CpDry,      &!
    &                 CpDryMol,      &!
    &                 SpcWetID,      &!
    &                 SpcWetSymbol,  &!
    &                 TempSfc,       &!
    &                 PressSfc,      &!
    &                 Grav            !
  use chemcalc, only: SvapPress,     &!
    &                 LatentHeatPerMol, &!
    &                 ReactHeatNH4SHPerMol
  use ChemData, only: GasRUniv,      &!
    &                 ChemData_OneSpcID
  use MoistFunc,only: DelMolFrNH4SH 

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿθ
  public ECCM_Init
  public ECCM_Temp_Press
  public ECCM_MolFr
  public ECCM_Stab

  !ѿ
  integer     :: LoopNum = 0
  integer     :: GasNum(10) = 0
  integer     :: CloudNum(10) = 0
  integer     :: NH3Num = 0
  integer     :: H2SNum = 0
  
  save LoopNum, GasNum, CloudNum
  save NH3Num, H2SNum
  
contains

  subroutine ECCM_Init( )

    !ۤηػ
    implicit none

    !ѿ
    integer                  :: s
    integer                  :: n1

    !-----------------------------------------------------------
    ! γȵΤ ID Ȥ
    !-----------------------------------------------------------
    !
    LoopNum = 0

    !ؼ椫γΤ, źʬ̤ݴ.
    SelectCloud: do s = 1, SpcNum
      
      ! NH4SH ˤĤƤ̵
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 
        cycle SelectCloud
      end if

      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      if (n1 /= 0) then
        LoopNum          = LoopNum + 1
        CloudNum(LoopNum)= s
        GasNum(LoopNum)  = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID(SpcWetSymbol(s)(1:n1-3) // '-g'))
      end if
    end do SelectCloud
    
    !-----------------------------------------------------------
    ! β˥, ӥ˥βǤ ID 
    !-----------------------------------------------------------
    NH3Num   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('NH3-g'))
    H2SNum   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('H2S-g'))

    !-----------------------------------------------------------
    ! ǧ
    !-----------------------------------------------------------
    if ( LoopNum == 0 ) then 
      write(*,*) "ECCM: CloudNum = 0, please comment out of MoistAdjust"
!      stop
    end if
    
    write(*,*) "ECCM_Init, LoopNum:      ", LoopNum
    write(*,*) "ECCM_Init, CloudNum:     ", CloudNum
    write(*,*) "ECCM_Init, GasNum:       ", GasNum    
    write(*,*) "ECCM_Init, NH3Num:       ", NH3Num
    write(*,*) "ECCM_Init, H2SNum:       ", H2SNum

  end subroutine ECCM_Init


!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Temp_Press( MolFrIni, z_Temp, z_Press )

    !ۤηػ
    implicit none
    
    real(8), intent(in) :: MolFrIni(1:SpcNum)
    real(8), intent(out):: z_Temp(DimZMin:DimZMax)
    real(8), intent(out):: z_Press(DimZMin:DimZMax)
    
    real(8)             :: z_MolFr(DimZMin:DimZMax, 0:SpcNum) 
                                                   !ʬΨ
    real(8)             :: z_DTempDZ(DimZMin:DimZMax) 
    real(8)             :: MolFr(0:SpcNum) 
    integer             :: k

    real(8)             :: Temp1, Press1, DTempDZ1
    real(8)             :: Temp2, Press2, DTempDZ2
    real(8)             :: Temp3, Press3, DTempDZ3
    real(8)             :: Temp4, Press4, DTempDZ4
    
    
    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !
    z_MolFr = 0.0d0
    z_MolFr(RegZMin, 1:SpcNum)   = MolFrIni(1:SpcNum) 
    z_MolFr(RegZMin, 0)          = 1.0d0 - sum(MolFrIni)
    z_MolFr(RegZMin-1, 1:SpcNum) = MolFrIni(1:SpcNum) 
    z_MolFr(RegZMin-1, 0)        = 1.0d0 - sum(MolFrIni)
    
    !ɽ̤Ǥβ(RegZMin ,  DelZ / 2 )
    z_Temp          = 1.0d-60
    z_Temp(RegZMin) = TempSfc - Grav / CpDry * ( DelZ * 5.0d-1 )
    
    !ɽ̤Ǥΰ(RegZMin ,  DelZ / 2 )
    z_Press           = 1.0d-60
    z_Press(RegZMin)  = PressSfc *((TempSfc / z_Temp(RegZMin)) &
      &                             ** ( - CpDryMol /  GasRUniv ))   


    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------    
    DtDz: do k = RegZMin, DimZMax-1
      
      !
      z_MolFr(k,:) = z_MolFr(k-1,:)
      
      !==============================================================
      !ǮΨ󥲥åˡѤƷ׻
      Temp1  = z_Temp(k)
      Press1 = z_Press(k)
      MolFr  = z_MolFr(k-1,:)
      call ECCM_DTempDZ( Temp1, Press1, z_MolFr(k,:), DTempDZ1 )
      
      Temp2  = Temp1 + DTempDZ1 * DelZ * 5.0d-1
      if (Temp2 < 0.0d0) exit DtDz
      Press2 =                                               &
        & Press1 * ( ( Temp1 / Temp2 )                       &
        &      ** (Grav * MolWtDry    / (GasRUniv * DTempDZ1) ) )
      call ECCM_DTempDZ( Temp2, Press2, MolFr, DTempDZ2 )

      Temp3  = Temp1 + DTempDZ2 * DelZ * 5.0d-1
      if (Temp3 < 0.0d0) exit DtDz
      Press3 =                                               &
        & Press1 * ( ( Temp1 / Temp3 )                       &
        &      ** (Grav * MolWtDry    / (GasRUniv * DTempDZ2) ) )
      call ECCM_DTempDZ( Temp3, Press3, MolFr, DTempDZ3 )
      
      Temp4  = Temp1 + DTempDZ3 * DelZ  
      if (Temp4 < 0.0d0) exit DtDz
      Press4 =                                               &
        & Press1 * ( ( Temp1 / Temp4 )                       &
        &      ** (Grav * MolWtDry    / (GasRUniv * DTempDZ3) ) )
      call ECCM_DTempDZ( Temp4, Press4, MolFr, DTempDZ4 )
      
      z_DTempDZ(k) = ( + DTempDZ1 + DTempDZ2 * 2.0d0           &
        &              + DTempDZ3 * 2.0d0 + DTempDZ4 ) / 6.0d0

      !==============================================================

      !٤׻
      z_Temp(k+1) = z_Temp(k) + z_DTempDz(k) * DelZ
      
      !Ϥſ尵ʿդ׻
      z_Press(k+1) =                                                  &
        &  z_Press(k) * ( ( z_Temp(k) / z_Temp(k+1))                  &
        &    ** (Grav * MolWtDry / ( z_DTempDZ(k) * GasRUniv ) ) )

      ! (DimZMax ǤͤĤ褦ˤ뤿)
      z_MolFr(k+1,:) = z_MolFr(k,:)
      z_MolFr(k+1,0) = 1.0d0 - sum( z_MolFr(k,1:SpcNum) )
      
      if (z_Temp(k+1) <= 0.0d0 ) exit DtDz

    end do DtDz
    
  end subroutine ECCM_Temp_Press



!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_MolFr( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    ! Ϳ줿٤Ф, ǮŪ˾徺˼¸
    ! Υץե
    !

    
    !ۤηػ
    implicit none
    
    real(8), intent(in) :: a_MolFrIni(1:SpcNum)
    real(8), intent(in) :: Humidity
    real(8), intent(in) :: z_Temp(DimZMin:DimZMax)
    real(8), intent(in) :: z_Press(DimZMin:DimZMax)
    real(8), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum)
    
    real(8)             :: DelMolFr
    integer             :: k, s
    

    !-----------------------------------------------------------
    ! ν
    !-----------------------------------------------------------
    do s = 1, SpcNum
      za_MolFr(:,s) = a_MolFrIni(s) 
    end do

    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------
    do k = RegZMin, DimZMax

      za_MolFr(k,:) = za_MolFr(k-1,:)
      
      !------------------------------------------------------------
      !NH4SH ʳβؼʿվ
      !------------------------------------------------------------
      do s = 1, LoopNum      

        !
        !ΥƥåפǤΥĶ뤳ȤϤʤ
        za_MolFr(k,GasNum(s)) =                                 &
          & min(                                                &
          &       za_MolFr(k-1,GasNum(s)),                      &
          &       SvapPress( SpcWetID(CloudNum(s)), z_Temp(k) ) &
          &        * Humidity / z_Press(k)                      &
          &      )
        
      end do

      !------------------------------------------------------------
      !NH4SH ʿվ
      !------------------------------------------------------------
      if ( NH3Num /= 0 ) then 
        
        !Ѳ. 
        !Ȥꤢ NH4SH Ф˰ 1.0 Ȥ(ȴ...).
        DelMolFr =                                            &
          & max (                                             &
          &    DelMolFrNH4SH(                                 &
          &      z_Temp(k), z_Press(k),                       &
          &      za_MolFr(k,NH3Num), za_MolFr(k,H2SNum), Humidity &
          &     ),                                            &
          &    0.0d0                                          &
          &  )
        
        za_MolFr(k,NH3Num) = za_MolFr(k,NH3Num) - DelMolFr 
        za_MolFr(k,H2SNum) = za_MolFr(k,H2SNum) - DelMolFr
        
        write(*,*) k, z_Temp(k), za_MolFr(k,NH3Num), za_MolFr(k,H2SNum)
      end if
      
    end do
  end subroutine ECCM_MolFr



  subroutine ECCM_DTempDZ( Temp, Press, MolFr, DTempDZ )
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: Temp
    real(8), intent(in) :: Press
    real(8), intent(inout) :: MolFr(0:SpcNum)    !ʬΨ
    real(8), intent(out):: DTempDZ
    real(8)             :: ReactHeat
    real(8)             :: Heat(SpcNum)
    real(8)             :: DelMolFr
    real(8)             :: SatPress
    real(8)             :: VapPress
    real(8)             :: Humidity
    real(8)             :: A, B
    integer             :: s

    !
    DTempDZ      = 0.0d0
    ReactHeat    = 0.0d0
    Heat         = 0.0d0
    DelMolFr     = 0.0d0
    SatPress     = 0.0d0
    VapPress     = 0.0d0

    !------------------------------------------------------------
    !NH4SH ʳβؼʿվ
    !------------------------------------------------------------
    do s = 1, LoopNum      
      
      !˰¾
      SatPress = SvapPress( SpcWetID(CloudNum(s)), Temp )
      
      !Ǯ. 
      Heat(GasNum(s)) = &
        & LatentHeatPerMol( SpcWetID(CloudNum(s)), Temp )
        
      !ΥʬΨѤƸߤξ׻
      VapPress = MolFr(GasNum(s)) * Press
      
      !˰¾ŷ̵ͭ
      if ( VapPress < SatPress ) then         
        !Ѳʤ
        MolFr(GasNum(s)) = MolFr(GasNum(s))
        
        !ŷ뤷ƤʤΤǮʤ.
        Heat(GasNum(s)) = 0.0d0          
      else      
        !˰¾ȰϤ鸽ߤΥ׻
        MolFr(GasNum(s)) = max(SatPress / Press, 1.0d-16)
      end if
    end do

    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    if ( NH3Num /= 0 ) then 

      Humidity = 1.0d0
      DelMolFr =                                            &
        & max (                                             &
        &    DelMolFrNH4SH(                                 &
        &         Temp, Press, MolFr(NH3Num), MolFr(H2SNum),&
        &         Humidity                                  &
        &      ),                                           &
        &    0.0d0                                          &
        &  )
      MolFr(NH3Num) = MolFr(NH3Num) - DelMolFr
      MolFr(H2SNum) = MolFr(H2SNum) - DelMolFr

      ReactHeat = ReactHeatNH4SHPerMol * DelMolFr
    end if

    !------------------------------------------------------------
    !ٸۤ׻
    !------------------------------------------------------------
    !
    MolFr(0) = 1.0d0 - sum( MolFr(1:SpcNum) )

    !ʬ

    !.  Temp(i) ɾ
    A = dot_product( Heat(1:SpcNum), MolFr(1:SpcNum)) &
      &  / ( GasRUniv * Temp )
    B = dot_product(( Heat(1:SpcNum) ** 2.0d0), MolFr(1:SpcNum)) &
      &  / ( CpDryMol * GasRUniv * ( Temp ** 2.0d0 ) )

    !ǮٸΨ
    DTempDZ = - Grav * MolWtDry * ( 1.0d0 + A )   &
      &         / ( CpDryMol * ( 1.0d0 + B ) )     &
      &       + ReactHeat / ( CpDryMol * DelZ )
   
!    write(*,*) A, B, ReactHeat, DTempDZ 
!    write(*,*) MolWtDry, CpDryMol 
!    write(*,*) CpDryMol / MolWtDry, CpDry
  end subroutine ECCM_DTempDZ



  subroutine ECCM_Stab( xz_PotTemp, xz_Exner, xza_MixRt, &
    &                   xz_Stab, xz_StabTemp, xz_StabMolWt )

    use gridset,  only: DimXMin,       &!  X β
      &                 DimXMax,       &!  X ξ 
      &                 DimZMin,       &!  Z β
      &                 DimZMax,       &!  Z ξ 
      &                 SpcNum          !
    use basicset,only:  MolWtDry,      &!
      &                 MolWtWet,      &!
      &                 CpDry,         &!
      &                 Grav,          &!
      &                 xz_ExnerBasicZ,   &!
      &                 xz_PotTempBasicZ, &!
      &                 xza_MixRtBasicZ
    use storeset,only:  StoreStab
    use average, only:  xz_avr_xr
    use differentiate_center2, only: xr_dz_xz
    
    implicit none

    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(in)  :: xz_Exner(DimXMin:DimXMax,  DimZMin:DimZMax)
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8), intent(out) :: xz_Stab(DimXMin:DimXMax,   DimZMin:DimZMax)
    real(8), intent(out) :: xz_StabTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_StabMolWt(DimXMin:DimXMax, DimZMin:DimZMax)

    real(8)    :: xza_MolFrAll(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum)
    real(8)    :: xz_TempAll(DimXMin:DimXMax,  DimZMin:DimZMax)
    real(8)    :: xz_MolWtWet(DimXMin:DimXMax, DimZMin:DimZMax)
    integer    :: i, k, s

    xz_TempAll = (xz_PotTemp + xz_PotTempBasicZ) * (xz_Exner + xz_ExnerBasicZ)
    do s = 1, SpcNum
      xza_MolFrAll(:,:,s) =                             &
        &   (xza_MixRt(:,:,s) + xza_MixRtBasicZ(:,:,s)) &
        &   * MolWtDry / MolWtWet(s) 
    end do
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_MolWtWet(i,k) = dot_product( MolWtWet(1:3), xza_MolFrAll(i,k,1:3) )
      end do
    end do
    
    xz_StabTemp =   &
      &         Grav / xz_TempAll &
      &           * ( xz_avr_xr( xr_dz_xz( xz_TempAll ) ) + Grav / CpDry ) 
    xz_StabMolWt =   &
      &       - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) / MolWtDry
    xz_Stab =   &
      &         Grav / xz_TempAll &
      &           * ( xz_avr_xr( xr_dz_xz( xz_TempAll ) ) + Grav / CpDry ) &
      &       - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) / MolWtDry

    where (xz_Stab < 1.0d-7) 
      xz_Stab = 1.0d-7
    end where

    call StoreStab( xz_Stab, xz_StabTemp, xz_StabMolWt)
    
  end subroutine ECCM_Stab


  
  subroutine ECCM_StabStore( xz_PotTemp, xz_Exner, xza_MixRt, &
    &                        xz_Stab, xz_StabTemp, xz_StabMolWt )

    use gridset,  only: DimXMin,       &!  X β
      &                 DimXMax,       &!  X ξ 
      &                 DimZMin,       &!  Z β
      &                 DimZMax,       &!  Z ξ 
      &                 SpcNum          !
    use basicset,only:  MolWtDry,      &!
      &                 MolWtWet,      &!
      &                 CpDry,         &!
      &                 Grav,          &!
      &                 xz_ExnerBasicZ,   &!
      &                 xz_PotTempBasicZ, &!
      &                 xza_MixRtBasicZ
    use average, only: xz_avr_xr
    use differentiate_center2, only: xr_dz_xz
    
    implicit none

    real(8), intent(in)    :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)    :: xz_Exner(DimXMin:DimXMax,   DimZMin:DimZMax)
    real(8), intent(in)    :: xza_MixRt(DimXMin:DimXMax,  DimZMin:DimZMax, SpcNum)
    real(8), intent(inout) :: xz_Stab(DimXMin:DimXMax,    DimZMin:DimZMax)
    real(8), intent(inout) :: xz_StabTemp(DimXMin:DimXMax,    DimZMin:DimZMax)
    real(8), intent(inout) :: xz_StabMolWt(DimXMin:DimXMax,    DimZMin:DimZMax)

    real(8)              :: xza_MolFrAll(DimXMin:DimXMax,  DimZMin:DimZMax, SpcNum)
    real(8)              :: xz_TempAll(DimXMin:DimXMax,  DimZMin:DimZMax)
    real(8)              :: xz_MolWtWet(DimXMin:DimXMax,  DimZMin:DimZMax)
    integer              :: i, k, s

    xz_TempAll = (xz_PotTemp + xz_PotTempBasicZ) * (xz_Exner + xz_ExnerBasicZ)
    do s = 1, SpcNum
      xza_MolFrAll(:,:,s) = &
        &   (xza_MixRt(:,:,s) + xza_MixRtBasicZ(:,:,s)) * MolWtDry / MolWtWet(s) 
    end do
    
    !ʬ̤δܾ줫Τ.
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_MolWtWet(i,k) = dot_product( MolWtWet(1:3), xza_MolFrAll(i,k,1:3) )
      end do
    end do
    
    xz_StabTemp  = xz_StabTemp  &
      &            + Grav / xz_TempAll &
      &              * ( xz_avr_xr( xr_dz_xz( xz_TempAll ) ) + Grav / CpDry ) 
    xz_StabMolWt = xz_StabMolWt  &
      &            - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) / MolWtDry
    xz_Stab = xz_Stab  &
      &       + Grav / xz_TempAll &
      &           * ( xz_avr_xr( xr_dz_xz( xz_TempAll ) ) + Grav / CpDry ) &
      &       - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) / MolWtDry

    where (xz_Stab < 1.0d-7) 
      xz_Stab = 1.0d-7
    end where
    
  end subroutine ECCM_StabStore

  
end module ECCM
