!= Program Arare
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: arare.f90,v 1.33 2006/09/28 11:54:27 odakker Exp $
! Tag Name::  $Name: arare4-20060928 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ϳإǥ deepconv/arare. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * ϤϽవ̷.
!
!== Future Plans
!
!

program arare
  !
  !ϳإǥ deepconv/arare. 
  !

  !----- ⥸塼ɤ߹ ------
  !-----    ⥸塼   -----
  !  ̷׻⥸塼
  use chemcalc

  !  ϥե̾⥸塼
  use fileset,       only : fileset_init, &
    &                       InitFile

  !  ǥХåϴ⥸塼
  use debugset,      only : debugset_init

  !  ִ⥸塼
  use timeset,       only : timeset_init, &
    &                       NstepLong, NstepShort, DelTimeLong, DelTimeShort, &
    &                       TimeDisp

  !  ʻ⥸塼 
  use gridset,       only : gridset_init, &
    &                       DimXMin, DimXMax, DimZMin, DimZMax, SpcNum

  !  ܾ⥸塼
  use basicset,      only : basicset_init, &
    &                       xz_DensBasicZ, xza_MixRtBasicZ, xz_PotTempBasicZ, &
    &                       xz_VelSoundBasicZ

  !  ѻʹ⥸塼
  use storeset,      only : storeset_init, storeclean


  !-----    ⥸塼   -----
  !  ໤׻⥸塼 
  use damping,       only : damping_init, & 
    &                       xz_DampSponge, pz_DampSponge, xr_DampSponge  

  !  ʬե륿⥸塼
  use timefilter,    only : AsselinFilter, xza_AsselinFilter_xza_xza_xza

  !  Ŭѥ⥸塼
  use boundary,      only : xz_BoundaryXCyc_xz, xz_BoundaryZSym_xz,     &
    &                       xza_BoundaryXCyc_xza, xza_BoundaryZSym_xza, &
    &                       pz_BoundaryXCyc_pz, pz_BoundaryZSym_pz,     &
    &                       xr_BoundaryXCyc_xr, xr_BoundaryZAntiSym_xr

  !  CFL ǧ⥸塼
  use cflcheck,      only : CFLCheckTimeShort, &
    &                       CFLCheckTimeLongVelX, CFLCheckTimeLongVelZ

  !  μ̤Ŷ׻⥸塼
  use fillnegative,  only : FillNegative_init, xza_FillNegative_xza

  !-----    ϥ⥸塼   -----
  !  ꥹȥեϥ⥸塼
  use RestartFileIO, only : ReStartFile_Open, ReStartFile_OutPut, &
    &                       ReStartFile_Close, ReStartFile_Get

  !  ҥȥեϥ⥸塼
  use HistoryFileIO, only : HistoryFile_Open, HistoryFile_OutPut, &
    &                       HistoryFile_Close

  !-----       ϳز        -----
  !  ϳز׻Ѵؿ⥸塼
  use DynFunc,       only : xz_AdvScalar, xz_AdvScalar2, pz_AdvVelX, &
    &                       xr_Buoy, xr_AdvVelZ, pz_GradPi

  !  ϳزˡ׻Ѵؿ⥸塼
  use DynImpFunc,    only : xz_Exner_init, xz_Exner, xr_GradPi

  !-----       ʪ        -----
  !  ͳȻ׻ѥ⥸塼
  use NumDiffusion,  only : NumDiffusion_Init, xz_NumDiffScalar, &
    &                       xz_NumDiffScalar2, pz_NumDiffVelX, xr_NumDiffVelZ

  !  ήȻ׻ѥ⥸塼
  use Turbulence,   only : Turbulence_Init, &
    &                      xz_TurbScalar, xz_TurbScalar2, pz_TurbVelX, &
    &                      xr_TurbVelZ  , xz_ShearKm    , xz_DispKm,   &
    &                      xz_DispHeat

  !  Ͷ׻ѥ⥸塼
  use Radiation,    only : Radiation_init,  &
    &                      xz_RadHeatConst, xz_NewtonCool

  !  ɽեå׻ѥ⥸塼
  use HeatFlux,     only : xz_HeatFluxBulk, xz_MixRtFluxBulk


  !  ˰Ĵˡ׻ѥ⥸塼
  use MoistAdjust,  only : MoistAdjust_Init, MoistAdjustSvapPress, MoistAdjustNH4SH

  !  ʪѥ᥿ꥼ
  use WarmRainPrm,  only : WarmRainPrm_Init, xz_Rain2GasHeat, xza_Rain2Gas, &
    &                      xza_Rain2GasNH4SH, xz_Rain2GasHeatNH4SH,         &
    &                      xza_Cloud2Rain, xz_FallRain

  !  ᵤϷ׻ѥ⥸塼
  use MoistBuoyancy,only : MoistBuoy_Init, xz_BuoyMoistKm, xr_BuoyMolWt, &
    &                      xr_BuoyDrag
  
  !  Ǯ徺βٸΨ׻ѥ⥸塼
  use ECCM,         only : eccm_init, eccm_stab
  

  !ۤηػ
  implicit none

  !ѿ
  character(80) :: cfgfile
  real(8), allocatable :: pz_VelXBl(:,:)
  real(8), allocatable :: pz_VelXNl(:,:)
  real(8), allocatable :: pz_VelXAl(:,:)
  real(8), allocatable :: pz_VelXNs(:,:)
  real(8), allocatable :: pz_VelXAs(:,:)
  real(8), allocatable :: xr_VelZBl(:,:)
  real(8), allocatable :: xr_VelZNl(:,:)
  real(8), allocatable :: xr_VelZAl(:,:)
  real(8), allocatable :: xr_VelZNs(:,:)
  real(8), allocatable :: xr_VelZAs(:,:)
  real(8), allocatable :: xz_ExnerBl(:,:)
  real(8), allocatable :: xz_ExnerNl(:,:)
  real(8), allocatable :: xz_ExnerAl(:,:)
  real(8), allocatable :: xz_ExnerNs(:,:)
  real(8), allocatable :: xz_ExnerAs(:,:)
  real(8), allocatable :: xz_PotTempWork(:,:)
  real(8), allocatable :: xz_PotTempBl(:,:)
  real(8), allocatable :: xz_PotTempNl(:,:)
  real(8), allocatable :: xz_PotTempAl(:,:)
  real(8), allocatable :: xz_KmBl(:,:)
  real(8), allocatable :: xz_KmNl(:,:)
  real(8), allocatable :: xz_KmAl(:,:)
  real(8), allocatable :: xz_KhBl(:,:)
  real(8), allocatable :: xz_KhNl(:,:)
  real(8), allocatable :: xz_KhAl(:,:)
  real(8), allocatable :: xza_MixRtWork(:,:,:)
  real(8), allocatable :: xza_MixRtBl(:,:,:)
  real(8), allocatable :: xza_MixRtNl(:,:,:)
  real(8), allocatable :: xza_MixRtAl(:,:,:)

  real(8), allocatable :: pz_AccelVelXNl(:,:)
  real(8), allocatable :: xr_AccelVelZNl(:,:)
  real(8), allocatable :: xza_DelMixRt(:,:,:)

  real(8), allocatable :: xz_Stab(:,:)
  real(8), allocatable :: xz_StabTemp(:,:)
  real(8), allocatable :: xz_StabMolWt(:,:)

  real(8)              :: Time
  real(8)              :: ReStartTime(2)
  real(8), allocatable :: DelTimeLFrog(:)
  real(8)              :: DelTimeEular
  integer, allocatable :: NStepEular(:)
  integer              :: NStepLFrog

  integer              :: t, tau
  integer              :: spc

 
  !----------------------------------------------------------------------
  ! ѿȷ⥸塼ν
  !----------------------------------------------------------------------
  !NAMELIST եμ
  call getarg( 1, cfgfile )
  write(*,*) "Input NAMELIST file: ", cfgfile
  
  !I/O ե̾ν
  !  NAMELIST ե̾ꤷ, deepconv/arare 
  !  ϥե̾ NAMELIST 
  call fileset_init(cfgfile)
  
  !ǥХν
  !  NAMELIST , ǥХåϥåؤԤ.  
  call debugset_init(cfgfile)
  
  !˴ؤν
  !  NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
  call timeset_init(cfgfile)

  !ʻν
  !  NAMELIST , ʻ׻
  call gridset_init(cfgfile)
  
  !ܾξν
  !  NAMELIST , ܾꤹ.
  call basicset_init(cfgfile)
  
  !ѻͤݴɤ뤿Υ⥸塼ν
  !  NAMELIST , ܾꤹ.
  call storeset_init( )
  
  !ѿν. ȤꤢͤꤵƤ. 
  call ArareAlloc
  
  !ͽѿν
  !  ReStartFile ꤵƤˤϥեɤ߹, 
  !  ꤵƤʤˤ, ǥեȤδܾȾ. 
  call ECCM_Init()
  if (trim(InitFile) /= '') then    

    !ܾ, νͤ netCDF ե뤫.
    call ReStartFile_Get(            &
      & ReStartTime,                 &
      & xz_PotTempBl, xz_ExnerBl, pz_VelXBl, xr_VelZBl, &
      & xza_MixRtBl,  xz_KmBl,    xz_KhBl,              &
      & xz_PotTempNl, xz_ExnerNl, pz_VelXNl, xr_VelZNl, &
      & xza_MixRtNl,  xz_KmNl,    xz_KhNl               )
  else
    !ǥեδܾ, . 
    call BasicEnv()
    call DisturbEnv(cfgfile,                            &
      & xz_PotTempBl, xz_ExnerBl, pz_VelXBl, xr_VelZBl, &
      & xza_MixRtBl,  xz_KmBl,    xz_KhBl               )
    
    ! 1 롼ܤ, bl  nl ͤƱˤƤ. 
    ! 1 ƥåܤϥ顼ˡǲɬפ뤬, 
    ! 1 ƥåܤȤʳΥƥåפ̡˥ǥ󥰤ʤ
    xz_PotTempNl = xz_PotTempBl
    xz_ExnerNl   = xz_ExnerBl
    pz_VelXNl    = pz_VelXBl
    xr_VelZNl    = xr_VelZBl
    xza_MixRtNl  = xza_MixRtBl
    xz_KmNl      = xz_KmBl
    xz_KhNl      = xz_KhBl
  end if
  
  
  !----------------------------------------------------------------------
  ! ѥå⥸塼ν
  !   ǥեȤͤѹɬפΤ롼Τ߽
  !----------------------------------------------------------------------
  call Damping_Init( cfgfile )      !Ȥθ그ν
  call NumDiffusion_Init()          !ͳȻν
  call Turbulence_Init()            !ή׻ν
  call MoistAdjust_Init()           !˰Ĵˡν
  call WarmRainPrm_Init( cfgfile )  !ȤΥѥ᥿ꥼν
  call FillNegative_Init( xza_MixRtBasicZ, xz_DensBasicZ) 
                                    !ήˤ̤ν
  call Radiation_Init( cfgfile )    !Ͷν
  call MoistBuoy_Init()             !ʬ̤ФϷ׻롼ν
  call xz_Exner_Init()              !ˡν  
       

  !----------------------------------------------------------------------
  ! ȥ롼ײν 
  !----------------------------------------------------------------------
  NstepLFrog   = NstepLong 
  NstepEular   = NstepShort 
  DelTimeLFrog = DelTimeLong * 2.0d0 
  DelTimeEular = DelTimeShort
  if ( trim(InitFile) /= '') then    
    Time = ReStartTime(2)               !ꥹȳϻ
  else
    Time = 0.0d0                          !׻ϻ
    NstepEular(1)   = NstepShort /2 ! 1 롼ܤ
    DelTimeLFrog(1) = DelTimeLong         ! 1 롼ܤ
  end if

 
  !----------------------------------------------------------------
  ! ե
  !----------------------------------------------------------------
  !ե륪ץ
  call HistoryFile_Open( )

  if ( trim(InitFile) /= '') then    
    call HistoryFile_Output(  &
      &  ReStartTime(2),      &
      &  xz_PotTempNl,        &
      &  xz_ExnerNl,          &
      &  pz_VelXNl,           &
      &  xr_VelZNl,           &
      &  xza_MixRtNl,         &
      &  xz_KmNl,             &
      &  xz_KhNl            )
  end if

  ! 0 ξˤϽ
  if ( Time == 0 ) then
    call HistoryFile_Output(  &
      &  Time,                &
      &  xz_PotTempNl,        &
      &  xz_ExnerNl,          &
      &  pz_VelXNl,           &
      &  xr_VelZNl,           &
      &  xza_MixRtNl,         &
      &  xz_KmNl,             &
      &  xz_KhNl            )
  end if
  
  !----------------------------------------------------------------------
  ! Υå
  !----------------------------------------------------------------------
  !CFL Υå
  call CFLCheckTimeShort( xz_VelSoundBasicZ )

  !----------------------------------------------------------------------
  ! ʬ
  !----------------------------------------------------------------------
  LFrog: do t = 1, NstepLFrog

    !
    Time = Time + DelTimeLong
!    write(*,*) Time

    !----------------------------------------------------------------
    ! Ǵ, Ȼ.
    !----------------------------------------------------------------
    xz_KmAl =                                                       &
      & xz_KmBl                                                     &
      & + DelTimeLFrog(t)                                           &
      &   * (                                                       &
      &     + xz_AdvScalar(xz_KmNl, pz_VelXNl, xr_VelZNl)           &
      &     + xz_BuoyMoistKm(xz_PotTempBl, xz_ExnerBl, xza_MixRtBl) &
      &     + xz_ShearKm(xz_KmBl, pz_VelXBl, xr_VelZBl)             &   
      &     + xz_NumDiffScalar(xz_KmBl)                             &
      &     + xz_DispKm(xz_KmBl)                                    &
      &    )
    
    !ͤξ²¤
    !  * ͤˤʤ뤳Ȥݾڤ
    !  * ͤξ¤ 800 Ȥ. (1994, ذʸ)
    xz_KmAl = max( 0.0d0, min( xz_KmAl, 800.0d0 ) )

    !
    xz_KmAl = xz_BoundaryXCyc_xz( xz_KmAl )
    xz_KmAl = xz_BoundaryZSym_xz( xz_KmAl )
   
    !Ȼ
    xz_KhAl = 3.0d0 * xz_KmAl

    !----------------------------------------------------------------
    ! ̤ΰή׻.
    !----------------------------------------------------------------    
    !ʬ
    xz_PotTempAl =                                                  &
      &   xz_PotTempBl                                              &
      & + DelTimeLFrog(t)                                           &
      &   * (                                                       &
      &     + xz_AdvScalar2( xz_PotTempNl,     pz_VelXNl, xr_VelZNl)&
      &     + xz_AdvScalar2( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl)&
      &     + xz_TurbScalar2(xz_PotTempBl,     xz_KhBl)             &
      &     + xz_TurbScalar2(xz_PotTempBasicZ, xz_KhBl)             &
      &     + xz_NumDiffScalar2(xz_PotTempBl)                       &
      &     + xz_DispHeat( xz_KhBl )                                &
      &     + xz_RadHeatConst( xz_ExnerBl )                         &
!      &     + xz_NewtonCool( xz_PotTempBl )                         &
      &     + xz_HeatFluxBulk( xz_PotTempNl )                       &
      &      )

    !
    xz_PotTempAl = xz_BoundaryXCyc_xz( xz_PotTempAl )
    xz_PotTempAl = xz_BoundaryZSym_xz( xz_PotTempAl )
    
    !----------------------------------------------------------------
    ! Žʬκΰή׻.
    !----------------------------------------------------------------
    do spc = 1, SpcNum
      xza_MixRtAl(:,:,spc) =                                               & 
        &   xza_MixRtBl(:,:,spc)                                           &
        & + DelTimeLFrog(t)                                                &
        &   * (                                                            &
        &    + xz_AdvScalar(xza_MixRtNl(:,:,spc),     pz_VelXNl, xr_VelZNl)&
        &    + xz_AdvScalar(xza_MixRtBasicZ(:,:,spc), pz_VelXNl, xr_VelZNl)& 
        &    + xz_TurbScalar(xza_MixRtBl(:,:,spc),    xz_KhBl)             &
        &    + xz_TurbScalar(xza_MixRtBasicZ(:,:,spc),xz_KhBl)             &
        &    + xz_NumDiffScalar(xza_MixRtBl(:,:,spc))                      &
        &    + xz_FallRain(xza_MixRtBl(:,:,spc), spc)                      &
        &    + xz_MixRtFluxBulk(xza_MixRtNl(:,:,spc))                      &
        &   )
    end do

    !ήˤäˤʤäʬ
    xza_MixRtAl = xza_FillNegative_xza( xza_MixRtAl )

    !
    xza_MixRtAl = xza_BoundaryXCyc_xza( xza_MixRtAl )
    xza_MixRtAl = xza_BoundaryZSym_xza( xza_MixRtAl )


    !-------------------------------------------------------------
    ! ȤΥѥ᥿ꥼ.
    !   <--> ѴԤ
    !-------------------------------------------------------------
    !鱫ؤѴʬɲä. 
    !  xza_Cloud2Rain ؿ, Ȥƻֹߤ뤳Ȥ, 
    !  ʬͤϤ. 
    xza_MixRtWork = xza_MixRtAl
    xza_MixRtAl   = xza_MixRtWork + xza_Cloud2Rain( xza_MixRtAl, DelTimeLFrog(t) )
    
    !
    xza_MixRtAl = xza_BoundaryXCyc_xza( xza_MixRtAl )
    xza_MixRtAl = xza_BoundaryZSym_xza( xza_MixRtAl )

    
    !-------------------------------------------------------------
    ! ˰Ĵˡ
    !   <-->ѴԤ.
    !-------------------------------------------------------------
    call MoistAdjustSvapPress(  xz_ExnerNl, xz_PotTempAl, xza_MixRtAl )
    call MoistAdjustNH4SH( xz_ExnerNl, xz_PotTempAl, xza_MixRtAl )

    !
    xza_MixRtAl = xza_BoundaryXCyc_xza( xza_MixRtAl )
    xza_MixRtAl = xza_BoundaryZSym_xza( xza_MixRtAl )


    !-------------------------------------------------------------
    ! ȤΥѥ᥿ꥼ.
    !   <--> ѴԤ
    !-------------------------------------------------------------
    !ؤѴȼѲ׻
    !  xza_Rain2Gas ؿ, Ȥƻֹߤ뤳Ȥ, 
    !  ʬͤϤ. 
    xza_DelMixRt = 0.0d0
    xza_DelMixRt =                                                    &
      & (                                                             &
      &   + xza_Rain2Gas(                                             &
      &        xz_ExnerNl, xz_PotTempAl, xza_MixRtAl, DelTimeLFrog(t) &
      &       )                                                       &
      &   + xza_Rain2GasNH4SH(                                        &
      &        xz_ExnerNl, xz_PotTempAl, xza_MixRtAl, DelTimeLFrog(t) &
      &       )                                                       &
      &  )    
    
    !̤η׻. ؤѴȼǮȿǮɲ.
    xz_PotTempWork = xz_PotTempAl
    xz_PotTempAl =                                                       &   
      & xz_PotTempWork                                                   &
      & + (                                                              &
      &      + xz_Rain2GasHeat( xz_PotTempAl, xz_ExnerNl, xza_DelMixRt ) & 
      &     + xz_Rain2GasHeatNH4SH( xz_ExnerNl, xza_DelMixRt )          &
      &    )
    
    !
    xz_PotTempAl = xz_BoundaryXCyc_xz( xz_PotTempAl )
    xz_PotTempAl = xz_BoundaryZSym_xz( xz_PotTempAl )

    !η׻. ؤѴʬɲ
    xza_MixRtWork = xza_MixRtAl
    xza_MixRtAl   = xza_MixRtWork + xza_DelMixRt

    !
    xza_MixRtAl = xza_BoundaryXCyc_xza( xza_MixRtAl )
    xza_MixRtAl = xza_BoundaryZSym_xza( xza_MixRtAl )
    
    !-------------------------------------------------------------
    ! Ĺ֥ƥåפǤ, ®٤ΰή, Ȼ, Ǵ, 
    !-------------------------------------------------------------
    pz_AccelVelXNl =                                    &
      & + pz_AdvVelX(pz_VelXNl, xr_VelZNl)              &
      & + pz_TurbVelX(xz_KmBl,   pz_VelXBl, xr_VelZBl)  &
      & + pz_NumDiffVelX(pz_VelXBl)
    
    xr_AccelVelZNl =                                    &
      & + xr_AdvVelZ(xr_VelZNl, pz_VelXNl)              &
      & + xr_Buoy(xz_PotTempNl)                         &    
      & + xr_BuoyMolWt(xza_MixRtNl)                     &
      & + xr_BuoyDrag(xza_MixRtNl)                      &
      & + xr_TurbVelZ(xz_KmBl,   pz_VelXBl, xr_VelZBl)  &
      & + xr_NumDiffVelZ(xr_VelZBl)                        

    !-------------------------------------------------------------
    ! û֥ƥåפνͺ
    !-------------------------------------------------------------
    pz_VelXNs  = pz_VelXBl
    xr_VelZNs  = xr_VelZBl
    xz_ExnerNs = xz_ExnerBl
    
    !-------------------------------------------------------------
    ! û֥ƥåפʬ. 顼ˡ
    !-------------------------------------------------------------
    Eular: do tau = 1, NstepEular(t)

      !-------------------------------------------------------------
      ! ® u η׻
      !-------------------------------------------------------------
      pz_VelXAs = &
        & pz_VelXNs                                          &
        &  + DelTimeEular                                    &
        &    * (                                             &
        &     - pz_GradPi(xz_ExnerNs, pz_VelXNs, xr_VelZNs)  &
        &     + pz_AccelVelXNl                                   &
        &     )

      !
      pz_VelXAs = pz_BoundaryXCyc_pz( pz_VelXAs )
      pz_VelXAs = pz_BoundaryZSym_pz( pz_VelXAs )

      !-------------------------------------------------------------
      ! ʡؿη׻
      !-------------------------------------------------------------
      xz_ExnerAs = xz_Exner( &
        & xr_AccelVelZNl,     &
        & pz_VelXNs,      &
        & pz_VelXAs,      &
        & xr_VelZNs,      &
        & xz_ExnerNs)

      !
      xz_ExnerAs = xz_BoundaryXCyc_xz( xz_ExnerAs )
      xz_ExnerAs = xz_BoundaryZSym_xz( xz_ExnerAs )

      !-------------------------------------------------------------
      ! ® w η׻
      !-------------------------------------------------------------
      xr_VelZAs =                                                    &
        & xr_VelZNs                                                  &
        &  + DelTimeEular                                            &
        &    * (                                                     &
        &     - xr_GradPi(xz_ExnerAs,xz_ExnerNs,pz_VelXNs,xr_VelZNs) &
        &     + xr_AccelVelZNl                                           &
        &     )

      !
      xr_VelZAs = xr_BoundaryXCyc_xr( xr_VelZAs )
      xr_VelZAs = xr_BoundaryZAntiSym_xr( xr_VelZAs )
      
      !-------------------------------------------------------------
      ! û֥ƥåפΥ롼פ󤹤ν
      !-------------------------------------------------------------
      xz_ExnerNs  = xz_ExnerAs
      pz_VelXNs   = pz_VelXAs
      xr_VelZNs   = xr_VelZAs

    end do Eular
    
    !----------------------------------------------------------------
    ! ǽŪû֥ƥåפǤͤĹ֥ƥåפǤͤȤߤʤ
    !----------------------------------------------------------------
    xz_ExnerAl  = xz_ExnerAs
    pz_VelXAl   = pz_VelXAs
    xr_VelZAl   = xr_VelZAs

    !-------------------------------------------------------------
    ! åλ֥ե륿.  Nl ͤե륿
    !-------------------------------------------------------------
    xz_ExnerNl   = AsselinFilter(xz_ExnerAl, xz_ExnerNl, xz_ExnerBl)
    pz_VelXNl    = AsselinFilter(pz_VelXAl,  pz_VelXNl,  pz_VelXBl )
    xr_VelZNl    = AsselinFilter(xr_VelZAl,  xr_VelZNl,  xr_VelZBl )
    xz_PotTempNl = AsselinFilter(xz_PotTempAl, xz_PotTempNl, xz_PotTempBl)
    xz_KmNl      = AsselinFilter(xz_KmAl, xz_KmNl, xz_KmBl)
    xza_MixRtNl  = xza_AsselinFilter_xza_xza_xza(                &
      &                xza_MixRtAl, xza_MixRtNl, xza_MixRtBl     &
      &              )
    
    !-------------------------------------------------------------
    ! ݥ
    !-------------------------------------------------------------
    xz_ExnerAl   = xz_DampSponge( xz_ExnerAl,    xz_ExnerBl,   DelTimeLFrog(t) )
    pz_VelXAl    = pz_DampSponge( pz_VelXAl,     pz_VelXBl,    DelTimeLFrog(t) )
    xr_VelZAl    = xr_DampSponge( xr_VelZAl,     xr_VelZBl,    DelTimeLFrog(t) )
    xz_PotTempAl = xz_DampSponge( xz_PotTempAl,  xz_PotTempBl, DelTimeLFrog(t) )
    xz_KmAl      = xz_DampSponge( xz_KmAl,       xz_KmBl,      DelTimeLFrog(t) )
!    xz_ExnerAl   = xz_ExnerAl   - DelTimeLFrog(t) * xz_DampSponge_xz(xz_ExnerBl)
!    pz_VelXAl    = pz_VelXAl    - DelTimeLFrog(t) * pz_DampSponge_pz(pz_VelXBl )
!    xr_VelZAl    = xr_VelZAl    - DelTimeLFrog(t) * xr_DampSponge_xr(xr_VelZBl )
!    xz_PotTempAl = xz_PotTempAl - DelTimeLFrog(t) * xz_DampSponge_xz(xz_PotTempBl)
!    xz_KmAl      = xz_KmAl      - DelTimeLFrog(t) * xz_DampSponge_xz(xz_KmBl)

    !--------------------------------------------------------------
    ! 椬ʲˤʤʤν
    !---------------------------------------------------------------
    xza_MixRtAl = max( - xza_MixRtBasicZ, xza_MixRtAl )
    
    !-------------------------------------------------------------
    ! 
    !-------------------------------------------------------------
    xz_KmAl      = xz_BoundaryXCyc_xz( xz_KmAl )
    xz_KmAl      = xz_BoundaryZSym_xz( xz_KmAl )
    xz_PotTempAl = xz_BoundaryXCyc_xz( xz_PotTempAl )
    xz_PotTempAl = xz_BoundaryZSym_xz( xz_PotTempAl )
    xza_MixRtAl  = xza_BoundaryXCyc_xza( xza_MixRtAl )
    xza_MixRtAl  = xza_BoundaryZSym_xza( xza_MixRtAl )
    pz_VelXAs    = pz_BoundaryXCyc_pz( pz_VelXAl )
    pz_VelXAs    = pz_BoundaryZSym_pz( pz_VelXAl )
    xz_ExnerAs   = xz_BoundaryXCyc_xz( xz_ExnerAl )
    xz_ExnerAs   = xz_BoundaryZSym_xz( xz_ExnerAl )
    xr_VelZAs    = xr_BoundaryXCyc_xr( xr_VelZAl )
    xr_VelZAs    = xr_BoundaryZAntiSym_xr( xr_VelZAl )

    !----------------------------------------------------------------
    ! ٤η׻. ͤ StoreSet ݻ
    !----------------------------------------------------------------
    call ECCM_Stab( xz_PotTempAl, xz_ExnerAl, xza_MixRtAl,  &
      &             xz_Stab, xz_StabTemp, xz_StabMolWt       )

    !----------------------------------------------------------------
    ! Ĺ֥ƥåפΥ롼פ󤹤ν
    !----------------------------------------------------------------
    xz_PotTempBl = xz_PotTempNl
    xza_MixRtBl  = xza_MixRtNl
    xz_ExnerBl   = xz_ExnerNl
    pz_VelXBl    = pz_VelXNl
    xr_VelZBl    = xr_VelZNl
    xz_KmBl      = xz_KmNl
    xz_KhBl      = xz_KhNl
    
    xz_PotTempNl = xz_PotTempAl
    xza_MixRtNl  = xza_MixRtAl
    xz_ExnerNl   = xz_ExnerAl
    pz_VelXNl    = pz_VelXAl
    xr_VelZNl    = xr_VelZAl
    xz_KmNl      = xz_KmAl
    xz_KhNl      = xz_KhAl
    
    !----------------------------------------------------------------
    ! ե
    !----------------------------------------------------------------
    if ( mod( anint(Time), TimeDisp ) == 0 ) then

      ! CFL Υå
      write(*,*) Time
      call CFLCheckTimeLongVelX( pz_VelXNl )
      call CFLCheckTimeLongVelZ( xr_VelZNl )

      !ҥȥե
      call HistoryFile_Output(  &
        &  Time,                &
        &  xz_PotTempNl,        &
        &  xz_ExnerNl,          &
        &  pz_VelXNl,           &
        &  xr_VelZNl,           &
        &  xza_MixRtNl,         &
        &  xz_KmNl,             &
        &  xz_KhNl              &
        & )

      !ѻͤΥꥢ
      call StoreClean

    end if
    
  end do LFrog

  !----------------------------------------------------------------
  ! ϥեΥ
  !----------------------------------------------------------------
  call HistoryFile_Close

  !----------------------------------------------------------------
  ! ꥹȥեκ
  !----------------------------------------------------------------
  call ReStartFile_Open( )
  call ReStartFile_OutPut(                            &
    & Time - DelTimeLong,                             &
    & xz_PotTempBl, xz_ExnerBl, pz_VelXBl, xr_VelZBl, &
    & xza_MixRtBl,  xz_KmBl,    xz_KhBl               )
  call ReStartFile_OutPut(                            &
    & Time,                                           &
    & xz_PotTempNl, xz_ExnerNl, pz_VelXNl, xr_VelZNl, &
    & xza_MixRtNl,  xz_KmNl,    xz_KhNl               )
  call ReStartFile_Close
  
contains

  subroutine ArareAlloc
    !
    !Ȥ, , ͤȤƥ.
    !

    !ۤηػ
    implicit none

    !
    allocate(                                                   &
      & pz_VelXBl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXNl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXAl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXNs(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXAs(DimXMin:DimXMax, DimZMin:DimZMax),           &
!
      & xr_VelZBl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZNl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZAl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZNs(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZAs(DimXMin:DimXMax, DimZMin:DimZMax),           &
!
      & xz_ExnerBl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerNl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerAl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerNs(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerAs(DimXMin:DimXMax, DimZMin:DimZMax),          &
!
      & xz_PotTempWork(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempBl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempAl(DimXMin:DimXMax, DimZMin:DimZMax),        &
!
      & xz_KmBl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KmNl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KmAl(DimXMin:DimXMax, DimZMin:DimZMax),             &
!
      & xz_KhBl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KhNl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KhAl(DimXMin:DimXMax, DimZMin:DimZMax),             &
!
      & xza_MixRtWork(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), &
      & xza_MixRtBl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xza_MixRtNl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xza_MixRtAl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
!
      & xz_Stab(DimXMin:DimXMax, DimZMin:DimZMax),               &
      & xz_StabTemp(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xz_StabMolWt(DimXMin:DimXMax, DimZMin:DimZMax),          &
!
      & pz_AccelVelXNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xr_AccelVelZNl(DimXMin:DimXMax, DimZMin:DimZMax),        & 
!
      & xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
!
      & DelTimeLFrog(NstepLong), NStepEular(NStepLong)               ) 

    pz_VelXNs = 0.0d0;     pz_VelXAs = 0.0d0    
    xr_VelZNs = 0.0d0;     xr_VelZAs = 0.0d0
    xz_ExnerNs = 0.0d0;    xz_ExnerAs = 0.0d0

    pz_VelXBl = 0.0d0;     pz_VelXNl = 0.0d0;     pz_VelXAl = 0.0d0
    xr_VelZBl = 0.0d0;     xr_VelZNl = 0.0d0;     xr_VelZAl = 0.0d0
    xz_ExnerBl = 0.0d0;    xz_ExnerNl = 0.0d0;    xz_ExnerAl = 0.0d0
    xz_KmBl = 0.0d0;       xz_KmNl = 0.0d0;       xz_KmAl = 0.0d0
    xz_KhBl = 0.0d0;       xz_KhNl = 0.0d0;       xz_KhAl = 0.0d0
    xz_PotTempBl = 0.0d0;  xz_PotTempNl = 0.0d0;  xz_PotTempAl = 0.0d0
    xza_MixRtBl = 0.0d0;    xza_MixRtNl = 0.0d0;    xza_MixRtAl = 0.0d0

    pz_AccelVelXNl = 0.0d0
    xr_AccelVelZNl = 0.0d0

    xza_DelMixRt = 0.0d0

    DelTimeEular = 0.0d0
    DelTimeLFrog = 0.0d0; 
    NStepEular = 0.0d0
    NstepLFrog = 0.0d0

  end subroutine ArareAlloc
      

end program arare
