!= Module ChemCalc
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: chemcalc.f90,v 1.11 2006/09/21 03:00:57 odakker Exp $
! Tag Name::  $Name: arare4-20060928 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!شϢν̤׻뤿Υ⥸塼. 
!AMP  Antoine ˰¾Ѥưʲ. 
!ǥեȤǤ AMP Ȥ褦ˤƤ. 
!  * ˰¾
!  * ˰¾βʬ
!  * Ǯ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module ChemCalc
  !
  !شϢν̤׻뤿Υ⥸塼. 
  !AMP  Antoine ˰¾Ѥưʲ. 
  !ǥեȤǤ AMP Ȥ褦ˤƤ. 
  !  * ˰¾
  !  * ˰¾βʬ
  !  * Ǯ
  !

  !⥸塼ƤӽФ
  use ChemData, only: ChemData_SpcNum,               & !ǡ١βؼ
    &                 ChemData_MolWt,                & !ʬ
    &                 ChemData_SvapPress_AntoineA,   & !Antoine  A 
    &                 ChemData_SvapPress_AntoineB,   & !Antoine  B 
    &                 ChemData_SvapPress_AntoineC,   & !Antoine  C 
    &                 ChemData_SvapPress_AntoineUnit,& !ñѴѷ
    &                 ChemData_SvapPress_AMPA,       & !AMP  A 
    &                 ChemData_SvapPress_AMPB,       & !AMP  B 
    &                 ChemData_SvapPress_AMPC,       & !AMP  C 
    &                 ChemData_SvapPress_AMPD,       & !AMP  D 
    &                 ChemData_SvapPress_AMPE          !AMP  E 

  !ۤηػ
  implicit none

  !ΤФ private °դ. 
  private
  
  !Τˤ public °դ
  public ChemCalc_Init                            !롼
  public ChemCalcSpc_Init, ChemCalcDim_Init       !롼
  public MolWt                                    !ʬ
  public GasR                                     !
  public Phase                                    !
  public CpRef, CpPerMolRef, CvRef                !갵Ǯ, Ǯ
  public SvapPress, xz_SvapPress                  !˰¾ [Pa]
  public xz_DSvapPressDTemp                       !˰¾βʬ [Pa/K]
  public xz_LatentHeat                            !Ǯ [J/K kg]
  public LatentHeatPerMol                         !Ǯ [J/K mol]
  public ReactHeatNH4SH, ReactHeatNH4SHPerMol     !NH4SH ȿǮ

  real(8)             :: ReactHeatNH4SH           !NH4SH ȿǮ [J/K kg]
  real(8)             :: ReactHeatNH4SHPerMol     !NH4SH ȿǮ [J/K mol]
  integer             :: XMin = 10   !X ɸϰ(). ͤϥߡ
  integer             :: XMax = 10   !X ɸϰ(). ͤϥߡ
  integer             :: ZMin = 10   !Z ɸϰ(). ͤϥߡ
  integer             :: ZMax = 10   !Z ɸϰ(). ͤϥߡ
  integer             :: SpcNum = 1  !ؼο. ͤϥߡ
  real(8)             :: a_antA(ChemData_SpcNum)   !Antoine ξ A 
  real(8)             :: a_antB(ChemData_SpcNum)   !Antoine ξ B 
  real(8)             :: a_antC(ChemData_SpcNum)   !Antoine ξ C 
  real(8)             :: a_antU(ChemData_SpcNum)   !Antoine ξñ̴Τη
  real(8)             :: a_ampA(ChemData_SpcNum)   !AMP ξ A 
  real(8)             :: a_ampB(ChemData_SpcNum)   !AMP ξ B 
  real(8)             :: a_ampC(ChemData_SpcNum)   !AMP ξ C 
  real(8)             :: a_ampD(ChemData_SpcNum)   !AMP ξ D 
  real(8)             :: a_ampE(ChemData_SpcNum)   !AMP ξ E 
  real(8)             :: a_MolWt(ChemData_SpcNum)  !ʬ
  integer, allocatable      :: SpcID(:)     !Ϥ˴ޤޤ벽ؼ. Ƚ
  character(3), allocatable :: Phase(:)     !
 
  save ReactHeatNH4SH, ReactHeatNH4SHPerMol
  save XMin, XMax, ZMin, ZMax, SpcNum
  save SpcID, Phase
  save a_antA, a_antB, a_antC, a_antU, a_MolWt
  save a_ampA, a_ampB, a_ampC, a_ampD, a_ampE

contains
  
!!!
!!! 롼
!!!
!!!==========================================================================
  subroutine ChemCalc_Init(IMin, IMax, KMin, KMax, SNum, SID)
    !
    !롼Υåѡ. 
    !  ChemCalcSpc_init  ChemCalcDim_init ¹
    !

    !⥸塼ƤӽФ
    use ChemData, only: GasRUniv,      &   !
      &                 ChemData_OneSpcID  !ؼ ID 
      
    !ۤηػ
    implicit none

    !ѿ
    integer,intent(in) :: IMin      !X β
    integer,intent(in) :: IMax      !X ξ
    integer,intent(in) :: KMin      !Z β
    integer,intent(in) :: KMax      !Z ξ
    integer,intent(in) :: SNum      !ؼθĿ
    integer,intent(in) :: SID(SNum) !Ϥ¸ߤ벽ؼο
    character(20)      :: Name
    integer            :: id

    !롼 2 ĸƤӽФ
    call ChemCalcSpc_Init(SNum, SID)
    call ChemCalcDim_Init(IMin, IMax, KMin, KMax)

    !NH4SH ȿǮν
    !  NH4SH 1kg ФȿǮˤ.
    Name = 'NH4SH-s'
    id   = ChemData_OneSpcID( Name )  
    
    ReactHeatNH4SHPerMol  = GasRUniv * 10834.0d0
    ReactHeatNH4SH = GasRUniv * 10834.0d0 / MolWt( id )
    write(*,*)     ReactHeatNH4SH, MolWt( id )

  end subroutine ChemCalc_Init


!!!==========================================================================
  subroutine ChemCalcSpc_Init(SNum, SID)
    !
    !롼( 1). 
    !  Ѥ벽ؼγ, 줾ʪͤꤹ.
    !  ׻򤷤ʤˤ, ν򤹤нʬǤ. 
    !

    !⥸塼ƤӽФ
    use ChemData, only: ChemData_Phase    !

    !ۤηػ
    implicit none

    !ѿ
    integer,intent(in) :: SNum            !ؼθĿ
    integer,intent(in) :: SID(SNum)       !Ϥ¸ߤ벽ؼο
    
    !ѿ
    integer            :: s

    !-----------------------------------------------------------
    ! 
    !-----------------------------------------------------------
    SpcNum  = SNum
!    write(*,*) "ChemCalc: SpcNum ", SpcNum
    
    !
    if (allocated(SpcID)) deallocate( SpcID, Phase)
    allocate( SpcID(SpcNum),  Phase(SpcNum) )

    !-----------------------------------------------------------    
    ! ǡ١ɬפʥǡФ
    !-----------------------------------------------------------
    !Ϥ¸ߤ벽ؼ. Ϥ줿ͤ
    SpcID = SID
    
    !
    do s = 1, SpcNum
      Phase(s) = ChemData_Phase(SpcID(s)) 
    end do
    
    !Antoine ˰¾η
    a_antA = ChemData_SvapPress_AntoineA
    a_antB = ChemData_SvapPress_AntoineB
    a_antC = ChemData_SvapPress_AntoineC
    a_antU = ChemData_SvapPress_AntoineUnit

    !AMP ˰¾η
    a_ampA = ChemData_SvapPress_AMPA
    a_ampB = ChemData_SvapPress_AMPB
    a_ampC = ChemData_SvapPress_AMPC
    a_ampD = ChemData_SvapPress_AMPD
    a_ampE = ChemData_SvapPress_AMPE

    !ʬ
    a_MolWt = ChemData_MolWt
    
  end subroutine ChemCalcSpc_Init


!!!==========================================================================
  subroutine ChemCalcDim_Init(IMin, IMax, KMin, KMax)
    !
    !롼( 2)
    !  󥵥γԤ. ؿѤˤ, 
    !  Υ֥롼ǽɬפ. 
    !   ChemCalcSpc_init ¹ԤƤɬפ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    integer,intent(in) :: IMin  !X β
    integer,intent(in) :: IMax  !X ξ
    integer,intent(in) :: KMin  !Z β
    integer,intent(in) :: KMax  !Z ξ
    
    !-----------------------------------------------------------
    ! 
    !-----------------------------------------------------------
    XMin = IMin;    XMax = IMax
    ZMin = KMin;    ZMax = KMax
    
  end subroutine ChemCalcDim_Init


!!!
!!! ˰¾, Ǯ, etc. δܴؿ. 
!!! ؼ ID Ȳ٤Ф֤ͤ
!!!  

!!!==========================================================================
  function CpRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̼갵Ǯ׻
    !

    !⥸塼ƤӽФ
    use ChemData, only: ChemData_CpRef !ɸ֤Ǥñ̼Ǯ

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: CpRef        !ɸ֤Ǥñ̼Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CpRef = ChemData_CpRef(ID)

  end function CpRef


!!!==========================================================================
  function CpPerMolRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̥갵Ǯ׻
    !

    !⥸塼ƤӽФ
    use ChemData, only: ChemData_CpPerMolRef !ɸ֤Ǥñ̥Ǯ

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: CpPerMolRef  !ɸ֤Ǥñ̥Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CpPerMolRef = ChemData_CpPerMolRef(ID)

  end function CpPerMolRef


!!!==========================================================================
  function CvRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̼갵Ǯ׻
    !

    !⥸塼ƤӽФ
    use ChemData, only: ChemData_CvRef !ɸ֤Ǥñ̼Ǯ

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: CvRef       !ɸ֤Ǥñ̼Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CvRef = ChemData_CvRef(ID)

  end function CvRef


!!!==========================================================================
  function MolWt(ID)
    !
    !Ϳ줿ؼФ, ʬ̤׻
    !

    !⥸塼ƤӽФ
    use ChemData, only: ChemData_MolWt   !ʬ

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: MolWt         !ʬ
    integer, intent(in) :: ID      !ؼ ID

    
    !ǡ١
    MolWt = ChemData_MolWt(ID)

  end function MolWt


!!!==========================================================================
  function GasR(ID)
    !
    !Ϳ줿ؼФ, ׻
    !

    !⥸塼ƤӽФ
    use ChemData, only: ChemData_GasR    ! [J/K kg]

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: GasR          !ʬ
    integer, intent(in) :: ID      !ؼ ID
    
    
    !ǡ١
    GasR = ChemData_GasR(ID)

  end function GasR



!!!
!!!  2 δؿ
!!!

!!!==========================================================================
  function xz_SvapPressAnt( ID, xz_Temp )
    !
    !˰¾η׻. Antoine μ
    !

    !ۤηػ
    implicit none
    
    ! ѿ  
    real(8)             :: xz_SvapPressAnt(XMin:XMax, ZMin:ZMax) 
                                                          !˰¾
    real(8), intent(in) :: xz_Temp(XMin:XMax, ZMin:ZMax)  !
    integer, intent(in) :: ID                             !ؼ ID
  
    !ѿ
    real(8)             :: xz_LogSvapPress(XMin:XMax, ZMin:ZMax) 
    real(8), parameter  :: Temp0C = 273.15d0


    !˰¾ log ׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xz_LogSvapPress =                                          &
      & min(                                                   & 
      &       (                                                &
      &         a_antA(ID)                                     &
      &         - a_antB(ID) / (a_antC(ID) + xz_Temp - Temp0C) &
      &        ) * dlog(10.0d0)                                &
      &        + a_antU(ID),                                   &
      &      7.0d2                                             &
      &    )
    
    !˰¾׻
    xz_SvapPressAnt =  dexp( xz_LogSvapPress )

  end function xz_SvapPressAnt


!!!==========================================================================
  function xz_DSvapPressDTempAnt(ID, xz_Temp)
    !
    !˰¾βʬη׻. Antoine μ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8)             :: xz_DSvapPressDTempAnt(XMin:XMax, ZMin:ZMax)
                                                  !˰¾βʬ [Pa/K]
    real(8), intent(in) :: xz_Temp(XMin:XMax, ZMin:ZMax)           
                                                  ! [K]
    integer, intent(in) :: ID                     !ؼ ID
  
    !ѿ
    real(8)             :: xz_LogSvapPress(XMin:XMax, ZMin:ZMax)
    real(8)             :: xz_DLogSvapPressDTemp(XMin:XMax, ZMin:ZMax)
    real(8), parameter  :: Temp0C = 273.15d0


    !˰¾ log ׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xz_LogSvapPress =                                          &
      & min(                                                   &
      &      (                                                 &
      &          a_antA(ID)                                    &
      &        - a_antB(ID) / (a_antC(ID) + xz_Temp - Temp0C)  &
      &       ) * dlog(10.0d0)                                 &
      &       + a_antU(ID),                                    &
      &     7.0d2                                              &
      &    )
    
    xz_DLogSvapPressDTemp =                                &
      & a_antB(ID) * dlog(10.0d0)                          &
      &  / ( (a_antC(ID) + xz_Temp - Temp0C) ** 2.0d0 )
    
    !˰¾βʬ׻
    xz_DSvapPressDTempAnt = xz_DLogSvapPressDTemp * dexp( xz_LogSvapPress ) 
    
  end function xz_DSvapPressDTempAnt
  

!!!==========================================================================
  function xz_LatentHeatAnt(ID, xz_Temp)
    !
    !˰¾Ǯ׻. Antoine μ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8)             :: xz_LatentHeatAnt(XMin:XMax, ZMin:ZMax)
                                                            !Ǯ[J/K kg]
    real(8), intent(in) :: xz_Temp(XMin:XMax, ZMin:ZMax)    ![K]
    integer, intent(in) :: ID                       !ؼ ID

    !ؿ
    real(8)             :: xz_DLogSvapPressDTemp(XMin:XMax, ZMin:ZMax)
    real(8), parameter  :: GasRUniv = 8.314d0
    real(8), parameter  :: Temp0C = 273.15d0

    !˰¾ log ׻, Ǯ׻. 
    xz_DLogSvapPressDTemp =                                   &
      & a_antB(ID) * dlog(10.0d0)                             &
      &  / ( (a_antC(ID) + xz_Temp - Temp0C) ** 2.0d0 )
    
    xz_LatentHeatAnt =                                        &
      & xz_DLogSvapPressDTemp * GasRUniv * (xz_Temp ** 2.0d0) &
      &  / a_MolWt(ID)

  end function xz_LatentHeatAnt


!!!==========================================================================
  function xz_SvapPress(ID, xz_Temp)
    !
    !Ϳ줿ؼȲ٤Ф, ˰¾׻. AMP 
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: xz_SvapPress(XMin:XMax, ZMin:ZMax)
                                                         !˰¾
    real(8), intent(in) :: xz_Temp(XMin:XMax, ZMin:ZMax) ! [K]
    integer, intent(in) :: ID                            !ؼ ID

    !ѿ
    real(8)             :: xz_LogSvapPress(XMin:XMax, ZMin:ZMax)
    
    !˰¾п׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xz_LogSvapPress =                            &
      & min(                                     &
      &      (                                   &
      &          a_ampA(ID) / xz_Temp            &
      &        + a_ampB(ID)                      &
      &        + a_ampC(ID) * dlog( xz_Temp )    &
      &        + a_ampD(ID) * xz_Temp            &
      &        + a_ampE(ID) * ( xz_temp ** 2 )   &
      &        + dlog(1.0d-1)                    &
      &      ),                                  &
      &    7.0d2                                 &
      &   )

    !˰¾׻
    xz_SvapPress =  dexp( xz_LogSvapPress )
    
  end function xz_SvapPress


!!!==========================================================================
  function xz_DSvapPressDTemp(ID, xz_Temp)
    !
    !Ϳ줿ؼȲ٤Ф, ˰¾βʬ׻
    !
    
    !ۤηػ
    implicit none
  
    !ѿ    
    real(8)             :: xz_DSvapPressDTemp(XMin:XMax, ZMin:ZMax)
                                                         !˰¾βʬ [Pa/K]
    real(8), intent(in) :: xz_Temp(XMin:XMax, ZMin:ZMax) ! [K]
    integer, intent(in) :: ID                            !ؼ̾

    !ѿ
    real(8)             :: xz_LogSvapPress(XMin:XMax, ZMin:ZMax)
    real(8)             :: xz_DLogSvapPressDTemp(XMin:XMax, ZMin:ZMax)
    

    !˰¾п׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xz_LogSvapPress =                        &
      & min(                               &
      &      (                             &
      &          a_ampA(ID) / xz_Temp            &
      &        + a_ampB(ID)                      &
      &        + a_ampC(ID) * dlog( xz_Temp )    &
      &        + a_ampD(ID) * xz_Temp            &
      &        + a_ampE(ID) * ( xz_temp ** 2 )   &
      &        + dlog(1.0d-1)                    &
      &      ),                                  &
      &    7.0d2                                 &
      &   )

    !˰¾βʬ
    xz_DLogSvapPressDTemp =                   &
      & - a_ampA(ID) / (xz_Temp ** 2.0d0)        &
      & + a_ampC(ID) / xz_Temp                   &
      & + a_ampD(ID)                             &
      & + a_ampE(ID) * 2.0d0 * xz_Temp
    
    !˰¾βʬ
    xz_DSvapPressDTemp =                          &
      & xz_DLogSvapPressDTemp * dexp( xz_LogSvapPress ) 
    
  end function xz_DSvapPressDTemp
  

!!!==========================================================================
  function xz_LatentHeat(ID, xz_Temp)
    !
    !Ϳ줿ؼȲ٤Ф, Ǯ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8)             :: xz_LatentHeat(XMin:XMax, ZMin:ZMax)
                                                         !Ǯ
    real(8), intent(in) :: xz_Temp(XMin:XMax, ZMin:ZMax) !
    integer, intent(in) :: ID                            !ؼ̾
    
    !ѿ
    real(8)             :: xz_DLogSvapPressDTemp(XMin:XMax, ZMin:ZMax)
    real(8), parameter  :: GasRUniv = 8.314d0  !׵
    

    !˰¾βʬ
    xz_DLogSvapPressDTemp =                      &
      & - a_ampA(ID) / (xz_Temp ** 2.0d0)        &
      & + a_ampC(ID) / xz_Temp                   &
      & + a_ampD(ID)                             &
      & + a_ampE(ID) * 2.0d0 * xz_Temp
        
    !Ǯη׻
    xz_LatentHeat =                                           &
      & xz_DLogSvapPressDTemp * GasRUniv * (xz_Temp ** 2.0d0) &
      & / a_MolWt(ID)

  end function xz_LatentHeat


!!!==========================================================================
  function SvapPress(ID, Temp)
    !
    !Ϳ줿ؼȲ٤Ф, ˰¾׻. AMP 
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(8)             :: SvapPress   !˰¾
    real(8), intent(in) :: Temp        ! [K]
    integer, intent(in) :: ID          !ؼ ID

    !ѿ
    real(8)             :: LogSvapPress
    
    !˰¾п׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    LogSvapPress =                            &
      & min(                                     &
      &      (                                   &
      &          a_ampA(ID) / Temp            &
      &        + a_ampB(ID)                      &
      &        + a_ampC(ID) * dlog( Temp )    &
      &        + a_ampD(ID) * Temp            &
      &        + a_ampE(ID) * ( temp ** 2 )   &
      &        + dlog(1.0d-1)                    &
      &      ),                                  &
      &    7.0d2                                 &
      &   )

    !˰¾׻
    SvapPress =  dexp( LogSvapPress )
    
  end function SvapPress


!!!==========================================================================
  function LatentHeatPerMol(ID, Temp)
    !
    !Ϳ줿ؼȲ٤Ф, Ǯ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8)             :: LatentHeatPerMol   !Ǯ
    real(8), intent(in) :: Temp            !
    integer, intent(in) :: ID                 !ؼ̾
    
    !ѿ
    real(8)             :: DLogSvapPressDTemp
    real(8), parameter  :: GasRUniv = 8.314d0  !׵
    

    !˰¾βʬ
    DLogSvapPressDTemp =                      &
      & - a_ampA(ID) / (Temp ** 2.0d0)        &
      & + a_ampC(ID) / Temp                   &
      & + a_ampD(ID)                          &
      & + a_ampE(ID) * 2.0d0 * Temp
        
    !Ǯη׻
    LatentHeatPerMol =                                     &
      & DLogSvapPressDTemp * GasRUniv * (Temp ** 2.0d0) 

  end function LatentHeatPerMol


end module ChemCalc

