module pbl_mym_phi
  use pp_vardef

contains
  subroutine pbl_mym_phi_calc(r_mosurf, z_f1, pmz, phh)
    use pp_vardef
    use pbl_mym_const
    use pbl_mym_option, only: my_lowest_pd_surf
    use pbl_mym_option_symbol, only: businger, bh1991
    use pp_phys_const, only: one_third, two_thirds
    implicit none

    real(r_size), intent(in) :: r_mosurf
    real(r_size), intent(in) :: z_f1
    real(r_size), intent(out) :: pmz
    real(r_size), intent(out) :: phh


    real(r_size), parameter :: my_zeta_max = 2.0d0

    ! coefficients appeared
    !               in Beljaars and Holtslag(1991)
    real(r_size), parameter :: bel_a = 1.0
    real(r_size), parameter :: bel_b = 2.0 / 3.0
    real(r_size), parameter :: bel_c = 5.0
    real(r_size), parameter :: bel_d = 0.35

    real(r_size) :: zeta
    real(r_size) :: tmp


    if (my_lowest_pd_surf == businger) then
      zeta = min(z_f1 * r_mosurf, my_zeta_max)
      if (zeta >= 0.0) then
        pmz = 1.0 + 4.7 * zeta
        phh = pr + 4.7 * zeta
      else
        pmz = 1.0 / sqrt(sqrt(1.0 - 15.0 * zeta))
        phh = pr / sqrt(1.0 - 9.0 * zeta)
      end if
      pmz = pmz - zeta
    else if (my_lowest_pd_surf == bh1991) then
      zeta = min(z_f1 * r_mosurf, my_zeta_max)
      if(zeta >= 0) then
        tmp = bel_b * exp(-bel_d * zeta)                              &
          * (bel_d * zeta - bel_c - 1.0)
        pmz = 1.0 - zeta * (tmp - bel_a)
        phh = 1.0 - zeta * (tmp -                               &
          sqrt(1.0 + two_thirds * bel_a * zeta))
      else
        tmp = sqrt(1.0 - 16.0 * zeta)
        pmz = 1.0 / sqrt(tmp)
        phh = 1.0 / tmp
      end if
      pmz = pmz - zeta
    end if
    return
  end subroutine pbl_mym_phi_calc




end module pbl_mym_phi
