module pbl_mym_parm
  use pp_vardef
  implicit none

  real(r_size) :: tke_cm_mx = 0.1
            ! A proportional coef CM below the top of mixed layer
            ! K = CM * SQRT(E) * L
  real(r_size) :: tke_cm_fa = 0.1
            ! A proportional coef CM above the top of mixed layer
            ! K = CM * SQRT(E) * L
  real(r_size) :: my_prod_adj_fact = 0.225
            ! Factor in production term adjustment related to diffusion.
  real(r_size) :: my_ini_dbdz_min = 1.0e-7
            ! the lower limit for dbdz in the initialization to avoid
            ! to diagnose huge initial values.
  real(r_size) :: my_z_limit_elb = 1.0e10
            ! IF Z_TQ > MY_z_limit_elb, elb is limited less than
            ! vertical grid spacing.

contains
  subroutine pbl_mym_parm_ini(tke_cm_mx_in, tke_cm_fa_in, &
    & my_prod_adj_fact_in, my_ini_dbdz_min_in, my_z_limit_elb_in)
    use pp_vardef
    implicit none

    real(r_size), intent(in), optional :: tke_cm_mx_in
    real(r_size), intent(in), optional :: tke_cm_fa_in
    real(r_size), intent(in), optional :: my_prod_adj_fact_in
    real(r_size), intent(in), optional :: my_ini_dbdz_min_in
    real(r_size), intent(in), optional :: my_z_limit_elb_in

    if (present(tke_cm_mx_in)) tke_cm_mx = tke_cm_mx_in
    if (present(tke_cm_fa_in)) tke_cm_fa = tke_cm_fa_in
    if (present(my_prod_adj_fact_in)) &
      & my_prod_adj_fact = my_prod_adj_fact_in
    if (present(my_ini_dbdz_min_in))  &
      & my_ini_dbdz_min =  my_ini_dbdz_min_in
    if (present(my_z_limit_elb_in)) &
      & my_z_limit_elb = my_z_limit_elb_in

    return
  end subroutine pbl_mym_parm_ini


end module pbl_mym_parm
