module pbl_mym_option_symbol
  implicit none

!=======================================================================
! Symbols of switches
!=======================================================================
! Symbols to choose TKE schemes (for BDY_TKE)
!
  integer(4), parameter :: none = 0
            ! not use TKE schemes
  integer(4), parameter :: deardorff = 1
            ! the first order scheme
  integer(4), parameter :: mymodel25 = 2
            ! the improved Mellor-Yamada level 2.5 model
  integer(4), parameter :: mymodel3  = 3
            ! the improved Mellor-Yamada level 3 model

! Symbols for the option to choose  the mixing length
! in the first order model (for tke_dlen)
  integer(4), parameter :: my_length = 1
            ! use the same mixing length in the MY model
  integer(4), parameter :: ddf_length = 2
            ! original mixing length suggested by Deardorff(1980)
 integer(4), parameter ::  non_local_like_length = 3
            ! with correction based on Sun and Chang (1986)

! Symbols for the option to choose the gradient function
! to calculate production terms at the lowest level.
! (for MY_lowest_pd_surf)
  integer(4), parameter :: no_pd_surf = 0
            ! No use of surface fluxes
  integer(4), parameter :: businger = 1
            ! use the gradient function by Businger
  integer(4), parameter :: bh1991 = 2
            ! use the gradient function by Beljaars and Holtslag

  integer(4), parameter :: full_impl = 0
  integer(4), parameter :: half_impl = 1
  integer(4), parameter :: expl      = 2

  



end module pbl_mym_option_symbol
