module pbl_mym_main
  implicit none
  private 
  public :: pbl_mym_main_level3
  public :: pbl_mym_main_level25
  public :: pbl_mym_main_level2

  public :: pbl_mym_adjust

contains
  subroutine pbl_mym_main_level3(&
    & taux_surf, tauy_surf, ftl_surf, fqw_surf, u_s, r_mosurf, p_surf, &
    & uvel, vvel, pt, qv, qc, qci, prs, exner, qke, tsq, qsq, cov, &
    & z_f, dz_f, rdz_f, rdz_h, f2h_m, f2h_p, h2f_m, h2f_p, &
    & dfm, dfh, tend_qke, tend_tsq, tend_qsq, tend_cov, &
    & taux_ex, tauy_ex, ftl_ex, fqw_ex)
    use pp_vardef
    use pbl_grid, only: nz
    use pbl_mym, only: pbl_mym_prepare, pbl_mym_buoy, &
      & pbl_mym_turbulence_common, &
      & pbl_mym_turbulence_common, pbl_mym_turbulence_level3, &
      & pbl_mym_tend_cov, pbl_mym_tend_tke_level3
    use pbl_mym_flux, only: pbl_mym_flux_run_level3

    implicit none


    real(r_size), intent(in) :: taux_surf
    real(r_size), intent(in) :: tauy_surf
    real(r_size), intent(in) :: ftl_surf
    real(r_size), intent(in) :: fqw_surf
    real(r_size), intent(in) :: u_s
    real(r_size), intent(in) :: r_mosurf
    real(r_size), intent(in) :: p_surf

    real(r_size), intent(in) :: uvel(nz)
    real(r_size), intent(in) :: vvel(nz)
    real(r_size), intent(in) :: pt(nz)
    real(r_size), intent(in) :: qv(nz)
    real(r_size), intent(in) :: qc(nz)
    real(r_size), intent(in) :: qci(nz)
    real(r_size), intent(in) :: prs(nz)
    real(r_size), intent(in) :: exner(nz)

    real(r_size), intent(in) :: qke(nz)
    real(r_size), intent(in) :: tsq(nz)
    real(r_size), intent(in) :: qsq(nz)
    real(r_size), intent(in) :: cov(nz)
    
    real(r_size), intent(in) :: z_f(nz)
    real(r_size), intent(in) :: dz_f(nz-1)
    real(r_size), intent(in) :: rdz_f(nz)
    real(r_size), intent(in) :: rdz_h(nz-1)
    real(r_size), intent(in) :: f2h_m(nz-1)
    real(r_size), intent(in) :: f2h_p(nz-1)
    real(r_size), intent(in) :: h2f_m(nz-1)
    real(r_size), intent(in) :: h2f_p(nz-1)

    real(r_size), intent(out) :: dfm(nz)
    real(r_size), intent(out) :: dfh(nz)

    real(r_size), intent(out) :: tend_qke(nz)
    real(r_size), intent(out) :: tend_tsq(nz)
    real(r_size), intent(out) :: tend_qsq(nz)
    real(r_size), intent(out) :: tend_cov(nz)

    real(r_size), intent(out) :: taux_ex(nz)
    real(r_size), intent(out) :: tauy_ex(nz)
    real(r_size), intent(out) :: ftl_ex(nz)
    real(r_size), intent(out) :: fqw_ex(nz)

    real(r_size) :: fb_surf

    real(r_size) :: qkw(nz)
    real(r_size) :: gtr(nz)
    real(r_size) :: temp(nz)
    real(r_size) :: tl(nz)
    real(r_size) :: qw(nz)
    real(r_size) :: wb_ng(nz)
    real(r_size) :: dtldz(nz)
    real(r_size) :: dqwdz(nz)
    real(r_size) :: dbdz(nz)
    real(r_size) :: dudz(nz)
    real(r_size) :: dvdz(nz)
    real(r_size) :: dvdzm(nz)
    real(r_size) :: vt(nz)
    real(r_size) :: vq(nz)
    real(r_size) :: cld(nz)
    real(r_size) :: ql(nz)
    real(r_size) :: gm(nz)
    real(r_size) :: gh(nz)
    real(r_size) :: sm(nz)
    real(r_size) :: sh(nz)
    real(r_size) :: qdiv(nz)
    real(r_size) :: el(nz)
    real(r_size) :: cw25(nz)

    real(r_size) :: dfu_cg(nz)
    real(r_size) :: dfv_cg(nz)
    real(r_size) :: dft_cg(nz)
    real(r_size) :: dfq_cg(nz)

    real(r_size) :: pdk(nz)
    real(r_size) :: pdt_tsq(nz)
    real(r_size) :: pdt_cov(nz)
    real(r_size) :: pdt(nz)
    real(r_size) :: pdq_qsq(nz)
    real(r_size) :: pdq_cov(nz)
    real(r_size) :: pdq(nz)
    real(r_size) :: pdc_tsq(nz)
    real(r_size) :: pdc_qsq(nz)
    real(r_size) :: pdc_cov(nz)
    real(r_size) :: pdc(nz)
    real(r_size) :: c2sq(nz)
    real(r_size) :: smd_coef(nz)
    real(r_size) :: gamv_coef(nz)

    call pbl_mym_prepare(&
      & uvel, vvel, pt, qv, qc, qci, prs, qke, &
      & rdz_f, rdz_h, f2h_m, f2h_p, &
      & qkw, gtr, temp, tl, qw, &
      & dtldz, dqwdz, dudz, dvdz, dvdzm)

    call pbl_mym_buoy( &
      & ftl_surf, fqw_surf, u_s, p_surf, &
      & z_f, uvel, vvel, temp, pt, qv, qc, qci, tl, qw, prs, exner, &
      & dtldz, dqwdz, &
      & tsq, qsq, cov, gtr, &
      & fb_surf, vt, vq, cld, ql, dbdz, wb_ng)

    call pbl_mym_turbulence_common(fb_surf, r_mosurf, qkw, &
      & dbdz, dvdzm, z_f, dz_f, &
      & gm, gh, sm, sh, qdiv, el, cw25)

    call pbl_mym_turbulence_level3(              &
      & ftl_surf, fqw_surf, r_mosurf, u_s,  &
      & gm, gh, sm, sh, &
      & vt, vq, gtr, wb_ng, dtldz, dqwdz, dudz, dvdz, &
      & tsq, qsq, cov, qkw, cw25, el, z_f, rdz_f, qdiv, &
      & dfm, dfh, dfu_cg, dfv_cg, dft_cg, dfq_cg, &
      & pdk, pdt_tsq, pdt_cov, pdt, pdq_qsq, pdq_cov, pdq, &
      & pdc_tsq, pdc_qsq, pdc_cov, pdc, &
      & c2sq, smd_coef, gamv_coef)

    call pbl_mym_tend_cov(&
      & f2h_m, f2h_p, rdz_f, rdz_h, &
      & qkw, el, dfm, &
      & pdt_tsq, pdt_cov, pdt, &
      & pdq_qsq, pdq_cov, pdq, &
      & pdc_tsq, pdc_qsq, pdc_cov, pdc, &
      & tsq, qsq, cov, &
      & tend_tsq, tend_qsq, tend_cov)

    call pbl_mym_tend_tke_level3(qke, qkw, tsq, qsq, cov, dfm, &
      & tend_tsq, tend_qsq, tend_cov, el, vt, vq, &
      & c2sq, gm, smd_coef, gamv_coef, &
      & f2h_m, f2h_p, rdz_f, rdz_h, pdk, tend_qke)
    
    call pbl_mym_flux_run_level3(&
      & dfm, dfh, dfu_cg, dfv_cg, dft_cg, dfq_cg, &
      & uvel, vvel, tl, qw, rdz_h, f2h_m, f2h_p, &
      & taux_ex, tauy_ex, ftl_ex, fqw_ex)

    return
  end subroutine pbl_mym_main_level3
  !
  subroutine pbl_mym_main_level25(&
    & taux_surf, tauy_surf, ftl_surf, fqw_surf, u_s, r_mosurf, p_surf, &
    & uvel, vvel, pt, qv, qc, qci, prs, exner, qke, tsq, qsq, cov, &
    & z_f, dz_f, rdz_f, rdz_h, f2h_m, f2h_p, h2f_m, h2f_p, &
    & dfm, dfh, tend_qke, tsq_new, qsq_new, cov_new, &
    & taux_ex, tauy_ex, ftl_ex, fqw_ex)
    use pp_vardef
    use pbl_grid, only: nz
    use pbl_mym, only: pbl_mym_prepare, pbl_mym_turbulence_common, &
      & pbl_mym_turbulence_common, pbl_mym_turbulence_level25, &
      & pbl_mym_diagnose_cov, pbl_mym_tend_tke_level25, pbl_mym_buoy
    use pbl_mym_flux, only: pbl_mym_flux_run_level25

    implicit none

    real(r_size), intent(in) :: taux_surf
    real(r_size), intent(in) :: tauy_surf
    real(r_size), intent(in) :: ftl_surf
    real(r_size), intent(in) :: fqw_surf
    real(r_size), intent(in) :: u_s
    real(r_size), intent(in) :: r_mosurf
    real(r_size), intent(in) :: p_surf

    real(r_size), intent(in) :: uvel(nz)
    real(r_size), intent(in) :: vvel(nz)
    real(r_size), intent(in) :: pt(nz)
    real(r_size), intent(in) :: qv(nz)
    real(r_size), intent(in) :: qc(nz)
    real(r_size), intent(in) :: qci(nz)
    real(r_size), intent(in) :: prs(nz)
    real(r_size), intent(in) :: exner(nz)

    real(r_size), intent(in) :: qke(nz)
    real(r_size), intent(in) :: tsq(nz)
    real(r_size), intent(in) :: qsq(nz)
    real(r_size), intent(in) :: cov(nz)
    
    real(r_size), intent(in) :: z_f(nz)
    real(r_size), intent(in) :: dz_f(nz-1)
    real(r_size), intent(in) :: rdz_f(nz)
    real(r_size), intent(in) :: rdz_h(nz-1)
    real(r_size), intent(in) :: f2h_m(nz-1)
    real(r_size), intent(in) :: f2h_p(nz-1)
    real(r_size), intent(in) :: h2f_m(nz-1)
    real(r_size), intent(in) :: h2f_p(nz-1)

    real(r_size), intent(out) :: dfm(nz)
    real(r_size), intent(out) :: dfh(nz)

    real(r_size), intent(out) :: tend_qke(nz)
    real(r_size), intent(out) :: tsq_new(nz)
    real(r_size), intent(out) :: qsq_new(nz)
    real(r_size), intent(out) :: cov_new(nz)

    real(r_size), intent(out) :: taux_ex(nz)
    real(r_size), intent(out) :: tauy_ex(nz)
    real(r_size), intent(out) :: ftl_ex(nz)
    real(r_size), intent(out) :: fqw_ex(nz)

    real(r_size) :: fb_surf

    real(r_size) :: qkw(nz)
    real(r_size) :: gtr(nz)
    real(r_size) :: temp(nz)
    real(r_size) :: tl(nz)
    real(r_size) :: qw(nz)
    real(r_size) :: wb_ng(nz)
    real(r_size) :: dtldz(nz)
    real(r_size) :: dqwdz(nz)
    real(r_size) :: dbdz(nz)
    real(r_size) :: dudz(nz)
    real(r_size) :: dvdz(nz)
    real(r_size) :: dvdzm(nz)
    real(r_size) :: vt(nz)
    real(r_size) :: vq(nz)
    real(r_size) :: cld(nz)
    real(r_size) :: ql(nz)
    real(r_size) :: gm(nz)
    real(r_size) :: gh(nz)
    real(r_size) :: sm(nz)
    real(r_size) :: sh(nz)
    real(r_size) :: qdiv(nz)
    real(r_size) :: el(nz)
    real(r_size) :: cw25(nz)


    real(r_size) :: pdk(nz)
    real(r_size) :: pdt(nz)
    real(r_size) :: pdq(nz)
    real(r_size) :: pdc(nz)

    call pbl_mym_prepare(&
      & uvel, vvel, pt, qv, qc, qci, prs, qke, &
      & rdz_f, rdz_h, f2h_m, f2h_p, &
      & qkw, gtr, temp, tl, qw, &
      & dtldz, dqwdz, dudz, dvdz, dvdzm)

    call pbl_mym_buoy( &
      & ftl_surf, fqw_surf, u_s, p_surf, &
      & z_f, uvel, vvel, temp, pt, qv, qc, qci, tl, qw, prs, exner, &
      & dtldz, dqwdz, &
      & tsq, qsq, cov, gtr, &
      & fb_surf, vt, vq, cld, ql, dbdz, wb_ng)

    call pbl_mym_turbulence_common(fb_surf, r_mosurf, qkw, &
      & dbdz, dvdzm, z_f, dz_f, &
      & gm, gh, sm, sh, qdiv, el, cw25)

    call pbl_mym_turbulence_level25(&
      & r_mosurf, u_s, ftl_surf, fqw_surf, &
      & qkw, qdiv, &
      & sm, sh, gm, gh, wb_ng, dtldz, dqwdz, el, z_f, &
      & dfm, dfh, pdk, pdt, pdq, pdc)

    call pbl_mym_diagnose_cov(el, pdt, pdq, pdc, qkw, &
      & tsq_new, qsq_new, cov_new)

    call pbl_mym_tend_tke_level25(qke, qkw, dfm, el, &
      & f2h_m, f2h_p, rdz_f, rdz_h, pdk, tend_qke)

    call  pbl_mym_flux_run_level25(&
      & dfm, dfh, uvel, vvel, tl, qw, &
      & rdz_h, f2h_m, f2h_p, &
      & taux_ex, tauy_ex, ftl_ex, fqw_ex)

    return
  end subroutine pbl_mym_main_level25
  !
  subroutine pbl_mym_main_level2(&
    & taux_surf, tauy_surf, ftl_surf, fqw_surf, u_s, r_mosurf, p_surf, &
    & uvel, vvel, pt, qv, qc, qci, prs, exner, qke, tsq, qsq, cov, &
    & z_f, dz_f, rdz_f, rdz_h, f2h_m, f2h_p, h2f_m, h2f_p, &
    & dfm, dfh, qke_new, tsq_new, qsq_new, cov_new, &
    & taux_ex, tauy_ex, ftl_ex, fqw_ex)
    use pp_vardef
    use pbl_grid, only: nz
    use pbl_mym, only: pbl_mym_prepare, pbl_mym_turbulence_common, &
      & pbl_mym_turbulence_common, pbl_mym_turbulence_level25, &
      & pbl_mym_diagnose_cov, pbl_mym_diagnose_tke, pbl_mym_buoy
    use pbl_mym_flux, only: pbl_mym_flux_run_level25

    implicit none

    real(r_size), intent(in) :: taux_surf
    real(r_size), intent(in) :: tauy_surf
    real(r_size), intent(in) :: ftl_surf
    real(r_size), intent(in) :: fqw_surf
    real(r_size), intent(in) :: u_s
    real(r_size), intent(in) :: r_mosurf
    real(r_size), intent(in) :: p_surf

    real(r_size), intent(in) :: uvel(nz)
    real(r_size), intent(in) :: vvel(nz)
    real(r_size), intent(in) :: pt(nz)
    real(r_size), intent(in) :: qv(nz)
    real(r_size), intent(in) :: qc(nz)
    real(r_size), intent(in) :: qci(nz)
    real(r_size), intent(in) :: prs(nz)
    real(r_size), intent(in) :: exner(nz)

    real(r_size), intent(in) :: qke(nz)
    real(r_size), intent(in) :: tsq(nz)
    real(r_size), intent(in) :: qsq(nz)
    real(r_size), intent(in) :: cov(nz)
    
    real(r_size), intent(in) :: z_f(nz)
    real(r_size), intent(in) :: dz_f(nz-1)
    real(r_size), intent(in) :: rdz_f(nz)
    real(r_size), intent(in) :: rdz_h(nz-1)
    real(r_size), intent(in) :: f2h_m(nz-1)
    real(r_size), intent(in) :: f2h_p(nz-1)
    real(r_size), intent(in) :: h2f_m(nz-1)
    real(r_size), intent(in) :: h2f_p(nz-1)

    real(r_size), intent(out) :: dfm(nz)
    real(r_size), intent(out) :: dfh(nz)

    real(r_size), intent(out) :: qke_new(nz)
    real(r_size), intent(out) :: tsq_new(nz)
    real(r_size), intent(out) :: qsq_new(nz)
    real(r_size), intent(out) :: cov_new(nz)

    real(r_size), intent(out) :: taux_ex(nz)
    real(r_size), intent(out) :: tauy_ex(nz)
    real(r_size), intent(out) :: ftl_ex(nz)
    real(r_size), intent(out) :: fqw_ex(nz)

    real(r_size) :: fb_surf

    real(r_size) :: qkw(nz)
    real(r_size) :: gtr(nz)
    real(r_size) :: temp(nz)
    real(r_size) :: tl(nz)
    real(r_size) :: qw(nz)
    real(r_size) :: wb_ng(nz)
    real(r_size) :: dtldz(nz)
    real(r_size) :: dqwdz(nz)
    real(r_size) :: dbdz(nz)
    real(r_size) :: dudz(nz)
    real(r_size) :: dvdz(nz)
    real(r_size) :: dvdzm(nz)
    real(r_size) :: vt(nz)
    real(r_size) :: vq(nz)
    real(r_size) :: cld(nz)
    real(r_size) :: ql(nz)
    real(r_size) :: gm(nz)
    real(r_size) :: gh(nz)
    real(r_size) :: sm(nz)
    real(r_size) :: sh(nz)
    real(r_size) :: qdiv(nz)
    real(r_size) :: el(nz)
    real(r_size) :: cw25(nz)

    real(r_size) :: pdk(nz)
    real(r_size) :: pdt(nz)
    real(r_size) :: pdq(nz)
    real(r_size) :: pdc(nz)


    call pbl_mym_prepare(&
      & uvel, vvel, pt, qv, qc, qci, prs, qke, &
      & rdz_f, rdz_h, f2h_m, f2h_p, &
      & qkw, gtr, temp, tl, qw, &
      & dtldz, dqwdz, dudz, dvdz, dvdzm)

    call pbl_mym_buoy( &
      & ftl_surf, fqw_surf, u_s, p_surf, &
      & z_f, uvel, vvel, temp, pt, qv, qc, qci, tl, qw, prs, exner, &
      & dtldz, dqwdz, &
      & tsq, qsq, cov, gtr, &
      & fb_surf, vt, vq, cld, ql, dbdz, wb_ng)

    call pbl_mym_turbulence_common(fb_surf, r_mosurf, qkw, &
      & dbdz, dvdzm, z_f, dz_f, &
      & gm, gh, sm, sh, qdiv, el, cw25)

    call pbl_mym_turbulence_level25(&
      & r_mosurf, u_s, ftl_surf, fqw_surf, &
      & qkw, qdiv, &
      & sm, sh, gm, gh, wb_ng, dtldz, dqwdz, el, z_f, &
      & dfm, dfh, pdk, pdt, pdq, pdc)

    call pbl_mym_diagnose_cov(el, pdt, pdq, pdc, qkw, &
      & tsq_new, qsq_new, cov_new)

    call pbl_mym_diagnose_tke(pdk, el, qke_new)

    call  pbl_mym_flux_run_level25(&
      & dfm, dfh, uvel, vvel, tl, qw, &
      & rdz_h, f2h_m, f2h_p, &
      & taux_ex, tauy_ex, ftl_ex, fqw_ex)
    return
  end subroutine pbl_mym_main_level2
  !
  subroutine pbl_mym_adjust(qke, tsq, qsq)
    use pp_vardef
    use pbl_grid, only: nz
    use pbl_mym_const, only: qke_max
    implicit none

    real(r_size), intent(inout) :: qke(nz)
    real(r_size), intent(inout) :: tsq(nz)
    real(r_size), intent(inout) :: qsq(nz)

    integer(4) :: kz

    do kz = 1, nz
      qke(kz) = min(max(qke(kz), 1.e-20_r_size), qke_max)
      tsq(kz) = max(tsq(kz), 0.0_r_size)
      qsq(kz) = max(qsq(kz), 0.0_r_size)
    end do

    return

  end subroutine pbl_mym_adjust
  !

end module pbl_mym_main


