!> A module containing information about constants in PBL schemes.
!! All of the constants are given by users.

module pbl_const
  use pp_vardef
  implicit none

  !> reference pressure (Pa)(using to obtain exner function)
  real(r_size) :: pref
  !> timestep (second)
  real(r_size) :: timestep
  !> ground emissivity
  real(r_size) :: e_emit

  ! derived parameters
  !> reciprocal of pref
  real(r_size) :: r_pref


contains
  !> Set the module variables given by users.
  !! This subroutine should be called once at the stage of the initialization
  !! of models. 
  subroutine pbl_const_ini(pref_in, timestep_in, e_emit_in)
    use pp_vardef
    implicit none
    
    !> User input for reference pressure (Pa)
    real(r_size), intent(in) :: pref_in
    !> User input for timestep (second)
    real(r_size), intent(in) :: timestep_in
    !> ground emissivity
    real(r_size), intent(in) :: e_emit_in

    pref = pref_in
    timestep = timestep_in
    e_emit = e_emit_in

    ! derived
    r_pref = 1.0 / pref
    return
  end subroutine pbl_const_ini
end module pbl_const
