!= 
!
!= set dust flux
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_dust_flux.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_dust_flux
  !
  != 
  !
  != set dust flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
  ! SetDustFlux     :: ダストフラックスの設定
  ! SetDustFluxInit :: 初期化
  ! --------------- :: ------------
  ! SetDustFlux     :: Set dust flux
  ! SetDustFluxInit :: Initialization
  !
  !== NAMELIST
  !
  ! NAMELIST#set_dust_flux_nml
  !

  ! モジュール引用 ; USE statements
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING, &  ! 文字列.       Strings. 
    &                 TOKEN      ! キーワード.   Keywords.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only: imax, & ! 経度格子点数. 
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数. 
                             ! Number of grid points in latitude
    &                kmax    ! 鉛直層数. 
                             ! Number of vertical level

  ! 時刻管理
  ! Time control
  !
  use timeset, only: &
    & TimeN,                & !
    & InitialDate             ! 計算開始日時.
                              ! Start date of calculation

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public:: SetDustFlux
  public:: SetDustFluxInit

  ! 公開変数
  ! Public variables
  !
  logical, save :: set_dust_flux_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag.


  ! 非公開変数
  ! Private variables
  !
  real(DP), save :: StartDay
                              ! start day of dust injection
  real(DP), save :: DustFlux
                              ! Dust flux

  real(DP), save :: sec_in_a_day

!!$  logical,  save:: FlagAnnualMean
!!$                              ! 年平均入射フラグ.
!!$                              ! Flag for annual mean incoming radiation. 
!!$  logical,  save:: FlagDiurnalMean
!!$                              ! 日平均入射フラグ.
!!$                              ! Flag for diurnal mean incoming radiation. 
!!$  logical,  save:: FlagPerpetual
!!$                              ! 季節変化なし入射フラグ.
!!$                              ! Flag for perpetual incoming radiation. 
!!$
!!$  logical,  save:: FlagSpecifySolDay
!!$                              ! 
!!$                              ! Flag for specifying solar day
!!$  real(DP), save :: SolDay
!!$                              ! length of solar day


  ! NOTE:
  !   Distance between the central star and the planet, and the declination can be
  !   determined by specifying following three parameters: 
  !     PerLonFromVE     : the longitude of the perihelion measured from the vernal 
  !                        equinox, 
  !     LonFromVEAtEpoch : the longitude of the planet at epoch, 
  !     epoch            : date or time. 
  !
!!$  real(DP), save:: PerLonFromVE
!!$                              ! 春分から測った近日点の経度 (近日点黄経) (degree)
!!$                              ! Longitude of the perihelion from vernal equinox (degree)
!!$  real(DP), save:: LonFromVEAtEpoch
!!$                              ! 元期における惑星の経度 (黄経) (degree)
!!$                              ! Longitude of the planet at epoch (degree)
!!$  real(DP), save:: TimeAtEpoch
!!$                              ! 元期における時刻 (sec)
!!$                              ! Time at epoch (sec)
!!$
!!$  real(DP), save:: EpsOrb
!!$                              ! 赤道傾斜角.
!!$                              ! Inclination of equator to orbit.
!!$  real(DP), save:: Eccentricity
!!$                              ! 離心率.
!!$                              ! Eccentricity.
!!$
!!$  integer,  save:: MaxItrEccAnomaly
!!$                              ! 離心近点角を計算する時の最大繰り返し回数.
!!$                              ! Maximum iteration number of times
!!$                              ! to calculate eccentric anomaly.
!!$  real(DP), save:: ThreEccAnomalyError
!!$                              ! 離心近点角を計算する時の誤差の許容しきい値.
!!$                              ! Threshold of error
!!$                              ! to calculate eccentric anomaly.
!!$
!!$  real(DP), save:: IncomAIns
!!$                              ! $ A_{ins} $ . 年平均入射の係数. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$  real(DP), save:: IncomBIns
!!$                              ! $ B_{ins} $ . 年平均入射の係数. AIns に同じ. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$                              ! Same as "AIns". 
!!$  real(DP), save:: IncomAZet
!!$                              ! $ A_{\zeta} $ . 年平均入射角の係数. AIns に同じ. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$                              ! Same as "AIns". 
!!$  real(DP), save:: IncomBZet
!!$                              ! $ B_{\zeta} $ . 年平均入射角の係数. AIns に同じ. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$                              ! Same as "AIns". 
!!$
!!$
!!$  real(DP), allocatable, save:: xy_InAngle (:,:)
!!$                              ! sec (入射角). 
!!$                              ! sec (angle of incidence)
!!$
!!$  logical:: FlagRadSynchronous
!!$                              ! 同期回転日射のフラグ
!!$                              ! Flag for synchronous rotation

  character(*), parameter:: module_name = 'set_dust_flux'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: set_dust_flux.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $'
                              ! モジュールのバージョン
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetDustFlux( &
    & xy_SurfDustFlux     & ! (out)
    & )
    !
    ! 
    !
    ! Set dust flux
    !

    ! モジュール引用 ; USE statements
    !

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! 宣言文 ; Declaration statements
    !
    implicit none
    real(DP), intent(out) :: xy_SurfDustFlux(0:imax-1, 1:jmax)
                              ! 
                              ! 


    ! 作業変数
    ! Work variables
    !


    ! 実行文 ; Executable statement
    !

    ! 初期化確認
    ! Initialization check
    !
    if ( .not. set_dust_flux_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( TimeN >= sec_in_a_day * StartDay ) then
      xy_SurfDustFlux = DustFlux
    else
      xy_SurfDustFlux = 0.0_DP
    end if


  end subroutine SetDustFlux

  !--------------------------------------------------------------------------------------

  subroutine SetDustFluxInit
    !
    ! set_dust_flux モジュールの初期化を行います. 
    ! NAMELIST#set_dust_flux_nml の読み込みはこの手続きで行われます. 
    !
    ! "set_dust_flux" module is initialized. 
    ! "NAMELIST#set_dust_flux_nml" is loaded in this procedure. 
    !

    ! モジュール引用 ; USE statements
    !

    ! 種別型パラメタ
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! 暦と日時の取り扱い
    ! Calendar and Date handler
    !
    use dc_calendar, only: &
      & DCCalInquire

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! 宣言文 ; Declaration statements
    !
    implicit none

    integer  :: hour_in_a_day
    integer  :: min_in_a_hour
    real(DP) :: sec_in_a_min


    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
                              ! IOSTAT of NAMELIST read
!!$
!!$    logical         :: FlagUseOfEpochDate
!!$    character(TOKEN):: date_print


    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /set_dust_flux_nml/ &
      & StartDay, DustFlux
          !
          ! デフォルト値については初期化手続 "set_dust_flux#SetDustFluxInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "set_dust_flux#SetDustFluxInit" for the default values. 
          !

    ! 実行文 ; Executable statement
    !

    if ( set_dust_flux_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !
    StartDay = 0.0_DP
    DustFlux = 1.0e-6_DP


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = set_dust_flux_nml,  &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !
    ! Preparation of length of a day in second
    !
    call DCCalInquire( &
      & hour_in_day      = hour_in_a_day,     & ! (out)
      & min_in_hour      = min_in_a_hour,     & ! (out)
      & sec_in_min       = sec_in_a_min       & ! (out)
      & )
    sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min


    ! 保存用の変数の割り付け
    ! Allocate variables for saving
    !

    ! ヒストリデータ出力のためのへの変数登録
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'xxxxx' , &
!!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
!!$      & 'xxxx', 'W m-2' )


    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'StartDay     = %f', d = (/ StartDay /) )
    call MessageNotify( 'M', module_name, 'DustFlux     = %f', d = (/ DustFlux /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    set_dust_flux_inited = .true.

  end subroutine SetDustFluxInit

  !-------------------------------------------------------------------

end module set_dust_flux
