module rad_planetconst

  use vtype_module

  implicit none


  public :: RadPlanetConstInit


  real(DP), save :: Grav
  real(DP), save :: Cp
  real(DP), save :: MolWtNonRadAct

  real(DP), save :: MolWtH2O
  real(DP), save :: CpH2OVap


  data Grav           / -1.0d0 /
  data Cp             / -1.0d0 /
  data MolWtNonRadAct / -1.0d0 /

  data MolWtH2O       / -1.0d0 /
  data CpH2OVap       / -1.0d0 /

contains

  !----------------------------------------------------------------------------

  subroutine RadPlanetConstInit( &
    & GravSet, &
    & CpSet, &
    & MolWtNonRadActSet &
    & )

    real(DP), intent(in), optional :: GravSet
    real(DP), intent(in), optional :: CpSet
    real(DP), intent(in), optional :: MolWtNonRadActSet


    ! for Earth
    !
!!$    Grav           = 9.80665d0
!!$    ! standard acceleration of gravity (m s-2)
!!$    ! WMO technical regulations (see above)
!!$    Cp             = 1004.6d0
!!$    MolWtNonRadAct = 28.96d-3

    ! for Venus
!!$    Grav           = 8.9d0
!!$    Cp             = 837.6d0
!!$    MolWtNonRadAct = 44.0d-3


    if ( present( GravSet ) ) then
      Grav      = GravSet
    else
      Grav      = 9.80665d0
      ! standard acceleration of gravity (m s-2)
      ! WMO technical regulations (see above)
    end if

    if ( present( CpSet ) ) then
      Cp        = CpSet
    else
      Cp        = 1004.6d0
    end if

    if ( present( MolWtNonRadActSet ) ) then
      MolWtNonRadAct = MolWtNonRadActSet
    else
      MolWtNonRadAct = 28.96d-3
    end if


    ! Other variables
    MolWtH2O   = 18.0d-3  ! kg mol-1
    CpH2OVap   = 1810.0d0 ! J K-1 kg-1


    write( 6, * ) 'rad_planetconst module:'
    write( 6, * ) '  Grav           = ', Grav
    write( 6, * ) '  Cp             = ', Cp
    write( 6, * ) '  MolWtNonRadAct = ', MolWtNonRadAct
    write( 6, * ) '  MolWtH2O       = ', MolWtH2O
    write( 6, * ) '  CpH2OVap       = ', CpH2OVap


  end subroutine RadPlanetConstInit

  !----------------------------------------------------------------------------

end module rad_planetconst
