!= 火星 H2O 雲モデル
!
!= Mars H2O cloud model
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: cloud_mars_h2o.f90,v 1.2 2015/01/29 12:06:42 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module cloud_mars_h2o
  !
  != 火星 H2O 雲モデル
  !
  != Mars H2O cloud model
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! In this module, H2O cloud on Mars is calculated by use of a simple
  ! cloud model.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#cloud_simple_nml
  !

  ! モジュール引用 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only: imax, & ! 経度格子点数.
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数.
                             ! Number of grid points in latitude
    &                kmax    ! 鉛直層数.
                             ! Number of vertical level

  implicit none

  private


  ! 公開手続き
  ! Public procedure
  !
  public :: CloudMarsH2O
  public :: CloudMarsH2OInit


  ! 公開変数
  ! Public variables
  !


  ! 非公開変数
  ! Private variables
  !

  logical, save :: cloud_mars_h2o_inited = .false.
                              ! 初期設定フラグ.
                              ! Initialization flag

  character(*), parameter:: module_name = 'cloud_mars_h2o'
                              ! モジュールの名称.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: cloud_mars_h2o.f90,v 1.2 2015/01/29 12:06:42 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine CloudMarsH2O(                            &
    & xyr_Press, xyr_Height,                          & ! (in)
    & xyz_DQH2OSolDtCum, xyz_DQH2OSolDtLSC,           & ! (in)
    & xyz_QH2OSol,                                    & ! (inout)
    & xy_Rain, xy_Snow                                & ! (out)
    & )

    ! USE statements
    !

    ! 時刻管理
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSed


    real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyr_Height       ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyz_DQH2OSolDtCum( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyz_DQH2OSolDtLSC( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )



    ! 実行文 ; Executable statement
    !

    ! 初期化確認
    ! Initialization check
    !
    if ( .not. cloud_mars_h2o_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_QH2OSol = xyz_QH2OSol &
      & + ( xyz_DQH2OSolDtCum + xyz_DQH2OSolDtLSC ) * 2.0_DP * DelTime


    xy_Rain = 0.0_DP
    xy_Snow = 0.0_DP

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    call GravSed(                          &
      & 'MarsH2OCloud',                    & ! (in )
      & xyr_Press, xyr_Height,             & ! (in )
      & xyz_QH2OSol,                       & ! (out)
      & xy_Snow                            & ! (out) optional
      & )
    xy_Snow = - xy_Snow


  end subroutine CloudMarsH2O

  !--------------------------------------------------------------------------------------

  subroutine CloudMarsH2OInit

!!$    ! ファイル入出力補助
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! NAMELIST ファイル入力に関するユーティリティ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSedInit

    ! 宣言文 ; Declaration statements
    !

!!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
!!$    namelist /cloud_simple_nml/ &
!!$      & CloudLifeTime,       &
!!$      & CloudWatLifeTime,    &
!!$      & CloudIceLifeTime,    &
!!$      & CloudCoverMethod,    &
!!$      & RHCrtl,              &
!!$      & CloudCover
          !
          ! デフォルト値については初期化手続 "cloud_mars_h2o#CloudMarsH2OInit"
          ! のソースコードを参照のこと.
          !
          ! Refer to source codes in the initialization procedure
          ! "cloud_mars_h2o#CloudMarsH2OInit" for the default values.
          !

    ! 実行文 ; Executable statement
    !

    if ( cloud_mars_h2o_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = cloud_mars_h2o_nml,       & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    ! Initialization of modules used in this module
    !

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    call GravSedInit


    ! ヒストリデータ出力のためのへの変数登録
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'EffCloudCover', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'effective cloud cover', '1' )



    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    cloud_mars_h2o_inited = .true.

  end subroutine CloudMarsH2OInit

  !--------------------------------------------------------------------------------------

end module cloud_mars_h2o
