#!/bin/bash

#PBS -N topo15
##PBS -q uv-test
#PBS -q uv-large
#PBS -o stdout.log
#PBS -e stderr.log
##PBS -l select=1:ncpus=1:mpiprocs=1
## for flat MPI (MPI 8 processes)
##PBS -l select=1:ncpus=8:mpiprocs=8
### for hybrid (MPI 8 processes with 12 threads each)
##PBS -l select=1:ncpus=96:mpiprocs=8
## for hybrid (MPI 12 processes with 8 threads each)
#PBS -l select=1:ncpus=96:mpiprocs=12

cd ${PBS_O_WORKDIR}
#mpiexec_mpt -np 8 dplace -s1 ./dcpam_init_data -N=./init_data_V_T10L50.conf
#mpiexec_mpt -np 8 dplace -s1 ./dcpam_init_data_surface -N=./surface_data_V_T10.conf
#mpiexec_mpt -np 8 dplace -s1 ./dcpam_main -N=./dcpam_V_T10L50.conf

# for hybrid (MPI 8 processes with 12 threads each)
#export KMP_AFFINITY=disabled
#export OMP_NUM_THREADS=12
#mpiexec_mpt -np 8 omplace -nt ${OMP_NUM_THREADS} -c 0-95 ./dcpam_main -N=./dcpam_V_T10L48.conf
# for hybrid (MPI 6 processes with 16 threads each)
export KMP_AFFINITY=disabled
export OMP_NUM_THREADS=8
mpiexec_mpt -np 12 omplace -nt ${OMP_NUM_THREADS} -c 0-95 ./dcpam_main -N=./dcpam_V_T15L48.conf


