#!/bin/bash

fn_serial="loop_serial"
fn_limit="loop_limit"
fn_dcpam="dcpam_V_T10L50.conf"
fn_dcpam_template="template_"$fn_dcpam
fn_qsub="vizfront_script_dcpam.sh"

fn_chkfile="stdout"

del_restart_time=$(( 86400*400 ))


while :
do

    # serial
    if [ ! -e $fn_serial ] ; then
	echo "ERROR: File" $fn_serial "does not exist."
	exit
    fi
    list=(`cat ${fn_serial}`)
    iloop=${list[0]}
    restart_time=${list[1]}
    #
    echo "CURRENT" $fn_serial
    echo "----------------------------"
    echo $iloop
    echo $restart_time
    echo "----------------------------"

    # limit
    if [ ! -e $fn_limit ] ; then
	echo "ERROR: File" $fn_limit "does not exist."
	exit
    fi
    iloope=`cat ${fn_limit}`


    echo "LOOP:" $iloop


    iloop_prev=$(( $iloop-1 ))
    if [ $iloop_prev -lt 0 ] ; then
	echo "ERROR: iloop_prev is less than zero : " $iloop_prev
	exit
    fi


    if [ $iloop -lt 10 ] ; then
	cdirname="000"$iloop
    elif [ $iloop -lt 100 ] ; then
	cdirname="00"$iloop
    elif [ $iloop -lt 1000 ] ; then
	cdirname="0"$iloop
    else
	cdirname=$iloop
    fi
    if [ $iloop_prev -lt 10 ] ; then
	cdirname_prev="000"$iloop_prev
    elif [ $iloop_prev -lt 100 ] ; then
	cdirname_prev="00"$iloop_prev
    elif [ $iloop_prev -lt 1000 ] ; then
	cdirname_prev="0"$iloop_prev
    else
	cdirname_prev=$iloop_prev
    fi



    if [ $iloop -le $iloope ] ; then

	echo "     CALCULATION..."

	if [ ! -e $fn_dcpam_template ] ; then
	    echo "ERROR: File" $fn_dcpam_template "does not exist."
	    exit
	fi
	cat $fn_dcpam_template \
	    | sed -e s/RESTARTTIME/$restart_time/g \
	    | sed -e s/RESTARTFILEDIR/$cdirname_prev/g \
	    > $fn_dcpam

	#qsub $fn_qsub
	nohup mpiexec -n 8 ./dcpam_main -N=./dcpam_V_T10L50.conf < /dev/null >& errorlog &

	# Loop for waiting until DCPAM finishes
	while :
	do

	    if [ -e $fn_chkfile ] ; then

		mkdir $cdirname
		mv $fn_dcpam *.nc errorlog $fn_chkfile $cdirname

		iloop_next=$(( $iloop+1 ))
		restart_time=$(( $restart_time + $del_restart_time ))

		echo $iloop_next   >  $fn_serial
		echo $restart_time >> $fn_serial
		echo "NEXT" $fn_serial
		echo "----------------------------"
		cat $fn_serial
		echo "----------------------------"

		break
	    else
		sleep 600
	    fi

	done


    else

	break

    fi

done

echo "Finish"
