=begin JA

= ごくらく DCPAM5

# * 森川 靖大 (morikawa), 納多 哲史 (noda), 高橋 芳幸 (yot), 竹広 真一 (takepiro)
#   * $Id: index.rd,v 1.11 2015/02/12 16:50:31 yot Exp $

=end JA

=begin EN

= GOKURAKU DCPAM5

# * Yasuhiro MORIKAWA (morikawa), Satoshi NODA (noda), Yoshiyuki O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: index.rd,v 1.11 2015/02/12 16:50:31 yot Exp $

=end EN

=begin JA
== はじめに

この文書は, DCPAM5 を用いて手軽に実験を
行うためのチュートリアルです. 

=end JA

=begin EN
== Introduction

This document is tutorial for performing experiments easily with 
DCPAM5.

As an aside, "GOKURAKU" means "easiest".

=end EN

=begin JA
== DCPAM5 のビルド

((<DCPAM5 インストールガイド|URL:../../INSTALL.htm>)) を参考に, 
DCPAM5 のビルドを行ってください. 
「ビルドの手引き」の「ソースコードのコンパイル」まで行ってください. 

ビルドが完了すると, "src/main" ディレクトリ以下に, 
((*dcpam_main*)), ((*init_data*)), ((*sst_data*))
といった実行ファイルが作成されます. 
またこのディレクトリには, 
いくつかのサンプル NAMELIST ファイル (拡張子が .conf のファイル)
が "exp_setup_files" に用意されています. 

  $ ls exp_setup_files

  dcpam_ape_T21L16.conf
  dcpam_ape_T42L16.conf
  dcpam_hs94_T21L20.conf
  dcpam_hs94_T42L20.conf
  init_data_T21L16.conf
  init_data_T42L16.conf
  sst_data_T21.conf
  sst_data_T42.conf

         :

=end JA

=begin EN
== Building DCPAM5

Build DCPAM5 referring to 
((<DCPAM5 Installation Guide|URL:../../INSTALL.htm.en>)). 
Work until "Compile source code" in "How to build".

After building, 
executable files ((*dcpam_main*)), ((*init_data*)), ((*sst_data*)) 
are created under "src/main" directory. 
Some NAMELIST files (with suffix ".conf") are prepared in 
in "exp_setup_files" directory. 

  $ ls exp_setup_files

  dcpam_ape_T21L16.conf
  dcpam_ape_T42L16.conf
  dcpam_hs94_T21L20.conf
  dcpam_hs94_T42L20.conf
  init_data_T21L16.conf
  init_data_T42L16.conf
  sst_data_T21.conf
  sst_data_T42.conf

         :

=end EN


=begin JA
=== いくつかのコンパイラに関する注意書き

動作チェックを行っている, もしくは行ったことのある
いくつかのコンパイラに関する注意書きです. 

  * ((<Intel Fortran|URL:compiler_note.htm#ifort>))
  * ((<G95 Fortran|URL:compiler_note.htm#g95>))
  * ((<Fujitsu Fortran|URL:compiler_note.htm#frt>))

他のコンパイラについても当てはまる場合があるかもしれませんので, 
下記の動作チェックがうまく行かない場合にはご一読ください. 

=end JA

=begin EN
=== Notes about some compilers

Notes about some compilers that are done the operation check or have done
are as follows.

  * ((<Intel Fortran|URL:compiler_note.htm.en#ifort>))
  * ((<G95 Fortran|URL:compiler_note.htm.en#g95>))
  * ((<Fujitsu Fortran|URL:compiler_note.htm.en#frt>))

Read it through if the following operation check doesn't go well, 
because it is likely to apply about other compilers. 

=end EN


=begin JA
== 実験の実行

下に, いくつかの実験の実行方法についての説明を記します.
始めて DCPAM を使う人は, まずどれか 1 つの実験
(例えば「Polvani et al. (2004) の傾圧不安定波動実験」) の説明に
従ってやってみて下さい.

ちなみに, どの実験も実行するには以下の 4 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験用データの準備
    * 実験用データとは, 例えば, 海表面温度, 地形, オゾンの分布のデータを意味します
  * 実験の実行

なお, 実験ディレクトリの準備は, 必ずしも必要ありません. 
ここでは, ある実験の設定や結果が他のものと混ざってしまうことを防ぐために, 
各実験ごとにディレクトリを作成しています. 

=end JA
=begin EN
== Execution of experiments

List described below is descriptions on procedures for performing 
DCPAM5 test experiments.
For beginners, 
performing one experiment (for example, Baroclinic wave experiment 
by Polvani et al. (2004)) is recommended
following procedures described in each page.

All experiments using DCPAM5 are performed with the following four steps:

  * Preparation of directory for an experiment
  * Preparation of initial condition
  * Preparation of additional data for experiments
    * Additional data mean data of sea surface temperature (SST), topography, ozone distribution
  * Execution of experiments

Note that the preparation of directory for an experiment is not necessary required. 
Here, a directory is created to isolate configuration files and result files 
in an experiment from those from another one. 
#Note that several experiments can share a directory for experiments, and 
#an initial condition data can be shared with several experiments.
#On the one hand, an initial condition data can be generated internally when the 
#experiments are performed without preparing an initial condition. 
#This is also the case for additional data for experiments. 

In the followings, methods for performing several experiments are described. 

=end EN


=begin JA
=== Polvani et al. (2004) の傾圧不安定波動実験
Polvani et al. (2004) で行われた, 傾圧不安定波動の実験を実行する方法を((<こちら|URL:./exp-p04.htm>))で説明します. 
=end JA
=begin EN
=== Baroclinic wave experiment by Polvani et al. (2004)
A method to perform a baroclinic wave experiment by Polvani et al. (2004) is described ((<here|URL:./exp-p04.htm.en>)).
=end EN

=begin JA
=== Held and Suarez (1994) による力学コア実験
Held and Suarez (1994) が提案した, 
大気大循環モデルの力学過程を評価するための
実験を実行する方法を((<こちら|URL:./exp-hs94.htm>))で説明します. 
=end JA
=begin EN
=== Dynamical core experiment by Held and Suarez (1994)
A method to perform dynamical core experiment proposed by
Held and Suarez (1994) is described ((<here|URL:./exp-hs94.htm.en>)).
=end EN

#=begin JA
#=== 水惑星実験 (Dennou AGCM5 version)
#惑星表面が全て水であるような条件 (水惑星) 
#で実験を行う方法を((<こちら|URL:./exp-ape.htm>))で説明します. 
#=end JA
#=begin EN
#=== Aqua planet experiment (Dennou AGCM5 version)
#A method to perform an aqua planet experiment
#(planetary surface is covered by watar) is described ((<here|URL:./exp-ape.htm.en>)).
#=end EN

=begin JA
=== Neale and Hoskins (2000) による水惑星実験
Neale and Hoskins (2000) によって提案された, 惑星表面が全て水であるような条件 (水惑星) 
で実験を行う方法を((<こちら|URL:./exp-APE-NH00.htm>))で説明します. 
=end JA
=begin EN
=== Aqua planet experiment by Neale and Hoskins (2000)
A method to perform an aqua planet experiment
(planetary surface is covered by watar) proposed by Neale and Hoskins (2000) 
is described ((<here|URL:./exp-APE-NH00.htm.en>)).
=end EN

#=begin JA
#=== Neale and Hoskins (2000) による水惑星実験 (軸対称計算)
#Neale and Hoskins (2000) によって提案された, 惑星表面が全て水であるような条件 (水惑星) 
#で, 軸対称モデルを用いて実験を行う方法を((<こちら|URL:./exp-APE-NH00-Axisym.htm>))で説明します. 
#=end JA
#=begin EN
#=== Aqua planet experiment by Neale and Hoskins (2000) (Axisymmetric calculation)
#A method to perform an aqua planet experiment
#(planetary surface is covered by watar) proposed by Neale and Hoskins (2000) 
#with an axisymmetric version of model 
#is described ((<here|URL:./exp-APE-NH00-Axisym.htm.en>)).
#=end EN

=begin JA
=== 地球実験
地球の実験を行う方法を((<こちら|URL:./exp-Earth.htm>))で説明します. 
=end JA
=begin EN
=== Experiment for the Earth
A method to perform an experiment for the Earth is described ((<here|URL:./exp-Earth.htm.en>)).
=end EN

=begin JA
=== 火星実験
火星の実験を行う方法を((<こちら|URL:./exp-Mars.htm>))で説明します. 
=end JA
=begin EN
=== Mars experiment
A method to perform a Mars experiment is described ((<here|URL:./exp-Mars.htm.en>)).
=end EN

=begin JA
=== 火星実験 (鉛直一次元計算)
火星の実験を行う方法を((<こちら|URL:./exp-Mars-1D.htm>))で説明します. 
=end JA
=begin EN
=== Mars experiment (Vertical 1-dimensional experiment)
A method to perform a Mars experiment is described ((<here|URL:./exp-Mars-1D.htm.en>)).
=end EN

=begin JA
=== 金星的惑星実験
Yamamoto and Takahashi (2003) に似た強制を与えた金星的惑星の
実験を実行する方法を((<こちら|URL:./exp-Venuslike.htm>))で説明します. 
=end JA
=begin EN
=== Experiment for Venus-like planet
A method to perform an experiment for Venus-like planet by using forcing by 
Yamamoto and Takahashi (2003) is described ((<here|URL:./exp-Venuslike.htm.en>)).
=end EN



=begin JA
== 簡単な解析・可視化

簡単な解析・可視化については ((<こちら|URL:./visualization.htm>)) を参照してください. 

#この他にも, 解析・可視化をより自在に行う
#CUI (キャラクターユーザインターフェース) ツール
#((<GPhys|URL:http://ruby.gfd-dennou.org/products/gphys/>))
#(((<チュートリアル|URL:http://ruby.gfd-dennou.org/products/gphys/tutorial/>)))
#などもあるため, 実際に解析・可視化を行う際には, 適宜選んで使用してください. 

=end JA

=begin EN
== First step analysis and visualization

Please see ((<here|URL:./visualization.htm.en>)) for simple analysis and visualization. 

#Detailed documents for analysis and visualization can be found in pages about
#((<GPhys|URL:http://ruby.gfd-dennou.org/products/gphys/>)). 
#Please select and use these tools for analysis and visualization.

=end EN




=begin JA

== 実験条件の変更

実験条件のいくつかについて変更方法を ((<こちら|URL:./changesetup.htm>)) で説明します. 

=end JA
=begin EN

== Change experimental setup

Ways how to change several experimental setup is described ((<here|URL:./changesetup.htm>)). 

=end EN




##################################################################
#
#
#=begin JA
#== 設定の参照と変更
#
#=== 設定の参照
#
#計算時の設定は標準出力へと表示されます. 
#((<実行: 乾燥大気での力学過程ベンチマーク計算 (Held and Suarez, 1994)>))
#では tee コマンドにより, 出力された情報を標準出力と "hs94.log" ファイルに
#書きだしたため, この "hs94.log" をテキストヴューアで眺めてみましょう.
#
#  $ more hs94.log
#
#以下では, 表示される内容の一部を解説します.
#
#計算開始時刻, 終了時刻, 時間ステップ, 
#終了予測時刻表示間隔, CPU 時間計測のオンオフです. 
#((<timeset モジュール|URL:../../code_reference/htm/classes/timeset.html>))
#で管理されています. 
#
#    |*** MESSAGE [timeset] ***  ----- Initialization Messages -----
#    |*** MESSAGE [timeset] ***    StartTime  = 0. [day]
#    |*** MESSAGE [timeset] ***    EndTime    = 10. [day]
#    |*** MESSAGE [timeset] ***    DelTime    = 30. [min]
#    |*** MESSAGE [timeset] ***               = 1800. [sec]
#    |*** MESSAGE [timeset] ***    PredictInt = 6. [hrs]
#    |*** MESSAGE [timeset] ***    CpuTimeMoniter = T
#    |*** MESSAGE [timeset] ***  -- version = ...
#
#
#実験の表題, データソース, データを作成した人/組織です.
#これらは出力データの大域属性へと与えられます. 
#((<fileset モジュール|URL:../../code_reference/htm/classes/fileset.html>))
#で管理されています. 
#    
#    |*** MESSAGE [fileset] ***  ----- Initialization Messages -----
#    |*** MESSAGE [fileset] ***    FileTitle       = Held and Suarez (1994) benchmark test
#    |*** MESSAGE [fileset] ***    FileSource      = dcpam5 (http://www.gfd-dennou.org/library/dcpam)
#    |*** MESSAGE [fileset] ***    FileInstitution = GFD Dennou Club (http://www.gfd-dennou.org)
#    |*** MESSAGE [fileset] ***  -- version ...
#
#最大全波数, 経度格子点数, 緯度格子点数, 鉛直層数です. 
#((<gridset モジュール|URL:../../code_reference/htm/classes/gridset.html>))
#で管理されています. 
#
#    |*** MESSAGE [gridset] ***  ----- Initialization Messages -----
#    |*** MESSAGE [gridset] ***    nmax = 21
#    |*** MESSAGE [gridset] ***    imax = 64
#    |*** MESSAGE [gridset] ***    jmax = 32
#    |*** MESSAGE [gridset] ***    kmax = 20
#    |*** MESSAGE [gridset] ***  -- version ...
#
#物理定数です. 
#((<constants モジュール|URL:../../code_reference/htm/classes/constants.html>))
#で管理されています. 各値の詳細はこのモジュールのマニュアルを参照してください. 
#
#    |*** MESSAGE [constants] ***  ----- Initialization Messages -----
#    |*** MESSAGE [constants] ***    PI         = 3.141592653589793
#    |*** MESSAGE [constants] ***    GasRUniv   = 8.314
#    |*** MESSAGE [constants] ***    StB        = 0.567E-07
#    |*** MESSAGE [constants] ***    FKarm      = 0.4
#    |*** MESSAGE [constants] ***    RPlanet    = 6371000.
#    |*** MESSAGE [constants] ***    Omega      = 0.7292106590880652E-04
#    |*** MESSAGE [constants] ***    Grav       = 9.800000000000001
#    |*** MESSAGE [constants] ***    CpDry      = 1004.6
#    |*** MESSAGE [constants] ***    MolWtDry   = 0.28964E-01
#    |*** MESSAGE [constants] ***    GasRDry    = 287.0459881231874
#    |*** MESSAGE [constants] ***    CpWet      = 1810.
#    |*** MESSAGE [constants] ***    MolWtWet   = 0.1801528E-01
#    |*** MESSAGE [constants] ***    GasRWet    = 461.4971291037386
#    |*** MESSAGE [constants] ***    LatentHeat = 2500000.
#    |*** MESSAGE [constants] ***    EpsV       = 0.6219886755972932
#    |*** MESSAGE [constants] ***  -- version ...
#
#リスタートデータの入出力に関する情報です. 
#((<restart_file_io モジュール|URL:../../code_reference/htm/classes/restart_file_io.html>))
#で管理されています. 各値の詳細はこのモジュールのマニュアルを参照してください. 
#
#    |*** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
#    |*** MESSAGE [restart_file_io] ***  Input::
#    |*** MESSAGE [restart_file_io] ***    InputFile  = <Non>
#    |*** MESSAGE [restart_file_io] ***    ** Initial data is generated in "initial_data" module
#    |*** MESSAGE [restart_file_io] ***  Output::
#    |*** MESSAGE [restart_file_io] ***    OutputFile = restart.nc
#    |*** MESSAGE [restart_file_io] ***    IntTime    = 1. [day]
#    |*** MESSAGE [restart_file_io] ***  -- version ...
#
#ヒストリデータの出力に関する情報です. 
#ヒストリデータの出力には
#((<"gtool5 Fortran 90/95 ライブラリ"|URL:http://www.gfd-dennou.org/library/gtool/gtool5.htm>)) 
#の gtool_historyauto モジュールを用いており, 
#下記は gtool_historyauto モジュールによって出力されるメッセージです. 
#各値の意味などは, ((<出力設定の変更>)) を参照してください. 
##各値の詳細は, 
##((<こちら|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/code_reference/classes/NAMELIST.html>))
##を参照してください. 
#
#    |*** MESSAGE [HistAuto] ***  ----- "gtool_historyauto_nml" is not loaded" -----
#    |*** MESSAGE [HistAuto] ***  Global Settings:
#    |*** MESSAGE [HistAuto] ***    AllOutput       = T
#    |*** MESSAGE [HistAuto] ***    FilePrefix      =
#    |*** MESSAGE [HistAuto] ***    Interval        = 1. [day]
#    |*** MESSAGE [HistAuto] ***    Precision       = float
#    |*** MESSAGE [HistAuto] ***    TimeAverage     = F
#    |*** MESSAGE [HistAuto] ***    Origin          = 0. [sec]
#    |*** MESSAGE [HistAuto] ***    Terminus        = 10. [day]
#    |*** MESSAGE [HistAuto] ***    SliceStart      = (/ 1, 1, 1, 1, 1 /)
#    |*** MESSAGE [HistAuto] ***    SliceEnd        = (/ -1, -1, -1, -1, -1 /)
#    |*** MESSAGE [HistAuto] ***    SliceStride     = (/ 1, 1, 1, 1, 1 /)
#    |*** MESSAGE [HistAuto] ***    SpaceAverage    = (/ F, F, F, F, F /)
#    |*** MESSAGE [HistAuto] ***    NewFileInterval = -1 [day]
#    |*** MESSAGE [HistAuto] ***
#
#力学過程の設定に関する情報です. 
#((<dynamics_hspl_vas83 モジュール|URL:../../code_reference/htm/classes/dynamics_hspl_vas83.html>))
#で管理されています. 各値の詳細はこのモジュールのマニュアルを参照してください. 
#
#    |*** MESSAGE [dynamics_hspl_vas83] ***  ----- Initialization Messages -----
#    |*** MESSAGE [dynamics_hspl_vas83] ***    TimeIntegScheme  = Semi-implicit
#    |*** MESSAGE [dynamics_hspl_vas83] ***    EFoldTime = 0.1 [day]
#    |*** MESSAGE [dynamics_hspl_vas83] ***    VisOrder  = 8
#    |*** MESSAGE [dynamics_hspl_vas83] ***    VisCoef   = 0.214573634546703E+43
#    |*** MESSAGE [dynamics_hspl_vas83] ***    RefTemp   = 300.
#    |*** MESSAGE [dynamics_hspl_vas83] ***  -- version ...
#
#=== 設定の変更
#
#計算設定を変更するには NAMELIST ファイルを編集し, これを実行時の -N=
#オプションに指定します. 
#ここでは, 上記で使用した
#((<dcpam_hs94_T21L20.nml|URL:../../../src/main/dcpam_hs94_T21L20.nml>))
#を編集してみます. 
#以下は dcpam_hs94_T21L20.nml の冒頭部です. 
#
#    #= dcpam_hs94 プログラム用 NAMELIST ファイル (T21L20 用)
#    #= NAMELIST file for "dcpam_hs94"
#    #
#
#    &dcpam_main_nml
#      FlagAPE  = .false.,         ! 物理過程 (APE) 計算オン／オフ. 
#                                  ! Physical processes (APE) calculation on/off. 
#      FlagHS94 = .true.           ! Held and Suarez (1994) 強制オン／オフ. 
#                                  ! Held and Suarez (1994) forcing on/off. 
#    /
#    &fileset_nml
#      FileTitle = 'Held and Suarez (1994) benchmark test', 
#                                  ! 出力データファイルの表題.
#                                  ! Title of output data files
#      FileSource = 'dcpam5 (http://www.gfd-dennou.org/library/dcpam)', 
#                                  ! データファイル作成の手段. 
#                                  ! Source of data file
#      FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'
#                                  ! データファイルを最終的に変更した組織/個人. 
#                                  ! Institution or person that changes data files for the last time
#    /
#    &gridset_nml
#      nmax = 21,                  ! 最大全波数. 
#                                  ! Maximum truncated wavenumber
#      imax = 64,                  ! 経度格子点数. 
#                                  ! Number of grid points in longitude
#      jmax = 32,                  ! 緯度格子点数. 
#                                  ! Number of grid points in latitude
#      kmax = 20                   ! 鉛直層数. 
#                                  ! Number of vertical level
#    /
#                   :
#
#積分時間について変更してみましょう. エディタを用いて,
#dcpam_hs94_T21L20.nml の ((*&timeset_nml*)) の ((*EndTimeValue*))
#を以下のように変更してください.
#
#  &timeset_nml
#              : 
#    EndTimeValue    = 20.0, 
#                                ! 計算終了時刻. 
#                                ! End time of calculation
#    EndTimeUnit     = 'day', 
#                                ! 計算開始時刻の単位. 
#                                ! Unit of end time of calculation
#
#この NAMELIST ファイルを読み込ませて dcpam_main を実行することにより,
#20 日分の計算が行われます. 
#
#編集が終わったら, 以下のように
#オプション -N (または --namelist) に NAMELIST ファイルを指定しつつ, 
#実行コマンドを入力してください. 
#
#  $ ./dcpam_main -N=dcpam_hs94_T21L20.nml | tee hs94-T21L20.log
#
#   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "dcpam_hs94_T21L20.nml".
#   *** MESSAGE [timeset] ***  ----- Initialization Messages -----
#   *** MESSAGE [timeset] ***    StartTime  = 0. [day]
#   *** MESSAGE [timeset] ***    EndTime    = 20. [day]
#   *** MESSAGE [timeset] ***    DelTime    = 30. [min]
#   *** MESSAGE [timeset] ***               = 1800. [sec]
#   *** MESSAGE [timeset] ***    PredictInt = 6. [hrs]
#   *** MESSAGE [timeset] ***    CpuTimeMoniter = T
#   *** MESSAGE [timeset] ***  -- version = ....
#                         : 
#
#この他にも dcpam_hs94_T21L20.nml に記述されている
#"&xxxxxx_nml" という NAMELIST 変数群名は, それぞれモジュール xxxxxx で
#管理される設定値です. DCPAM5 で管理される NAMELIST 変数群名のリストおよび
#各設定値の詳細については
#((<DCPAM5 NAMELIST|URL:../../code_reference/htm/classes/NAMELIST.html>))
#から参照可能です.
#一通りの設定値がサンプルとして記述されている
#((<dcpam_hs94_T42L20.nml|URL:../../../src/main/dcpam_hs94_T42L20.nml>))
#も用意しているので, こちらも参照ください. 
#
#((*&gtool_historyauto_nml*)) に関しては
#((<出力設定の変更>)) を参照してください. 
#
#
#=end JA
#
#=begin EN
#== Refer and Change configuration
#
#=== Refer configuration
#
#Setting values of calculation is output to standard output. 
#In ((<Run: Dry atmosphere benchmark experiment for dynamical core suggested by Held and Suarez (1994)>)), 
#the messages were written to standard output and a file "hs94.log". 
#See the "hs94.log". 
#
#A part of displayed contents is explained. 
#
#Start time of calculation, end time of calculation, time step, 
#Interval of predicted end time output, On/off of CPU time monitoring are
#displayed. 
#These values are managed in
#((<timeset module|URL:../../code_reference/htm/classes/timeset.html>)). 
#
#    |*** MESSAGE [timeset] ***  ----- Initialization Messages -----
#    |*** MESSAGE [timeset] ***    StartTime  = 0. [day]
#    |*** MESSAGE [timeset] ***    EndTime    = 10. [day]
#    |*** MESSAGE [timeset] ***    DelTime    = 30. [min]
#    |*** MESSAGE [timeset] ***               = 1800. [sec]
#    |*** MESSAGE [timeset] ***    PredictInt = 6. [hrs]
#    |*** MESSAGE [timeset] ***    CpuTimeMoniter = T
#    |*** MESSAGE [timeset] ***  -- version = ...
#
#
#Title of experiments, source of data, institutions are displayed. 
#These are given to global attributes of output data. 
#These values are managed in 
#((<fileset module|URL:../../code_reference/htm/classes/fileset.html>)).
#    
#    |*** MESSAGE [fileset] ***  ----- Initialization Messages -----
#    |*** MESSAGE [fileset] ***    FileTitle       = Held and Suarez (1994) benchmark test
#    |*** MESSAGE [fileset] ***    FileSource      = dcpam5 (http://www.gfd-dennou.org/library/dcpam)
#    |*** MESSAGE [fileset] ***    FileInstitution = GFD Dennou Club (http://www.gfd-dennou.org)
#    |*** MESSAGE [fileset] ***  -- version ...
#
#Maximum truncated wavenumber, number of grid points in longitude and
#latitude, number of vertical level are displayed. 
#These values are managed in
#((<gridset module|URL:../../code_reference/htm/classes/gridset.html>)).
#
#    |*** MESSAGE [gridset] ***  ----- Initialization Messages -----
#    |*** MESSAGE [gridset] ***    nmax = 21
#    |*** MESSAGE [gridset] ***    imax = 64
#    |*** MESSAGE [gridset] ***    jmax = 32
#    |*** MESSAGE [gridset] ***    kmax = 20
#    |*** MESSAGE [gridset] ***  -- version ...
#
#Some physical constants are displauyed. 
#These values are managed in
#((<constants module|URL:../../code_reference/htm/classes/constants.html>)).
#See a manual of this module for details. 
#
#    |*** MESSAGE [constants] ***  ----- Initialization Messages -----
#    |*** MESSAGE [constants] ***    PI         = 3.141592653589793
#    |*** MESSAGE [constants] ***    GasRUniv   = 8.314
#    |*** MESSAGE [constants] ***    StB        = 0.567E-07
#    |*** MESSAGE [constants] ***    FKarm      = 0.4
#    |*** MESSAGE [constants] ***    RPlanet    = 6371000.
#    |*** MESSAGE [constants] ***    Omega      = 0.7292106590880652E-04
#    |*** MESSAGE [constants] ***    Grav       = 9.800000000000001
#    |*** MESSAGE [constants] ***    CpDry      = 1004.6
#    |*** MESSAGE [constants] ***    MolWtDry   = 0.28964E-01
#    |*** MESSAGE [constants] ***    GasRDry    = 287.0459881231874
#    |*** MESSAGE [constants] ***    CpWet      = 1810.
#    |*** MESSAGE [constants] ***    MolWtWet   = 0.1801528E-01
#    |*** MESSAGE [constants] ***    GasRWet    = 461.4971291037386
#    |*** MESSAGE [constants] ***    LatentHeat = 2500000.
#    |*** MESSAGE [constants] ***    EpsV       = 0.6219886755972932
#    |*** MESSAGE [constants] ***  -- version ...
#
#Information of input/output of restart data are displayed. 
#These values are managed in
#((<restart_file_io module|URL:../../code_reference/htm/classes/restart_file_io.html>)). 
#See a manual of this module for details. 
#
#    |*** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
#    |*** MESSAGE [restart_file_io] ***  Input::
#    |*** MESSAGE [restart_file_io] ***    InputFile  = <Non>
#    |*** MESSAGE [restart_file_io] ***    ** Initial data is generated in "initial_data" module
#    |*** MESSAGE [restart_file_io] ***  Output::
#    |*** MESSAGE [restart_file_io] ***    OutputFile = restart.nc
#    |*** MESSAGE [restart_file_io] ***    IntTime    = 1. [day]
#    |*** MESSAGE [restart_file_io] ***  -- version ...
#
#Information of output of history data are displayed. 
#These values are managed in "gtool_historyauto" module of 
#((<"gtool5 Fortran 90/95 library"|URL:http://www.gfd-dennou.org/library/gtool/gtool5.htm.en>)). 
#See
#((<this manual|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/code_reference/classes/NAMELIST.html>))
#for details. 
#
#    |*** MESSAGE [HistAuto] ***  ----- "gtool_historyauto_nml" is not loaded" -----
#    |*** MESSAGE [HistAuto] ***  Global Settings:
#    |*** MESSAGE [HistAuto] ***    AllOutput       = T
#    |*** MESSAGE [HistAuto] ***    FilePrefix      =
#    |*** MESSAGE [HistAuto] ***    Interval        = 1. [day]
#    |*** MESSAGE [HistAuto] ***    Precision       = float
#    |*** MESSAGE [HistAuto] ***    TimeAverage     = F
#    |*** MESSAGE [HistAuto] ***    Origin          = 0. [sec]
#    |*** MESSAGE [HistAuto] ***    Terminus        = 10. [day]
#    |*** MESSAGE [HistAuto] ***    SliceStart      = (/ 1, 1, 1, 1, 1 /)
#    |*** MESSAGE [HistAuto] ***    SliceEnd        = (/ -1, -1, -1, -1, -1 /)
#    |*** MESSAGE [HistAuto] ***    SliceStride     = (/ 1, 1, 1, 1, 1 /)
#    |*** MESSAGE [HistAuto] ***    SpaceAverage    = (/ F, F, F, F, F /)
#    |*** MESSAGE [HistAuto] ***    NewFileInterval = -1 [day]
#    |*** MESSAGE [HistAuto] ***
#
#Information of setting values of dynamical core are displayed. 
#These values are managed in
#((<dynamics_hspl_vas83 module|URL:../../code_reference/htm/classes/dynamics_hspl_vas83.html>)). 
#See a manual of this module for details. 
#
#    |*** MESSAGE [dynamics_hspl_vas83] ***  ----- Initialization Messages -----
#    |*** MESSAGE [dynamics_hspl_vas83] ***    TimeIntegScheme  = Semi-implicit
#    |*** MESSAGE [dynamics_hspl_vas83] ***    EFoldTime = 0.1 [day]
#    |*** MESSAGE [dynamics_hspl_vas83] ***    VisOrder  = 8
#    |*** MESSAGE [dynamics_hspl_vas83] ***    VisCoef   = 0.214573634546703E+43
#    |*** MESSAGE [dynamics_hspl_vas83] ***    RefTemp   = 300.
#    |*** MESSAGE [dynamics_hspl_vas83] ***  -- version ...
#
#
#=== Change configuration
#
#In order to configure the settings of calculation, 
#edit a NAMELIST file, and specify the file to "-N" option of an execution.
#Here, above '((<dcpam_hs94_T21L20.nml|URL:../../../src/main/dcpam_hs94_T21L20.nml>))'
#is edited. 
#A part of 'dcpam_hs94_T21L20.nml' is showed as follows. 
#
#    #= NAMELIST file for "dcpam_hs94"
#    #
#
#    &dcpam_main_nml
#      FlagAPE  = .false.,         ! Physical processes (APE) calculation on/off. 
#      FlagHS94 = .true.           ! Held and Suarez (1994) forcing on/off. 
#    /
#    &fileset_nml
#      FileTitle = 'Held and Suarez (1994) benchmark test', 
#                                  ! Title of output data files
#      FileSource = 'dcpam5 (http://www.gfd-dennou.org/library/dcpam)', 
#                                  ! Source of data file
#      FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'
#                                  ! Institution or person that changes data files for the last time
#    /
#    &gridset_nml
#      nmax = 21,                  ! Maximum truncated wavenumber
#      imax = 64,                  ! Number of grid points in longitude
#      jmax = 32,                  ! Number of grid points in latitude
#      kmax = 20                   ! Number of vertical level
#    /
#                   :
#
#Change end time of integration. Edit 
#((*EndTimeValue*)) of ((*&timeset_nml*)) in "dcpam_hs94_T21L20.nml"
#as follows.
#
#  &timeset_nml
#              : 
#    EndTimeValue    = 20.0,     ! End time of calculation
#    EndTimeUnit     = 'day',    ! Unit of end time of calculation
#
#20 days integration is performed when "dcpam_main" is executed with
#this NAMELIST file. 
#
#After edit, execute with '-N' (or '--namelist') option as follows.
#
#  $ ./dcpam_main -N=dcpam_hs94_T21L20.nml | tee hs94-T21L20.log
#
#   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "dcpam_hs94_T21L20.nml".
#   *** MESSAGE [timeset] ***  ----- Initialization Messages -----
#   *** MESSAGE [timeset] ***    StartTime  = 0. [day]
#   *** MESSAGE [timeset] ***    EndTime    = 20. [day]
#   *** MESSAGE [timeset] ***    DelTime    = 30. [min]
#   *** MESSAGE [timeset] ***               = 1800. [sec]
#   *** MESSAGE [timeset] ***    PredictInt = 6. [hrs]
#   *** MESSAGE [timeset] ***    CpuTimeMoniter = T
#   *** MESSAGE [timeset] ***  -- version = ....
#                         : 
#
#A NAMELIST group name "&xxxxxx_nml" is managed by "xxxxxx" module.
#List of NAMELIST group names managed in DCPAM5 is 
#((<DCPAM5 NAMELIST|URL:../../code_reference/htm/classes/NAMELIST.html>)). 
#See this manual for details.
#
#
#See ((<Configure output settings>)) about 
#((*&gtool_historyauto_nml*))
#
#
#=end EN
#
#=begin JA
#== 出力設定の変更
#
#=== gtool_historyauto_nml の各項目
#
#解析用のヒストリデータの出力に関する設定は以下の
#((*&gtool_historyauto_nml*)) を編集することで行います.
#
#  ! ヒストリデータ出力の全体設定
#  ! Global settings about history data output
#  !
#  &gtool_historyauto_nml
#    IntValue = 1.0,
#                                ! ヒストリデータの出力間隔の数値. 
#                                ! 負の値を与えると, 出力を抑止します. 
#                                !
#                                ! Numerical value for interval of history data output
#                                ! Negative values suppresses output.
#    IntUnit = 'day',
#                                ! ヒストリデータの出力間隔の単位. 
#                                ! Unit for interval of history data output
#    Precision = 'float',     ! 単精度
#                                ! ヒストリデータの精度. 
#                                ! Precision of history data
#    FilePrefix = '',
#                                ! ヒストリデータのファイル名の接頭詞. 
#                                ! Prefixes of history data filenames
#  /
#  !
#  ! ヒストリデータ出力の個別設定
#  ! Individual settings about history data output
#  !
#  &gtool_historyauto_nml
#    Name = 'U, V, Temp, Ps, QVap, Vor, Div, SigDot, DPiDt'
#  /
#  &gtool_historyauto_nml
#    Name = 'Mass, KinEngy, IntEngy, PotEngy, LatEngy, TotEngy, Enstro', 
#    SpaceAverage = .true., .true., .true., .true., .true.
#  /
#
#それぞれの設定項目について以下に記します.
#より詳しい説明については,
#((<gtool5 チュートリアル: 多数のファイル出力を行うモデルでのデータ出力 -- 設定可能な項目|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/tutorial/gtauto_first.htm#label-7>))
#を参照ください. 
#
#: IntValue
#  (実数型) 出力間隔の数値
#
#: IntUnit
#  (文字型) 出力間隔の単位. "sec", "min", "hour", "day", "month", "year" などが
#  使用可能です.
#  使用可能な単位の詳細については, 
#  ((<gtool5 ライブラリ: dc_date_types モジュール|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/code_reference/classes/dc_date_types.html>)) の
#  "Characters list for unit" を参照ください. 
#  
#: Precision
#  (文字型) データの精度. "float" (単精度実数型), "double" (倍精度実数型), "int" (整数型) を指定可能
#  
#: SpaceAverage
#  (論理型配列) 空間平均のフラグ. 
#  配列の 1 番目, 2 番目, 3 番目が, 経度, 緯度, 高度(σ) に対応します.
#  
#((*Name*)) を指定しない, もしくは空文字を与えた場合,
#それは全ての変数に対するデフォルト設定となります.
#その場合にのみ有効な項目として以下のものがあります. 
#
#: FilePrefix
#  (文字型) データのファイル名の接頭詞.
#  例えば "exp1-" と指定すれば, 変数 "U" の出力ファイル名は "exp1-U.nc" となります.
#  また, "data01/" のようにスラッシュを含む文字列を指定することで,
#  カレントディレクトリ以外の場所に出力するよう設定することも可能です. 
#
#
#=== 設定の変更
#
#以下では, 出力する変数を U (東西風速), V (南北風速), Temp (温度), Ps (地表面気圧), 
#SigDot (鉛直風) のみとし, 出力の間隔を 3 時間にしてみましょう.
#また, ファイルを "data01" というディレクトリ以下に作成してみましょう.
#
#再びエディタを用いて, dcpam_hs94_T21L20.nml の ((*&gtool_historyauto_nml*)) 
#を以下のように変更してください.
#
#  ! ヒストリデータ出力の全体設定
#  ! Global settings about history data output
#  !
#  &gtool_historyauto_nml
#    IntValue = 3.0,
#    IntUnit = 'hrs',
#    Precision = 'float', 
#    FilePrefix = 'data01/',
#  /
#  !
#  ! ヒストリデータ出力の個別設定
#  ! Individual settings about history data output
#  !
#  &gtool_historyauto_nml
#    Name = 'U, V, Temp, Ps, SigDot'
#  /
#
#=== 出力設定を変更しての再実行
#
#実行の前に, データの出力先であるディレクトリを作成します.
#
#  $ mkdir data01
#
#プログラムを実行してください.
#
#  $ ./dcpam_main -N=dcpam_hs94_T21L20.nml | tee hs94-T21L20.log
#
#以下のようなメッセージが表示されるとともに, "data01" ディレクトリ以下に
#5 つのデータが出力されます.
#
#  |*** MESSAGE [HistAuto] ***  ----- "gtool_historyauto_nml" is loaded from "dcpam_hs94_T21L20.nml" -----
#  |*** MESSAGE [HistAuto] ***  Global Settings:
#  |*** MESSAGE [HistAuto] ***    AllOutput       = F
#  |*** MESSAGE [HistAuto] ***    FilePrefix      = data01/
#  |*** MESSAGE [HistAuto] ***    Interval        = 3. [hrs]
#  |*** MESSAGE [HistAuto] ***    Precision       = float
#  |*** MESSAGE [HistAuto] ***    TimeAverage     = F
#  |*** MESSAGE [HistAuto] ***        :
#  |*** MESSAGE [HistAuto] ***  Individual Settings:
#  |*** MESSAGE [HistAuto] ***    Name            = U, V, Temp, Ps, SigDot
#  |*** MESSAGE [HistAuto] ***    File            = data03/<Name>.nc
#  |*** MESSAGE [HistAuto] ***    Interval        = 3. [hrs]
#  |*** MESSAGE [HistAuto] ***    Precision       = float
#
#"data01" ディレクトリ以下の出力ファイルを眺めてみましょう.
#次元変数 "time" に関する情報を参照すると,
#((<設定の変更>)) に合わせて出力間隔が変更されたことがわかります. 
#
#  $ ncdump data01/U.nc |more
#
#    netcdf U {
#    dimensions:
#            lon = 64 ;
#            lat = 32 ;
#            sig = 20 ;
#            sigm = 21 ;
#            time = UNLIMITED ; // (161 currently)
#               :
#
#            float time(time) ;
#                    time:long_name = "time" ;
#                    time:units = "hrs" ;
#                                  ^^^ ← 単位が hrs に
#
#    // global attributes:
#               :
#    data:
#               :
#
#     time = 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 
#        54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96, 99, 102, 105, 
#        108, 111, 114, 117, 120, ...;
#
#この他にも, 変数ごとに個別に出力設定を変更するといったことも可能です.
#詳しくは 
#((<gtool5 チュートリアル: 多数のファイル出力を行うモデルでのデータ出力|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/tutorial/gtauto_first.htm>))
#を参照ください. 
#
#
#=end JA
#=begin EN
#== Configure output settings
#
#!!! Under construction !!!
#
#=end EN
#
#

##################################################################
#
#=begin JA
#== 初期値データファイルの作成
#
#上記の実験では, 初期値データは実行プログラムによって内部で作成されていました. 
#以下では, 初期値データをファイルに出力する方法を記します.
#
#初期値データファイル生成プログラムのサンプルとして
#((<init_data.F90|URL:../../code_reference/htm/files/main/init_data_F90.html>))
#が用意されており, これは
#((<DCPAM5 のビルド>)) にてコンパイルされ実行ファイル "init_data" として
#作業ディレクトリに用意されているはずです. 
#
#また, NAMELIST ファイルのサンプルとして,
#((<init_data_T21L20.nml|URL:../../../src/main/init_data_T21L20.nml>))
#などを用意しています.
#この NAMELIST ファイルを編集したした後, 
#以下のように実行してください. 
##コマンドラインオプションとして "-h" や "--help" を指定することで, 
##解像度や出力されるファイル名の一覧が表示されます. 
#
#  $ ./init_data -N=init_data_T21L20.nml
#
#この例の場合には, "init_T21L20.nc" という名前のファイルが出力されます. 
#このファイルを初期値データとして入力する方法に関しては,
#((<初期値データ・リスタートデータファイルの入力>)) を参照してください. 
#
#=end JA
#
#=begin EN
#== Generate initial data file
#
#In the case of above experiment, initial data is generated internally by
#execution program. A way to output initial data to a file is described
#below.
#
#First, as above, move "practice" directory, and create a directory
#for a experiment by "make" command. Then move the directory.
#
#Executive file "init_data" and NAMELIST file
#((<init_data_T21L20.nml|URL:../../../src/main/init_data_T21L20.nml>))
#are prepared for generation of initial data file. 
#At first, edit "init_data_T21L20.nml", and 
#execute as follows.
##If "-h" or "--help" are specified as command line options, 
##the resolution or output files are displayed. 
#
#  $ ./init_data -N=init_data_T21L20.nml
#
#By default, a file named "init_T21L20.nc" is output. 
#In order to use this file as initial data or restart data, 
#See ((<Input initial data or restart data file>)).
#
#=end EN
#
##################################################################


#=begin JA
#== 初期値データ・リスタートデータファイルの入力
#
#ファイルから初期値データ, もしくはリスタートデータを読み込む際には,
#実行時に読み込まれる NAMELIST ファイルの以下の項目を変更してください. 
#
#  &restart_file_io_nml
#    InputFile = 'init_T21L20.nc',    ! 入力する初期値/リスタートデータのファイル名
#                                    ! filename of input initial/restart data
#              :
#  /
#
#"InputFile" の部分に初期値データもしくはリスタートデータのファイル名を
#指定します.
#
#NAMELIST ファイルを変更後, 以下のようにその NAMELIST ファイルを -N
#もしくは --namelist オプションに指定して実験を始めてください.
#
#  $ ./dcpam_main -N=dcpam_hs94_T21L20.nml | tee hs94.log
#
#実験が開始されると, 以下のようなデータ入力のメッセージが表示されます. 
#
#  |*** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
#  |*** MESSAGE [restart_file_io] ***  Input::
#  |*** MESSAGE [restart_file_io] ***    InputFile  = init_T21L20.nc
#  |*** MESSAGE [restart_file_io] ***  Output::
#  |*** MESSAGE [restart_file_io] ***    OutputFile = restart.nc
#  |*** MESSAGE [restart_file_io] ***    IntTime    = 100. [day]
#  |*** MESSAGE [restart_file_io] ***  -- version = ... r |ikawa Exp $
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@U,time=0.
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@V,time=0.
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@Temp,time=0.
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@QVap,time=0.
#  |*** MESSAGE [HistoryGetDouble2] ***  Input init_T21L20.nc@Ps,time=0.
#  |*** MESSAGE [restart_file_io] ***  Initial data (not restart data) is input from a data file "init_T21L20.nc". *B | (t-dt) and *N (t) are same.
#
#
#=end JA
#
#=begin EN
#== Input initial data or restart data file
#
#In order to input initial data or restart data from a file, 
#edit NAMELIST file as follows. 
#
#  &restart_file_io_nml
#    InputFile = 'init_T21L20.nc',    ! filename of input initial/restart data
#              :
#  /
#
#Specify a filename of initial data or restart data to "InputFile". 
#
#After change of NAMELIST file, start an experiment with -N 
#or --namelist option and the NAMELIST file as follows. 
#
#  $ ./dcpam_main -N=dcpam_hs94_T21L20.nml | tee hs94.log
#
#Starting an experiments, following data input messages may be 
#displayed. Confirm them.
#
#  |*** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
#  |*** MESSAGE [restart_file_io] ***  Input::
#  |*** MESSAGE [restart_file_io] ***    InputFile  = init_T21L20.nc
#  |*** MESSAGE [restart_file_io] ***  Output::
#  |*** MESSAGE [restart_file_io] ***    OutputFile = restart.nc
#  |*** MESSAGE [restart_file_io] ***    IntTime    = 100. [day]
#  |*** MESSAGE [restart_file_io] ***  -- version = ... r |ikawa Exp $
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@U,time=0.
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@V,time=0.
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@Temp,time=0.
#  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@QVap,time=0.
#  |*** MESSAGE [HistoryGetDouble2] ***  Input init_T21L20.nc@Ps,time=0.
#  |*** MESSAGE [restart_file_io] ***  Initial data (not restart data) is input from a data file "init_T21L20.nc". *B | (t-dt) and *N (t) are same.
#
#=end EN
#


#=begin JA
#== 飽和水蒸気圧計算スキームの変更
#
#※ 作成中 ※
#=end JA
#=begin EN
#== Change scheme of saturation water vapor
#
#!!! Under construction !!!
#=end EN
#
#
#=begin JA
#== モジュール間の依存関係ファイルの自動生成
#
#※ 作成中 ※
#=end JA
#=begin EN
#== Auto generation of dependency files between modules
#
#!!! Under construction !!!
#=end EN


# =begin JA
# == 実行プログラムの更新
#
# src ディレクトリ以下の編集を行った場合, 以下のようにすることで
# practice 以下の実験用ディレクトリの内容を簡単に更新することが
# 可能です. 
# #なお, src 以下の Fortran 90/95 プログラムの変更を
# #行う際には ((<らくらく DCPAM5 (製作中)|URL:../rakuraku>))
# #を参照してください. 
#
# まず, practice 以下の実験用ディレクトリへ移動します.
#
#   $ cd practice/testXX
#
# 以下のコマンドを入力します. 更新するか問われるので, "Y" を
# 入力します. 
#
#   $ make update
#
#    Update directory "testXX" ? [y/N]: Y
#
# src ディレクトリ内で更新されたファイルが practice/testXX に
# コピーされます. 古いファイルは ".bak.XX" というサフィックスが付加
# されたファイル名に変更されます. 
#
# =end JA
#
# =begin EN
# == Update execution programs
#
# After editing files under "src" directory, update of contents in 
# a directory for a experiment under "practice" is performed easily
# as follows. 
# #If you edit Fortran 90/95 programs under "src", see
# #((<RAKURAKU (easier) DCPAM5 (under construction)|URL:../rakuraku/index.htm.en>))
# #for detail. 
#
# Forst, move a directory for a experiment under "practice".
#
#   $ cd practice/testXX
#
# Input a following command. A question whether update them may be
# displayed, then input "Y". 
#
#   $ make update
#
#    Update directory "testXX" ? [y/N]: Y
#
# Updated files under "src" directory are copied into "practice/testXX".
# Old files are renamed to filenames with suffixes ".bak.XX".

# =end EN




=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin
* Held, I. M., and M. J. Suarez, 1994: 
  A proposal for the intercomparison of the dynamical cores of
  atmospheric general circuation models,
  ((|Bull. Am. Meteor. Soc.|)), ((*75*)), 1825--1830.
* Neale, R. B., and B. J. Hoskins, 2000:
  A standard test for AGCMs including their physical parameterizations:
  I: The proposal, 
  ((|Atmos. Sci. Lett.|)), doi:10.1006/asle.2000.0019.
* Polvani, L. M., R. K. Scott, S. J. Thomas, 2004:
  Numerically converged solutions of the global primitive equations for testing 
  the dynamical core of atmospheric GCMs, 
  ((|J. Atmos. Sci.|)), ((*132*)), 2539--2552.
* Yamamoto, M., and M. Takahashi, 2003:
  The fully developed superrotation simulated by a general circulation model 
  of a Venus-like atmosphere,
  ((|J. Atmos. Sci.|)), ((*60*)), 561--574.
=end

=begin HTML
<hr />
<small>
  $Id: index.rd,v 1.11 2015/02/12 16:50:31 yot Exp $
</small>
=end HTML

