# coding: utf-8
require "numru/ggraph"
require "./gphys_methods_v1.93"
include NumRu
include NMath

ncfn  = "../mknc_zm-2012-10-13/out/zm.nc"
ncfn  = "../mknc_zm-2016-11-30/out/zm.nc"
vname = 'ua'
vname = 'ta2'

ncfn  = ARGV[0]
vname = ARGV[1]

if vname == 'msf' then
  gphysArr3d0 = GPhys::IO.open( ncfn, 'va' )
else
  gphysArr3d0 = GPhys::IO.open( ncfn, vname )
end

gphysArr3d = gphysArr3d0.mean('lon')

if vname == 'msf' then
  gphysArr3d = gphysArr3d.mean('time')
  gphysArr3d = calc_msf( gphysArr3d, 'lat', 'sig' )
end

#gphysArr3d.name      = 'variance of Temperature'
#gphysArr3d.long_name = 'variance of Temperature'
#gphysArr3d.units     = gphysArr3d.units.to_s + ' 2'


#DCL.gropn(1)
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2に画面分割, 'y'=yoko: 左上→右上→左下...
DCL.sgpset('lcntl', false)   # 制御文字を解釈しない
DCL.sgpset('lfull',true)     # 全画面表示
DCL.uzfact(0.7)             # 座標軸の文字列サイズを 0.75 倍
DCL.sgpset('lfprop',true)    # プロポーショナルフォントを使う

#DCL.glpset('lmiss',true)
#DCL.glpset('rmiss',rmiss)

#< GGraph による 描画 >
GGraph.set_fig 'itr'=>1, 'viewport'=>[0.15,0.85,0.15,0.6], 'window'=>[-90,90,1,0]
#GGraph.set_fig 'itr'=>1, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa'
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa'
GGraph.set_axes('xlabelint'=>30)

if vname == 'ua' then
  gphysArr3d.name = 'zonal wind'
  levels   = [-36,-32,-28,-24,-20,-16,-12,-8,-4,0,4,8,12,16,20,24,28,32,36]
#  levels   = [-64,-56,-48,-40,-32,-24,-16,-8,0,8,16,24,32,40,48,56,64]
  patterns = [10999,12999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,92999,95999]
elsif vname == 'va' then
  gphysArr3d.name = 'meridional wind'
  levels   = [-4.5,-4,-3.5,-3,-2.5,-2,-1.5,-1,-0.5,0,0.5,1,1.5,2,2.5,3,3.5,4,4.5]
  patterns = [10999,12999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,92999,95999]
elsif vname == 'ta' then
  gphysArr3d.name = 'temperature'
  levels   = [170,180,190,200,210,220,230,240,250,260,270,280,290,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999]
elsif vname == 'ta2' then
  gphysArr3d.name = 'temperature variance'
  levels   = [5,10,15,20,25,30,35,40,45]
  patterns = [10999,15999,20999,30999,40999,50999,60999,70999,80999,90999]
elsif vname == 'vt' then
  gphysArr3d.name = 'northward wind - temperature covariance'
  levels   = [-24,-21,-18,-15,-12,-9,-6,-3,0,3,6,9,12,15,18,21,24]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'uv' then
  gphysArr3d.name = 'eastward wind - northward wind covariance'
  levels   = [-80,-70,-60,-50,-40,-30,-20,-10,0,10,20,30,40,50,60,70,80]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'uomg' then
  gphysArr3d.name = 'eastward wind - vertical wind covariance'
  levels   = [-80e-2,-70e-2,-60e-2,-50e-2,-40e-2,-30e-2,-20e-2,-10e-2,0,10e-2,20e-2,30e-2,40e-2,50e-2,60e-2,70e-2,80e-2]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'qa' then
  gphysArr3d.name = 'specific humidity'
  levels   = [1e-3,2e-3,3e-3,4e-3,5e-3,6e-3,7e-3,8e-3,9e-3,10e-3,11e-3,12e-3,13e-3,14e-3,15e-3,16e-3,17e-3]
  patterns = [1,10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,90999,95999]
elsif vname == 'msf' then
  gphysArr3d.name = 'normalized mass stream function'
#  levels   = [-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9]
  levels   = [-13.5,-12,-10.5,-9,-7.5,-6,-4.5,-3,-1.5,0,1.5,3,4.5,6,7.5,9,10.5,12,13.5]
  patterns = [10999,12999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,92999,95999]
else
  p "Unexpected vname"
end

if vname == 'ua' || vname == 'va' || vname == 'msf' then
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'vt' || vname == 'uv' || vname == 'uomg' then
  DCL.sgscmn(14) # blue-white-red
end


#GGraph.tone( gphysArr3d, true )
GGraph.tone( gphysArr3d, true,
             'lev'=>levels,  # レベル＆パターンを陽に指定
             'pat'=>patterns # パタンの方が1つ多→±∞まで
           )
GGraph.contour( gphysArr3d, false, 'lev'=>levels, 'index'=>3 )
GGraph.color_bar

DCL::uxmttl('T', gphysArr3d.units.to_s, 1.0)


## first panel
##GGraph.tone( gphyszm1, true )
#GGraph.tone( gphyszm1, true,
##             'lev'=>[200,210,220,230,240,250,260,270,280,290,300],
##             # レベル＆パターンを陽に指定
##             'pat'=>[10999,20999,30999,40999,50999,60999,65999,70999,75999,80999,90999,95999] )
##             # パタンの方が1つ多→±∞まで
#             'lev'=>[170,180,190,200,210,220,230,240,250,260,270,280,290,300],
#             # レベル＆パターンを陽に指定
#             'pat'=>[10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999] )
#             # パタンの方が1つ多→±∞まで
#GGraph.color_bar
#
#
#DCL::uxmttl('T', ' ', 1.0)
#DCL::uxmttl('T', ' ', 1.0)
#DCL::uxmttl('T', title, -1.0)
#
#
## second panel
##GGraph.tone( gphyszm2, true )
#GGraph.tone( gphyszm2, true,
##             'lev'=>[-20,-10,0,10,20,30,40,50,60],
##             # レベル＆パターンを陽に指定
##             'pat'=>[10999,20999,30999,40999,50999,60999,65999,70999,80999,90999] )
##             # パタンの方が1つ多→±∞まで
#             'lev'=>[-20,-15,-10,-5,0,5,10,15,20,25,30,35,40,45,50],
#             # レベル＆パターンを陽に指定
#             'pat'=>[10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,90999] )
#             # パタンの方が1つ多→±∞まで
#GGraph.color_bar
#
## third panel
##GGraph.tone( gphyszm3, true )
#GGraph.tone( gphyszm3, true,
##             'lev'=>[-12e0,-10e0,-8e0,-6e0,-4e0,-2e0,0,2e0,4e0,6e0,8e0,10e0,12e0],
##             # レベル＆パターンを陽に指定
##             'pat'=>[10999,15999,20999,25999,30999,40999,50999,60999,70999,75999,80999,85999,90999,95999] )
##             # パタンの方が1つ多→±∞まで
#             'lev'=>[-14e0,-12e0,-10e0,-8e0,-6e0,-4e0,-2e0,0,2e0,4e0,6e0,8e0,10e0,12e0,14e0],
#             # レベル＆パターンを陽に指定
#             'pat'=>[10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999,90999,95999] )
#             # パタンの方が1つ多→±∞まで
#GGraph.color_bar
#
## forth panel
##GGraph.tone( gphyszm4, true )
#GGraph.tone( gphyszm4, true,
#             'lev'=>[1e-4,2e-3,4e-3,6e-3,8e-3,10e-3,12e-3,14e-3,16e-3,18e-3,20e-3],
#             # レベル＆パターンを陽に指定
#             'pat'=>[1,10999,20999,30999,40999,50999,60999,65999,70999,80999,90999,95999] )
#GGraph.color_bar

DCL.grcls

