# -*- coding: euc-jp -*-
require "numru/ggraph"
include NumRu

t = ARGV[0].to_i
tmeanperiod = ARGV[1].to_i


dir    = '..'
vname1 = 'PRCP'
#vname2 = 'EvapB'
vname2 = 'EvapU'
vname3 = 'SensA'
vname4 = 'SLRA'
vname5 = 'SSRA'
vname6 = 'OLRA'
vname7 = 'OSRA'
vname11 = 'PRCP'
#vname12 = 'SurfH2OVapFluxB'
vname12 = 'SurfH2OVapFluxU'

ts =  10
te = 100

ts = 10 * 365 * 4 + 1
te = 20 * 365 * 4
ts =  2 * 365 * 4 + 1
te =  3 * 365 * 4

gphysw = GPhys::NetCDF_IO.open(dir+'/'+vname1+".nc", 'lat_weight')
weight = gphysw.val
weight = weight / weight.sum(0)

#p weight
#p weight.reshape!(1,gphysw.shape[0])

gphys1 = GPhys::NetCDF_IO.open(dir+'/'+vname1+".nc", vname1)
gphys2 = GPhys::NetCDF_IO.open(dir+'/'+vname2+".nc", vname2)
gphys3 = GPhys::NetCDF_IO.open(dir+'/'+vname3+".nc", vname3)
gphys4 = GPhys::NetCDF_IO.open(dir+'/'+vname4+".nc", vname4)
gphys5 = GPhys::NetCDF_IO.open(dir+'/'+vname5+".nc", vname5)
gphys6 = GPhys::NetCDF_IO.open(dir+'/'+vname6+".nc", vname6)
gphys7 = GPhys::NetCDF_IO.open(dir+'/'+vname7+".nc", vname7)
gphys11 = GPhys::NetCDF_IO.open(dir+'/'+vname11+".nc", vname11)
gphys12 = GPhys::NetCDF_IO.open(dir+'/'+vname12+".nc", vname12)

gphys1 = gphys1.cut('lon'=>0..180)
gphys2 = gphys2.cut('lon'=>0..180)
gphys3 = gphys3.cut('lon'=>0..180)
gphys4 = gphys4.cut('lon'=>0..180)
gphys5 = gphys5.cut('lon'=>0..180)
gphys6 = gphys6.cut('lon'=>0..180)
gphys7 = gphys7.cut('lon'=>0..180)
gphys11 = gphys11.cut('lon'=>0..180)
gphys12 = gphys12.cut('lon'=>0..180)

gphys1 = gphys1 * 2.5e6
gphys1.units = 'W m-2'

tm = gphys1.shape[2] # number of elements for time      dimension
time = gphys1.coord('time').val

gphys8 = gphys2 + gphys3 + gphys4 + gphys5 - ( gphys6 + gphys7 )
gphys8.name      = 'net_atm_heating'
gphys8.long_name = 'net_atmospheric_heating'

gphys9 = gphys12 - gphys11
gphys9.name      = 'net_atm_water_loading'
gphys9.long_name = 'net_atmospheric_water_loading'



#< DCLΥץ >
DCL.gropn(1)
DCL.sldiv('y',3,3)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
#DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

GGraph.set_fig('viewport'=>[0.15,0.7,0.2,0.6])

#GGraph.line( gphys1.average(1).average(0),true )
#GGraph.line( gphys2.average(1).average(0),true )
#GGraph.line( gphys3.average(1).average(0),true )
#GGraph.line( gphys4.average(1).average(0),true )
#GGraph.line( gphys5.average(1).average(0),true )
#GGraph.line( gphys6.average(1).average(0),true )
#GGraph.line( gphys7.average(1).average(0),true )
#GGraph.line( gphys8.average(1).average(0),true )
#GGraph.line( gphys9.average(1).average(0),true )

GGraph.line( ( gphys1 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys2 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys3 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys4 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys5 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys6 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys7 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys8 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys9 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys11 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )
GGraph.line( ( gphys12 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0),true )


DCL.grcls

gphys1 = ( gphys1 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys2 = ( gphys2 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys3 = ( gphys3 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys4 = ( gphys4 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys5 = ( gphys5 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys6 = ( gphys6 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys7 = ( gphys7 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys8 = ( gphys8 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys9 = ( gphys9 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys11 = ( gphys11 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')
gphys12 = ( gphys12 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time')

p vname1 + ': ' + gphys1.to_s
p vname2 + ': ' + gphys2.to_s
p vname3 + ': ' + gphys3.to_s
p vname4 + ': ' + gphys4.to_s
p vname5 + ': ' + gphys5.to_s
p vname6 + ': ' + gphys6.to_s
p vname7 + ': ' + gphys7.to_s
p 'Heating' + ': ' + gphys8.to_s
p 'Water  ' + ': ' + gphys9.to_s
p vname11 + ': ' + gphys11.to_s
p vname12 + ': ' + gphys12.to_s

fileunit = File.open("heatbudget.txt", 'w')
fileunit.puts vname1 + '   :   ' + gphys1.to_s + ',    80'
fileunit.puts vname2 + '  :   ' + gphys2.to_s + ',    80'
fileunit.puts vname3 + '  :   ' + gphys3.to_s + ',    17'
fileunit.puts vname4 + '   :   ' + gphys4.to_s + ',    63'
fileunit.puts vname5 + '   : ' + gphys5.to_s + ',    -161'
fileunit.puts vname6 + '   :  ' + gphys6.to_s + ',    239'
fileunit.puts vname7 + '   : ' + gphys7.to_s + ',   -239'
fileunit.puts 'Heating' + ': ' + gphys8.to_s
fileunit.puts 'Water  ' + ': ' + gphys9.to_s
fileunit.close



#p vname1 + ':' + ( gphys1 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p vname2 + ':' + ( gphys2 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p vname3 + ':' + ( gphys3 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p vname4 + ':' + ( gphys4 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p vname5 + ':' + ( gphys5 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p vname6 + ':' + ( gphys6 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p vname7 + ':' + ( gphys7 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p 'Heating' + ':' + ( gphys8 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
#p 'Water  ' + ':' + ( gphys9 * weight.reshape!(1,gphysw.shape[0]) ).sum(1).mean(0).cut('time'=>time[ts]..time[te]).mean('time').to_s
