#!/usr/bin/env perl
#
#= Fortran 90/95 dependency lister
#
$AUTHORS="Yasuhiro MORIKAWA";
$VERSION='$Id: f90depend.pl,v 1.2 2009/07/12 01:16:12 morikawa Exp $';
$COPYRIGHT='Copyright (C) GFD Dennou Club, 2008. All rights reserved.';
#
# ȤƼ Fortran 90/95 ե use ʸ
# module ʸϤ, ¸ط򵭤ե Makefile 
# ɸϤ˽񤭽Ф.
#
# Ruby 󥹥ȡ뤵ƤʤĶǤ
# f90depend.rb إġ
# (θ Ruby ٤ƴŤ)
#

######################################################################
# Settings

# End Settings
######################################################################

sub f90dependhelp() {
    print STDOUT <<EOF;

  Usage: 
    f90depend.pl [OPTIONS] f90_file [f90_file [f90_file] .. ]

  Options
       -v:       verbose mode
       -q:       quiet mode
       -h:       show help messages

EOF

  &f90dependprintversion;
}

sub f90dependprintversion() {
    print STDOUT <<EOF;
  f90depend.pl Version ${VERSION}

  ${AUTHORS}
    ${COPYRIGHT}

EOF
}

#
# ʣܤ
#
sub uniqArray{
    my $array = shift;
    my $num = 0;
    my @uniqary = ();
    
    foreach my $af ( @$array ) {
        $new = 1;
        foreach (@uniqary) {
	    if ( $af eq $_ ) {
		$new = 0;
	    }
        }
        if ( $new ) {
	    $uniqary[$num] = $af;
	    $num = $num + 1;
        }
    }

    return @uniqary;
}

#
# 
#
$verbose = 0;
$num = 0;


while ( $#ARGV > -1 ) {
    $argv0 = shift(@ARGV);
    if ( $argv0 =~ /^\-v/ ){
	$verbose = 1;
    } elsif ( $argv0 =~ /^\-q/ ) {
	$verbose = 0;
    } elsif ( $argv0 =~ /^\-h/ ) {
	&f90dependhelp;
	exit 1
    } elsif ( $argv0 =~ /^\-/ ) {
	print STDERR "Error: \"$argv0\" is invalid option.\n";
	exit 1;
    } else {
	@ArgvFiles[$num] = $argv0;
	$num = $num + 1;
	if ( not -f $argv0 ) {
	    print STDERR "\n  Error: \"$argv0\" is not found or not a regular file.\n\n";
	    exit 1;
	}
    }
}

#
#  2 İʾʤϥإɽ
#
if ( $#ArgvFiles < 1 ) {
    f90dependhelp;
    exit 1;
}

#
# ʣե
#
@Files = uniqArray(\@ArgvFiles);

if ( $verbose ) {
    print "#--- File list --- \n";
    foreach (@Files) {
	print "#  $_\n";
    }
}

##
##  2 İʾʤϥإɽ ()
##
if ( $#Files < 1 ) {
    f90dependhelp;
    exit 1;
}

#
#  f90 եɤ߹ USE ʸ
#
$num=0;
foreach $file (@Files) {
    open( F90FILE, $file ) || die "\"$file\" can not read.";
    @textary = <F90FILE>;
    close(F90FILE);
    @FileContent[$num] = join('', @textary);
    $num = $num + 1;
}

$num = 0;
if ( $verbose ) {
    print "#--- Cont list --- \n";
    foreach $cont (@FileContent) {
	@lines = split( /\n/, $cont );
	print "#  $Files[$num]: $#lines lines \n";
#	print $cont;
#	print "\n";
	$num = $num + 1;
    }
}

#
#  f90 ե뤫 USE ʸ
#
$num = 0;
foreach $cont (@FileContent) {
    @lines = split( /\n/, $cont );
    @uses = ();
    foreach $line (@lines) {
	if ( $line =~ /^\s*USE\s+/i ) {
	    $line =~ s/^.*USE\s+//i;
	    $line =~ s/\,.*$//i;
	    $line =~ s/\!.*$//i;
	    $line =~ s/\s*$//i;

	    $new = 1;
	    foreach $alr (@uses) {
		if ( $alr eq $line ) {
		    $new = 0;
		}
	    }
	    if ( $new ) {
		push (@uses, $line);
	    }
	}
    }
    $UseList[$num] = join(" ", @uses);
    $num = $num + 1;
}

$num = 0;
if ( $verbose ) {
    print "#--- Uses list --- \n";
    foreach (@Files) {
	print "#  $_: $UseList[$num] \n";
	$num = $num + 1;
    }
}


#
#  f90 ե뤫 MODULE ʸ
#
$num = 0;
foreach $cont (@FileContent) {
    @lines = split( /\n/, $cont );
    @modules = ();
    foreach $line (@lines) {
	if ( $line =~ /^\s*MODULE\s+/i ) {
	    next if ( $line =~ /^\s*MODULE\s+PROCEDURE\s+/i );
	    $line =~ s/^.*MODULE\s+//i;
	    $line =~ s/\!.*$//i;
	    $line =~ s/\s*$//i;

	    $new = 1;
	    foreach $alr (@modules) {
		if ( $alr eq $line ) {
		    $new = 0;
		}
	    }
	    if ( $new ) {
		push (@modules, $line);
	    }
	}
    }
    $ModuleList[$num] = join(" ", @modules);
    $num = $num + 1;
}

$num = 0;
if ( $verbose ) {
    print "#--- Modules list --- \n";
    foreach (@Files) {
	print "#  $_: $ModuleList[$num] \n";
	$num = $num + 1;
    }
}


#
#  f90 ե뤫ᥤե븡
#
$num = 0;
foreach $cont (@FileContent) {
    @lines = split( /\n/, $cont );
    @mains = ();
    $MainList[$num] = "";
    foreach $line (@lines) {
	if ( $line =~ /^\s*PROGRAM\s+/i ) {
	    $file = $Files[$num];
	    $file =~ s/\.f9[05]$//i;
	    push (@mains, $file);
	}
    }
    $MainList[$num] = join(" ", @mains);
    $num = $num + 1;
}

$num = 0;
if ( $verbose ) {
    print "#--- Mains list --- \n";
    foreach (@Files) {
	print "#  $_: $MainList[$num] \n";
	$num = $num + 1;
    }
}

#
# ֥ȥե̾κ
#
$num = 0;
foreach (@Files) {
    @ObjFiles[$num] = $_;
    @ObjFiles[$num] =~ s/\.f9[05]$/.o/i;
    $num = $num + 1;
}

#
# USE ȥե̾Ѵ (¸ߤʤΤϺ)
#
for ($num = 0; $num <= $#Files; $num++) {
    $DependList[$num] = '';
    @uses = split( / /, $UseList[$num] );
    UL: foreach $ul (@uses) {
	next if ( $ul eq $ModuleList[$num] );
	$fnum = 0;
	foreach $file (@Files) {
	    @modules = split( / /, $ModuleList[$fnum] );
	    foreach $ml (@modules) {
		if ( $ul eq $ml ) {
		    $DependList[$num] = $DependList[$num] . ' ' . $ObjFiles[$fnum];
		    next UL;
		}
	    }
	    $fnum = $fnum + 1;
	}
    }
}

$num = 0;
if ( $verbose ) {
    print "#--- Depend list --- \n";
    foreach (@Files) {
	print "#  $_: \n";
	print "#    $DependList[$num] \n";
	$num = $num + 1;
    }
}



#
# ץ˴ؤ¸ꥹȺ
#

for ($num = 0; $num <= $#Files; $num++) {
    next if ( $MainList[$num] eq '' );
    $MainDepList[$num] = $DependList[$num];
    $PrevMainDepList = $MainDepList[$num];

    while ( 1 ) {
	@depends = split( / /, $MainDepList[$num] );
	foreach $dl (@depends) {
	    $fnum = 0;
	    foreach $ob (@ObjFiles) {
		if ( $dl eq $ob ) {
		    $MainDepList[$num] =
			$MainDepList[$num] . ' ' . $ob . ' ' . $DependList[$fnum]
		    }
		$fnum = $fnum + 1;
	    }
	}
	@mdepl = split( / /, $MainDepList[$num] );
	@mdepl = uniqArray(\@mdepl);
	@mdepl = sort @mdepl;
	$MainDepList[$num] = join( " ", @mdepl );

	if ( $PrevMainDepList eq $MainDepList[$num] ) {
	    last;
	} else {
	    $PrevMainDepList = $MainDepList[$num];
	}
    }

}

$num = 0;
if ( $verbose ) {
    print "#--- MainDep list --- \n";
    foreach (@Files) {
	print "#  $_: \n";
	print "#    $MainDepList[$num] \n";
	$num = $num + 1;
    }
}

#
# 
#
for ($num = 0; $num <= $#Files; $num++) {
    print "$ObjFiles[$num]: $DependList[$num]\n"
}

for ($num = 0; $num <= $#Files; $num++) {
    next if ( $MainList[$num] eq '' );
    print "$MainList[$num]: $MainDepList[$num]\n"
}
