/* Copyright by TOYODA Eizi, 1999.  All rights reserved.
 * g77.c:  Fortran service routine emulation for g77 + UNIX environment.
 */

#include <sys/times.h>
#include <signal.h>
#include <time.h>

double etime_(float *tarray) {
	struct tms etm;

	(void)times(&etm);
	tarray[0] = (double)etm.tms_utime / CLOCKS_PER_SEC;
	tarray[1] = (double)etm.tms_stime / CLOCKS_PER_SEC;
	return tarray[0] + tarray[1];
}

int idate_(int *ans) {
	struct tm	*tmp;
	time_t		now;
	time(&now);
	tmp = localtime(&now);
	ans[0] = tmp->tm_mday;
	ans[1] = tmp->tm_mon;
	ans[2] = tmp->tm_year + 1900;
	return 0;
}

int itime_(int *ans) {
	struct tm	*tmp;
	time_t		now;
	time(&now);
	tmp = localtime(&now);
	ans[0] = tmp->tm_hour;
	ans[1] = tmp->tm_min;
	ans[2] = tmp->tm_sec;
	return 0;
}

int getpid_(void) {
	return getpid();
}

int kill_(int pid, int signal) {
	return kill(pid, signal);
}
