!= phy_verdiff ⥸塼Υƥȥץ
!
!= Test program for "phy_verdiff"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_verdiff_test.f90,v 1.2 2007/09/25 17:43:28 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_verdiff ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_verdiff" module.
! Confirm compilation and execution of this program.
!

program phy_verdiff_test
  use phy_verdiff, only: PHYVDIF, Create, Close, &
    & PutLine, initialized, VerticalDiffusion
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_verdiff_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_verdiff" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12
                              ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air

  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant


  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xyz_U (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ U $ . ®. Zonal wind
  real(DP):: xyz_V (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ V $ . ®. Meridional wind

  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
  real(DP):: xyr_Temp (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
  real(DP):: xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity
  real(DP):: xyz_Press (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP):: xyr_Press (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP):: xyz_GeoPot (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
  real(DP):: xyr_GeoPot (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)
  real(DP):: xyr_UFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ®եå. 
                              ! Zonal wind flux
  real(DP):: xyr_VFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ®եå. 
                              ! Meridional wind flux
  real(DP):: xyr_TempFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
  real(DP):: xyr_QvapFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
  real(DP):: xyza_UVMatrix (0:imax-1, 0:jmax-1, 0:kmax-1, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
  real(DP):: xyza_TempMatrix  (0:imax-1, 0:jmax-1, -1:kmax-1, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
  real(DP):: xyza_QvapMatrix (0:imax-1, 0:jmax-1, 0:kmax-1, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYVDIF):: phy_vdif00, phy_vdif01, phy_vdif02, phy_vdif03
  logical:: err
  character(*), parameter:: subname = 'phy_verdiff_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_verdiff_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  call Get( constant = const_earth, &      ! (inout)
    & RAir = RAir, Cp = Cp, Grav = Grav, & ! (out)
    & EL = EL, FKarm = FKarm )             ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_vdif = phy_vdif00, &        ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    & RAir = RAir, Cp = Cp, Grav = Grav, &     ! (in)
    & EL = EL, FKarm = FKarm )                 ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_vdif00) )
  call PutLine( phy_vdif = phy_vdif00 ) ! (in)

  !---------------------------------------------------------
  !  VerticalDiffusion ƥ
  !  VerticalDiffusion test
  !---------------------------------------------------------
  xyz_U = 0.0_DP
!!$  call HistoryGet( &
!!$    & file = 'phy_verdiff_test00.nc', & ! (in)
!!$    & varname = 'U', &                  ! (in)
!!$    & array = xyz_U )                   ! (out)

  xyz_V = 0.0_DP
!!$  call HistoryGet( &
!!$    & file = 'phy_verdiff_test00.nc', & ! (in)
!!$    & varname = 'V', &                  ! (in)
!!$    & array = xyz_V )                   ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'Temp', &               ! (in)
    & array = xyz_Temp )                ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'TempM', &              ! (in)
    & array = xyr_Temp )                ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'QVap', &               ! (in)
    & array = xyz_QVap )                ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'Press', &              ! (in)
    & array = xyz_Press )               ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'PressM', &             ! (in)
    & array = xyr_Press )               ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'GeoPot', &             ! (in)
    & array = xyz_GeoPot )              ! (out)

  call HistoryGet( &
    & file = 'phy_verdiff_test00.nc', & ! (in)
    & varname = 'GeoPotM', &            ! (in)
    & array = xyr_GeoPot )              ! (out)

  xyr_UFlux       = 0.0_DP
  xyr_VFlux       = 0.0_DP
  xyr_TempFlux    = 0.0_DP
  xyr_QVapFlux    = 0.0_DP
  xyza_UVMatrix   = 0.0_DP
  xyza_TempMatrix = 0.0_DP
  xyza_QVapMatrix = 0.0_DP

  call VerticalDiffusion( phy_vdif = phy_vdif00, &         ! (inout)
    & xyz_U    = xyz_U,    xyz_V    = xyz_V, &             ! (in)
    & xyz_Temp = xyz_Temp, xyr_Temp = xyr_Temp, &          ! (in)
    & xyz_QVap = xyz_QVap, &                               ! (in)
    & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &   ! (in)
    & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot, &  ! (in)
    & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &      ! (inout)
    & xyr_TempFlux = xyr_TempFlux, &                       ! (inout)
    & xyr_QVapFlux = xyr_QVapFlux, &                       ! (inout)
    & xyza_UVMatrix   = xyza_UVMatrix, &                   ! (inout)
    & xyza_TempMatrix = xyza_TempMatrix, &                 ! (inout)
    & xyza_QVapMatrix = xyza_QVapMatrix )                  ! (inout)

  call PutLine( xyr_UFlux, indent = ' xyr_UFlux=' )
  call PutLine( xyr_VFlux, indent = ' xyr_VFlux=' )
  call PutLine( xyr_TempFlux, indent = ' xyr_TempFlux=' )
  call PutLine( xyr_QVapFlux, indent = ' xyr_QVapFlux=' )
  call PutLine( xyza_UVMatrix, indent = ' xyza_UVMatrix=' )
  call PutLine( xyza_TempMatrix, indent = ' xyza_TempMatrix=' )
  call PutLine( xyza_QVapMatrix, indent = ' xyza_QVapMatrix=' )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_vdif = phy_vdif00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_vdif00) )
  call PutLine( phy_vdif = phy_vdif00 ) ! (in)

  call Close( phy_vdif = phy_vdif02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_verdiff_test
