!= phy_surface_flux ⥸塼Υƥȥץ
!
!= Test program for "phy_surface_flux"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_surface_flux_test.f90,v 1.1 2007/09/25 17:44:45 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_surface_flux ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_surface_flux" module.
! Confirm compilation and execution of this program.
!

program phy_surface_flux_test
  use phy_surface_flux, only: PHYSURFFLX, Create, Close, &
    & PutLine, initialized, SurfaceFlux
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_surface_flux_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_surface_flux" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12
                              ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
  real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
  real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
  real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant
  !-----------------------------------------------------------------
  !  ɽ
  !  Ground condition
  !-----------------------------------------------------------------
  real(DP):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP):: xy_SurfHumidCoeff (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface humidity coefficient
  real(DP):: xy_SurfRoughLength (0:imax-1, 0:jmax-1)
                              ! ɽĹ. 
                              ! Surface rough length
  integer:: xy_SurfCondition (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface condition

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xyz_U (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ U $ . ®. Zonal wind
  real(DP):: xyz_V (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ V $ . ®. Meridional wind

  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
  real(DP):: xyr_Temp (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
  real(DP):: xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity
  real(DP):: xyz_Press (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP):: xyr_Press (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP):: xyz_GeoPot (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
  real(DP):: xyr_UFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ®եå. 
                              ! Zonal wind flux
  real(DP):: xyr_VFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ®եå. 
                              ! Meridional wind flux
  real(DP):: xyr_TempFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
  real(DP):: xyr_QvapFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP):: xy_SurfUVMatrix (0:imax-1, 0:jmax-1)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP):: xyaa_SurfTempMatrix (0:imax-1, 0:jmax-1, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP):: xyaa_SurfQvapMatrix (0:imax-1, 0:jmax-1, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYSURFFLX):: phy_surfflx00, phy_surfflx01, phy_surfflx02, phy_surfflx03
  logical:: err
  character(*), parameter:: subname = 'phy_surface_flux_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_surface_flux_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  call Get( constant = const_earth, &               ! (inout)
    & RAir = RAir, Cp = Cp, Grav = Grav, EL = EL, & ! (out)
    & ES0 = ES0, RVap = RVap, EpsV = EpsV, &        ! (out)
    & FKarm = FKarm )                               ! (out)

  !-----------------------------------------------------------------
  !  ɽ
  !  Configure ground condition
  !-----------------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'SurfTemp', &          ! (in)
    & array = xy_SurfTemp )            ! (out)

  xy_SurfHumidCoeff = 1.0_DP
  xy_SurfRoughLength = 1.0e-4_DP
  xy_SurfCondition = 0


  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_surfflx = phy_surfflx00, &         ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &        ! (in)
    & RAir = RAir, Cp = Cp, Grav = Grav, EL = EL, &   ! (in)
    & ES0 = ES0, RVap = RVap, EpsV = EpsV, &          ! (in)
    & FKarm = FKarm, &                                ! (in)
    & xy_SurfTemp = xy_SurfTemp, &                    ! (in)
    & xy_SurfHumidCoeff = xy_SurfHumidCoeff, &        ! (in)
    & xy_SurfRoughLength = xy_SurfRoughLength, &      ! (in)
    & xy_SurfCondition = xy_SurfCondition )           ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_surfflx00) )
  call PutLine( phy_surfflx = phy_surfflx00 ) ! (in)

  !---------------------------------------------------------
  !  SurfaceFlux ƥ
  !  SurfaceFlux test
  !---------------------------------------------------------
  xyz_U = 0.0_DP
!!$  call HistoryGet( &
!!$    & file = 'phy_surface_flux_test00.nc', & ! (in)
!!$    & varname = 'U', &                  ! (in)
!!$    & array = xyz_U )                   ! (out)

  xyz_V = 0.0_DP
!!$  call HistoryGet( &
!!$    & file = 'phy_surface_flux_test00.nc', & ! (in)
!!$    & varname = 'V', &                  ! (in)
!!$    & array = xyz_V )                   ! (out)

  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'Temp', &               ! (in)
    & array = xyz_Temp )                ! (out)

  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'TempM', &              ! (in)
    & array = xyr_Temp )                ! (out)

  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'QVap', &               ! (in)
    & array = xyz_QVap )                ! (out)

  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'Press', &              ! (in)
    & array = xyz_Press )               ! (out)

  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'PressM', &             ! (in)
    & array = xyr_Press )               ! (out)

  call HistoryGet( &
    & file = 'phy_surface_flux_test00.nc', & ! (in)
    & varname = 'GeoPot', &             ! (in)
    & array = xyz_GeoPot )              ! (out)

  xyr_UFlux = 0.0_DP
  xyr_VFlux = 0.0_DP
  xyr_TempFlux = 0.0_DP
  xyr_QVapFlux = 0.0_DP

  call SurfaceFlux( phy_surfflx = phy_surfflx00, &         ! (inout)
    & xyz_U = xyz_U, xyz_V = xyz_V, &                      ! (in)
    & xyz_Temp = xyz_Temp, xyr_Temp = xyr_Temp, &          ! (in)
    & xyz_QVap = xyz_QVap, &                               ! (in)
    & xyz_Press = xyz_Press, xyr_Press = xyr_Press, &      ! (in)
    & xyz_GeoPot = xyz_GeoPot, &                           ! (in)
    & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &      ! (inout)
    & xyr_TempFlux = xyr_TempFlux, &                       ! (inout)
    & xyr_QVapFlux = xyr_QVapFlux, &                       ! (inout)
    & xy_SurfUVMatrix = xy_SurfUVMatrix, &                 ! (out)
    & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &         ! (out)
    & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix )          ! (out)

  call PutLine( xy_SurfUVMatrix, indent = ' xy_SurfUVMatrix=' )
  call PutLine( xyaa_SurfTempMatrix, indent = ' xyaa_SurfTempMatrix=' )
  call PutLine( xyaa_SurfQVapMatrix, indent = ' xyaa_SurfQVapMatrix=' )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_surfflx = phy_surfflx00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_surfflx00) )
  call PutLine( phy_surfflx = phy_surfflx00 ) ! (in)

  call Close( phy_surfflx = phy_surfflx02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_surface_flux_test
