!= ɽ̥եå
!
!= Surface flux
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_surface_flux.f90,v 1.4 2007/10/13 07:08:46 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_surface_flux
  !
  != ɽ̥եå
  !
  != Surface flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̥եå׻ޤ. 
  !
  ! Surface fluxes are calculated.
  !
  !== Procedures List
  !
  ! Create        :: PHYSURFFLX ѿν
  ! Close         :: PHYSURFFLX ѿνλ
  ! PutLine       :: PHYSURFFLX ѿ˳ǼƤΰ
  ! initialized   :: PHYSURFFLX ѿꤵƤ뤫ݤ
  ! SurfaceFlux   :: ɽ̥եåη׻
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYSURFFLX"
  ! Close         :: Deconstructor of "PHYSURFFLX"
  ! PutLine       :: Print information of "PHYSURFFLX"
  ! initialized   :: Check initialization of "PHYSURFFLX"
  ! SurfaceFlux   :: Surface fluxes are calculated
  !
  !== Usage
  !
  ! Ϥ, PHYSURFFLX ѿ, Create ǽԤޤ.
  ! SurfaceFlux Ѥɽ̥եå׻ޤ. 
  ! PHYSURFFLX ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYSURFFLX" by "Create".
  ! Calculate surface flux by "SurfaceFlux".
  ! In order to terminate "PHYSURFFLX", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: PHYSURFFLX, Create, Close, PutLine, initialized, SurfaceFlux

  type PHYSURFFLX
    !
    ! ޤ, Create  "PHYSURFFLX" ѿꤷƲ.
    ! ꤵ줿 "PHYSURFFLX" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYSURFFLX" variable by "Create" before usage.
    ! If you reuse "PHYSURFFLX" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant

    real(DP), pointer:: xy_SurfTemp (:,:) =>null()
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), pointer:: xy_SurfHumidCoeff (:,:) =>null()
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), pointer:: xy_SurfRoughLength (:,:) =>null()
                              ! ɽĹ. 
                              ! Surface rough length
    integer, pointer:: xy_SurfCondition (:,:) =>null()
                              ! ɽ. 
                              ! Surface condition

  end type PHYSURFFLX

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: phy_surface_flux.f90,v 1.4 2007/10/13 07:08:46 morikawa Exp $'

  interface Create
    module procedure PhySurfFluxCreate
  end interface

  interface Close
    module procedure PhySurfFluxClose
  end interface

  interface PutLine
    module procedure PhySurfFluxPutLine
  end interface

  interface initialized
    module procedure PhySurfFluxInitialized
  end interface

  interface NmlRead
    module procedure PhySurfFluxNmlRead
  end interface

  interface SurfaceFlux
    module procedure PhySurfFluxSurfaceFlux
  end interface

  interface BulkCoeff
    module procedure PhySurfFluxBulkCoeff
  end interface

!!$  interface Sample
!!$    module procedure PhySurfFluxSample
!!$  end interface

contains

  subroutine PhySurfFluxCreate( phy_surfflx, &
    & imax, jmax, kmax, &
    & RAir, Cp, Grav, EL, ES0, RVap, EpsV, FKarm, &
    & xy_SurfTemp, &
    & xy_SurfHumidCoeff, &
    & xy_SurfRoughLength, &
    & xy_SurfCondition, &
    & nmlfile, err )
    !
    ! PHYSURFFLX ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYSURFFLX ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_surfflx* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_surface_flux_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYSURFFLX".
    ! Initialize *phy_surfflx* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_surfflx* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_surface_flux_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(PHYSURFFLX), intent(inout):: phy_surfflx
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(in):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(in):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP), intent(in):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP), intent(in):: FKarm     ! $ k $ .                 ޥ.   Karman constant
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfHumidCoeff (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(in):: xy_SurfRoughLength (0:imax-1, 0:jmax-1)
                              ! ɽĹ. 
                              ! Surface rough length
    integer, intent(in):: xy_SurfCondition (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface condition
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_surface_flux_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_surface_flux_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySurfFluxCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_surfflx % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYSURFFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYSURFFLX" 
    !  Configure the settings for "PHYSURFFLX"
    !-----------------------------------------------------------------
    phy_surfflx % imax  = imax 
    phy_surfflx % jmax  = jmax 
    phy_surfflx % kmax  = kmax 
    phy_surfflx % RAir  = RAir 
    phy_surfflx % Cp    = Cp   
    phy_surfflx % Grav  = Grav 
    phy_surfflx % EL    = EL   
    phy_surfflx % ES0   = ES0  
    phy_surfflx % RVap  = RVap 
    phy_surfflx % EpsV  = EpsV 
    phy_surfflx % FKarm = FKarm

    allocate( phy_surfflx % xy_SurfTemp (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1) )
    allocate( phy_surfflx % xy_SurfHumidCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1) )
    allocate( phy_surfflx % xy_SurfRoughLength (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1) )
    allocate( phy_surfflx % xy_SurfCondition (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1) )

    phy_surfflx % xy_SurfTemp        = xy_SurfTemp       
    phy_surfflx % xy_SurfHumidCoeff  = xy_SurfHumidCoeff 
    phy_surfflx % xy_SurfRoughLength = xy_SurfRoughLength
    phy_surfflx % xy_SurfCondition   = xy_SurfCondition  

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_surfflx % param_r = 0.0_DP
!!$    phy_surfflx % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_surfflx % param_i = param_i
!!$    if ( present(param_r) )  phy_surfflx % param_r = param_r
!!$    if ( present(param_c) )  phy_surfflx % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_surfflx % param_i, &   ! (inout)
!!$        & param_r = phy_surfflx % param_r, &   ! (inout)
!!$        & param_c_ = phy_surfflx % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_surfflx % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_surfflx % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySurfFluxCreate

  subroutine PhySurfFluxClose( phy_surfflx, err )
    !
    ! PHYSURFFLX ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_surfflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYSURFFLX".
    ! Note that if *phy_surfflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYSURFFLX), intent(inout):: phy_surfflx
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySurfFluxClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_surfflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSURFFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYSURFFLX" ξõ
    !  Clear the settings for "PHYSURFFLX"
    !-----------------------------------------------------------------
    deallocate( phy_surfflx % xy_SurfTemp )
    deallocate( phy_surfflx % xy_SurfHumidCoeff )
    deallocate( phy_surfflx % xy_SurfRoughLength )
    deallocate( phy_surfflx % xy_SurfCondition )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_surfflx % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySurfFluxClose

  subroutine PhySurfFluxPutLine( phy_surfflx, unit, indent, err )
    !
    !  *phy_surfflx* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_surfflx*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYSURFFLX), intent(in):: phy_surfflx
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhySurfFluxPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYSURFFLX" ΰ
    !  Print the settings for "PHYSURFFLX"
    !-----------------------------------------------------------------
    if ( phy_surfflx % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYSURFFLX:: @initialized=%y', &
        & l = (/phy_surfflx % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_surfflx % imax, phy_surfflx % jmax, phy_surfflx % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f @RAir=%f', &
        & d = (/ phy_surfflx % Grav, phy_surfflx % Cp, phy_surfflx % RAir /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @EL=%f @RVap=%f @EpsV=%f', &
        & d = (/ phy_surfflx % EL, phy_surfflx % RVap, phy_surfflx % EpsV /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ES0=%f @FKarm=%f', &
        & d = (/ phy_surfflx % ES0, phy_surfflx % FKarm /) )

      call PutLine( phy_surfflx % xy_SurfTemp, unit = out_unit, &
        & lbounds = lbound(phy_surfflx % xy_SurfTemp), &
        & ubounds = ubound(phy_surfflx % xy_SurfTemp), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfTemp=' )

      call PutLine( phy_surfflx % xy_SurfHumidCoeff, unit = out_unit, &
        & lbounds = lbound(phy_surfflx % xy_SurfHumidCoeff), &
        & ubounds = ubound(phy_surfflx % xy_SurfHumidCoeff), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfHumidCoeff=' )

      call PutLine( phy_surfflx % xy_SurfRoughLength, unit = out_unit, &
        & lbounds = lbound(phy_surfflx % xy_SurfRoughLength), &
        & ubounds = ubound(phy_surfflx % xy_SurfRoughLength), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfRoughLength=' )

      call PutLine( phy_surfflx % xy_SurfCondition, unit = out_unit, &
        & lbounds = lbound(phy_surfflx % xy_SurfCondition), &
        & ubounds = ubound(phy_surfflx % xy_SurfCondition), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfCondition=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYSURFFLX:: @initialized=%y>', &
        & l = (/phy_surfflx % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySurfFluxPutLine

  logical function PhySurfFluxInitialized( phy_surfflx ) result(result)
    !
    ! *phy_surfflx* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_surfflx* is initialized, .true. is returned.
    ! If *phy_surfflx* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYSURFFLX), intent(in):: phy_surfflx
  continue
    result = phy_surfflx % initialized
  end function PhySurfFluxInitialized

  subroutine PhySurfFluxNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_surface_flux_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_surface_flux ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_surface_flux#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_surface_flux" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_surface_flux#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhySurfFluxNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_surface_flux_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_surface_flux_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_surface_flux_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_surface_flux_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySurfFluxNmlRead

  subroutine PhySurfFluxSurfaceFlux( phy_surfflx, &
    & xyz_U, xyz_V, &
    & xyz_Temp, xyr_Temp, &
    & xyz_QVap, &
    & xyz_Press, xyr_Press, &
    & xyz_GeoPot, &
    & xyr_UFlux, xyr_VFlux, &
    & xyr_TempFlux, &
    & xyr_QVapFlux, &
    & xy_SurfUVMatrix, &
    & xyaa_SurfTempMatrix, &
    & xyaa_SurfQVapMatrix, &
    & err )
    !
    ! ɽ̥եå׻ޤ.
    !
    ! ʤ, Ϳ줿 *phy_surfflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Surface fluxes are calculated.
    !
    ! If *phy_surfflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYSURFFLX), intent(inout):: phy_surfflx
    real(DP), intent(in):: xyz_U (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax-1)
                              ! $ U $ . ®. Zonal wind
    real(DP), intent(in):: xyz_V (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax-1)
                              ! $ V $ . ®. Meridional wind

    real(DP), intent(in):: xyz_Temp (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax-1)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in):: xyr_Temp (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(in):: xyz_QVap (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax-1)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP), intent(in):: xyr_Press (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(in):: xyz_GeoPot (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP), intent(inout):: xyr_UFlux (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax)
                              ! ®եå. 
                              ! Zonal wind flux
    real(DP), intent(inout):: xyr_VFlux (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax)
                              ! ®եå. 
                              ! Meridional wind flux
    real(DP), intent(inout):: xyr_TempFlux (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(inout):: xyr_QvapFlux (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:phy_surfflx%kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(out):: xy_SurfUVMatrix (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP), intent(out):: xyaa_SurfTempMatrix (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP), intent(out):: xyaa_SurfQvapMatrix (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude

    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C

    real(DP):: xy_SurfTemp (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP):: xy_SurfHumidCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP):: xy_SurfRoughLength (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽĹ. 
                              ! Surface rough length
    integer:: xy_SurfCondition (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽ. 
                              ! Surface condition

    real(DP), parameter:: BasePotTemp   = 300.0_DP
                              ! ܲ. 
                              ! Basic potential temperature
    real(DP), parameter:: VelMinForRi   = 0.01_DP
                              ! $ R_i $ Ǿ. 
                              ! Minimum value of velocity for $ R_i $ number
    real(DP), parameter:: VelMinForVel  = 0.01_DP
                              ! ưǾ. 
                              ! Minimum value of velocity for momentum
    real(DP), parameter:: VelMinForTemp = 0.01_DP
                              ! ǮǾ. 
                              ! Minimum value of velocity for thermal
    real(DP), parameter:: VelMinForQvap = 0.01_DP
                              ! Ǿ. 
                              ! Minimum value of velocity for vapor
    real(DP), parameter:: VelMaxForVel  = 1000.0_DP
                              ! ư. 
                              ! Maximum value of velocity for momentum
    real(DP), parameter:: VelMaxForTemp = 1000.0_DP
                              ! Ǯ. 
                              ! Maximum value of velocity for thermal
    real(DP), parameter:: VelMaxForQvap = 1000.0_DP
                              ! . 
                              ! Maximum value of velocity for vapor

    real(DP):: xy_SurfBulkRiNum (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $ number
    real(DP):: xy_SurfTempTransCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP):: xy_SurfQvapTransCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity
    real(DP):: xy_SurfVelTransCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP):: xy_SurfTempBulkCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯. 
                              ! Bulk coefficient: temperature
    real(DP):: xy_SurfQvapBulkCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯漾. 
                              ! Bulk coefficient: specific humidity
    real(DP):: xy_SurfVelBulkCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯ư. 
                              ! Bulk coefficient: temperature
    real(DP):: xy_SurfExner (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Exner ؿ. 
                              ! Exner function
    real(DP):: xy_SurfVelAbs (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ®. 
                              ! Absolute velocity
    real(DP):: xy_SurfSatQvap (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽ˰漾. 
                              ! Saturated specific humidity on surface
    real(DP):: xy_SurfDSatQvapDTemp (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽ˰漾Ѳ. 
                              ! Saturated specific humidity tendency on surface

    integer:: i, j            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySurfFluxSurfaceFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_surfflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSURFFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_surfflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_surfflx*
    !-----------------------------------------------------------------
    imax  = phy_surfflx % imax 
    jmax  = phy_surfflx % jmax 
    RAir  = phy_surfflx % RAir 
    Cp    = phy_surfflx % Cp   
    Grav  = phy_surfflx % Grav 
    EL    = phy_surfflx % EL   
    ES0   = phy_surfflx % ES0  
    RVap  = phy_surfflx % RVap 
    EpsV  = phy_surfflx % EpsV 

    xy_SurfTemp        = phy_surfflx % xy_SurfTemp       
    xy_SurfHumidCoeff  = phy_surfflx % xy_SurfHumidCoeff 
    xy_SurfRoughLength = phy_surfflx % xy_SurfRoughLength
    xy_SurfCondition   = phy_surfflx % xy_SurfCondition  


    !-----------------------------------------------------------------
    !  Exner ؿ
    !  Calculate Exner functions
    !-----------------------------------------------------------------
    xy_SurfExner = ( xyz_Press(:,:,0) / xyr_Press(:,:,0)  )**( RAir / Cp )

    !-----------------------------------------------------------------
    !  Х륯 $ R_i $ 
    !  Calculate bulk $ R_i $
    !-----------------------------------------------------------------
    do i = 0, imax-1
      do j = 0, jmax-1
        xy_SurfVelAbs(i,j) = sqrt ( xyz_U(i,j,0)**2 + xyz_V(i,j,0)**2 )

        xy_SurfBulkRiNum(i,j) = &
          &   Grav / BasePotTemp &
          &   * ( xyz_Temp(i,j,0) / xy_SurfExner(i,j) - xy_SurfTemp(i,j)  ) &
          &   / max( xy_SurfVelAbs(i,j), VelMinForRi )**2 &
          &   * xyz_GeoPot(i,j,0)
      end do
    end do
    
    !-----------------------------------------------------------------
    !  Х륯
    !  Calculate bulk coefficients
    !-----------------------------------------------------------------
    call BulkCoeff( phy_surfflx = phy_surfflx, &         ! (inout)
      & xy_SurfBulkRiNum       = xy_SurfBulkRiNum, &     ! (in)
!!$      & xy_SurfVelAbs          = xy_SurfVelAbs, &        ! (in)
      & xy_SurfVelRoughLength  = xy_SurfRoughLength, &   ! (in)
      & xy_SurfTempRoughLength = xy_SurfRoughLength, &   ! (in)
      & xy_SurfGeoPot          = xyz_GeoPot(:,:,0), &    ! (in)
      & xy_SurfVelBulkCoeff    = xy_SurfVelBulkCoeff, &  ! (out)
      & xy_SurfTempBulkCoeff   = xy_SurfTempBulkCoeff, & ! (out)
      & xy_SurfQvapBulkCoeff   = xy_SurfQvapBulkCoeff )  ! (out)

    !-----------------------------------------------------------------
    !  ͢η׻
    !  Calculate transfer coefficient
    !-----------------------------------------------------------------
    do i = 0, imax-1
      do j = 0, jmax-1
        
        xy_SurfVelTransCoeff(i,j) = &
          &   xy_SurfVelBulkCoeff(i,j) &
          &   * xyr_Press(i,j,0) / ( RAir * xyr_Temp(i,j,0) ) &
          &   * min( max( xy_SurfVelAbs(i,j), VelMinForVel ), VelMaxForVel )
        
        xy_SurfTempTransCoeff(i,j) = &
          &   xy_SurfTempBulkCoeff(i,j) &
          &   * xyr_Press(i,j,0) / ( RAir * xyr_Temp(i,j,0) ) &
          &   * min( max( xy_SurfVelAbs(i,j), VelMinForTemp ), VelMaxForTemp )
        
        xy_SurfQvapTransCoeff(i,j) = &
          &   xy_SurfQvapBulkCoeff(i,j) &
          &   * xyr_Press(i,j,0) / ( RAir * xyr_Temp(i,j,0) ) &
          &   * min( max( xy_SurfVelAbs(i,j), VelMinForQvap ), VelMaxForQvap )
        
      end do
    end do
    
    !-----------------------------------------------------------------
    !  ˰漾η׻
    !  Calculate saturated specific humidity
    !-----------------------------------------------------------------
    xy_SurfSatQvap = &
      &   EpsV * ES0  &
      &   * exp( EL / RVap * ( 1.0_DP / 273.0_DP - 1.0_DP / xy_SurfTemp ) ) &
      &   / xyr_Press(:,:,0)

    xy_SurfDSatQvapDTemp = &
      &   EL * xy_SurfSatQvap &
      &   / ( RVap * xy_SurfTemp * xy_SurfTemp )
    
    !-----------------------------------------------------------------
    !  եåη׻
    !  Calculate fluxes
    !-----------------------------------------------------------------
    xyr_UFlux(:,:,0) =   xyr_UFlux(:,:,0) &
      &                - xy_SurfVelTransCoeff * xyz_U(:,:,0)

    xyr_VFlux(:,:,0) =   xyr_VFlux(:,:,0) &
      &                - xy_SurfVelTransCoeff * xyz_V(:,:,0)

    xyr_TempFlux(:,:,0) =   xyr_TempFlux(:,:,0) &
      &                   + Cp * xy_SurfTempTransCoeff &
      &                     * (   xy_SurfTemp           &
      &                         - xyz_Temp(:,:,0) / xy_SurfExner )

    xyr_QvapFlux(:,:,0) =   xyr_QvapFlux(:,:,0) &
      &                   + EL * xy_SurfQvapTransCoeff * xy_SurfHumidCoeff &
      &                     * ( xy_SurfSatQvap - xyz_Qvap(:,:,0) )
    
    !-----------------------------------------------------------------
    !  η׻
    !  Calculate implicit matrices
    !-----------------------------------------------------------------
    xyaa_SurfTempMatrix = 0.0_DP
    xyaa_SurfQvapMatrix = 0.0_DP
    
    xy_SurfUVMatrix = xy_SurfVelTransCoeff
    
    xyaa_SurfTempMatrix(:,:,1,0) =   Cp * xy_SurfTempTransCoeff / xy_SurfExner
    xyaa_SurfTempMatrix(:,:,0,1) = - Cp * xy_SurfTempTransCoeff / xy_SurfExner
    
    xyaa_SurfQvapMatrix(:,:,1,0) =   Cp * xy_SurfQvapTransCoeff * xy_SurfHumidCoeff
    xyaa_SurfQvapMatrix(:,:,0,1) = - Cp * xy_SurfQvapTransCoeff * xy_SurfHumidCoeff
    
    do i = 0, imax-1
      do j = 0, jmax-1
        if ( xy_SurfCondition(i,j) >= 1 ) then
          
          xyaa_SurfTempMatrix(i,j,1,-1) = - Cp * xy_SurfTempTransCoeff(i,j)
          xyaa_SurfTempMatrix(i,j,0,0)  =   Cp * xy_SurfTempTransCoeff(i,j)
          
          xyaa_SurfQvapMatrix(i,j,1,-1) = &
            & - EL * xy_SurfQvapTransCoeff(i,j) &
            &   * xy_SurfHumidCoeff(i,j) * xy_SurfDSatQvapDTemp(i,j)

          xyaa_SurfQvapMatrix(i,j,0,0)  =   &
            &   EL * xy_SurfQvapTransCoeff(i,j) &
            &   * xy_SurfHumidCoeff(i,j) * xy_SurfDSatQvapDTemp(i,j)
          
        end if
      end do
    end do
    
    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySurfFluxSurfaceFlux

  subroutine PhySurfFluxBulkCoeff( phy_surfflx, &
    & xy_SurfBulkRiNum, &
!!$    & xy_SurfVelAbs, &
    & xy_SurfVelRoughLength, &
    & xy_SurfTempRoughLength, &
    & xy_SurfGeoPot, &
    & xy_SurfVelBulkCoeff, &
    & xy_SurfTempBulkCoeff, &
    & xy_SurfQvapBulkCoeff, &
    & err )
    !
    ! Х륯򻻽Фޤ.
    !
    ! ʤ, Ϳ줿 *phy_surfflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Bulk coefficients are calculated.
    !
    ! If *phy_surfflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYSURFFLX), intent(inout):: phy_surfflx
    real(DP), intent(in):: xy_SurfBulkRiNum (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $ number

!!$    real(DP), intent(in):: xy_SurfVelAbs (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
!!$                              ! ®. 
!!$                              ! Absolute velocity
    real(DP), intent(in):: xy_SurfVelRoughLength (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽĹ (ư). 
                              ! Surface rough length (momentum)
    real(DP), intent(in):: xy_SurfTempRoughLength (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! ɽĹ (Ǯ). 
                              ! Surface rough length (thermal)
    real(DP), intent(in):: xy_SurfGeoPot (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (ɽ). 
                              ! Geo-potential (on surface)
    real(DP), intent(out):: xy_SurfVelBulkCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯ư. 
                              ! Bulk coefficient: temperature
    real(DP), intent(out):: xy_SurfTempBulkCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯. 
                              ! Bulk coefficient: temperature
    real(DP), intent(out):: xy_SurfQvapBulkCoeff (0:phy_surfflx%imax-1, 0:phy_surfflx%jmax-1)
                              ! Х륯漾. 
                              ! Bulk coefficient: specific humidity
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant

    logical:: Neutral = .false.
                              ! ΩǤ뤫ݤ. 
                              ! Whether it was neutral or not?
    real(DP), parameter:: ConstBulkCoeff  = -1.0_DP
                              ! Х륯. 
                              ! Steady value of bulk coefficient
    real(DP), parameter:: VelBulkCoeffMin  = 0.0_DP
                              ! $ u $ Х륯Ǿ. 
                              ! Minimum value of $ u $ bulk coefficient
    real(DP), parameter:: TempBulkCoeffMin = 0.0_DP
                              ! $ T $ Х륯Ǿ. 
                              ! Minimum value of $ T $ bulk coefficient
    real(DP), parameter:: QvapBulkCoeffMin = 0.0_DP
                              ! $ q $ Х륯Ǿ. 
                              ! Minimum value of $ q $ bulk coefficient
    real(DP), parameter:: VelBulkCoeffMax  = 1.0_DP
                              ! $ u $ Х륯. 
                              ! Maximum value of $ u $ bulk coefficient
    real(DP), parameter:: TempBulkCoeffMax = 1.0_DP
                              ! $ T $ Х륯. 
                              ! Maximum value of $ T $ bulk coefficient
    real(DP), parameter:: QvapBulkCoeffMax = 1.0_DP
                              ! $ q $ Х륯. 
                              ! Maximum value of $ q $ bulk coefficient

    integer:: i, j            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySurfFluxBulkCoeff'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_surfflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSURFFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_surfflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_surfflx*
    !-----------------------------------------------------------------
    imax  = phy_surfflx % imax 
    jmax  = phy_surfflx % jmax 

    FKarm  = phy_surfflx % FKarm 

    !-----------------------------------------------------------------
    !  ΩХ륯η׻
    !  Calculate neutral bulk coefficients
    !-----------------------------------------------------------------
    if ( ConstBulkCoeff < 0.0_DP ) then
      
      xy_SurfVelBulkCoeff  = &
        & ( FKarm / log ( xy_SurfGeoPot / xy_SurfVelRoughLength ) )**2

      xy_SurfTempBulkCoeff = &
        & ( FKarm / log ( xy_SurfGeoPot / xy_SurfTempRoughLength ) )**2

      xy_SurfQvapBulkCoeff = xy_SurfTempBulkCoeff
      
    else
      xy_SurfVelBulkCoeff  = ConstBulkCoeff
      xy_SurfTempBulkCoeff = ConstBulkCoeff
      xy_SurfQvapBulkCoeff = ConstBulkCoeff
    end if
    
    !-----------------------------------------------------------------
    !  ΩХ륯η׻
    !  Calculate non-neutral bulk coefficients
    !-----------------------------------------------------------------
    if ( .not. Neutral ) then
      
      do i = 0, imax-1
        do j = 0, jmax-1

          if ( xy_SurfBulkRiNum(i,j) > 0.0_DP ) then 

            xy_SurfVelBulkCoeff(i,j) = &
              &   xy_SurfVelBulkCoeff(i,j) &
              &   / (   1.0_DP &
              &       + 10.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) ) &
              &     )

            xy_SurfTempBulkCoeff(i,j) = &
              &   xy_SurfTempBulkCoeff(i,j) &
              &   / (   1.0_DP &
              &       + 15.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) ) )

            xy_SurfQvapBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j)

          else

            xy_SurfVelBulkCoeff(i,j) = &
              &   xy_SurfVelBulkCoeff(i,j) &
              &   * (   1.0_DP &
              &       - 10.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / (   1.0_DP &
              &             + 75.0_DP * xy_SurfVelBulkCoeff(i,j) &
              &               * sqrt( - xy_SurfGeoPot(i,j) &
              &                         / xy_SurfVelRoughLength(i,j) &
              &                         * xy_SurfBulkRiNum(i,j) &
              &                     ) &
              &           ) &
              &     )
            
            xy_SurfTempBulkCoeff(i,j) = &
              &   xy_SurfTempBulkCoeff(i,j) &
              &   * (   1.0_DP &
              &       - 15.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / (   1.0_DP &
              &             + 75.0_DP * xy_SurfTempBulkCoeff(i,j) &
              &               * sqrt( - xy_SurfGeoPot(i,j) &
              &                         / xy_SurfTempRoughLength(i,j) &
              &                         * xy_SurfBulkRiNum(i,j) &
              &                     ) &
              &           ) &
              &     )

            xy_SurfQvapBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j)

          end if
        end do
      end do
      
    end if
    
    !-----------------------------------------------------------------
    !  /Ǿ Ƚ
    !  Measure maximum/minimum
    !-----------------------------------------------------------------
    do i = 0, imax-1
      do j = 0, jmax-1

        xy_SurfVelBulkCoeff(i,j)  = &
          & max( min( xy_SurfVelBulkCoeff(i,j), VelBulkCoeffMax ), &
          &      VelBulkCoeffMin )

        xy_SurfTempBulkCoeff(i,j) = &
          & max( min( xy_SurfTempBulkCoeff(i,j), TempBulkCoeffMax ), &
          &      TempBulkCoeffMin )

        xy_SurfQvapBulkCoeff(i,j) = &
          & max( min( xy_SurfQvapBulkCoeff(i,j), QvapBulkCoeffMax ), &
          &      QvapBulkCoeffMin )

      end do
    end do
    
    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySurfFluxBulkCoeff

!!$  subroutine PhySurfFluxSample( phy_surfflx, err )
!!$    !--
!!$    ! PhySurfFluxSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_surfflx*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhySurfFluxSample
!!$    !++
!!$    ! If *phy_surfflx* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYSURFFLX), intent(inout):: phy_surfflx
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhySurfFluxSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_surfflx % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYSURFFLX'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_surfflx* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_surfflx*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_surfflx % param_i
!!$!!$    param_r = phy_surfflx % param_r
!!$!!$    param_c = phy_surfflx % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhySurfFluxSample

end module phy_surface_flux
