!= ͥեå
!
!= Radiation flux
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_radiation_flux.f90,v 1.7 2007/10/12 13:47:17 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_radiation_flux
  !
  != ͥեå
  !
  != Radiation flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! , 漾, , ͥեå׻ޤ. 
  !
  ! Calculate radiation flux from temperature, specific humidity, and
  ! air pressure.
  !
  !== Procedures List
  !
  ! Create        :: PHYRADFLX ѿν
  ! Close         :: PHYRADFLX ѿνλ
  ! PutLine       :: PHYRADFLX ѿ˳ǼƤΰ
  ! initialized   :: PHYRADFLX ѿꤵƤ뤫ݤ
  ! RadiationFlux :: ͥեåη׻
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYRADFLX"
  ! Close         :: Deconstructor of "PHYRADFLX"
  ! PutLine       :: Print information of "PHYRADFLX"
  ! initialized   :: Check initialization of "PHYRADFLX"
  ! RadiationFlux :: Calculate radiation flux
  !
  !== Usage
  !
  ! Ϥ, PHYRADFLX ѿ, Create ǽԤޤ.
  ! RadiationFlux Ѥͥեå׻ޤ. 
  ! PHYRADFLX ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYRADFLX" by "Create".
  ! Calculate radiation flux by "RadiationFlux". 
  ! In order to terminate "PHYRADFLX", use "Close".
  !

  use dc_types, only: DP, TOKEN
  use dc_date_types, only: DC_DIFFTIME
  implicit none
  private
  public:: PHYRADFLX, Create, Close, PutLine, initialized
  public:: RadiationFlux, RadiationDelTemp

  type PHYRADFLX
    !
    ! ޤ, Create  "PHYRADFLX" ѿꤷƲ.
    ! ꤵ줿 "PHYRADFLX" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYRADFLX" variable by "Create" before usage.
    ! If you reuse "PHYRADFLX" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag

    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: xy_SurfTemp (:,:) =>null()
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), pointer:: xy_SurfAlbedo (:,:) =>null()
                              ! ɽ٥. 
                              ! Surface albedo
    type(DC_DIFFTIME):: current_time
                              ! ߻. Current time.
    type(DC_DIFFTIME):: delta_time
                              ! $ \Delta t $ . ॹƥå. Time step
    type(DC_DIFFTIME):: delta_time_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ. 
                              ! Step interval of long wave flux calculation
    type(DC_DIFFTIME):: delta_time_RadShort
                              ! û () եå׻륹ƥå״ֳ. 
                              ! Step interval of short wave (insolation) flux calculation

    real(DP), pointer:: xy_IncomRadSFlux (:,:) =>null()
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), pointer:: xy_InAngle (:,:) =>null()
                              ! sec (ͳ). 
                              ! sec (angle of incidence)

    real(DP), pointer:: xy_TempSave (:,:) =>null()
                              ! $ T $ .      (¸). Temperature (for save)
    real(DP), pointer:: xyr_RadLFluxSave (:,:,:) =>null()
                              ! Ĺȥեå (¸). 
                              ! Long wave flux (for save)
    real(DP), pointer:: xyr_RadSFluxSave (:,:,:) =>null()
                              ! û () եå (¸). 
                              ! Short wave (insolation) flux (for save)
    real(DP), pointer:: xyra_DelRadLFluxSave (:,:,:,:) =>null()
                              ! ĹɽѲ (¸). 
                              ! Surface temperature tendency with long wave (for save)
    logical:: save_flag
                              ! ¸Υե饰. 
                              ! Flug for save
  end type PHYRADFLX

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: phy_radiation_flux.f90,v 1.7 2007/10/12 13:47:17 morikawa Exp $'

  interface Create
    module procedure PhyRadFluxCreate
  end interface

  interface Close
    module procedure PhyRadFluxClose
  end interface

  interface PutLine
    module procedure PhyRadFluxPutLine
  end interface

  interface initialized
    module procedure PhyRadFluxInitialized
  end interface

  interface NmlRead
    module procedure PhyRadFluxNmlRead
  end interface

  interface RadiationFlux
    module procedure PhyRadFluxRadiationFlux
  end interface

  interface LongFlux
    module procedure PhyRadFluxLongFlux
  end interface

  interface ShortIncoming
    module procedure PhyRadFluxShortIncoming
  end interface

  interface ShortFlux
    module procedure PhyRadFluxShortFlux
  end interface

  interface RadiationDelTemp
    module procedure PhyRadFluxRadiationDelTemp
  end interface

!!$  interface Sample
!!$    module procedure PhyRadFluxSample
!!$  end interface

contains

  subroutine PhyRadFluxCreate( phy_radflx, &
    & imax, jmax, kmax, &
    & y_Lat, &
    & Grav, Cp, StB, &
    & xy_SurfTemp, &
    & xy_SurfAlbedo, &
    & current_time_value, current_time_unit, &
    & delta_time_value, delta_time_unit, &
    & delta_time_value_RadLong, delta_time_unit_RadLong, &
    & delta_time_value_RadShort, delta_time_unit_RadShort, &
    & nmlfile, err )
    !
    ! PHYRADFLX ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYRADFLX ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_radflx* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_radiation_flux_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYRADFLX".
    ! Initialize *phy_radflx* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_radflx* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_radiation_flux_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use dc_date, only: Create
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), intent(in):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 0:jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(in), optional:: current_time_value
                              ! ߻. Value of current time
    character(*), intent(in), optional:: current_time_unit
                              ! ߻ñ. Unit of current time
    real(DP), intent(in), optional:: delta_time_value
                              ! $ \Delta t $ . ॹƥåפ. Value of time step
    character(*), intent(in), optional:: delta_time_unit
                              ! ॹƥåפñ. Unit of time step
    real(DP), intent(in), optional:: delta_time_value_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤. 
                              ! Value of step interval of long wave flux calculation
    character(*), intent(in), optional:: delta_time_unit_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of long wave flux calculation
    real(DP), intent(in), optional:: delta_time_value_RadShort
                              ! û () եå׻륹ƥå״ֳ֤. 
                              ! Value of step interval of short wave (insolation) flux calculation
    character(*), intent(in), optional:: delta_time_unit_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of short wave (insolation) flux calculation
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_radiation_flux_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_radiation_flux_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_radflx % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYRADFLX" 
    !  Configure the settings for "PHYRADFLX"
    !-----------------------------------------------------------------
    phy_radflx % imax    = imax   
    phy_radflx % jmax    = jmax   
    phy_radflx % kmax    = kmax   
    phy_radflx % Grav    = Grav   
    phy_radflx % Cp      = Cp   
    phy_radflx % StB     = StB    

    allocate( phy_radflx % y_Lat (0:phy_radflx%jmax-1) )
    phy_radflx % y_Lat   = y_Lat    

    allocate( phy_radflx % xy_SurfTemp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    allocate( phy_radflx % xy_SurfAlbedo (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    phy_radflx % xy_SurfTemp   = xy_SurfTemp   
    phy_radflx % xy_SurfAlbedo = xy_SurfAlbedo 

    !-----------------------------------------------------------------
    !  
    !  Configure time
    !-----------------------------------------------------------------
    if ( present(current_time_value) .and. present(current_time_unit) ) then
      call Create( &
        & diff = phy_radflx % current_time, &   ! (out)
        & value = current_time_value, &         ! (in)
        & unit = current_time_unit )            ! (in)
    else
      call Create( &
        & diff = phy_radflx % current_time, &   ! (out)
        & value = 0.0_DP, &         ! (in)
        & unit = 'sec' )            ! (in)
    end if

    if ( present(delta_time_value) .and. present(delta_time_unit) ) then
      call Create( &
        & diff = phy_radflx % delta_time, &   ! (out)
        & value = delta_time_value, &         ! (in)
        & unit = delta_time_unit )            ! (in)
    else
      call Create( &
        & diff = phy_radflx % delta_time, &   ! (out)
        & value = 1.0_DP, &          ! (in)
        & unit = 'sec' )             ! (in)
    end if

    if ( present(delta_time_value_RadLong) .and. present(delta_time_unit_RadLong) ) then
      call Create( &
        & diff = phy_radflx % delta_time_RadLong, &   ! (out)
        & value = delta_time_value_RadLong, &         ! (in)
        & unit = delta_time_unit_RadLong )            ! (in)
    else
      call Create( &
        & diff = phy_radflx % delta_time_RadLong, &   ! (out)
        & value = -1.0_DP, &         ! (in)
        & unit = 'sec' )             ! (in)
    end if

    if ( present(delta_time_value_RadShort) .and. present(delta_time_unit_RadShort) ) then
      call Create( &
        & diff = phy_radflx % delta_time_RadShort, &   ! (out)
        & value = delta_time_value_RadShort, &         ! (in)
        & unit = delta_time_unit_RadShort )            ! (in)
    else
      call Create( &
        & diff = phy_radflx % delta_time_RadShort, &   ! (out)
        & value = -1.0_DP, &         ! (in)
        & unit = 'sec' )             ! (in)
    end if

    !-----------------------------------------------------------------
    !  ¸ѿγ
    !  Allocate variables for save
    !-----------------------------------------------------------------
    phy_radflx % save_flag = .false.
    allocate( phy_radflx % xy_TempSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    allocate( phy_radflx % xyr_RadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax) )
    allocate( phy_radflx % xyr_RadSFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax) )
    allocate( phy_radflx % xyra_DelRadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1) )

    phy_radflx % xy_TempSave = 0.0_DP
    phy_radflx % xyr_RadLFluxSave = 0.0_DP
    phy_radflx % xyr_RadSFluxSave = 0.0_DP
    phy_radflx % xyra_DelRadLFluxSave = 0.0_DP

    !-----------------------------------------------------------------
    !  NAMELIST μ
    !  Get NAMELIST
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_radflx % param_r = 0.0_DP
!!$    phy_radflx % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_radflx % param_i = param_i
!!$    if ( present(param_r) )  phy_radflx % param_r = param_r
!!$    if ( present(param_c) )  phy_radflx % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_radflx % param_i, &   ! (inout)
!!$        & param_r = phy_radflx % param_r, &   ! (inout)
!!$        & param_c_ = phy_radflx % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_radflx % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  ե饰
    !  Set initialization flag 
    !-----------------------------------------------------------------
    phy_radflx % initialized = .true.

    !-----------------------------------------------------------------
    !  ûͤη׻
    !  Calculate short wave (insolation) incoming radiation
    !-----------------------------------------------------------------
    allocate( phy_radflx % xy_IncomRadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    allocate( phy_radflx % xy_InAngle (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )

    call ShortIncoming( phy_radflx = phy_radflx, &          ! (inout)
      & xy_IncomRadSFlux = phy_radflx % xy_IncomRadSFlux, & ! (out)
      & xy_InAngle = phy_radflx % xy_InAngle )              ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxCreate

  subroutine PhyRadFluxClose( phy_radflx, err )
    !
    ! PHYRADFLX ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYRADFLX".
    ! Note that if *phy_radflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYRADFLX" ξõ
    !  Clear the settings for "PHYRADFLX"
    !-----------------------------------------------------------------
    deallocate( phy_radflx % y_Lat )

    deallocate( phy_radflx % xy_IncomRadSFlux )
    deallocate( phy_radflx % xy_InAngle )

    deallocate( phy_radflx % xy_SurfTemp )
    deallocate( phy_radflx % xy_SurfAlbedo )

    deallocate( phy_radflx % xy_TempSave  )
    deallocate( phy_radflx % xyr_RadLFluxSave )
    deallocate( phy_radflx % xyr_RadSFluxSave )
    deallocate( phy_radflx % xyra_DelRadLFluxSave )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_radflx % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxClose

  subroutine PhyRadFluxPutLine( phy_radflx, unit, indent, err )
    !
    !  *phy_radflx* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_radflx*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_date, only: toChar
    implicit none
    type(PHYRADFLX), intent(in):: phy_radflx
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyRadFluxPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYRADFLX" ΰ
    !  Print the settings for "PHYRADFLX"
    !-----------------------------------------------------------------
    if ( phy_radflx % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYRADFLX:: @initialized=%y', &
        & l = (/phy_radflx % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_radflx % imax, phy_radflx % jmax, phy_radflx % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f @StB=%f', &
        & d = (/ phy_radflx % Grav, phy_radflx % Cp, phy_radflx % StB/) )

      call PutLine( phy_radflx % y_Lat, unit = out_unit, &
        & lbounds = lbound(phy_radflx % y_Lat), &
        & ubounds = ubound(phy_radflx % y_Lat), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat=' )

      call PutLine( phy_radflx % xy_SurfTemp, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_SurfTemp), &
        & ubounds = ubound(phy_radflx % xy_SurfTemp), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfTemp=' )

      call PutLine( phy_radflx % xy_SurfAlbedo, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_SurfAlbedo), &
        & ubounds = ubound(phy_radflx % xy_SurfAlbedo), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfAlbedo=' )

      call PutLine( phy_radflx % xy_IncomRadSFlux, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_IncomRadSFlux), &
        & ubounds = ubound(phy_radflx % xy_IncomRadSFlux), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_IncomRadSFlux=' )

      call PutLine( phy_radflx % xy_InAngle, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_InAngle), &
        & ubounds = ubound(phy_radflx % xy_InAngle), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_InAngle=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @current_time=%c', &
        & c1 = trim( toChar(phy_radflx % current_time) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @delta_time=%c', &
        & c1 = trim( toChar(phy_radflx % delta_time) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @delta_time_RadLong=%c', &
        & c1 = trim( toChar(phy_radflx % delta_time_RadLong) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @delta_time_RadShort=%c', &
        & c1 = trim( toChar(phy_radflx % delta_time_RadShort) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYRADFLX:: @initialized=%y>', &
        & l = (/phy_radflx % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxPutLine

  logical function PhyRadFluxInitialized( phy_radflx ) result(result)
    !
    ! *phy_radflx* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_radflx* is initialized, .true. is returned.
    ! If *phy_radflx* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYRADFLX), intent(in):: phy_radflx
  continue
    result = phy_radflx % initialized
  end function PhyRadFluxInitialized

  subroutine PhyRadFluxNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_radiation_flux_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_radiation_flux ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_radiation_flux#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_radiation_flux" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_radiation_flux#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyRadFluxNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_radiation_flux_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_radiation_flux_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_radiation_flux_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_radiation_flux_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxNmlRead

  subroutine PhyRadFluxRadiationFlux( phy_radflx, &
    & xyz_Temp, xyz_QVap, xyr_Press, &
    & xyr_RadLFlux, xya_SurfRadLMatrix, xyra_DelRadLFlux, xyr_RadSFlux, &
    & err )
    !
    ! , 漾, , ͥեå׻ޤ. 
    !
    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate radiation flux from temperature, specific humidity, and 
    ! air pressure. 
    !
    ! If *phy_radflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_date, only: EvalSec, EvalByUnit, mod, &
      & operator(*), operator(==), operator(<), operator(/), &
      & operator(+), operator(-)
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(in):: xyz_Temp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_QVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyr_Press (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyr_RadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP), intent(out):: xya_SurfRadLMatrix (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
    real(DP), intent(out):: xyra_DelRadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
    real(DP), intent(out):: xyr_RadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: xy_SurfTemp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature

    real(DP):: xy_TempSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! $ T $ .      (¸). Temperature (for save)
    real(DP):: xyr_RadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå (¸). 
                              ! Long wave flux (for save)
    real(DP):: xyr_RadSFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå (¸). 
                              ! Short wave (insolation) flux (for save)
    real(DP):: xyra_DelRadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1)
                              ! ĹɽѲ (¸). 
                              ! Surface temperature tendency with long wave (for save)

    real(DP):: xyr_TauQVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of water
    real(DP):: xyr_TauDryAir (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of air

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop


    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxRadiationFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax    = phy_radflx % kmax   
    Grav    = phy_radflx % Grav   

    xy_SurfTemp   = phy_radflx % xy_SurfTemp   

    xyr_RadSFlux = 0.0_DP
    xyr_RadSFlux(:,:,kmax) = phy_radflx % xy_IncomRadSFlux

    xy_TempSave          = phy_radflx % xy_TempSave         
    xyr_RadLFluxSave     = phy_radflx % xyr_RadLFluxSave     
    xyr_RadSFluxSave     = phy_radflx % xyr_RadSFluxSave     
    xyra_DelRadLFluxSave = phy_radflx % xyra_DelRadLFluxSave 

    !-----------------------------------------------------------------
    !  Ūη׻
    !  Calculate optical depth
    !-----------------------------------------------------------------
    xyr_TauQVap   = 0.0_DP
    xyr_TauDryAir = 0.0_DP

    do k = kmax-1 , 0, -1
      xyr_TauQVap(:,:,k) = &
        &   xyr_TauQVap(:,:,k+1) &
        & + xyz_QVap(:,:,k) &
        &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav

      xyr_TauDryAir(:,:,k) = &
        &   xyr_TauDryAir(:,:,k+1) &
        & + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do


    !-----------------------------------------------------------------
    !  Ĺȥեåλ
    !  Calculate long wave flux
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  current_time / delta_time_RadLong == 0, ޤ
    !  delta_time_RadLong ̤, ޤ
    !  ޤ٤׻ƤʤˤϷ׻Ԥ. 
    !
    !  If current_time / delta_time_RadLong == 0, or
    !  "delta_time_RadLong" is not configured, or
    !  calculation was never performed, 
    !  calculation is performed. 
    if ( mod( phy_radflx % current_time, &
      &       phy_radflx % delta_time_RadLong) == 0 .or. &
      &  EvalSec( phy_radflx % delta_time_RadLong ) < 0.0_DP .or. &
      &  .not. phy_radflx % save_flag                               ) then

      call DbgMessage( 'LongFlux is calculated' )

      call LongFlux( phy_radflx = phy_radflx, &  ! (inout)
        & xyr_RadLFlux = xyr_RadLFlux, &         ! (out)
        & xyra_DelRadLFlux = xyra_DelRadLFlux, & ! (out)
        & xyz_Temp = xyz_Temp, &                 ! (in)
        & xy_SurfTemp = xy_SurfTemp, &           ! (in)
        & xyr_TauQVap = xyr_TauQVap, &           ! (in)
        & xyr_TauDryAir = xyr_TauDryAir )        ! (in)
       
    !-----------------------------------
    !  ͤ
    !  Use values in last time
    else

      call DbgMessage( &
        & 'LongFlux is not calculated. Save values are used' )

      xyr_RadLFlux = xyr_RadLFluxSave
      xyra_DelRadLFlux = xyra_DelRadLFluxSave
       
      do k = 0, kmax
        xyr_RadLFlux(:,:,k) = &
          &   xyr_RadLFlux(:,:,k) &
          & + xyra_DelRadLFlux(:,:,k,1) &
          &     * ( xyz_Temp(:,:,0) - xy_TempSave )

        xyra_DelRadLFlux(:,:,k,1) = &
          &   xyra_DelRadLFlux(:,:,k,1) &
          &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,0)**3 )
      end do
    end if


    !-----------------------------------------------------------------
    !  Ĺȱѹλ
    !  Calculate long wave implicit matrix
    !-----------------------------------------------------------------
    xya_SurfRadLMatrix(:,:,0)  = xyra_DelRadLFlux(:,:,0,0)
    xya_SurfRadLMatrix(:,:,1)  = xyra_DelRadLFlux(:,:,0,1)
    xya_SurfRadLMatrix(:,:,-1) = 0.0_DP


    !-----------------------------------------------------------------
    !  û () եåλ
    !  Calculate short wave (insolation)
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  current_time / delta_time_RadShort == 0, ޤ
    !  delta_time_RadShort ̤, ޤ
    !  ޤ٤׻ƤʤˤϷ׻Ԥ. 
    !
    !  If current_time / delta_time_RadShort == 0, or
    !  "delta_time_RadShort" is not configured, or
    !  calculation was never performed, 
    !  calculation is performed. 
    if ( mod( phy_radflx % current_time, &
      &       phy_radflx % delta_time_RadShort) == 0 .or. &
      &  EvalSec( phy_radflx % delta_time_RadShort ) < 0.0_DP .or. &
      &  .not. phy_radflx % save_flag                               ) then

      call DbgMessage( 'ShortFlux is calculated' )

      !---------------------------------
      !  ûȥեåη׻
      !  Calculate short wave (insolation) flux
      call ShortFlux( phy_radflx = phy_radflx, & ! (inout)
        & xyr_RadSFlux = xyr_RadSFlux, &         ! (inout)
        & xyr_TauQVap = xyr_TauQVap, &           ! (in)
        & xyr_TauDryAir = xyr_TauDryAir )        ! (in)


    !-----------------------------------
    !  ͤ
    !  Use values in last time
    else

      call DbgMessage( &
        & 'ShortFlux is not calculated. Save values are used' )

      xyr_RadSFlux = xyr_RadSFluxSave
    end if


    !-----------------------------------------------------------------
    !  ׻ͤ¸
    !  Save calculated values in this time
    !-----------------------------------------------------------------
    phy_radflx % xy_TempSave          = xyz_Temp (:,:,0)
    phy_radflx % xyr_RadLFluxSave     = xyr_RadLFlux
    phy_radflx % xyr_RadSFluxSave     = xyr_RadSFlux
    phy_radflx % xyra_DelRadLFluxSave = xyra_DelRadLFlux

    phy_radflx % save_flag = .true.

    !-----------------------------------------------------------------
    !  ι
    !  Update time
    !-----------------------------------------------------------------
    phy_radflx % current_time = &
      & phy_radflx % current_time + phy_radflx % delta_time

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxRadiationFlux

  subroutine PhyRadFluxLongFlux( phy_radflx, &
    & xyr_RadLFlux, &
    & xyra_DelRadLFlux, &
    & xyz_Temp, &
    & xy_SurfTemp, &
    & xyr_TauQVap, &
    & xyr_TauDryAir, &
    & err )
    !
    ! Ĺȥեåη׻
    !
    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate long wave flux
    !
    ! If *phy_radflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(out):: xyr_RadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP), intent(out):: xyra_DelRadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
    real(DP), intent(in):: xyz_Temp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xy_SurfTemp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyr_TauQVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of water
    real(DP), intent(in):: xyr_TauDryAir (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of air
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant

    real(DP):: xyr_Trans (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP):: xyr_Trans1 (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! 1/2 ٥뤫Ʃ᷸. 
                              ! Transmission coefficient above 1/2 level
    real(DP):: xyr_Trans2 (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! 3/2 ٥뤫Ʃ᷸. 
                              ! Transmission coefficient above 3/2 level
    real(DP):: xyz_PiB (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ \pi B = \sigma T^{4} $
    real(DP):: xy_SurfPiB (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ̤ $ \pi B $ . 
                              ! $ \pi B $ on surface

    integer:: kk , bn
    real(DP):: BandWeightSum

    integer, parameter :: BandNumber = 4
                              ! ĹȥХɿ. 
                              ! Number of long wave band

    real(DP):: AbsorpCoeffQVap(BandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP):: AbsorpCoeffDryAir(BandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP):: BandWeight(BandNumber)
                              ! Хɥ. 
                              ! Band weight
    real(DP):: PathLengthFact
                              ! ϩĹΥե. 
                              ! Factor of optical length

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxLongFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax    = phy_radflx % kmax   
    StB     = phy_radflx % StB    

    !-----------------------------------------------------------------
    !  ۼʤɤ
    !  Configure absorption coefficients etc.
    !-----------------------------------------------------------------
    AbsorpCoeffQVap = (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /)
    AbsorpCoeffDryAir = (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
    BandWeight = (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
    PathLengthFact = 1.5_DP


    !-----------------------------------------------------------------
    !  ХɥȤ
    !  Configure band weight
    !-----------------------------------------------------------------
    BandWeightSum = 0.0_DP

    do bn = 1, BandNumber
      BandWeightSum =  BandWeightSum +  BandWeight(bn)
    end do

    do bn = 1, BandNumber
      BandWeight(bn) = BandWeight(bn) / BandWeightSum
    end do

    !-----------------------------------------------------------------
    !  $ \pi B $ η׻
    !  Calculate $ \pi B $
    !-----------------------------------------------------------------
    xyz_PiB    = StB * ( xyz_Temp**4 )
    xy_SurfPiB = StB * ( xy_SurfTemp**4 )

    do k = 0, kmax

      !---------------------------------------------------------------
      !  Ʃؿ׻
      !  Calculate transmission functions
      !---------------------------------------------------------------
      xyr_Trans = 0.0_DP
      
      do bn = 1, BandNumber
        do kk = 0, kmax
          xyr_Trans(:,:,kk) = &
            &   xyr_Trans(:,:,kk) &
            & + BandWeight(bn) &
            &   * exp( - PathLengthFact &
            &            * (   AbsorpCoeffQVap(bn) &
            &                  * abs(   xyr_TauQVap(:,:,kk) &
            &                         - xyr_TauQVap(:,:,k)  ) &
            &                + AbsorpCoeffDryAir(bn) &
            &                  * abs(   xyr_TauDryAir(:,:,kk) &
            &                         - xyr_TauDryAir(:,:,k)  ) ) )
        end do
      end do
      

      !---------------------------------------------------------------
      !  ͥեå׻
      !  Calculate radiation flux
      !---------------------------------------------------------------
      xyr_RadLFlux(:,:,k) = xy_SurfPiB * xyr_Trans(:,:,0)
 
      do kk = 0, kmax-1
        xyr_RadLFlux(:,:,k) = &
          &   xyr_RadLFlux(:,:,k) &
          & - xyz_PiB(:,:,kk) * ( xyr_Trans(:,:,kk) - xyr_Trans(:,:,kk+1) )
      end do

      !---------------------------------------------------------------
      !  ׻Ʃؿ׻
      !  Calculate transmission functions for correction terms
      !---------------------------------------------------------------
      xyr_Trans1(:,:,k) = xyr_Trans(:,:,0)
      xyr_Trans2(:,:,k) = xyr_Trans(:,:,1)

    end do

    !-----------------------------------------------------------------
    !  ĹɽѲη׻
    !  Calclate surface temperature tendency with long wave
    !-----------------------------------------------------------------
    do k = 0, kmax
      xyra_DelRadLFlux(:,:,k,0) = &
        & 4.0_DP * xy_SurfPiB / xy_SurfTemp * xyr_Trans1(:,:,k)

      xyra_DelRadLFlux(:,:,k,1) = &
        & 4.0_DP * xyz_PiB(:,:,0) / xyz_Temp(:,:,0) &
        &   * ( xyr_Trans2(:,:,k) - xyr_Trans1(:,:,k) )
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxLongFlux

  subroutine PhyRadFluxShortIncoming( phy_radflx, &
    & xy_IncomRadSFlux, &
    & xy_InAngle, &
    & err )
    !
    ! ûͤ׻ޤ.
    !
    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate short wave (insolation) incoming radiation. 
    !
    ! If *phy_radflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(out):: xy_IncomRadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), intent(out):: xy_InAngle (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude

    real(DP):: y_Lat (0:phy_radflx%jmax-1)
                              !  (饸). Latitude (radian)

    real(DP), parameter:: SolarCoeff = 1380.0_DP
                              ! . 
                              ! Solar constant
    real(DP), parameter:: AtmosAlbedo = 0.2_DP
                              ! 絤٥. 
                              ! Albedo of air

!!$    real(DP), parameter:: EPSORB = 23.5_DP
!!$                              ! ƻг. 
!!$                              ! Inclination of equator to orbit
!!$    real(DP), parameter:: EQNORB = 110.0_DP
!!$                              ! . 
!!$                              ! 
    real(DP), parameter:: AINS   = 0.127_DP
                              ! ǯʿͤη
                              ! Coefficient of annual mean incoming radiation
    real(DP), parameter:: BINS   = 0.183_DP
                              ! ǯʿͤη
                              ! Coefficient of annual mean incoming radiation
    real(DP), parameter:: AZET   = 0.410_DP
                              ! ǯʿͳѤη
                              ! Coefficient of annual mean incoming radiation
    real(DP), parameter:: BZET   = 0.590_DP
                              ! ǯʿͳѤη
                              ! Coefficient of annual mean incoming radiation

    integer:: i, j            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxShortIncoming'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    imax    = phy_radflx % imax   
    jmax    = phy_radflx % jmax   
    y_Lat   = phy_radflx % y_Lat   

    !-----------------------------------------------------------------
    !  ǯ, ʿͤη׻
    !  Calculate annual mean, daily mean insolation
    !-----------------------------------------------------------------
    do i = 0, imax - 1
      do j = 0, jmax - 1
        xy_IncomRadSFlux(i,j) = &
          &  - SolarCoeff * (1.0_DP - AtmosAlbedo ) &
          &    * ( AINS + BINS * cos( y_Lat(j) )**2 )

        if ( xy_IncomRadSFlux(i,j) < 0.0_DP ) then
          xy_InAngle(i,j) = 1.0_DP / ( AZET + BZET * cos( y_Lat(j) )**2 )
        else
          xy_IncomRadSFlux(i,j) = 0.0_DP
          xy_InAngle(i,j) = 0.0_DP
        end if
      end do
    end do

    !-----------------------------------------------------------------
    !  Ѳ, Ѳη׻
    !  Calculate with seasonal change and diurnal change
    !-----------------------------------------------------------------
    ! ᤯ AGCM5 ܿͽ. 
    ! Importation from AGCM5 is planed within days


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxShortIncoming

  subroutine PhyRadFluxShortFlux( phy_radflx, &
    & xyr_RadSFlux, &
    & xyr_TauQVap, &
    & xyr_TauDryAir, &
    & err )
    !
    ! Ĺȥեåη׻
    !
    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate long wave flux
    !
    ! If *phy_radflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(inout):: xyr_RadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

    real(DP), intent(in):: xyr_TauQVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of water
    real(DP), intent(in):: xyr_TauDryAir (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of air
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: xy_InAngle (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)

    real(DP):: xy_SurfAlbedo (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo

    integer:: bn
    real(DP):: BandWeightSum

    integer, parameter :: BandNumber = 1
                              ! ûȥХɿ. 
                              ! Number of short wave band

    real(DP):: AbsorpCoeffQVap(BandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP):: AbsorpCoeffDryAir(BandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP):: BandWeight(BandNumber)
                              ! Хɥ. 
                              ! Band weight
    real(DP):: SECSCT
                              !  $ sec \zeta $
                              ! $ sec \zeta $ of scattering

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxShortFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax          = phy_radflx % kmax   
    xy_InAngle    = phy_radflx % xy_InAngle
    xy_SurfAlbedo = phy_radflx % xy_SurfAlbedo

    !-----------------------------------------------------------------
    !  ۼʤɤ
    !  Configure absorption coefficients etc.
    !-----------------------------------------------------------------
    AbsorpCoeffQVap = (/ 0.002_DP /)
    AbsorpCoeffDryAir = (/ 0.0_DP /)
    BandWeight = (/ 1.0_DP /)
    SECSCT = 1.66_DP

    !-----------------------------------------------------------------
    !  ХɥȤ
    !  Configure band weight
    !-----------------------------------------------------------------
    BandWeightSum = 0.0_DP

    do bn = 1, BandNumber
      BandWeightSum =  BandWeightSum +  BandWeight(bn)
    end do

    do bn = 1, BandNumber
      BandWeight(bn) = BandWeight(bn) / BandWeightSum
    end do

    do bn = 1, BandNumber
      do k = 0, kmax

        !-------------------------------------------------------------
        !  ƥ٥ǤβƩ
        !  Downward transmission on each level
        !-------------------------------------------------------------
        if ( k /= kmax ) then
          xyr_RadSFlux(:,:,k) = &
            &   xyr_RadSFlux(:,:,k) & 
            & + BandWeight(bn) * xyr_RadSFlux(:,:,kmax) &
            &   * exp( - xy_InAngle(:,:) &
            &            * (   AbsorpCoeffQVap(bn) * xyr_TauQVap(:,:,k) &
            &                + AbsorpCoeffDryAir(bn) * xyr_TauDryAir(:,:,k) ) &
            &       )
        end if
        
        !-------------------------------------------------------------
        !  ƥ٥ǤξƩ
        !  Upward transmission on each level
        !-------------------------------------------------------------
        xyr_RadSFlux(:,:,k) = &
          &   xyr_RadSFlux(:,:,k) & 
          & - BandWeight(bn) * xyr_RadSFlux(:,:,kmax) &
          &   * exp( - xy_InAngle(:,:) &
          &            * (   AbsorpCoeffQVap(bn) * xyr_TauQVap(:,:,0) &
          &                + AbsorpCoeffDryAir(bn) * xyr_TauDryAir(:,:,0) ) &
          &       ) &
          &   * xy_SurfAlbedo &
          &   * exp( - SECSCT &
          &            * (   AbsorpCoeffQVap(bn) &
          &                  * ( xyr_TauQVap(:,:,0) - xyr_TauQVap(:,:,k) ) &
          &                + AbsorpCoeffDryAir(bn) &
          &                  * ( xyr_TauDryAir(:,:,0) - xyr_TauDryAir(:,:,k) ) &
          &              ) &
          &        )
      end do
    end do

    !-----------------------------------------------------------------
    !  ۼʤξ
    !  In the case of no absorption
    !-----------------------------------------------------------------
    if ( BandNumber == 0 ) then
      do k = 0, kmax
        xyr_RadSFlux(:,:,k) = &
          & ( 1.0_DP - xy_SurfAlbedo ) * xyr_RadSFlux(:,:,kmax)
      end do
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxShortFlux

  subroutine PhyRadFluxRadiationDelTemp( phy_radflx, &
    & xyr_RadLFlux, &
    & xyr_RadSFlux, &
    & xyr_Press, &
    & xyz_DRadLTempDt, &
    & xyz_DRadSTempDt, &
    & err )
    !
    ! ͤˤ벹ѲΨ׻ޤ. 
    !
    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate temperature tendency with radiation.
    !
    ! If *phy_radflx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(in):: xyr_RadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP), intent(in):: xyr_RadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), intent(in):: xyr_Press (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyz_DRadLTempDt (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
    real(DP), intent(out):: xyz_DRadSTempDt (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxRadiationDelTemp'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax        = phy_radflx % kmax   
    Grav        = phy_radflx % Grav   
    Cp          = phy_radflx % Cp   

    !----------------------------------------------------------------
    !  Ψα黻
    !  Calculate radiation cooling rate
    !----------------------------------------------------------------
    do k = 0, kmax - 1
      xyz_DRadLTempDt(:,:,k) = &
        & ( xyr_RadLFlux(:,:,k) - xyr_RadLFlux(:,:,k+1) ) &
        & / ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Cp * Grav
      xyz_DRadSTempDt(:,:,k) = &
        & ( xyr_RadSFlux(:,:,k) - xyr_RadSFlux(:,:,k+1) ) &
        & / ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Cp * Grav
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxRadiationDelTemp

!!$  subroutine PhyRadFluxSample( phy_radflx, err )
!!$    !--
!!$    ! PhyRadFluxSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_radflx*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyRadFluxSample
!!$    !++
!!$    ! If *phy_radflx* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYRADFLX), intent(inout):: phy_radflx
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyRadFluxSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_radflx % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYRADFLX'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_radflx* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_radflx*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_radflx % param_i
!!$!!$    param_r = phy_radflx % param_r
!!$!!$    param_c = phy_radflx % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyRadFluxSample

end module phy_radiation_flux
