!= phy_ape ⥸塼Υƥȥץ
!
!= Test program for "phy_ape"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_ape_test.f90,v 1.5 2007/10/11 19:54:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_ape ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_ape" module.
! Confirm compilation and execution of this program.
!

program phy_ape_test
  use phy_ape, only: PHYAPE, Create, Close, &
    & PutLine, initialized, PhysicsAPE
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_ape_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_ape" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 64         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 32         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 20         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
  real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
  real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
  real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
  real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant
  real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP):: x_Lon (0:imax-1)
                              ! . Longitude
  real(DP):: x_Lon_Weight(0:imax-1)
                   ! ٺɸŤ. 
                   ! Weight of longitude
  real(DP):: y_Lat (0:jmax-1)
                              ! . Latitude
  real(DP):: y_Lat_Weight(0:jmax-1)
                   ! ٺɸŤ. 
                   ! Weight of latitude
  real(DP):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xyz_U (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ U $ . ®. Zonal wind
  real(DP):: xyz_V (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ V $ . ®. Meridional wind

  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .     . Temperature
  real(DP):: xy_Ps (0:imax-1, 0:jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYAPE):: phy_ape00, phy_ape01, phy_ape02, phy_ape03
  logical:: err
  type(GT_HISTORY):: gthist
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_ape_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth )               ! (inout)
  call Get( constant = const_earth, &                 ! (inout)
    & PI = PI, &                                      ! (out)
    & RAir = RAir, Grav = Grav, Cp = Cp, &            ! (out)
    & EL = EL, RVap = RVap, EpsV = EpsV, ES0 = ES0, & ! (out)
    & StB = StB, FKarm = FKarm )                      ! (out)

  DelTime = 360.0_DP

  !---------------------------------------------------------
  !  ǡ
  !  Get axes data
  !---------------------------------------------------------
  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lon', & ! (in)
    & array = x_Lon )                                ! (out)
  x_Lon = x_Lon * PI / 180.0_DP

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lon_weight', & ! (in)
    & array = x_Lon_Weight )                       ! (out)

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lat', & ! (in)
    & array = y_Lat )                                ! (out)
  y_Lat = y_Lat * PI / 180.0_DP

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lat_weight', & ! (in)
    & array = y_Lat_Weight )                       ! (out)

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'sig', & ! (in)
    & array = z_Sigma )                     ! (out)

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'sigm', & ! (in)
    & array = r_Sigma )                      ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_ape = phy_ape00, &                           ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &                  ! (in)
    & x_Lon = x_Lon, y_Lat = y_Lat, &                           ! (in)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma, &                   ! (in)
    & PI = PI, &                                                ! (in)
    & RAir = RAir, Grav = Grav, Cp = Cp, &                      ! (in)
    & EL = EL, RVap = RVap, EpsV = EpsV, ES0 = ES0, &           ! (in)
    & StB = StB, FKarm = FKarm, &                               ! (in)
    & DelTime = DelTime, &                                      ! (in)
    & x_Lon_Weight = x_Lon_Weight, &                            ! (in)
    & y_Lat_Weight = y_Lat_Weight, &                            ! (in)
    & current_time_value = 360.0_DP, current_time_unit = 'sec', & ! (in)
    & nmlfile = VAL_namelist )                                  ! (in)

  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_ape00) )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  !---------------------------------------------------------
  !  PhysicsAPE ƥ
  !  PhysicsAPE test
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'U', &              ! (in)
    & array = xyz_U )               ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'V', &              ! (in)
    & array = xyz_V )               ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'Temp', &           ! (in)
    & array = xyz_Temp )            ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'QVap', &           ! (in)
    & array = xyz_QVap )            ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'Ps', &             ! (in)
    & array = xy_Ps )               ! (out)

  call PhysicsAPE( phy_ape = phy_ape00, &   ! (inout)
    & xyz_U = xyz_U, xyz_V = xyz_V, &       ! (inout)
    & xyz_Temp = xyz_Temp, xy_Ps = xy_Ps, & ! (inout)
    & xyz_QVap = xyz_QVap )                 ! (inout)


  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_ape = phy_ape00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_ape00) )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  call Close( phy_ape = phy_ape02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )


  !----------------------------------------------------------------
  !  ǡ
  !  Output data
  !----------------------------------------------------------------
  call HistoryCreate( &
    & history = gthist, &                            ! (out)
    & file = 'phy_ape_test02.nc', &          ! (in)
    & title = title, &                               ! (in)
    & source = source, institution = institution, &  ! (in)
    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
    & longnames = &
    &  StoA('longitude', 'latitude', &
    &       'sigma at layer midpoints', &
    &       'sigma at layer end-points (half level)'), & ! (in)
    & units = StoA('degree_east', 'degree_north', &
    &              '1', '1') )                           ! (out)

  call HistoryPut( &
    & history = gthist, &               ! (out)
    & varname = 'lon', array = x_Lon * 180.0_DP / PI )  ! (in)
  call HistoryPut( &
    & history = gthist, &               ! (out)
    & varname = 'lat', array = y_Lat * 180.0_DP / PI ) ! (in)
  call HistoryPut( &
    & history = gthist, &                ! (out)
    & varname = 'sig', array = z_Sigma ) ! (in)
  call HistoryPut( &
    & history = gthist, &                 ! (out)
    & varname = 'sigm', array = r_Sigma ) ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                    ! (inout)
    & varname = 'lon', attrname = 'standard_name', & ! (in)
    & value = 'longitude' )                          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                    ! (inout)
    & varname = 'lat', attrname = 'standard_name', & ! (in)
    & value = 'latitude' )                           ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sig', attrname = 'standard_name', &   ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sigm', attrname = 'standard_name', &  ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sig', attrname = 'positive', &   ! (in)
    & value = 'down' )                            ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sigm', attrname = 'positive', &  ! (in)
    & value = 'down' )                            ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                           ! (inout)
    & varname = 'U', &                              ! (in)
    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
    & longname = 'eastward wind', &                 ! (in)
    & units = 'm/s', xtype = 'double' )             ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                          ! (inout)
    & varname = 'U', attrname = 'standard_name', & ! (in)
    & value = 'eastward_wind' )                    ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                           ! (inout)
    & varname = 'V', &                              ! (in)
    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
    & longname = 'northward wind', &                ! (in)
    & units = 'm/s', xtype = 'double' )             ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                          ! (inout)
    & varname = 'V', attrname = 'standard_name', & ! (in)
    & value = 'northward_wind' )                   ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                   ! (inout)
    & varname = 'Temp', &                           ! (in)
    & dims = StoA('lon', 'lat', 'sig' ), &          ! (in)
    & longname = 'temperature', &                   ! (in)
    & units = 'K', xtype = 'double' )               ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                     ! (inout)
    & varname = 'Temp', attrname = 'standard_name', & ! (in)
    & value = 'air_temperature' )                     ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                   ! (inout)
    & varname = 'QVap', &                           ! (in)
    & dims = StoA('lon', 'lat', 'sig' ), &          ! (in)
    & longname = 'specific humidity', &             ! (in)
    & units = '1', xtype = 'double' )               ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                     ! (inout)
    & varname = 'QVap', attrname = 'standard_name', & ! (in)
    & value = 'specific_humidity' )                   ! (in)

  call HistoryAddVariable( &
    & history = gthist, &               ! (inout)
    & varname = 'Ps', &                 ! (in)
    & dims = StoA('lon', 'lat'), &      ! (in)
    & longname = 'surface pressure', &  ! (in)
    & units = 'Pa', xtype = 'double' )  ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                   ! (inout)
    & varname = 'Ps', attrname = 'standard_name', & ! (in)
    & value = 'surface_air_pressure' )              ! (in)

  call HistoryPut( &
    & history = gthist, &            ! (inout)
    & varname = 'U', array = xyz_U ) ! (in)
  call HistoryPut( &
    & history = gthist, &            ! (inout)
    & varname = 'V', array = xyz_V ) ! (in)
  call HistoryPut( &
    & history = gthist, &             ! (inout)
    & varname = 'Temp', array = xyz_Temp )   ! (in)
  call HistoryPut( &
    & history = gthist, &             ! (inout)
    & varname = 'QVap', array = xyz_QVap )   ! (in)
  call HistoryPut( &
    & history = gthist, &        ! (inout)
    & varname = 'Ps', array = xy_Ps )   ! (in)

  call HistoryClose( history = gthist ) ! (inout)

end program phy_ape_test
