!= ¸
!
!= Aqua Planet Experiment
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_ape.f90,v 1.23 2007/10/12 13:47:32 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_ape
  !
  != ¸
  !
  != Aqua Planet Experiment
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 夬ʤƤ褦絤׻
  ! ɬפʪ׻ޤ. 
  ! ºݤˤΥ⥸塼Ƿ׻Ƥʪϰʲ̤Ǥ. 
  ! 
  ! * ʰ¿
  ! * ľȻ (Mellor and Yamada, 1974, ٥ 2)
  ! * ɽեå (Х륯ˡ)
  ! * ήĴ (Manabe et al., 1965)
  ! * ήĴ, 
  ! * Ƿ絬϶ŷ
  !
  ! Physical processes are calculated for calculation of
  ! atmosphere on a planet covered with water globally.
  ! Physical processes calculated in this module is as follows.
  !
  ! * Radiation process represented by band model
  ! * Vertical diffusion
  ! * Surface flux (bulk formulae)
  ! * Moist convective adjustment
  ! * Dry convective adjustment
  ! * Large scale condensation
  !
  !== Procedures List
  !
  ! Create        :: PHYAPE ѿν
  ! PhysicsAPE    :: ʪη׻
  ! Close         :: PHYAPE ѿνλ
  ! PutLine       :: PHYAPE ѿ˳ǼƤΰ
  ! initialized   :: PHYAPE ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYAPE"
  ! PhysicsAPE    :: Calculate physical processes
  ! Close         :: Deconstructor of "PHYAPE"
  ! PutLine       :: Print information of "PHYAPE"
  ! initialized   :: Check initialization of "PHYAPE"
  !
  !== Usage
  !
  ! ץλϤ, PHYAPE ѿ Create ǽޤ.
  ! , ʬ롼Ǳ, ȯ, , 漾, ɽ̵ 
  ! ( $ t+\Delta t $ )  PhysicsAPE ͿƤ. 
  ! ͤФʪα黻Ԥޤ.
  ! Ǹ, PHYAPE ѿνλ Close ˤƹԤޤ.
  !
  ! In the begging of program, initialize "PHYAPE" by "Create".
  ! Next, in the time integration loop, 
  ! provide vorticity, divergence, temperature, specific humidity, 
  ! surface pressure on $ t+\Delta t $ to PhysicsAPE. 
  ! Physical processes are calculate about the values.
  ! Finally, terminate "PHYAPE" by "Close".
  !

  use dc_types, only: DP, TOKEN, STRING
  use dc_date_types, only: DC_DIFFTIME
  use phy_ground, only: PHYGRD
  use phy_interpolate, only: PHYINTPOL 
  use phy_neg_moist, only: PHYNEGMST 
  use phy_cumulus_adjust, only: PHYCUMAD 
  use phy_lscond, only: PHYLSC 
  use phy_implicit, only: PHYIMPL 
  use phy_radiation_flux, only: PHYRADFLX 
  use phy_verdiff, only: PHYVDIF 
  use phy_surface_flux, only: PHYSURFFLX
  use phy_dryconv_adjust, only: PHYDRYCONV
  use gt4_history, only: GT_HISTORY

  implicit none
  private
  public:: PHYAPE, Create, Close, PutLine, initialized, PhysicsAPE
  public:: PHYAPE_HISTNML

  type PHYAPE
    !
    ! ޤ, Create  "PHYAPE" ѿꤷƲ.
    ! ꤵ줿 "PHYAPE" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYAPE" variable by "Create" before usage.
    ! If you reuse "PHYAPE" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag

    !-----------------------------------------------------------------
    !  ʻȿ
    !  Grid points and maximum truncated wavenumber
    !-----------------------------------------------------------------
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    !-----------------------------------------------------------------
    !  ǡ
    !  Axes data
    !-----------------------------------------------------------------
    real(DP), pointer:: x_Lon (:) =>null()
                              ! . Longitude
    real(DP), pointer:: x_Lon_Weight(:) =>null()
                              ! ٺɸŤ. 
                              ! Weight of longitude
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: y_Lat_Weight(:) =>null()
                              ! ٺɸŤ. 
                              ! Weight of latitude
    real(DP), pointer:: z_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), pointer:: r_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

    !-----------------------------------------------------------------
    !  
    !  Coefficients
    !-----------------------------------------------------------------
    real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
    type(DC_DIFFTIME):: current_time
                              ! ߻. Current time.
    type(DC_DIFFTIME):: delta_time
                              ! $ \Delta t $ . ॹƥå. Time step

    !-----------------------------------------------------------------
    !  ̥⥸塼ι¤ǡ
    !  Derived data type of lower modules
    !-----------------------------------------------------------------
    type(PHYGRD):: phy_grd
    type(PHYINTPOL):: phy_intpol
    type(PHYNEGMST):: phy_neg_mst
    type(PHYCUMAD):: phy_cumad
    type(PHYLSC):: phy_lsc
    type(PHYIMPL):: phy_impl
    type(PHYRADFLX):: phy_radflx
    type(PHYVDIF):: phy_vdif
    type(PHYSURFFLX):: phy_surfflx
    type(PHYDRYCONV):: phy_dryconv

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------
    character(TOKEN), pointer:: history_varlist_array(:) =>null()
                              ! ҥȥǡνѿꥹ. 
                              ! List of variables output to history data. 
    character(STRING):: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames

    type(PHYAPE_HISTNML), pointer:: hist_nml(:) =>null()
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              !  1 ܤˤϥǥեȤ꤬Ǽ
                              ! , 2 ܰʹߤ˸̤꤬Ǽ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml". 
                              ! Default settings are stored in 
                              ! the first element of this array, 
                              ! and individual settings are stored in 
                              ! the second or more.

    !-----------------------------------
    !  gt4_history ⥸塼ѹ¤
    !  Derived type for "gt4_history" module
    type(GT_HISTORY), pointer:: gthist_surfstressx =>null()
    type(GT_HISTORY), pointer:: gthist_surfstressy =>null()
    type(GT_HISTORY), pointer:: gthist_sensheatflux =>null()
    type(GT_HISTORY), pointer:: gthist_latentheatflux =>null()
    type(GT_HISTORY), pointer:: gthist_rain =>null()
    type(GT_HISTORY), pointer:: gthist_cumrain =>null()
    type(GT_HISTORY), pointer:: gthist_lscrain =>null()
    type(GT_HISTORY), pointer:: gthist_radlflux =>null()
    type(GT_HISTORY), pointer:: gthist_radsflux =>null()
    type(GT_HISTORY), pointer:: gthist_dnegqvapdt =>null()
    type(GT_HISTORY), pointer:: gthist_dlsctempdt =>null()
    type(GT_HISTORY), pointer:: gthist_dlscqvapdt =>null()
    type(GT_HISTORY), pointer:: gthist_dcumtempdt =>null()
    type(GT_HISTORY), pointer:: gthist_dcumqvapdt =>null()
    type(GT_HISTORY), pointer:: gthist_ddrytempdt =>null()
    type(GT_HISTORY), pointer:: gthist_dpsdt =>null()
    type(GT_HISTORY), pointer:: gthist_dradltempdt =>null()
    type(GT_HISTORY), pointer:: gthist_dradstempdt =>null()
    type(GT_HISTORY), pointer:: gthist_dverdiffudt =>null()
    type(GT_HISTORY), pointer:: gthist_dverdiffvdt =>null()
    type(GT_HISTORY), pointer:: gthist_dverdifftempdt =>null()
    type(GT_HISTORY), pointer:: gthist_dverdiffqvapdt =>null()
  end type PHYAPE

  type PHYAPE_HISTNML
    !
    ! NAMELIST#phy_ape_history_nml ǡνϾ
    ! ̤˼뤿ι¤ǡǤ. λȤ
    ! ԤʤǤ. 
    !
    ! This derived type is worked for input information about 
    ! data output individually from 
    ! "NAMELIST#phy_ape_history_nml" 
    ! Do not refer this derived type externally. 
    !
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    character(STRING):: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    type(DC_DIFFTIME):: history_interval_time
                              ! ҥȥǡνϴֳ. 
                              ! Interval of history data output
    real(DP):: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(TOKEN):: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical:: history_average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data.
    logical:: dummy0          ! 8 ӥåȶѤΥߡѿ. 
                              ! Dummy variable for 8 bit boundary
  end type PHYAPE_HISTNML

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: phy_ape.f90,v 1.23 2007/10/12 13:47:32 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface Create
    module procedure PhysApeCreate
  end interface

  interface Close
    module procedure PhysApeClose
  end interface

  interface PutLine
    module procedure PhysApePutLine
  end interface

  interface initialized
    module procedure PhysApeInitialized
  end interface

  interface SetTime
    module procedure PhysApeSetTime
  end interface

  interface PhysicsAPE
    module procedure PhysApePhysicsAPE
  end interface

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface NmlRead
    module procedure PhysApeNmlRead
  end interface

  interface HstSetXYZR
    module procedure PhysApeHstSetXYZR
  end interface

  interface HstNmlAssoc
    module procedure PhysApeHstNmlAssoc
  end interface

!!$  interface Sample
!!$    module procedure PhysApeSample
!!$  end interface

contains

  subroutine PhysApeCreate( phy_ape, &
    & imax, jmax, kmax, &
    & x_Lon, y_Lat, z_Sigma, r_Sigma, &
    & PI, &
    & RAir, Grav, Cp, &
    & EL, RVap, EpsV, ES0, &
    & StB, FKarm, &
    & DelTime, &
    & x_Lon_Weight, y_Lat_Weight, &
    & current_time_value, current_time_unit, &
    & history_varlist, &
    & history_interval_value, history_interval_unit, &
    & history_precision, history_fileprefix, &
    & nmlfile, err )
    !
    ! PHYAPE ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYAPE ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_ape* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_ape_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYAPE".
    ! Initialize *phy_ape* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_ape* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_ape_nml"
    ! for details about a NAMELIST group.
    !
    use phy_ground, only: Create, Get
    use phy_interpolate, only: Create
    use phy_neg_moist, only: Create
    use phy_cumulus_adjust, only: Create
    use phy_lscond, only: Create
    use phy_implicit, only: Create
    use phy_radiation_flux, only: Create
    use phy_verdiff, only: Create
    use phy_surface_flux, only: Create
    use phy_dryconv_adjust, only: Create
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use dc_string, only: Split, StrInclude, StoA
    use dc_date, only: Create
    use gt4_history, only: GT_HISTORY, &
      & HistoryAddVariable, HistoryAddAttr
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: x_Lon (0:imax-1)
                              ! . Longitude
    real(DP), intent(in):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP), intent(in):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(in):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), intent(in):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(in):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(in):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP), intent(in):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP), intent(in):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), intent(in):: FKarm     ! $ k $ .                 ޥ.   Karman constant
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in), optional:: x_Lon_Weight(0:imax-1)
                   ! ٺɸŤ. 
                   ! Weight of longitude
    real(DP), intent(in), optional:: y_Lat_Weight(0:jmax-1)
                   ! ٺɸŤ. 
                   ! Weight of latitude
    real(DP), intent(in), optional:: current_time_value
                              ! ߻ο. Numerical value of current time
    character(*), intent(in), optional:: current_time_unit
                              ! ߻ñ. Unit of current time
    character(*), intent(in), optional:: history_varlist
                              ! ҥȥǡνѿꥹ. 
                              ! ޤǶڤä¤٤. 
                              ! (: "Rain,RadLFlux,RadSFlux" ). 
                              ! 
                              ! List of variables output to history data. 
                              ! Delimiter is comma. 
                              ! (exp. "Rain,RadLFlux,RadSFlux" ). 
                              ! 
    real(DP), intent(in), optional:: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(*), intent(in), optional:: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(in), optional:: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    character(*), intent(in), optional:: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_ape_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_ape_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ɽ̥ǡ
    !  Data on surface
    real(DP):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP):: xy_SurfAlbedo (0:imax-1, 0:jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP):: xy_SurfHumidCoeff (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP):: xy_SurfRoughLength (0:imax-1, 0:jmax-1)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP):: xy_SurfHeatCapacity (0:imax-1, 0:jmax-1)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP):: xy_GroundTempFlux (0:imax-1, 0:jmax-1)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer:: xy_SurfCondition (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface condition

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(PHYAPE_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ.  
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml" 
    character(STRING):: history_filename
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    character(STRING):: history_varlist_work
    type(GT_HISTORY), pointer:: history_work =>null()
                              ! gt4_history ⥸塼ѹ¤. 
                              ! Derived type for "gt4_history" module
    character(TOKEN):: xdim
                              ! ٤̾. Name of longitude
    character(TOKEN):: ydim
                              ! ٤̾. Name of latitude
    character(TOKEN):: zdim
                              ! $ \sigma $ ٥ () ̾.  
                              ! Name of full $ \sigma $ level
    character(TOKEN):: rdim
                              ! $ \sigma $ ٥ (Ⱦ) ̾. 
                              ! Name of half $ \sigma $ level
    character(TOKEN):: timedim
                              ! ̾. Name of time

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApeCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_ape % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    phy_ape % imax = imax
    phy_ape % jmax = jmax
    phy_ape % kmax = kmax

    !-----------------------------------------------------------------
    !  ɸ
    !  Configure axes
    !-----------------------------------------------------------------
    allocate( phy_ape % x_Lon (0:imax-1) )
    phy_ape % x_Lon = x_Lon

    allocate( phy_ape % x_Lon_Weight (0:imax-1) )
    if ( present(x_Lon_Weight) ) then
      phy_ape % x_Lon_Weight = x_Lon_Weight
    else
      phy_ape % x_Lon_Weight = 2.0_DP * PI / imax
    end if

    allocate( phy_ape % y_Lat (0:jmax-1) )
    phy_ape % y_Lat = y_Lat

    allocate( phy_ape % y_Lat_Weight (0:jmax-1) )
    if ( present(y_Lat_Weight) ) then
      phy_ape % y_Lat_Weight = y_Lat_Weight
    else
      phy_ape % y_Lat_Weight = 2.0_DP / jmax
    end if

    allocate( phy_ape % z_Sigma (0:kmax-1) )
    phy_ape % z_Sigma = z_Sigma

    allocate( phy_ape % r_Sigma (0:kmax) )
    phy_ape % r_Sigma = r_Sigma

    !-----------------------------------------------------------------
    !  
    !  Configure constants
    !-----------------------------------------------------------------
    phy_ape % PI = PI

    !-----------------------------------------------------------------
    !  $ \Delta t $ 
    !  Configure $ \Delta t $
    !-----------------------------------------------------------------
    phy_ape % DelTime = DelTime

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
    if ( present(current_time_value) .and. present(current_time_unit) ) then
      call Create( &
        & diff = phy_ape % current_time, & ! (out)
        & value = current_time_value, &    ! (in)
        & unit = current_time_unit )       ! (in)
    else
      call Create( &
        & diff = phy_ape % current_time, & ! (out)
        & value = 0.0_DP, &    ! (in)
        & unit = 'sec' )       ! (in)
    end if

    call Create( &
      & diff = phy_ape % delta_time, & ! (out)
      & value = DelTime, &             ! (in)
      & unit = 'sec' )                 ! (in)

    !-----------------------------------------------------------------
    !  ɽ
    !  Configure ground condition
    !-----------------------------------------------------------------
    call Create( phy_grd = phy_ape % phy_grd, &  ! (inout)
      & imax = imax, jmax = jmax, &              ! (in)
      & SurfTemp = 273.0_DP, &                   ! (in)
      & SurfAlbedo = 0.15_DP, &                  ! (in)
      & SurfHumidCoeff = 1.0_DP, &               ! (in)
      & SurfRoughLength = 1.0e-4_DP, &           ! (in)
      & SurfHeatCapacity = 0.0_DP, &             ! (in)
      & GroundTempFlux  = 0.0_DP, &              ! (in)
      & SurfCondition = 0, &                     ! (in)
      & nmlfile = nmlfile, &                     ! (in)
      & err = err )                              ! (out)

    call Get( phy_grd = phy_ape % phy_grd, &          ! (inout)
      & xy_SurfTemp         = xy_SurfTemp, &          ! (out)
      & xy_SurfAlbedo       = xy_SurfAlbedo, &        ! (out)
      & xy_SurfHumidCoeff   = xy_SurfHumidCoeff, &    ! (out)
      & xy_SurfRoughLength  = xy_SurfRoughLength, &   ! (out)
      & xy_SurfCondition    = xy_SurfCondition, &     ! (out)
      & xy_SurfHeatCapacity = xy_SurfHeatCapacity, &  ! (out)
      & xy_GroundTempFlux   = xy_GroundTempFlux )     ! (out)

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential
    !-----------------------------------------------------------------
    call Create( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &       ! (in)
      & z_Sigma = z_Sigma, r_Sigma = r_Sigma, &        ! (in)
      & RAir = RAir, Grav = Grav, &                    ! (in)
      & nmlfile = nmlfile, &                           ! (in)
      & err = err )                                    ! (out)

    !-----------------------------------------------------------------
    !  ο
    !  Remove negative moisture
    !-----------------------------------------------------------------
    call Create( phy_neg_mst = phy_ape % phy_neg_mst, &  ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &         ! (in)
      & PI = PI, &                                       ! (in)
      & DelTime = DelTime, &                             ! (in)
      & x_Lon_Weight = x_Lon_Weight, &                   ! (in)
      & y_Lat_Weight = y_Lat_Weight, &                   ! (in)
      & nmlfile = nmlfile, &                             ! (in)
      & err = err )                                      ! (out)

    !-----------------------------------------------------------------
    !   (ѱ)
    !  Moist process (cumulus)
    !-----------------------------------------------------------------
    call Create( phy_cumad = phy_ape % phy_cumad, &  ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &     ! (in)
      & Grav = Grav, Cp = Cp, RAir = RAir, &         ! (in)
      & EL = EL, RVap = RVap, &                      ! (in)
      & EpsV = EpsV, ES0 = ES0, &                    ! (in)
      & DelTime = DelTime, &                         ! (in)
      & nmlfile = nmlfile, &                         ! (in)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !   (絬϶ŷ)
    !  Moist process (large scale condensation)
    !-----------------------------------------------------------------
    call Create( phy_lsc = phy_ape % phy_lsc, &       ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
      & Grav = Grav, Cp = Cp, EL = EL, RVap = RVap, & ! (in)
      & EpsV = EpsV, ES0 = ES0, &                     ! (in)
      & DelTime = DelTime, &                          ! (in)
      & nmlfile = nmlfile, &                          ! (in)
      & err = err )                                   ! (out)

    !-----------------------------------------------------------------
    !  
    !  Initialize implicit matrices
    !-----------------------------------------------------------------
    call Create( phy_impl = phy_ape % phy_impl, &    ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &     ! (in)
      & Grav = Grav, Cp = Cp, EL = EL, &             ! (in)
      & DelTime = DelTime, &                         ! (in)
      & xy_SurfHeatCapacity = xy_SurfHeatCapacity, & ! (in)
      & xy_SurfCondition = xy_SurfCondition, &       ! (in)
      & xy_GroundTempFlux = xy_GroundTempFlux, &     ! (in)
      & nmlfile = nmlfile, &                         ! (in)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !  ͥեå
    !  Radiation flux
    !-----------------------------------------------------------------
    call Create( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
      & y_Lat = y_Lat, &                              ! (in)
      & Grav = Grav, Cp = Cp, StB = StB, &            ! (in)
      & xy_SurfTemp = xy_SurfTemp, &                  ! (in)
      & xy_SurfAlbedo = xy_SurfAlbedo, &              ! (in)
      & current_time_value = current_time_value, &    ! (in)
      & current_time_unit = current_time_unit, &      ! (in)
      & delta_time_value = DelTime, &                 ! (in)
      & delta_time_unit = 'sec', &                    ! (in)
      & delta_time_value_RadLong = 3.0_DP, &          ! (in)
      & delta_time_unit_RadLong = 'hour', &           ! (in)
      & delta_time_value_RadShort = 1.0_DP, &         ! (in)
      & delta_time_unit_RadShort = 'hour', &          ! (in)
      & nmlfile = nmlfile, &                          ! (in)
      & err = err )                                   ! (out)

    !-----------------------------------------------------------------
    !  ľȻեå
    !  Vertical diffusion flux
    !-----------------------------------------------------------------
    call Create( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &  ! (in)
      & RAir = RAir, Cp = Cp, Grav = Grav, &      ! (in)
      & EL = EL, FKarm = FKarm, &                 ! (in)
      & nmlfile = nmlfile, &                      ! (in)
      & err = err )                               ! (out)

    !-----------------------------------------------------------------
    !  ɽ̥եå
    !  Surface flux
    !-----------------------------------------------------------------
    call Create( phy_surfflx = phy_ape % phy_surfflx, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &        ! (in)
      & RAir = RAir, Cp = Cp, Grav = Grav, EL = EL, &   ! (in)
      & ES0 = ES0, RVap = RVap, EpsV = EpsV, &          ! (in)
      & FKarm = FKarm, &                                ! (in)
      & xy_SurfTemp = xy_SurfTemp, &                    ! (in)
      & xy_SurfHumidCoeff = xy_SurfHumidCoeff, &        ! (in)
      & xy_SurfRoughLength = xy_SurfRoughLength, &      ! (in)
      & xy_SurfCondition = xy_SurfCondition, &          ! (in)
      & nmlfile = nmlfile, &                            ! (in)
      & err = err )                                     ! (out)

    !-----------------------------------------------------------------
    !  ήĴ
    !  Dry convective adjustment
    !-----------------------------------------------------------------
    call Create( phy_dryconv = phy_ape % phy_dryconv, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &        ! (in)
      & RAir = RAir, Cp = Cp, &                         ! (in)
      & DelTime = DelTime, &                            ! (in)
      & nmlfile = nmlfile, &                            ! (in)
      & err = err )                                     ! (out)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------
    if ( associated( phy_ape % hist_nml ) ) deallocate( phy_ape % hist_nml )
    allocate( phy_ape % hist_nml(1) )

    !-------------------------
    !  ǥե
    !  Default values
    history_varlist_work             = ''
    phy_ape % history_fileprefix = ''
    phy_ape % hist_nml(1) % name = ''
    phy_ape % hist_nml(1) % file = ''
    phy_ape % hist_nml(1) % history_interval_value = -1.0_DP
    phy_ape % hist_nml(1) % history_interval_unit  = 'sec'
    phy_ape % hist_nml(1) % history_precision      = 'float'
    phy_ape % hist_nml(1) % history_average        = .false.

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    if ( present(history_varlist)        ) history_varlist_work                               = history_varlist       
    if ( present(history_fileprefix)     ) phy_ape % history_fileprefix                   = history_fileprefix    
    if ( present(history_interval_value) ) phy_ape % hist_nml(1) % history_interval_value = history_interval_value
    if ( present(history_interval_unit)  ) phy_ape % hist_nml(1) % history_interval_unit  = history_interval_unit 
    if ( present(history_precision)      ) phy_ape % hist_nml(1) % history_precision      = history_precision     

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &      ! (in)
        & history_varlist_    = history_varlist_work, &             ! (inout)
        & history_fileprefix_ = phy_ape % history_fileprefix, & ! (inout)
        & hist_nml            = phy_ape % hist_nml, &           ! (inout)
        & err = err )                          ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  ҥȥ꡼ǡ˴ؤ
    !  Time control for history data
    !-----------------------------------------------------------------
    call Create( &
      & diff = phy_ape % hist_nml(1) % history_interval_time, & ! (out)
      & value = phy_ape % hist_nml(1) % history_interval_value, & ! (in)
      & unit = phy_ape % hist_nml(1) % history_interval_unit )    ! (in)

    !-----------------------------------------------------------------
    !  롼 HstSetXYZR ˤե
    !  Files are created by internal subroutine "HstSetXYZR"
    !-----------------------------------------------------------------
    call Split( &
      & str = history_varlist_work, sep = ',', &   ! (in)
      & carray = phy_ape % history_varlist_array ) ! (out)

    !-------------------------
    !  xyr_UFlux ν
    !  Configure the settings for "xyr_UFlux" output
    name = 'SurfStressX'
    history_filename = trim(phy_ape % history_fileprefix) // 'SurfStressX.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_surfstressx => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_surfstressx, & ! (inout)
        & varname = 'SurfStressX', &             ! (in)
        & dims = StoA(xdim, ydim, rdim, timedim), & ! (in)
        & longname = 'surface stress(x)', &          ! (in)
        & units = 'N/m**2', &                       ! (in)
        & xtype = hptr % history_precision )        ! (in)

    end if

    !-------------------------
    !  xyr_VFlux ν
    !  Configure the settings for "xyr_VFlux" output
    name = 'SurfStressY'
    history_filename = trim(phy_ape % history_fileprefix) // 'SurfStressY.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_surfstressy => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_surfstressy, & ! (inout)
        & varname = 'SurfStressY', &             ! (in)
        & dims = StoA(xdim, ydim, rdim, timedim), & ! (in)
        & longname = 'surface stress(y)', &          ! (in)
        & units = 'N/m**2', &                       ! (in)
        & xtype = hptr % history_precision )        ! (in)

    end if

    !-------------------------
    !  xyr_TempFlux ν
    !  Configure the settings for "xyr_TempFlux" output
    name = 'SensHeatFlux'
    history_filename = trim(phy_ape % history_fileprefix) // 'SensHeatFlux.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_sensheatflux => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_sensheatflux, & ! (inout)
        & varname = 'SensHeatFlux', &             ! (in)
        & dims = StoA(xdim, ydim, rdim, timedim), & ! (in)
        & longname = 'sensible heat flux', &          ! (in)
        & units = 'W/m**2', &                       ! (in)
        & xtype = hptr % history_precision )        ! (in)

    end if

    !-------------------------
    !  xyr_QVapFlux ν
    !  Configure the settings for "xyr_QVapFlux" output
    name = 'LatentHeatFlux'
    history_filename = trim(phy_ape % history_fileprefix) // 'LatentHeatFlux.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_latentheatflux => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_latentheatflux, & ! (inout)
        & varname = 'LatentHeatFlux', &             ! (in)
        & dims = StoA(xdim, ydim, rdim, timedim), & ! (in)
        & longname = 'latent heat flux', &          ! (in)
        & units = 'W/m**2', &                       ! (in)
        & xtype = hptr % history_precision )        ! (in)

    end if

    !-------------------------
    !  xy_LscRain + xy_CumulusRain ν
    !  Configure the settings for "xy_LscRain + xy_CumulusRain" output
    name = 'Rain'
    history_filename = trim(phy_ape % history_fileprefix) // 'Rain.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_rain => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_rain, &    ! (inout)
        & varname = 'Rain', &                   ! (in)
        & dims = StoA(xdim, ydim, timedim), &   ! (in)
        & longname = 'precipitation', &         ! (in)
        & units = 'W/m**2', &                   ! (in)
        & xtype = hptr % history_precision )    ! (in)

    end if

    !-------------------------
    !  xy_CumulusRain ν
    !  Configure the settings for "xy_CumulusRain" output
    name = 'CumulusRain'
    history_filename = trim(phy_ape % history_fileprefix) // 'CumulusRain.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_cumrain => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_cumrain, &         ! (inout)
        & varname = 'CumulusRain', &                    ! (in)
        & dims = StoA(xdim, ydim, timedim), &           ! (in)
        & longname = 'precipitation by cumulus scheme', & ! (in)
        & units = 'W/m**2', &                           ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xy_LscRain ν
    !  Configure the settings for "xy_LscRain" output
    name = 'LscRain'
    history_filename = trim(phy_ape % history_fileprefix) // 'LscRain.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_lscrain => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_lscrain, &        ! (inout)
        & varname = 'LscRain', &                    ! (in)
        & dims = StoA(xdim, ydim, timedim), &           ! (in)
        & longname = 'precipitation by large scale condensation', & ! (in)
        & units = 'W/m**2', &                           ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyr_RadLFlux ν
    !  Configure the settings for "xyr_RadLFlux" output
    name = 'RadLFlux'
    history_filename = trim(phy_ape % history_fileprefix) // 'RadLFlux.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_radlflux => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_radlflux, &        ! (inout)
        & varname = 'RadLFlux', &                       ! (in)
        & dims = StoA(xdim, ydim, rdim, timedim), &     ! (in)
        & longname = 'longwave flux', &                 ! (in)
        & units = 'W/m**2', &                           ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyr_RadSFlux ν
    !  Configure the settings for "xyr_RadSFlux" output
    name = 'RadSFlux'
    history_filename = trim(phy_ape % history_fileprefix) // 'RadSFlux.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_radsflux => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_radsflux, &        ! (inout)
        & varname = 'RadSFlux', &                       ! (in)
        & dims = StoA(xdim, ydim, rdim, timedim), &     ! (in)
        & longname = 'shortwave flux', &               ! (in)
        & units = '1', &                                ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyz_DNegQVap1Dt, xyz_DNegQVap2Dt ν
    !  Configure the settings for "xyz_DNegQVap1Dt", "xyz_DNegQVap2Dt" output
    name = 'DNegQVapDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DNegQVapDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dnegqvapdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dnegqvapdt, &  ! (inout)
        & varname = 'DNegQVapDt', &                 ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), & ! (in)
        & longname = 'remove negative moist', &     ! (in)
        & units = '1/s', &                          ! (in)
        & xtype = hptr % history_precision )        ! (in)
    end if

    !-------------------------
    !  xyz_DLscTempDt ν
    !  Configure the settings for "xyz_DLscTempDt" output
    name = 'DLscTempDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DLscTempDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dlsctempdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dlsctempdt, &  ! (inout)
        & varname = 'DLscTempDt', &                 ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), & ! (in)
        & longname = 'condensation heating', &      ! (in)
        & units = 'K/s', &                          ! (in)
        & xtype = hptr % history_precision )        ! (in)
    end if

    !-------------------------
    !  xyz_DLscQVapDt ν
    !  Configure the settings for "xyz_DLscQVapDt" output
    name = 'DLscQVapDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DLscQVapDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dlscqvapdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dlscqvapdt, &  ! (inout)
        & varname = 'DLscQVapDt', &                 ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), & ! (in)
        & longname = 'condensation moistning', &    ! (in)
        & units = '1/s', &                          ! (in)
        & xtype = hptr % history_precision )        ! (in)
    end if

    !-------------------------
    !  xyz_DCumulusTempDt ν
    !  Configure the settings for "xyz_DCumulusTempDt" output
    name = 'DCumulusTempDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DCumulusTempDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dcumtempdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dcumtempdt, &   ! (inout)
        & varname = 'DCumulusTempDt', &              ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), &  ! (in)
        & longname = 'cumulus heating', &            ! (in)
        & units = 'K/s', &                           ! (in)
        & xtype = hptr % history_precision )         ! (in)
    end if

    !-------------------------
    !  xyz_DCumulusQVapDt ν
    !  Configure the settings for "xyz_DCumulusQVapDt" output
    name = 'DCumulusQVapDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DCumulusQVapDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dcumqvapdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dcumqvapdt, &  ! (inout)
        & varname = 'DCumulusQVapDt', &             ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), & ! (in)
        & longname = 'cumulus moistning', &         ! (in)
        & units = '1/s', &                          ! (in)
        & xtype = hptr % history_precision )        ! (in)
    end if

    !-------------------------
    !  xyz_DDryTempDt ν
    !  Configure the settings for "xyz_DDryTempDt" output
    name = 'DDryTempDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DDryTempDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_ddrytempdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_ddrytempdt, &        ! (inout)
        & varname = 'DDryTempDt', &                     ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), &    ! (in)
        & longname = 'temperature tendency by dry convective adjustment', &    ! (in)
        & units = 'K/s', &                                ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xy_DPsDt ν
    !  Configure the settings for "xy_DPsDt" output
    name = 'DPsDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DPsDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dpsdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dpsdt, &        ! (inout)
        & varname = 'DPsDt', &                     ! (in)
        & dims = StoA(xdim, ydim, timedim), &   ! (in)
        & longname = 'surface pressure tendency', &    ! (in)
        & units = 'Pa/s', &                                ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyz_DRadLTempDt ν
    !  Configure the settings for "xyz_DRadLTempDt" output
    name = 'DRadLTempDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DRadLTempDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dradltempdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dradltempdt, & ! (inout)
        & varname = 'DRadLTempDt', &                ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), & ! (in)
        & longname = 'longwave heating', &          ! (in)
        & units = 'K/s', &                          ! (in)
        & xtype = hptr % history_precision )        ! (in)
    end if

    !-------------------------
    !  xyz_DRadSTempDt ν
    !  Configure the settings for "xyz_DRadSTempDt" output
    name = 'DRadSTempDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DRadSTempDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dradstempdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dradstempdt, & ! (inout)
        & varname = 'DRadSTempDt', &                ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), & ! (in)
        & longname = 'shortwave heating', &         ! (in)
        & units = 'K/s', &                          ! (in)
        & xtype = hptr % history_precision )        ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffUDt ν
    !  Configure the settings for "xyz_DVerdiffUDt" output
    name = 'DVerdiffUDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DVerdiffUDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dverdiffudt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dverdiffudt, &        ! (inout)
        & varname = 'DVerdiffUDt', &                     ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), &    ! (in)
        & longname = 'diffusive force(x)', &    ! (in)
        & units = 'm/s**2', &                                ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffVDt ν
    !  Configure the settings for "xyz_DVerdiffVDt" output
    name = 'DVerdiffVDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DVerdiffVDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dverdiffvdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dverdiffvdt, &        ! (inout)
        & varname = 'DVerdiffVDt', &                     ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), &    ! (in)
        & longname = 'diffusive force(y)', &    ! (in)
        & units = 'm/s**2', &                                ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffTempDt ν
    !  Configure the settings for "xyz_DVerdiffTempDt" output
    name = 'DVerdiffTempDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DVerdiffTempDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dverdifftempdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dverdifftempdt, &  ! (inout)
        & varname = 'DVerdiffTempDt', &                 ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), &     ! (in)
        & longname = 'diffusive heating', &             ! (in)
        & units = 'K/s', &                              ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffQVapDt ν
    !  Configure the settings for "xyz_DVerdiffQVapDt" output
    name = 'DVerdiffQVapDt'
    history_filename = trim(phy_ape % history_fileprefix) // 'DVerdiffQVapDt.nc'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      if ( associated( history_work ) ) nullify( history_work )

      call HstSetXYZR( phy_ape = phy_ape, &       ! (inout)
        & file = history_filename, hptr = hptr, &        ! (in)
        & history = history_work, &                      ! (out)
        & xdim = xdim, ydim = ydim, &                    ! (out)
        & zdim = zdim, rdim = rdim, timedim = timedim, & ! (out)
        & err = err )                                    ! (out)

      phy_ape % gthist_dverdiffqvapdt => history_work
      nullify( history_work )

      call HistoryAddVariable( &
        & history = phy_ape % gthist_dverdiffqvapdt, &        ! (inout)
        & varname = 'DVerdiffQVapDt', &                     ! (in)
        & dims = StoA(xdim, ydim, zdim, timedim), &    ! (in)
        & longname = 'diffusive moistning', &    ! (in)
        & units = '1/s', &                                ! (in)
        & xtype = hptr % history_precision )            ! (in)
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_ape % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeCreate

  subroutine PhysApeClose( phy_ape, err )
    !
    ! PHYAPE ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYAPE".
    ! Note that if *phy_ape* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use phy_ground, only: Close
    use phy_interpolate, only: Close
    use phy_neg_moist, only: Close
    use phy_cumulus_adjust, only: Close
    use phy_lscond, only: Close
    use phy_implicit, only: Close
    use phy_radiation_flux, only: Close
    use phy_verdiff, only: Close
    use phy_surface_flux, only: Close
    use phy_dryconv_adjust, only: Close
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Split, StrInclude
    use gt4_history, only: HistoryClose
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(PHYAPE_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ.  
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml" 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApeClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_ape % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ɽ
    !  Configure ground condition
    !-----------------------------------------------------------------
    call Close( phy_grd = phy_ape % phy_grd, &  ! (inout)
      & err = err )                             ! (out)

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential
    !-----------------------------------------------------------------
    call Close( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & err = err )                                   ! (out)

    !-----------------------------------------------------------------
    !  ο
    !  Remove negative moisture
    !-----------------------------------------------------------------
    call Close( phy_neg_mst = phy_ape % phy_neg_mst, &  ! (inout)
      & err = err )                                     ! (out)

    !-----------------------------------------------------------------
    !   (ѱ)
    !  Moist process (cumulus)
    !-----------------------------------------------------------------
    call Close( phy_cumad = phy_ape % phy_cumad, &  ! (inout)
      & err = err )                                 ! (out)

    !-----------------------------------------------------------------
    !   (絬϶ŷ)
    !  Moist process (large scale condensation)
    !-----------------------------------------------------------------
    call Close( phy_lsc = phy_ape % phy_lsc, & ! (inout)
      & err = err )                            ! (out)

    !-----------------------------------------------------------------
    !  
    !  Initialize implicit matrices
    !-----------------------------------------------------------------
    call Close( phy_impl = phy_ape % phy_impl, &    ! (inout)
      & err = err )                                 ! (out)

    !-----------------------------------------------------------------
    !  ͥեå
    !  Radiation flux
    !-----------------------------------------------------------------
    call Close( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !  ľȻեå
    !  Vertical diffusion flux
    !-----------------------------------------------------------------
    call Close( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  ɽ̥եå
    !  Surface flux
    !-----------------------------------------------------------------
    call Close( phy_surfflx = phy_ape % phy_surfflx, & ! (inout)
      & err = err )                                    ! (out)

    !-----------------------------------------------------------------
    !  ήĴ
    !  Dry convective adjustment
    !-----------------------------------------------------------------
    call Close( phy_dryconv = phy_ape % phy_dryconv, &   ! (inout)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡϤνλ
    !  Terminate the settings for history data output
    !-----------------------------------------------------------------

    !-------------------------
    !  xyr_UFlux νϤνλ
    !  Terminate the settings for "xyr_UFlux" output
    name = 'SurfStressX'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_surfstressx )         ! (inout)
    end if

    !-------------------------
    !  xyr_VFlux νϤνλ
    !  Terminate the settings for "xyr_VFlux" output
    name = 'SurfStressY'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_surfstressy )         ! (inout)
    end if

    !-------------------------
    !  xyr_TempFlux νϤνλ
    !  Terminate the settings for "xyr_TempFlux" output
    name = 'SensHeatFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_sensheatflux )         ! (inout)
    end if

    !-------------------------
    !  xyr_QVapFlux νϤνλ
    !  Terminate the settings for "xyr_QVapFlux" output
    name = 'LatentHeatFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_latentheatflux )         ! (inout)
    end if

    !-------------------------
    !  xy_LscRain + xy_CumulusRain νϤνλ
    !  Terminate the settings for "xy_LscRain + xy_CumulusRain" output
    name = 'Rain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_rain )    ! (inout)
    end if

    !-------------------------
    !  xy_CumulusRain νϤνλ
    !  Terminate the settings for "xy_CumulusRain" output
    name = 'CumulusRain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_cumrain )         ! (inout)
    end if

    !-------------------------
    !  xy_LscRain νϤνλ
    !  Terminate the settings for "xy_LscRain" output
    name = 'LscRain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_lscrain )        ! (inout)
    end if

    !-------------------------
    !  xyr_RadLFlux νϤνλ
    !  Terminate the settings for "xyr_RadLFlux" output
    name = 'RadLFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_radlflux )        ! (inout)
    end if

    !-------------------------
    !  xyr_RadSFlux νϤνλ
    !  Terminate the settings for "xyr_RadSFlux" output
    name = 'RadSFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_radsflux )        ! (inout)
    end if

    !-------------------------
    !  xyz_DNegQVap1Dt, xyz_DNegQVap2Dt νϤνλ
    !  Terminate the settings for "xyz_DNegQVap1Dt", "xyz_DNegQVap2Dt" output
    name = 'DNegQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dnegqvapdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DLscTempDt νϤνλ
    !  Terminate the settings for "xyz_DLscTempDt" output
    name = 'DLscTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dlsctempdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DLscQVapDt νϤνλ
    !  Terminate the settings for "xyz_DLscQVapDt" output
    name = 'DLscQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dlscqvapdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DCumulusTempDt νϤνλ
    !  Terminate the settings for "xyz_DCumulusTempDt" output
    name = 'DCumulusTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dcumtempdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DCumulusQVapDt νϤνλ
    !  Terminate the settings for "xyz_DCumulusQVapDt" output
    name = 'DCumulusQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dcumqvapdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DDryTempDt νϤνλ
    !  Terminate the settings for "xyz_DDryTempDt" output
    name = 'DDryTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_ddrytempdt )        ! (inout)
    end if

    !-------------------------
    !  xy_DPsDt νϤνλ
    !  Terminate the settings for "xy_DPsDt" output
    name = 'DPsDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dpsdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DRadLTempDt νϤνλ
    !  Terminate the settings for "xyz_DRadLTempDt" output
    name = 'DRadLTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dradltempdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DRadSTempDt νϤνλ
    !  Terminate the settings for "xyz_DRadSTempDt" output
    name = 'DRadSTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dradstempdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DVerdiffUDt νϤνλ
    !  Terminate the settings for "xyz_DVerdiffUDt" output
    name = 'DVerdiffUDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dverdiffudt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DVerdiffVDt νϤνλ
    !  Terminate the settings for "xyz_DVerdiffVDt" output
    name = 'DVerdiffVDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dverdiffvdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DVerdiffTempDt νϤνλ
    !  Terminate the settings for "xyz_DVerdiffTempDt" output
    name = 'DVerdiffTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dverdifftempdt )        ! (inout)
    end if

    !-------------------------
    !  xyz_DVerdiffQVapDt νϤνλ
    !  Terminate the settings for "xyz_DVerdiffQVapDt" output
    name = 'DVerdiffQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = phy_ape % gthist_dverdiffqvapdt )        ! (inout)
    end if

    !-----------------------------------------------------------------
    !  ǡγղ
    !  Deallocate axes data
    !-----------------------------------------------------------------
    deallocate( phy_ape % x_Lon )
    deallocate( phy_ape % x_Lon_Weight )
    deallocate( phy_ape % y_Lat )
    deallocate( phy_ape % y_Lat_Weight )
    deallocate( phy_ape % z_Sigma )
    deallocate( phy_ape % r_Sigma )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_ape % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeClose

  subroutine PhysApePutLine( phy_ape, unit, indent, err )
    !
    !  *phy_ape* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_ape*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use phy_ground, only: PutLine
    use phy_interpolate, only: PutLine
    use phy_neg_moist, only: PutLine
    use phy_cumulus_adjust, only: PutLine
    use phy_lscond, only: PutLine
    use phy_implicit, only: PutLine
    use phy_radiation_flux, only: PutLine
    use phy_verdiff, only: PutLine
    use phy_surface_flux, only: PutLine
    use phy_dryconv_adjust, only: PutLine
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(PHYAPE), intent(in):: phy_ape
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    character(*), parameter:: subname = 'PhysApePutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYAPE" ΰ
    !  Print the settings for "PHYAPE"
    !-----------------------------------------------------------------
    if ( phy_ape % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYAPE:: @initialized=%y', &
        & l = (/phy_ape % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_ape % imax, phy_ape % jmax, phy_ape % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @PI=%f @DelTime=%f', &
        & d = (/phy_ape % PI, phy_ape % DelTime/) )

      call PutLine( phy_ape % x_Lon, unit = out_unit, &
        & lbounds = lbound(phy_ape % x_Lon), &
        & ubounds = ubound(phy_ape % x_Lon), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_Lon=' )

      call PutLine( phy_ape % x_Lon_Weight, unit = out_unit, &
        & lbounds = lbound(phy_ape % x_Lon_Weight), &
        & ubounds = ubound(phy_ape % x_Lon_Weight), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_Lon_Weight=' )

      call PutLine( phy_ape % y_Lat, unit = out_unit, &
        & lbounds = lbound(phy_ape % y_Lat), &
        & ubounds = ubound(phy_ape % y_Lat), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat=' )

      call PutLine( phy_ape % y_Lat_Weight, unit = out_unit, &
        & lbounds = lbound(phy_ape % y_Lat_Weight), &
        & ubounds = ubound(phy_ape % y_Lat_Weight), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat_Weight=' )

      call PutLine( phy_ape % z_Sigma, unit = out_unit, &
        & lbounds = lbound(phy_ape % z_Sigma), &
        & ubounds = ubound(phy_ape % z_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_Sigma=' )

      call PutLine( phy_ape % r_Sigma, unit = out_unit, &
        & lbounds = lbound(phy_ape % r_Sigma), &
        & ubounds = ubound(phy_ape % r_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @r_Sigma=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @history_varlist=%c', &
        & c1 = trim( JoinChar(phy_ape % history_varlist_array, ',') ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @history_fileprefix=%c', &
        & c1 = trim(phy_ape % history_fileprefix) )

      hmax = size( phy_ape % hist_nml )

      do i = 1, hmax

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & ' #<PHYAPE_HISTNML:: @name=%c @file=%c', &
          & c1 = trim(phy_ape % hist_nml(i) % name), &
          & c2 = trim(phy_ape % hist_nml(i) % file) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @history_interval_value=%f @history_interval_unit=%c', &
          & d = (/phy_ape % hist_nml(i) % history_interval_value/), &
          & c1 = trim(phy_ape % hist_nml(i) % history_interval_unit) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @history_precision=%c @history_average=%c', &
          & c1 = trim(phy_ape % hist_nml(i) % history_precision), &
          & l = (/ phy_ape % hist_nml(i) % history_average /) )

      end do

      call PutLine( phy_ape % phy_grd, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_intpol, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_neg_mst, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_cumad, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_lsc, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_impl, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_radflx, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_vdif, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_surfflx, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_dryconv, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYAPE:: @initialized=%y>', &
        & l = (/phy_ape % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApePutLine

  logical function PhysApeInitialized( phy_ape ) result(result)
    !
    ! *phy_ape* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_ape* is initialized, .true. is returned.
    ! If *phy_ape* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYAPE), intent(in):: phy_ape
  continue
    result = phy_ape % initialized
  end function PhysApeInitialized

  subroutine PhysApeSetTime( phy_ape, &
    & current_time_value, current_time_unit, &
    & err )
    !
    ! *phy_ape* ФƻԤޤ. 
    !
    ! ҥȥǡ
    ! ϻꤷޤ. ٤Ǥ⤳Υ֥롼Ƥˤ, 
    ! ʸΥҥȥǡˤΥ֥롼ƤӽФ, 
    ! ԤäƤ. 
    ! ޤ, ǡϤ륵֥롼ФƤ 
    ! ץʥ historyput_flag  .true. ͿƤ. 
    !
    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Set time to *phy_ape*. 
    !
    ! The output time of history data are specified. 
    ! Once this subroutine is called, the time of history data must be 
    ! specified by this routine before history data output. 
    ! In additional, give ".true." to an optional argument 
    ! "historyput_flag" of a data output subroutine. 
    !
    ! If *phy_ape* is not initialized by "Create" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_date, only: Create, EvalbyUnit
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gt4_history, only: HistorySetTime
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    real(DP), intent(in):: current_time_value
                              ! ߻ο. Numerical value of current time
    character(*), intent(in):: current_time_unit
                              ! ߻ñ. Unit of current time
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(PHYAPE_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#phy_ape_history_nml" 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    character(*), parameter:: subname = 'PhysApeSetTime'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_ape % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  
    !  Configure time
    !-----------------------------------------------------------------
    call Create( &
      & diff = phy_ape % current_time, & ! (out)
      & value = current_time_value, &    ! (in)
      & unit = current_time_unit )       ! (in)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡλ
    !  Configure the time of history data
    !-----------------------------------------------------------------
    hmax = size( phy_ape % hist_nml )
    do i = 1, hmax
      phy_ape % hist_nml(i) % history_interval_value = - 1.0_DP
      call Create( &
        & diff = phy_ape % hist_nml(i) % history_interval_time, & ! (out)
        & value = phy_ape % hist_nml(i) % history_interval_value, &    ! (in)
        & unit = phy_ape % hist_nml(i) % history_interval_unit )       ! (in)
    end do

    !-------------------------
    !  xyr_UFlux λ
    !  Configure the time of "xyr_UFlux"
    name = 'SurfStressX'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_surfstressx, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyr_VFlux λ
    !  Configure the time of "xyr_VFlux"
    name = 'SurfStressY'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_surfstressy, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyr_TempFlux λ
    !  Configure the time of "xyr_TempFlux"
    name = 'SensHeatFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_sensheatflux, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyr_QVapFlux λ
    !  Configure the time of "xyr_QVapFlux"
    name = 'LatentHeatFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_latentheatflux, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xy_LscRain + xy_CumulusRain λ
    !  Configure the time of "xy_LscRain + xy_CumulusRain"
    name = 'Rain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_rain, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xy_CumulusRain λ
    !  Configure the time of "xy_CumulusRain"
    name = 'CumulusRain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_cumrain, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xy_LscRain λ
    !  Configure the time of "xy_LscRain"
    name = 'LscRain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_lscrain, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyr_RadLFlux λ
    !  Configure the time of "xyr_RadLFlux"
    name = 'RadLFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_radlflux, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyr_RadSFlux λ
    !  Configure the time of "xyr_RadSFlux"
    name = 'RadSFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_radsflux, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DNegQVap1Dt, xyz_DNegQVap2Dt λ
    !  Configure the time of "xyz_DNegQVap1Dt", "xyz_DNegQVap2Dt"
    name = 'DNegQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dnegqvapdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DLscTempDt λ
    !  Configure the time of "xyz_DLscTempDt"
    name = 'DLscTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dlsctempdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DLscQVapDt λ
    !  Configure the time of "xyz_DLscQVapDt"
    name = 'DLscQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dlscqvapdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DCumulusTempDt λ
    !  Configure the time of "xyz_DCumulusTempDt"
    name = 'DCumulusTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dcumtempdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DCumulusQVapDt λ
    !  Configure the time of "xyz_DCumulusQVapDt"
    name = 'DCumulusQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dcumqvapdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DDryTempDt λ
    !  Configure the time of "xyz_DDryTempDt"
    name = 'DDryTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_ddrytempdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xy_DPsDt λ
    !  Configure the time of "xy_DPsDt"
    name = 'DPsDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dpsdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DRadLTempDt λ
    !  Configure the time of "xyz_DRadLTempDt"
    name = 'DRadLTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dradltempdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DRadSTempDt λ
    !  Configure the time of "xyz_DRadSTempDt"
    name = 'DRadSTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dradstempdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffUDt λ
    !  Configure the time of "xyz_DVerdiffUDt"
    name = 'DVerdiffUDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dverdiffudt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffVDt λ
    !  Configure the time of "xyz_DVerdiffVDt"
    name = 'DVerdiffVDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dverdiffvdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffTempDt λ
    !  Configure the time of "xyz_DVerdiffTempDt"
    name = 'DVerdiffTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dverdifftempdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffQVapDt λ
    !  Configure the time of "xyz_DVerdiffQVapDt"
    name = 'DVerdiffQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = phy_ape % gthist_dverdiffqvapdt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( phy_ape % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeSetTime

  subroutine PhysApePhysicsAPE( phy_ape, &
    & xyz_U, xyz_V, xyz_Temp, xy_Ps, xyz_QVap, &
    & historyput_flag, &
    & err )
    !
    ! ͤѱѥ᥿ꥼʤ, Ĥʪ
    ! ׻, Ϳ줿®, , ɽ̵, 漾
    ! ѹ֤ޤ. ܺ٤ phy_ape 򻲾ȤƤ. 
    !
    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Some physical processes (radiation, cumulus parameterization, etc) 
    ! are calculated, and given velocity, temperature, surface pressure, 
    ! specific humidity are changed and returned.
    ! See "phy_ape" for detail.
    !
    ! If *phy_ape* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use phy_interpolate, only: InterpolateTemp, InterpolateGeoPot
    use phy_neg_moist, only: RemoveNegQVap
    use phy_cumulus_adjust, only: Cumulus
    use phy_lscond, only: LScaleCond
    use phy_implicit, only: GetMatrices, Integrate
    use phy_radiation_flux, only: RadiationFlux, RadiationDelTemp
    use phy_verdiff, only: VerticalDiffusion
    use phy_surface_flux, only: SurfaceFlux
    use phy_dryconv_adjust, only: DryConvectAdjust
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: PutLine, Split, StrInclude
    use dc_date, only: EvalSec, EvalByUnit, mod, &
      & operator(*), operator(==), operator(<), operator(/), &
      & operator(+), operator(-)
    use gt4_history, only: HistoryPut
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    real(DP), intent(inout):: xyz_U (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ U $ . ®. Zonal wind
    real(DP), intent(inout):: xyz_V (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ V $ . ®. Meridional wind

    real(DP), intent(inout):: xyz_Temp (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xy_Ps (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure
    real(DP), intent(inout):: xyz_QVap (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ q $ .     漾. Specific humidity

    logical, intent(in), optional:: historyput_flag
                              ! ǡϤΥե饰. 
                              ! SetTime ˤäƻŪ
                              ! ꤷˤ, ΰ
                              ! .true. ޤ .false. ꤹ
                              ! ȤǥǡϤΥ󥪥դ
                              ! Ū˻ꤹɬפޤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! Data output flag. 
                              ! When time is specified by "SetTime", 
                              ! explicit specification of data output 
                              ! on/off by specifying ".true." or ".false." 
                              ! to this argument. 
                              ! Default value is ".false.". 
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  *phy_ape* Ф
    !  Setting values fetched from *phy_ape*
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    !-----------------------------------
    !  ͤ¸ѿ
    !  Variables for saving input value
    real(DP):: xy_PsB (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure

    !-----------------------------------
    !   (٥) ɽ̵ޤǡ
    !  Data interpolated from temperature (full level) and surface pressure
    real(DP):: xyr_Temp (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP):: xyz_Press (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP):: xyr_Press (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP):: xyz_GeoPot (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP):: xyr_GeoPot (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)

    !-----------------------------------
    !  ο˻Ѥ
    !  Values for removal of negative moisture
    real(DP):: xyz_DNegQVap1Dt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 漾ѲΨ (1). 
                              ! Specific humidity tendency (1)
    real(DP):: xyz_DNegQVap2Dt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 漾ѲΨ (2). 
                              ! Specific humidity tendency (2)

    !-----------------------------------
    !   (ѱ) Ƿ׻
    !  Values calculated by moist process (cumulus)
    real(DP):: xy_CumulusRain (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! ѱˤ߿. 
                              ! Precipitation by cumulus scheme
    real(DP):: xyz_DCumulusTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ѱˤ벹ѲΨ. 
                              ! Temperature tendency by cumulus scheme
    real(DP):: xyz_DCumulusQVapDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ѱˤ漾ѲΨ. 
                              ! Specific humidity tendency by cumulus scheme

    !-----------------------------------
    !   (絬϶ŷ) Ƿ׻
    !  Values calculated by moist process (large scale condensation)
    real(DP):: xyz_DLscTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 絬϶ŷˤ벹ѲΨ. 
                              ! Temperature tendency by large scale condensation
    real(DP):: xyz_DLscQVapDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 絬϶ŷˤ漾ѲΨ. 
                              ! Specific humidity tendency by large scale condensation
    real(DP):: xy_LscRain (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! 絬϶ŷˤ߿. 
                              ! Precipitation by large scale condensation

    !-----------------------------------
    !  
    !  Implicit matrices
    real(DP):: xyza_UVMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP):: xyza_TempMatrix  (0:phy_ape%imax-1, 0:phy_ape%jmax-1, -1:phy_ape%kmax-1, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP):: xyza_QVapMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity

    !-----------------------------------
    !  ͥեåǷ׻
    !  Values calculated by radiation flux
    real(DP):: xyr_RadLFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP):: xya_SurfRadLMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
    real(DP):: xyra_DelRadLFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP):: xyr_RadSFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux

    !-----------------------------------
    !  ľȻեåǷ׻
    !  Values calculated by vertical diffusion flux
    real(DP):: xyr_UFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ®եå. 
                              ! Zonal wind flux
    real(DP):: xyr_VFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ®եå. 
                              ! Meridional wind flux
    real(DP):: xyr_TempFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP):: xyr_QVapFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! 漾եå. 
                              ! Specific humidity flux

    !-----------------------------------
    !  ɽ̥եåǷ׻
    !  Values calculated by surface flux
    real(DP):: xy_SurfUVMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP):: xyaa_SurfTempMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP):: xyaa_SurfQVapMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface

    !-----------------------------------
    !  ѲΨη׻ (ˡ)
    !  Calculate tendency (implicit)
    real(DP):: xyz_DVerdiffUDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ʬ ľȻ®. 
                              ! Zonal acceleration by vertical diffusion
    real(DP):: xyz_DVerdiffVDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ʬ ľȻ®. 
                              ! Meridional acceleration by vertical diffusion
    real(DP):: xyz_DVerdiffTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ľȻǮΨ. 
                              ! Temperature tendency by vertical diffusion
    real(DP):: xy_DVerdiffSurfTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! ɽ ľȻǮΨ. 
                              ! Surface temperature tendency by vertical diffusion
    real(DP):: xyz_DVerdiffQVapDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ľȻüΨ. 
                              ! Specific humidity tendency by vertical diffusion

    !-----------------------------------
    !  ѴΨ
    !  Temperature tendency
    real(DP):: xyz_DRadLTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
    real(DP):: xyz_DRadSTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

    !-----------------------------------
    !  ήĴǷ׻
    !  Values calculated by dry convective adjustment
    real(DP):: xyz_DDryTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ήĴˤ벹ѲΨ. 
                              ! Temperature tendency by dry convective adjustment

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(PHYAPE_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ.  
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml" 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApePhysicsAPE'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_ape % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_ape* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_ape*
    !-----------------------------------------------------------------
    kmax = phy_ape % kmax

    DelTime = phy_ape % DelTime

    !-----------------------------------------------------------------
    !  ͤ¸
    !  Save input value
    !-----------------------------------------------------------------
    xy_PsB = xy_Ps

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ (1)
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential (1)
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ٤Ⱦ $ \sigma $ ٥
    !  Interpolate temperature on half $ \sigma $ level
    call InterpolateTemp( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xyz_Temp   = xyz_Temp, &                                ! (in)
      & xyr_Temp   = xyr_Temp, &                                ! (out)
      & err = err )                                             ! (out)

    !-----------------------------------
    !  ȥݥƥ󥷥λ
    !  Calculate pressure and geo-potential
    call InterpolateGeoPot( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xy_Ps      = xy_Ps, &                                     ! (in)
      & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &         ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &        ! (out)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot, &       ! (out)
      & err = err )                                               ! (out)

    !-----------------------------------------------------------------
    !  ο (1)
    !  Remove negative moisture (1)
    !-----------------------------------------------------------------
    xyz_DNegQVap1Dt = 0.0_DP
    call RemoveNegQVap( phy_neg_mst = phy_ape % phy_neg_mst, &   ! (inout)
      & xyr_Press = xyr_Press, &                                 ! (in)
      & xyz_QVap = xyz_QVap, xyz_DNegQVapDt = xyz_DNegQVap1Dt, & ! (inout)
      & err = err )                                              ! (out)

    !-----------------------------------------------------------------
    !   (ѱ)
    !  Moist process (cumulus)
    !-----------------------------------------------------------------
    call Cumulus( phy_cumad = phy_ape % phy_cumad, &     ! (inout)
      & xyz_Temp  = xyz_Temp,   xyz_QVap  = xyz_QVap, &  ! (inout)
      & xyz_Press = xyz_Press,  xyr_Press = xyr_Press, & ! (in)
      & xy_Rain = xy_CumulusRain, &                      ! (out)
      & xyz_DTempDt = xyz_DCumulusTempDt, &              ! (out)
      & xyz_DQVapDt = xyz_DCumulusQVapDt, &              ! (out)
      & err = err )                                      ! (out)

    !-----------------------------------------------------------------
    !   (絬϶ŷ)
    !  Moist process (large scale condensation)
    !-----------------------------------------------------------------
    call LScaleCond( phy_lsc = phy_ape % phy_lsc, &       ! (inout)
      & xyz_Temp  = xyz_Temp,   xyz_QVap  = xyz_QVap, &   ! (inout)
      & xyz_Press = xyz_Press,  xyr_Press = xyr_Press, &  ! (in)
      & xy_Rain = xy_LscRain, &                           ! (out)
      & xyz_DTempDt = xyz_DLscTempDt, &                   ! (out)
      & xyz_DQVapDt = xyz_DLscQVapDt, &                   ! (out)
      & err = err )                                       ! (out)

    !-----------------------------------------------------------------
    !  ο (2)
    !  Remove negative moisture (2)
    !-----------------------------------------------------------------
    call RemoveNegQVap( phy_neg_mst = phy_ape % phy_neg_mst, &   ! (inout)
      & xyr_Press = xyr_Press, &                                 ! (in)
      & xyz_QVap = xyz_QVap, xyz_DNegQVapDt = xyz_DNegQVap1Dt, & ! (inout)
      & err = err )                                              ! (out)

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ (2)
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential (2)
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax - 1
      xy_Ps =   xy_Ps &
        &     + (   xyz_DLscQVapDt(:,:,k) &
        &         + xyz_DCumulusQVapDt(:,:,k) &
        &         + xyz_DNegQVap1Dt(:,:,k)     ) &
        &       * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
        &       * 2.0_DP * DelTime
    end do

    !-----------------------------------
    !  ٤Ⱦ $ \sigma $ ٥
    !  Interpolate temperature on half $ \sigma $ level
    call InterpolateTemp( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xyz_Temp   = xyz_Temp, &                                ! (in)
      & xyr_Temp   = xyr_Temp, &                                ! (out)
      & err = err )                                             ! (out)

    !-----------------------------------
    !  ȥݥƥ󥷥λ
    !  Calculate pressure and geo-potential
    call InterpolateGeoPot( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xy_Ps      = xy_Ps, &                                     ! (in)
      & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &         ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &        ! (out)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot, &       ! (out)
      & err = err )                                               ! (out)

    !-----------------------------------------------------------------
    !  
    !  Create implicit matrices
    !-----------------------------------------------------------------
    call GetMatrices( phy_impl = phy_ape % phy_impl, &              ! (inout)
      & xyr_Press = xyr_Press, &                                    ! (in)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &             ! (out)
      & xyr_TempFlux = xyr_TempFlux, xyr_QVapFlux = xyr_QVapFlux, & ! (out)
      & xyza_UVMatrix = xyza_UVMatrix, &                            ! (out)
      & xyza_TempMatrix = xyza_TempMatrix, &                        ! (out)
      & xyza_QVapMatrix = xyza_QVapMatrix, &                        ! (out)
      & err = err )                                                 ! (out)

    !-----------------------------------------------------------------
    !  ͥեå
    !  Radiation flux
    !-----------------------------------------------------------------
    call RadiationFlux( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & xyz_Temp = xyz_Temp, &                               ! (in)
      & xyz_QVap = xyz_QVap, &                               ! (in)
      & xyr_Press = xyr_Press, &                             ! (in)
      & xyr_RadLFlux = xyr_RadLFlux, &                       ! (out)
      & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &           ! (out)
      & xyra_DelRadLFlux = xyra_DelRadLFlux, &               ! (out)
      & xyr_RadSFlux = xyr_RadSFlux, &                       ! (out)
      & err = err )                                          ! (out)

    !-----------------------------------------------------------------
    !  ľȻեå
    !  Vertical diffusion flux
    !-----------------------------------------------------------------
    call VerticalDiffusion( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & xyz_U    = xyz_U,    xyz_V    = xyz_V, &             ! (in)
      & xyz_Temp = xyz_Temp, xyr_Temp = xyr_Temp, &          ! (in)
      & xyz_QVap = xyz_QVap, &                               ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &   ! (in)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot, &  ! (in)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &      ! (inout)
      & xyr_TempFlux = xyr_TempFlux, &                       ! (inout)
      & xyr_QVapFlux = xyr_QVapFlux, &                       ! (inout)
      & xyza_UVMatrix   = xyza_UVMatrix, &                   ! (inout)
      & xyza_TempMatrix = xyza_TempMatrix, &                 ! (inout)
      & xyza_QVapMatrix = xyza_QVapMatrix, &                 ! (inout)
      & err = err )                                          ! (out)

    !-----------------------------------------------------------------
    !  ɽ̥եå
    !  Surface flux
    !-----------------------------------------------------------------
    call SurfaceFlux( phy_surfflx = phy_ape % phy_surfflx, & ! (inout)
      & xyz_U = xyz_U, xyz_V = xyz_V, &                      ! (in)
      & xyz_Temp = xyz_Temp, xyr_Temp = xyr_Temp, &          ! (in)
      & xyz_QVap = xyz_QVap, &                               ! (in)
      & xyz_Press = xyz_Press, xyr_Press = xyr_Press, &      ! (in)
      & xyz_GeoPot = xyz_GeoPot, &                           ! (in)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &      ! (inout)
      & xyr_TempFlux = xyr_TempFlux, &                       ! (inout)
      & xyr_QVapFlux = xyr_QVapFlux, &                       ! (inout)
      & xy_SurfUVMatrix = xy_SurfUVMatrix, &                 ! (out)
      & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &         ! (out)
      & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix, &         ! (out)
      & err = err )                                          ! (out)

    !-----------------------------------------------------------------
    !  ѲΨη׻ (ˡ)
    !  Calculate tendency (implicit)
    !-----------------------------------------------------------------
    call Integrate( phy_impl = phy_ape % phy_impl, &       ! (inout)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &    ! (in)
      & xyr_TempFlux = xyr_TempFlux, &                     ! (in)
      & xy_SurfRadSFlux = xyr_RadSFlux(:,:,0), &           ! (in)
      & xy_SurfRadLFlux = xyr_RadLFlux(:,:,0), &           ! (in)
      & xyr_QVapFlux = xyr_QVapFlux, &                     ! (in)
      & xyza_UVMatrix = xyza_UVMatrix, &                   ! (in)
      & xyza_TempMatrix = xyza_TempMatrix, &               ! (in)
      & xyza_QVapMatrix = xyza_QVapMatrix, &               ! (in)
      & xy_SurfUVMatrix = xy_SurfUVMatrix, &               ! (in)
      & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &       ! (in)
      & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix, &       ! (in)
      & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &         ! (in)
      & xyz_DVerdiffUDt = xyz_DVerdiffUDt, &               ! (out)
      & xyz_DVerdiffVDt = xyz_DVerdiffVDt, &               ! (out)
      & xyz_DVerdiffTempDt = xyz_DVerdiffTempDt, &         ! (out)
      & xy_DVerdiffSurfTempDt = xy_DVerdiffSurfTempDt, &   ! (out)
      & xyz_DVerdiffQVapDt = xyz_DVerdiffQVapDt, &         ! (out)
      & err = err )                                        ! (out)

    !-----------------------------------------------------------------
    !  եå
    !  Flux correction
    !-----------------------------------------------------------------
    !   dcpam3 ǿǤƳͽ
!!$    call FluxCorrection( phy_impl = phy_ape % phy_impl, &  ! (inout)
!!$      & xyz_DVerdiffUDt = xyz_DVerdiffUDt, &               ! (in)
!!$      & xyz_DVerdiffVDt = xyz_DVerdiffVDt, &               ! (in)
!!$      & xyz_DVerdiffTempDt = xyz_DVerdiffTempDt, &         ! (in)
!!$      & xy_DVerdiffSurfTempDt = xy_DVerdiffSurfTempDt, & ! (in)
!!$      & xyz_DVerdiffQVapDt = xyz_DVerdiffQVapDt, &         ! (in)
!!$      & xyza_UVMatrix = xyza_UVMatrix, &                   ! (in)
!!$      & xyza_TempMatrix = xyza_TempMatrix, &               ! (in)
!!$      & xyza_QVapMatrix = xyza_QVapMatrix, &               ! (in)
!!$      & xy_SurfUVMatrix = xy_SurfUVMatrix, &               ! (in)
!!$      & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &       ! (in)
!!$      & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix, &       ! (in)
!!$      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &    ! (inout)
!!$      & xyr_TempFlux = xyr_TempFlux, &                     ! (inout)
!!$      & xyr_QVapFlux = xyr_QVapFlux )                      ! (inout)

    !-----------------------------------------------------------------
    !  ͤˤ벹ѲΨ
    !  Temperature tendency with radiation
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax
      xyr_RadLFlux(:,:,k) = &
        &   xyr_RadLFlux(:,:,k) &
        & + (   xy_DVerdiffSurfTempDt * xyra_DelRadLFlux(:,:,k,0)   &
        &     + xyz_DVerdiffTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
        &   * 2.0_DP * DelTime
    end do

    !-----------------------------------
    !  ѴΨη׻
    !  Calculate temperature tendency
    call RadiationDelTemp( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & xyr_RadLFlux = xyr_RadLFlux, &                          ! (in)
      & xyr_RadSFlux = xyr_RadSFlux, &                          ! (in)
      & xyr_Press = xyr_Press, &                                ! (in)
      & xyz_DRadLTempDt = xyz_DRadLTempDt, &                    ! (out)
      & xyz_DRadSTempDt = xyz_DRadSTempDt, &                    ! (out)
      & err = err )                                             ! (out)

    !-----------------------------------------------------------------
    !  
    !  Gravity wave drag
    !-----------------------------------------------------------------
    !   AGCM5 ǿǤƳͽ.

    !-----------------------------------------------------------------
    !  Ѳʬ­
    !  Add temperature tendency
    !-----------------------------------------------------------------
    xyz_Temp =   xyz_Temp &
      &        + ( xyz_DRadLTempDt + xyz_DRadSTempDt ) * 2.0_DP * DelTime

    xyz_Temp =   xyz_Temp &
      &        + ( xyz_DVerdiffTempDt ) * 2.0_DP * DelTime

    xyz_QVap =   xyz_QVap &
      &        + ( xyz_DVerdiffQVapDt ) * 2.0_DP * DelTime

    xyz_U =   xyz_U &
      &     + ( xyz_DVerdiffUDt ) * 2.0_DP * DelTime

    xyz_V =   xyz_V &
      &     + ( xyz_DVerdiffVDt ) * 2.0_DP * DelTime

!!$    !  ̤Ƴ. (⥸塼벽Ƥʤ??)
!!$    call physics_integrate_surftemp( & 
!!$      &  xy_SurfTemp, xyr_RadLFlux, xyra_DelRadLFlux, & !(inout)
!!$      &  xy_DVerdiffSurfTempDt, DelTime & !(in)
!!$      &  )

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ (3)
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential (3)
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax - 1
      xy_Ps =   xy_Ps &
        &     + xyz_DVerdiffQVapDt(:,:,k)  &
        &       * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
        &       * 2.0_DP * DelTime
    end do

    !-----------------------------------
    !  ٤Ⱦ $ \sigma $ ٥
    !  Interpolate temperature on half $ \sigma $ level
    call InterpolateTemp( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xyz_Temp   = xyz_Temp, &                                ! (in)
      & xyr_Temp   = xyr_Temp, &                                ! (out)
      & err = err )                                             ! (out)

    !-----------------------------------
    !  ȥݥƥ󥷥λ
    !  Calculate pressure and geo-potential
    call InterpolateGeoPot( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xy_Ps      = xy_Ps, &                                     ! (in)
      & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &         ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &        ! (out)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot, &       ! (out)
      & err = err )                                               ! (out)

    !-----------------------------------------------------------------
    !  ήĴ
    !  Dry convective adjustment
    !-----------------------------------------------------------------
    call DryConvectAdjust( phy_dryconv = phy_ape % phy_dryconv, & ! (inout)
      & xyz_Press = xyz_Press, xyr_Press = xyr_Press, &           ! (in)
      & xyz_Temp = xyz_Temp, &                                    ! (inout)
      & xyz_DDryTempDt = xyz_DDryTempDt, &                        ! (out)
      & err = err )                                               ! (out)

    !-----------------------------------------------------------------
    !  ο (3)
    !  Remove negative moisture (3)
    !-----------------------------------------------------------------
    xyz_DNegQVap2Dt = 0.0_DP
    call RemoveNegQVap( phy_neg_mst = phy_ape % phy_neg_mst, &   ! (inout)
      & xyr_Press = xyr_Press, &                                 ! (in)
      & xyz_QVap = xyz_QVap, xyz_DNegQVapDt = xyz_DNegQVap2Dt, & ! (inout)
      & err = err )                                              ! (out)

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax - 1
       xy_Ps =   xy_Ps &
         &     + xyz_DNegQVap2Dt(:,:,k) &
         &       * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
         &       * 2.0_DP * DelTime
    end do

    !----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  History data output
    !----------------------------------------------------------------

    !-------------------------
    !  xyr_UFlux ν
    !  Output "xyr_UFlux"
    name = 'SurfStressX'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_surfstressx, &         ! (inout)
        & varname = 'SurfStressX', &                 ! (in)
        & array = xyr_UFlux, &                       ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xyr_VFlux ν
    !  Output "xyr_VFlux"
    name = 'SurfStressY'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_surfstressy, &         ! (inout)
        & varname = 'SurfStressY', &                 ! (in)
        & array = xyr_VFlux, &                       ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xyr_TempFlux ν
    !  Output "xyr_TempFlux"
    name = 'SensHeatFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_sensheatflux, &         ! (inout)
        & varname = 'SensHeatFlux', &                 ! (in)
        & array = xyr_TempFlux, &                       ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xyr_QVapFlux ν
    !  Output "xyr_QVapFlux"
    name = 'LatentHeatFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_latentheatflux, &  ! (inout)
        & varname = 'LatentHeatFlux', &                 ! (in)
        & array = xyr_QVapFlux, &                       ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xy_LscRain + xy_CumulusRain ν
    !  Output "xy_LscRain + xy_CumulusRain"
    name = 'Rain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_rain, &     ! (inout)
        & varname = 'Rain', &                    ! (in)
        & array = xy_LscRain + xy_CumulusRain, & ! (in)
        & quiet = .false. )                      ! (in)
    end if

    !-------------------------
    !  xy_CumulusRain ν
    !  Output "xy_CumulusRain"
    name = 'CumulusRain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_cumrain, &         ! (inout)
        & varname = 'CumulusRain', &                    ! (in)
        & array = xy_CumulusRain, &                     ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xy_LscRain ν
    !  Output "xy_LscRain"
    name = 'LscRain'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_lscrain, &        ! (inout)
        & varname = 'LscRain', &                       ! (in)
        & array = xy_LscRain, &                        ! (in)
        & quiet = .false. )                            ! (in)
    end if

    !-------------------------
    !  xyr_RadLFlux ν
    !  Output "xyr_RadLFlux"
    name = 'RadLFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_radlflux, &        ! (inout)
        & varname = 'RadLFlux', &                       ! (in)
        & array = xyr_RadLFlux, &                       ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xyr_RadSFlux ν
    !  Output "xyr_RadSFlux"
    name = 'RadSFlux'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_radsflux, &        ! (inout)
        & varname = 'RadSFlux', &                       ! (in)
        & array = xyr_RadSFlux, &                       ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xyz_DNegQVap1Dt, xyz_DNegQVap2Dt ν
    !  Output "xyz_DNegQVap1Dt", "xyz_DNegQVap2Dt"
    name = 'DNegQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dnegqvapdt, &        ! (inout)
        & varname = 'DNegQVapDt', &                       ! (in)
        & array = xyz_DNegQvap1Dt + xyz_DNegQvap2Dt, &    ! (in)
        & quiet = .false. )                               ! (in)
    end if

    !-------------------------
    !  xyz_DLscTempDt ν
    !  Output "xyz_DLscTempDt"
    name = 'DLscTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dlsctempdt, &        ! (inout)
        & varname = 'DLscTempDt', &                     ! (in)
        & array = xyz_DLscTempDt, &                          ! (in)
        & quiet = .false. )                                  ! (in)
    end if

    !-------------------------
    !  xyz_DLscQVapDt ν
    !  Output "xyz_DLscQVapDt"
    name = 'DLscQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dlscqvapdt, &        ! (inout)
        & varname = 'DLscQVapDt', &                     ! (in)
        & array = xyz_DLscQVapDt, &                       ! (in)
        & quiet = .false. )                               ! (in)
    end if

    !-------------------------
    !  xyz_DCumulusTempDt ν
    !  Output "xyz_DCumulusTempDt"
    name = 'DCumulusTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dcumtempdt, &        ! (inout)
        & varname = 'DCumulusTempDt', &                     ! (in)
        & array = xyz_DCumulusTempDt, &                     ! (in)
        & quiet = .false. )                                 ! (in)
    end if

    !-------------------------
    !  xyz_DCumulusQVapDt ν
    !  Output "xyz_DCumulusQVapDt"
    name = 'DCumulusQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dcumqvapdt, &        ! (inout)
        & varname = 'DCumulusQVapDt', &                     ! (in)
        & array = xyz_DCumulusQVapDt, &                    ! (in)
        & quiet = .false. )                                ! (in)
    end if

    !-------------------------
    !  xyz_DDryTempDt ν
    !  Output "xyz_DDryTempDt"
    name = 'DDryTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_ddrytempdt, &        ! (inout)
        & varname = 'DDryTempDt', &                     ! (in)
        & array = xyz_DDryTempDt, &                     ! (in)
        & quiet = .false. )                             ! (in)
    end if

    !-------------------------
    !  xy_DPsDt ν
    !  Output "xy_DPsDt"
    name = 'DPsDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dpsdt, &        ! (inout)
        & varname = 'DPsDt', &                       ! (in)
        & array = xy_Ps - xy_PsB, &                  ! (in)
        & quiet = .false. )                          ! (in)
    end if

    !-------------------------
    !  xyz_DRadLTempDt ν
    !  Output "xyz_DRadLTempDt"
    name = 'DRadLTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dradltempdt, &        ! (inout)
        & varname = 'DRadLTempDt', &                     ! (in)
        & array = xyz_DRadLTempDt, &                       ! (in)
        & quiet = .false. )                                ! (in)
    end if

    !-------------------------
    !  xyz_DRadSTempDt ν
    !  Output "xyz_DRadSTempDt"
    name = 'DRadSTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dradstempdt, &        ! (inout)
        & varname = 'DRadSTempDt', &                     ! (in)
        & array = xyz_DRadSTempDt, &                      ! (in)
        & quiet = .false. )                               ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffUDt ν
    !  Output "xyz_DVerdiffUDt"
    name = 'DVerdiffUDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dverdiffudt, &        ! (inout)
        & varname = 'DVerdiffUDt', &                     ! (in)
        & array = xyz_DVerdiffUDt, &                       ! (in)
        & quiet = .false. )                                ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffVDt ν
    !  Output "xyz_DVerdiffVDt"
    name = 'DVerdiffVDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dverdiffvdt, &        ! (inout)
        & varname = 'DVerdiffVDt', &                     ! (in)
        & array = xyz_DVerdiffVDt, &                      ! (in)
        & quiet = .false. )                               ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffTempDt ν
    !  Output "xyz_DVerdiffTempDt"
    name = 'DVerdiffTempDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dverdifftempdt, &        ! (inout)
        & varname = 'DVerdiffTempDt', &                     ! (in)
        & array = xyz_DVerdiffTempDt, &                      ! (in)
        & quiet = .false. )                                  ! (in)
    end if

    !-------------------------
    !  xyz_DVerdiffQVapDt ν
    !  Output "xyz_DVerdiffQVapDt"
    name = 'DVerdiffQVapDt'

    call HstNmlAssoc( &
      & hist_nml = phy_ape % hist_nml, & ! (in)
      & name = name, &                   ! (in)
      & hptr = hptr )                    ! (out)

    if ( StrInclude( phy_ape % history_varlist_array, name ) &
      &  .and. &
      &  ( present_and_true( historyput_flag ) &
      &    .or. hptr % history_interval_value > 0.0_DP &
      &    .and. mod( phy_ape % current_time, hptr % history_interval_time) == 0 ) ) then

      call HistoryPut( &
        & history = phy_ape % gthist_dverdiffqvapdt, &        ! (inout)
        & varname = 'DVerdiffQVapDt', &                     ! (in)
        & array = xyz_DVerdiffQVapDt, &                      ! (in)
        & quiet = .false. )                                  ! (in)
    end if

    !-----------------------------------------------------------------
    !  ι
    !  Update time
    !-----------------------------------------------------------------
    phy_ape % current_time = &
      & phy_ape % current_time + phy_ape % delta_time

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApePhysicsAPE

  subroutine PhysApeNmlRead( nmlfile, &
    & history_varlist_, &
    & history_fileprefix_, &
    & hist_nml, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_date, only: Create
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD, DC_ENOASSOC
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    character(*), intent(inout):: history_varlist_
    character(STRING):: history_varlist
                              ! ҥȥǡνѿꥹ. 
                              ! ޤǶڤä¤٤. 
                              ! (: "Data1,Data2" ). 
                              ! 
                              ! List of variables output to history data. 
                              ! Delimiter is comma. 
                              ! (exp. "Data1,Data2" ). 
                              ! 
    character(*), intent(inout):: history_fileprefix_
    character(STRING):: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames
    type(PHYAPE_HISTNML), pointer:: hist_nml(:)
                              ! (inout)
                              ! 
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              !  1 ܤˤϥǥեȤ꤬Ǽ
                              ! , 2 ܰʹߤ˸̤꤬Ǽ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml". 
                              ! Default settings are stored in 
                              ! the first element of this array, 
                              ! and individual settings are stored in 
                              ! the second or more. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_ape_nml/ &
!!$      & param_c
!!$                              ! phy_ape ⥸塼
!!$                              ! NAMELIST ѿ̾.
!!$                              !
!!$                              ! phy_ape#Create Ѥݤ, 
!!$                              ! ץʥ *nmlfile*  NAMELIST 
!!$                              ! ե̾ꤹ뤳Ȥ, Υե뤫
!!$                              !  NAMELIST ѿɤ߹ߤޤ.
!!$                              !
!!$                              ! NAMELIST group name for
!!$                              ! "phy_ape" module.
!!$                              ! 
!!$                              ! If a NAMELIST filename is specified to 
!!$                              ! an optional argument *nmlfile* 
!!$                              ! when "phy_ape#Create" is used, 
!!$                              ! this NAMELIST group is loaded from 
!!$                              ! the file.

    namelist /phy_ape_varlist_nml/ &
      & history_varlist
                              ! phy_ape ⥸塼
                              ! ҥȥǡϥꥹ
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_ape#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! output list of history data of 
                              ! "phy_ape" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_ape#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    character(TOKEN):: name
                              ! ѿ̾. 
                              ! ξˤ, ¾ͤ
                              ! phy_ape ⥸塼ˤ
                              ! ϤǡƤ
                              ! ǥեͤȤʤޤ. 
                              ! 
                              ! Variable name. 
                              ! If blank is given, other values are 
                              ! used as default values of output data 
                              ! in "phy_ape". 
    character(STRING):: file
                              ! ϥե̾. 
                              ! ϥǥեͤȤƤϻѤޤ. 
                              ! *name* ͤꤵƤΤͭǤ. 
                              ! 
                              ! Output file name. 
                              ! This is not used as default value. 
                              ! This value is valid only when *name* is 
                              ! specified. 

    real(DP):: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(TOKEN):: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data

    logical:: history_average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data

    namelist /phy_ape_history_nml/ &
      & name, &
      & file, &
      & history_interval_value, &
      & history_interval_unit, &
      & history_precision, &
      & history_fileprefix, &
      & history_average
                              ! phy_ape ⥸塼Υҥȥǡ
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_ape#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! history data of "phy_ape" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_ape#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(TOKEN):: pos_nml
                              ! NAMELIST ɤ߹߻Υե. 
                              ! File position of NAMELIST read
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    type(PHYAPE_HISTNML), allocatable:: hist_nml_work(:)
    character(*), parameter:: subname = 'PhysApeNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  վ֤γǧ
    !  Check allocation
    !-----------------------------------------------------------------
    if ( .not. associated( hist_nml ) ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    if ( size( hist_nml ) < 1 ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
    history_varlist       = history_varlist_
    history_fileprefix    = history_fileprefix_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------

    !-------------------------
    !  ʤɤμ
    !  Get coefficients etc.
!!$    rewind( unit_nml )
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_ape_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1='phy_ape_nml', c2=trim(nmlfile) )
!!$      write(STDOUT, nml = phy_ape_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1='phy_ape_nml', c2=trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if
!!$
!!$    rewind( unit_nml )

    !-------------------------
    !  ѿꥹȼ
    !  Get list of output variables
    rewind( unit_nml )
    read( unit = unit_nml, & ! (in)
      & nml = phy_ape_varlist_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='phy_ape_varlist_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = phy_ape_varlist_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='phy_ape_varlist_nml', c2=trim(nmlfile), &
        & i = (/iostat_nml/) )
    end if

    !-------------------------
    !  ϥǡθ̾μ
    !  Get individual information of output data
    rewind( unit_nml )
    iostat_nml = 0
    pos_nml = ''
    do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

      name                   = ''
      file                   = ''
      history_interval_value = hist_nml(1) % history_interval_value 
      history_interval_unit  = hist_nml(1) % history_interval_unit  
      history_precision      = hist_nml(1) % history_precision      
      history_average        = hist_nml(1) % history_average        

      read( unit = unit_nml, & ! (in)
        & nml = phy_ape_history_nml, iostat = iostat_nml ) ! (out)
      inquire( unit_nml, &     ! (in)
        & position = pos_nml ) ! (out)

      if ( iostat_nml == 0 ) then
        call MessageNotify( 'M', subname, &
          & 'NAMELIST group "%c" is loaded from "%c".', &
          & c1='phy_ape_history_nml', c2=trim(nmlfile) )
        write(STDOUT, nml = phy_ape_history_nml)

        if ( name == '' ) then
          hist_nml(1) % name                   = name                   
          hist_nml(1) % file                   = ''
          hist_nml(1) % history_interval_value = history_interval_value 
          hist_nml(1) % history_interval_unit  = history_interval_unit  
          hist_nml(1) % history_precision      = history_precision      
          hist_nml(1) % history_average        = history_average        

          call Create( &
            & diff = hist_nml(1) % history_interval_time, & ! (out)
            & value = history_interval_value, &    ! (in)
            & unit = history_interval_unit )       ! (in)

        elseif ( file /= '' ) then
          hmax = size( hist_nml )
          allocate( hist_nml_work(hmax) )
          hist_nml_work = hist_nml
          deallocate( hist_nml )
          allocate( hist_nml(hmax+1) )
          hist_nml(1:hmax) = hist_nml_work
          deallocate( hist_nml_work )

          if ( trim(history_varlist) /= '' ) history_varlist = trim( history_varlist ) // ','
          history_varlist = trim( history_varlist ) // trim(name)

          hist_nml(hmax+1) % name                   = name                   
          hist_nml(hmax+1) % file                   = file                   
          hist_nml(hmax+1) % history_interval_value = history_interval_value 
          hist_nml(hmax+1) % history_interval_unit  = history_interval_unit  
          hist_nml(hmax+1) % history_precision      = history_precision      
          hist_nml(hmax+1) % history_average        = history_average        

          call Create( &
            & diff = hist_nml(hmax+1) % history_interval_time, & ! (out)
            & value = history_interval_value, &    ! (in)
            & unit = history_interval_unit )       ! (in)

        end if

      else
        call MessageNotify( 'W', subname, &
          & 'NAMELIST group "%c" is not found in "%c" any more (iostat=%d).', &
          & c1='phy_ape_history_nml', c2=trim(nmlfile), &
          & i = (/iostat_nml/) )
      end if
    end do

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
    history_varlist_       = history_varlist
    history_fileprefix_    = history_fileprefix

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeNmlRead

  subroutine PhysApeHstNmlAssoc( &
    & name, hist_nml, hptr, &
    & err )
    !
    ! ǡϾ󤬳Ǽ줿ݥ *hist_nml*  
    ! *name* ˳ǡξ *hptr* 礷֤ޤ. 
    !
    ! *hist_nml* դƤʤ, 顼֤ޤ. 
    !
    ! Associate *hptr* to information of data correspond to *name* 
    ! stored in pointer array *hist_nml*, and return it. 
    !
    ! If *hist_nml* is not allocated, error is occured. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOASSOC
    implicit none
    character(*), intent(in):: name
                              ! ѿ̾. Variable name
    type(PHYAPE_HISTNML), pointer:: hist_nml(:)
                              ! (in)
                              ! 
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              !  1 ܤˤϥǥեȤ꤬Ǽ
                              ! , 2 ܰʹߤ˸̤꤬Ǽ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml". 
                              ! Default settings are stored in 
                              ! the first element of this array, 
                              ! and individual settings are stored in 
                              ! the second or more.
    type(PHYAPE_HISTNML), pointer:: hptr
                              ! (out)
                              ! 
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#phy_ape_history_nml" 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    character(*), parameter:: subname = 'PhysApeHstNmlAssoc'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  վ֤γǧ
    !  Check allocation
    !-----------------------------------------------------------------
    if ( .not. associated( hist_nml ) ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    if ( size( hist_nml ) < 1 ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *hist_nml* ˳Ǽ, *name* ˳ǡط
    !  Associate information of data correspond to *name* 
    !  stored in pointer array *hist_nml*
    !-----------------------------------------------------------------
    hmax = size( hist_nml )

    if ( associated(hptr) ) nullify( hptr )
    do i = 1, hmax
      if ( trim(hist_nml(i) % name) == trim(name) ) &
        & hptr => hist_nml(i)
    end do
    if ( .not. associated(hptr) ) hptr => hist_nml(1)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeHstNmlAssoc

  subroutine PhysApeHstSetXYZR( phy_ape, &
    & file, hptr, &
    & history, xdim, ydim, zdim, rdim, timedim, &
    & err )
    !
    ! Υ֥롼ϥ⥸塼⤫νϥǡνԤޤ. 
    ! Ū˻Ѥ뤳ȤꤷƤ뤿, ⥸塼볰
    ! ƤӽФʤǤ. 
    ! 
    ! *file* Ϳ줿̾Υե򥪡ץ, ե ID ʤɤ
    ! Ǽ줿 GT_HISTORY ѿ *history* ֤ޤ. 
    ! *history* ϶֤ˤͿƤ. 
    !
    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! This subroutine initializes settings of data output from this module. 
    ! It is expected that this subroutine is used internally, so 
    ! do not refer from the outside. 
    !
    ! A file with name *file* is opened, and "GT_HISTORY" variable 
    ! *history* that stores file ID etc. is returned. 
    ! Give disassociated *history*. 
    !
    ! If *phy_ape* is not initialized by "Create" yet, 
    ! error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_ENOASSOC
    use dc_date, only: Create, EvalSec, EvalByUnit
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, &
      & HistoryAddAttr
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    character(*), intent(in):: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    type(PHYAPE_HISTNML), pointer:: hptr
                              ! (in)
                              !
                              ! NAMELIST#phy_ape_history_nml 
                              ! ꤵ̤ΥǡϾ.  
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_ape_history_nml" 
    type(GT_HISTORY), pointer:: history
                              ! (out)
                              !
                              ! gt4_history ⥸塼ѹ¤. 
                              ! Derived type for "gt4_history" module
    character(*), intent(out):: xdim
                              ! ٤̾. Name of longitude
    character(*), intent(out):: ydim
                              ! ٤̾. Name of latitude
    character(*), intent(out):: zdim
                              ! $ \sigma $ ٥ () ̾.  
                              ! Name of full $ \sigma $ level
    character(*), intent(out):: rdim
                              ! $ \sigma $ ٥ (Ⱦ) ̾. 
                              ! Name of half $ \sigma $ level
    character(*), intent(out):: timedim
                              ! ̾. Name of time
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApeHstSetXYZR'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  վ֤γǧ
    !  Check allocation
    !-----------------------------------------------------------------
    if ( .not. associated( hptr ) ) then
      stat = DC_ENOASSOC
      cause_c = 'hptr'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ޤǤ˥ץ󤵤줿եΥå
    !  Check already opened files
    !-----------------------------------------------------------------
    ! HistoryInquire ǥե̾פƤ뤳Ȥå
    ! HistoryInquire  hptr ȤӤ, 
    !   origin, interval, ñ̤פ뤳Ȥå
    !
    ! 嵭å̤,  gthist ˷.
    ! եΤߤפ, ʳפʤϥ顼֤. 
    ! ե̾פʤ, Τ褦 allocate Ԥ, 
    ! ꥹȹ¤ˤʤäƤ ***_HISTLIST Ǥ䤷Ƥ餫
    ! Ѥߤѿ˷礹.

    if ( associated( history ) ) nullify( history )
    allocate( history )

    !-----------------------------------------------------------------
    !  ̾Τ
    !  Configure names of axes
    !-----------------------------------------------------------------
    xdim = 'lon'
    ydim = 'lat'
    zdim = 'sig'
    rdim = 'sigm'
    timedim = 'time'

    !-----------------------------------------------------------------
    !  HistoryCreate ˤե
    !  Files are created by "HistoryCreate"
    !-----------------------------------------------------------------
    call HistoryCreate( &
      & history = history, &  ! (out)
      & file = file, &        ! (in)
      & title = 'Aqua planet experiment', &                  ! (in)
      & source = 'dcpam4 : ' // trim(version), &             ! (in)
      & institution = 'GFD Dennou Club', &                   ! (in)
      & dims = StoA(xdim, ydim, zdim, rdim, timedim), &  ! (in)
      & dimsizes = (/phy_ape % imax, phy_ape % jmax, &
      &              phy_ape % kmax, phy_ape % kmax + 1, 0/), & ! (in)
      & longnames = StoA('longitude', 'latitude', &
      &                  'sigma at layer midpoints', &
      &                  'sigma at layer end-points (half level)', &
      &                  'time'), &                           ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1', hptr % history_interval_unit), &  ! (in)
      & origin = real(EvalbyUnit(phy_ape % current_time, &
      &                          hptr % history_interval_unit)), &   ! (in)
      & interval = real(EvalbyUnit(hptr % history_interval_time, &
      &                            hptr % history_interval_unit)) )  ! (in)

    call HistoryAddAttr( &
      & history = history, &                           ! (inout)
      & varname = xdim, attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & history = history, &                           ! (inout)
      & varname = ydim, attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)
    call HistoryAddAttr( &
      & history = history, &                             ! (inout)
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = history, &                             ! (inout)
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = history, &                            ! (inout)
      & varname = 'time', attrname = 'standard_name', & ! (in)
      & value = 'time' )                                ! (in)
    call HistoryAddAttr( &
      & history = history, &                        ! (inout)
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & history = history, &                        ! (inout)
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)

    call HistoryPut( &
      & history = history, &                                ! (inout)
      & varname = xdim, &                                   ! (in)
      & array = phy_ape % x_Lon / phy_ape % PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & history = history, &                                ! (inout)
      & varname = ydim, &                                   ! (in)
      & array = phy_ape % y_Lat / phy_ape % PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & history = history, &                         ! (inout)
      & varname = 'sig', array = phy_ape % z_Sigma ) ! (in)
    call HistoryPut( &
      & history = history, &                          ! (inout)
      & varname = 'sigm', array = phy_ape % r_Sigma ) ! (in)

    call HistoryAddVariable( &
      & history = history, &                                ! (inout)
      & varname = 'lon_weight', &                           ! (in)
      & dims = StoA('lon'), &                               ! (in)
      & longname = 'weight for integration in longitude', & ! (in)
      & units = 'radian', xtype = 'double' )                ! (in)
    call HistoryAddAttr( &
      & history = history, &                            ! (inout)
      & varname = 'lon', attrname = 'gt_calc_weight', & ! (in)
      & value = 'lon_weight' )                          ! (in)
    call HistoryPut( &
      & history = history, &             ! (inout)
      & varname = 'lon_weight', &        ! (in)
      & array = phy_ape % x_Lon_Weight ) ! (in)

    call HistoryAddVariable( &
      & history = history, &                               ! (inout)
      & varname = 'lat_weight', &                          ! (in)
      & dims = StoA('lat'), &                              ! (in)
      & longname = 'weight for integration in latitude', & ! (in)
      & units = 'radian', xtype = 'double' )               ! (in)
    call HistoryAddAttr( &
      & history = history, &                            ! (inout)
      & varname = 'lat', attrname = 'gt_calc_weight', & ! (in)
      & value = 'lat_weight' )                          ! (in)
    call HistoryPut( &
      & history = history, &             ! (inout)
      & varname = 'lat_weight', &        ! (in)
      & array = phy_ape % y_Lat_Weight ) ! (in)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeHstSetXYZR

!!$  subroutine PhysApeSample( phy_ape, err )
!!$    !--
!!$    ! PhysApeSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhysApeSample
!!$    !++
!!$    ! If *phy_ape* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYAPE), intent(inout):: phy_ape
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhysApeSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_ape % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYAPE'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_ape* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_ape*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_ape % param_i
!!$!!$    param_r = phy_ape % param_r
!!$!!$    param_c = phy_ape % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhysApeSample

end module phy_ape
