#---------------------------------------------------------------------
#     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
#---------------------------------------------------------------------
#
#= Template File for "Config.mk", build configuration of dcpam (autoconf)
#
# Authors::   Yasuhiro MORIKAWA, Masaki ISHIWATARI
# Version::   $Id: Config.mk.in,v 1.8 2007/07/30 13:41:16 morikawa Exp $
# Tag Name::  $Name: dcpam4-20070925 $
# Copyright:: Copyright (C) GFD Dennou Club, 2004-2005. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#== Overview
#
# This file is template file to create "Config.mk" by
# autoconf 2.59. Some functions are defined in "aclocal.m4"
# (for example, DC_ARG_WITH).
#
# [JAPANESE]
# Υե Makefile ƤӽФե "Config.mk"
# οեǤ. configure ץȤˤäƤΥե
#  (@ ǰϤޤ줿ѿ) ֤, "Config.mk" ޤ.
# configure  configure.in  aclocal.m4  autoconf ޥɤ
# Ѥ뤳Ȥޤ.
#
############################################################

############################################################
#== for Debian install
#
# [JAPANESE] Debian 󥹥ȡ
#
DESTDIR = 

############################################################
#== Fortran Compiler
#
# [JAPANESE] Fortran ѥ
#
FC=sxf90

# Flags needed when compiled and linked
# [JAPANESE] ѥ󥯻ɬפʥե饰
SYSFFLAGS=-ftrace -I/home/taiki/gatm132/lib/spml-sx8/include -I/home/taiki/gatm132/lib/gt4f90io/include
#SYSFFLAGS=-ftrace -Wf'-pvctl nodivloop noloopchg -O' -I/home/taiki/gatm132/lib/spml-sx8/include -I/home/taiki/gatm132/lib/gt4f90io/include

# Flags needed when linked
# [JAPANESE] 󥯻ɬפʥե饰
SYSLDFLAGS=-ftrace -L/home/taiki/gatm132/lib/spml-sx8/lib -L/home/taiki/gatm132/lib/gt4f90io/lib -L/usr/local/lib -L/home/taiki/gatm132/lib/ispack-sx8/lib
#SYSLDFLAGS=-ftrace -Wf'-pvctl nodivloop noloopchg -O' -L/home/taiki/gatm132/lib/spml-sx8/lib -L/home/taiki/gatm132/lib/gt4f90io/lib -L/usr/local/lib -L/home/taiki/gatm132/lib/ispack-sx8/lib

# Libraries needed when linked
# [JAPANESE] 󥯻ɬפʥ饤֥
SYSLDLIBS= -lspml-sx8 -lgt4f90io -lnetcdf -lisp-sx8

# Linker which includes flags
# [JAPANESE] 󥫥ޥ
LINKF=$(FC) $(FFLAGS) -I$(MODDIR) $(INCLUDES) $(SYSFFLAGS)

# Host type
# [JAPANESE] ۥȥƥΥ
HOST_CPU=x86_64

# Cross-compile
# [JAPANESE] ѥ
CROSS_COMPILING=no

# Information of Modules (std.mod, HP.mod, fqs.mod, intel.d, hitachi.f90)
# [JAPANESE] ⥸塼Ϥ
F90MODTYPE=std.mod

# Flag for module files search path
# [JAPANESE] ⥸塼եؤΥѥꤹ뤿Υե饰
MODPATHFLAG=-I

# Extensions of Module Files (".mod" or ".d" or ".f90")
# [JAPANESE] ⥸塼եγĥ
MODEXT=@MOD@
#
# Extensions of Module Files used when "make clean"
# * if "F90MODTYPE = hitachi.f90", clean nothing.
#
# [JAPANESE]
# make clean ˻Ѥ⥸塼ե
# (F90MODTYPE = hitachi.f90 ΤȤϲäƤϤʤʤ)
#
CLEAN_MODS=*.mod
MODSUFFIX=.mod
MODFILE=`basename $@ .o`$(MODSUFFIX)

############################################################
#== library name lib$(LIBNAME).a
#
# [JAPANESE] 饤֥̾ lib$(LIBNAME).a
#
LIBNAME		= dcpam4
DCPAMLIB	= lib$(LIBNAME).a

############################################################
#== Directory to which the all files are archived
#
# [JAPANESE] ֤ԤΥǥ쥯ȥ
#
DCPAMDIR	= /home/taiki/gatm132/src/dcpam4-20071012-hs94test

MODDIR		= $(DCPAMDIR)/include
LIBDIR		= $(DCPAMDIR)/lib
BINDIR		= $(DCPAMDIR)/bin
DOCDIR		= $(DCPAMDIR)/doc

############################################################
#== Directory to which the all files are installed
#
# [JAPANESE] 󥹥ȡΥǥ쥯ȥ
#
prefix		= /usr/local/lib/dcpam4
exec_prefix	= ${prefix}
dcpam_bin_suffix= 

INSTMODDIR	= $(DESTDIR)${prefix}/include
INSTLIBDIR	= $(DESTDIR)${exec_prefix}/lib
INSTBINDIR	= $(DESTDIR)${exec_prefix}/bin
INSTDOCDIR	= $(DESTDIR)${prefix}/doc

############################################################
#== Maximum number of dimensions of input and output data
#
# If you want to reflect this value to source code,
# move to "src" and do "make clean.rb2f90" before "make".
# You need Ruby.
#
# [JAPANESE] Ϥǡκ缡
#
# , ɤȿǤ뤿ˤ src ʲ˰ư,
# make clean.rb2f90 ¹Ը make ɬפޤ.
# κ, Ruby ɬפˤʤޤ.
#
MAXDIM=7

############################################################
#== Tools for build
#
# [JAPANESE] ӥѤΥġ
#
RUBYSCRIPTDIR	= $(DCPAMDIR)/script
RUBYF90LIB	= $(RUBYSCRIPTDIR)/f90
F90DEPEND	= $(RUBYF90LIB)/f90depend.rb
F90DEPENDOPTS	= -q #-S -v
F90TEMPLATE	= $(RUBYF90LIB)/dcmodel_f90sample_maker.rb

############################################################
#== Settings for test
#
# [JAPANESE] ƥ
#
TESTLOG		= xtest.log

############################################################
#== Set Commands for compile and install source code
#
# Please edit according to your system.
#
# [JAPANESE] ѥ䥤󥹥ȡɬפʥޥɷ
#
# ƥ˹碌ѹƤ.
#
MV         = mv -f
CP         = cp -p
SH         = sh
INSTALL    = install -m 644
INSTALLBIN = install -m 755
INSTALLDIR = install -d -m 755
MKDIR      = mkdir -p
DIRNAME    = dirname
BASENAME   = basename
TOUCH      = touch
RM         = rm
RMDIR      = rmdir
GUNZIP     = gunzip        # decompression  (equal to "gzip -d")
TEE        = tee           # tee command
MAKE       = make        # GNU Make
AR         = sxar          # AR : Library builder specification
ARFLAGS    = cru     # flags of AR
RANLIB     = touch      # generate index to archivea
NCDUMP     = ncdump      # netCDF file dump command

############################################################
#== Set Commands for development
#
# [JAPANESE] ȯѤݤΥޥ
#
TAGS		= etags --regex='/\ *module.*\|\ *interface.*\|\ *type\ .*\|\ *function\ .*\|\ *MODULE.*\|\ *INTERFACE.*\|\ *TYPE\ .*\|\ *FUNCTION\ .*/'



############################################################
#== Set Commands for documentations
#
# [JAPANESE] ɥɬפʥޥ
#
RUBY		= ruby          # for Generation RD documents
RD2		= rd2           # for Generation RD documents
RDOC		= rdoc          # for Generation RDOC documents
RDOCOPTS	= -U --title "DCPAM Reference Manual" \
		  --charset euc-jp --inline-source --ignore-case --all
JLATEX		= platex        # for Generation DVI documents
DVI2PDF		= dvipdfmx      # for Generation PDF documents
DVI2JPS		= dvi2ps        # for Generation PS documents
LPR		= lpr -s        # for Print out

#=== latex2html_jp for Dennou.sty
#
# latex2html_jp+dennou is available from
# http://www.gfd-dennou.org/arch/cc-env/latex2html/SIGEN.htm
#
# [JAPANESE] latex2html_jp+dennnou Ѥݤɬפ
#
# latex2html_jp+dennou ϰʲ URL Ǥޤ.
# http://www.gfd-dennou.org/arch/cc-env/latex2html/SIGEN.htm
#
LATEX2HTML = latex2html
LATEX2HTMLOPTIONS = -no_footnode -local_icons -short_extn \
	-bottom_navigation -no_contents_in_navigation -no_auto_link \
	-up_url $(HREFTOPDIR)/index.htm -up_title $(HREFTOPDIRNAME) \
	-split 3 -show_section_numbers -dir $(TARGETHTMDIR) 
