!= constants ⥸塼Υƥȥץ
!
!= Test program for "constants"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: constants_test.f90,v 1.7 2007/08/03 06:45:22 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! constants ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "constants" module.
! Confirm compilation and execution of this program.
!
program constants_test
  use constants, only: CONST, Create, PutLine, initialized, Get
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'constants_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "constants" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS) :: arg
  type(CONST) :: const0, const1
  logical:: OPT_namelist
  character(STRING):: VAL_namelist
  real(DP):: RPlanet   ! $ a $ .      Ⱦ.       Radius of planet
  real(DP):: Omega     ! $ \Omega $ . ž®.     Angular velocity
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './constants_test [Options]')
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )


  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create(const0, &     ! (inout)
    & Omega = 7.088e-5_DP ) ! (in)
  call AssertEqual( 'Initialization test 1', &
    & answer = .true., check = initialized(const0) )

  call PutLine(const0) ! (in)
  call Get(const0, &                    ! (inout)
    & RPlanet = RPlanet, Omega = Omega) ! (out)

  call AssertEqual( 'Initialization test 2', &
    & answer = 6.371e6_DP, check = RPlanet )

  call AssertEqual( 'Initialization test 3', &
    & answer = 7.088e-5_DP, check = Omega )

  !---------------------------------------------------------
  !  NAMELIST ɤ߹ߥƥ
  !  Loading NAMELIST test
  !---------------------------------------------------------
  call Create(const1, &       ! (inout)
    & Omega = 7.088e-5_DP, &  ! (in)
    & nmlfile = VAL_namelist) ! (in)
  call AssertEqual( 'Loading NAMELIST test 1', &
    & answer = .true., check = initialized(const1) )

  call PutLine(const1) ! (in)
  call Get(const1, &                    ! (inout)
    & RPlanet = RPlanet, Omega = Omega) ! (out)

  call AssertEqual( 'Loading NAMELIST test 2', &
    & answer = 3.371e6_DP, check = RPlanet )

  call AssertEqual( 'Loading NAMELIST test 3', &
    & answer = 4.292e-5_DP, check = Omega )

end program constants_test
