!= phy_lscond ⥸塼Υƥȥץ
!
!= Test program for "phy_lscond"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_lscond_test.f90,v 1.2 2007/09/25 12:35:29 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_lscond ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_lscond" module.
! Confirm compilation and execution of this program.
!

program phy_lscond_test
  use phy_lscond, only: PHYLSC, Create, Close, &
    & PutLine, initialized, LScaleCond
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_lscond_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_lscond" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 12         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
  real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
  real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
  real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q $ .     漾. Specific humidity
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP), allocatable:: xy_LscRain (:,:)
                              ! 絬϶ŷ륹ˤ߿. 
                              ! Precipitation by large scale condensation scheme
  real(DP), allocatable:: xyz_DLscTempDt (:,:,:)
                              ! 絬϶ŷ륹ˤ벹ѲΨ. 
                              ! Temperature tendency by large scale condensation scheme
  real(DP), allocatable:: xyz_DLscQVapDt (:,:,:)
                              ! 絬϶ŷ륹ˤ漾ѲΨ. 
                              ! Specific humidity tendency by large scale condensation scheme

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYLSC):: phy_lsc00, phy_lsc01, phy_lsc02, phy_lsc03
  logical:: err
  character(*), parameter:: subname = 'phy_lscond_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_lscond_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 600.0_DP

  call Get( constant = const_earth, &      ! (inout)
    & Grav = Grav, Cp = Cp, &              ! (out)
    & EL = EL, RVap = RVap, &              ! (out)
    & EpsV = EpsV, ES0 = ES0 )             ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_lsc = phy_lsc00,  &         ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    & Grav = Grav, Cp = Cp, &                  ! (in)
    & EL = EL, RVap = RVap, &                  ! (in)
    & EpsV = EpsV, ES0 = ES0, &                ! (in)
    & DelTime = DelTime )
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_lsc00) )
  call PutLine( phy_lsc = phy_lsc00 ) ! (in)

  !---------------------------------------------------------
  !  LScaleCond ƥ
  !  LScaleCond test
  !---------------------------------------------------------
  allocate( xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_Press (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyr_Press (0:imax-1, 0:jmax-1, 0:kmax) )
  allocate( xy_LscRain (0:imax-1, 0:jmax-1) )
  allocate( xyz_DLscTempDt (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DLscQVapDt (0:imax-1, 0:jmax-1, 0:kmax-1) )

  xyz_Temp = 273.0_DP
  xyz_QVap = 1.0e-5_DP
  xyz_Press = 1.0e+6_DP
  xyr_Press = 1.0e+6_DP

  call LScaleCond( phy_lsc = phy_lsc00, &             ! (inout)
    & xyz_Temp = xyz_Temp, xyz_QVap = xyz_QVap, &     ! (inout)
    & xyz_Press = xyz_Press, xyr_Press = xyr_Press, & ! (in)
    & xy_Rain = xy_LscRain, &                         ! (out)
    & xyz_DTempDt = xyz_DLscTempDt, &                 ! (out)
    & xyz_DQVapDt = xyz_DLscQVapDt )                  ! (out)

  call PutLine ( xyz_Temp, indent = ' xyz_Temp=')
  call PutLine ( xyz_QVap, indent = ' xyz_QVap=')
  call PutLine ( xy_LscRain, indent = ' xy_LscRain=')
  call PutLine ( xyz_DLscTempDt, indent = ' xyz_DLscTempDt=')
  call PutLine ( xyz_DLscQvapDt, indent = ' xyz_DLscQvapDt=')

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_lsc = phy_lsc00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_lsc00) )
  call PutLine( phy_lsc = phy_lsc00 ) ! (in)

  call Close( phy_lsc = phy_lsc02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_lscond_test
