!= phy_interpolate ⥸塼Υƥȥץ
!
!= Test program for "phy_interpolate"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_interpolate_test.f90,v 1.3 2007/09/25 22:36:40 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_interpolate ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_interpolate" module.
! Confirm compilation and execution of this program.
!

program phy_interpolate_test
  use phy_interpolate, only: PHYINTPOL, Create, Close, &
    & PutLine, initialized, InterpolateTemp, InterpolateGeoPot
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_interpolate_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_interpolate" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 12         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants
  !-----------------------------------------------------------------
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
  real(DP), allocatable:: xyr_Temp (:,:,:)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
  real(DP), allocatable:: xyr_TempAns (:,:,:)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)

  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ P_s $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP), allocatable:: xyz_PressAns (:,:,:)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP), allocatable:: xyr_PressAns (:,:,:)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP), allocatable:: xyz_GeoPot (:,:,:)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
  real(DP), allocatable:: xyz_GeoPotAns (:,:,:)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
  real(DP), allocatable:: xyr_GeoPot (:,:,:)
                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)
  real(DP), allocatable:: xyr_GeoPotAns (:,:,:)
                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYINTPOL):: phy_intpol00, phy_intpol01, phy_intpol02, phy_intpol03
  type(CONST):: const_earth
  type(GT_HISTORY):: gthist
  logical:: err
  character(*), parameter:: subname = 'phy_interpolate_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_interpolate_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth )   ! (inout)
  call Get( constant = const_earth, &     ! (inout)
    & RAir = RAir, Grav = Grav )          ! (out)

  !---------------------------------------------------------
  !  ǡ
  !  Configure axes data
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )
  allocate( z_Sigma (0:kmax-1) )
  allocate( r_Sigma (0:kmax) )

  x_Lon = &
    & (/  0.0,   11.25,  22.5,   33.75,  45.0,  56.25,  67.5,   78.75, &
    &    90.0,  101.25, 112.5,  123.75, 135.0, 146.25, 157.5,  168.75, &
    &   180.0,  191.25, 202.5,  213.75, 225.0, 236.25, 247.5,  258.75, &
    &   270.0,  281.25, 292.5,  303.75, 315.0, 326.25, 337.5,  348.75 /)

  y_Lat = &
    & (/ -81.65059, -70.83464, -59.95486, -49.06072, &
    &    -38.16121, -27.25921, -16.35593,  -5.45204, &
    &      5.45204,  16.35593,  27.25921,  38.16121, &
    &     49.06072,  59.95486,  70.83464,  81.65059 /)

  z_Sigma = &
    & (/ 0.994997,  0.9799879, 0.9499499,  0.8897859, &
    &    0.7996277, 0.689378,  0.5641075,  0.4286365, &
    &    0.2879657, 0.1572454, 0.07398598, 0.02074752 /)

  r_Sigma = &
    & (/ 1.0,  0.99, 0.97, 0.93, 0.85, 0.75, &
    &    0.63, 0.5,  0.36, 0.22, 0.1,  0.05, 0.0 /)

  !---------------------------------------------------------
  !  
  !  Initialization
  !---------------------------------------------------------
  call Create( phy_intpol = phy_intpol00, &    ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma, &  ! (in)
    & RAir = RAir, Grav = Grav )               ! (in)

  !---------------------------------------------------------
  !  ٤ɽ̵μ
  !  Get temperature and surface pressure
  !---------------------------------------------------------
  allocate( xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xy_Ps (0:imax-1, 0:jmax-1) )
  call HistoryGet( &
    & file = 'phy_interpolate_test00.nc', & ! (in)
    & varname = 'Temp', &                   ! (in)
    & array = xyz_Temp )                    ! (out)

  call HistoryGet( &
    & file = 'phy_interpolate_test00.nc', & ! (in)
    & varname = 'Ps', &                     ! (in)
    & array = xy_Ps )                       ! (out)

  !---------------------------------------------------------
  !  μ
  !  Get correct answer
  !---------------------------------------------------------
  allocate( xyr_TempAns (0:imax-1, 0:jmax-1, 0:kmax) )
  allocate( xyz_PressAns (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyr_PressAns (0:imax-1, 0:jmax-1, 0:kmax) )
  allocate( xyz_GeoPotAns (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyr_GeoPotAns (0:imax-1, 0:jmax-1, 0:kmax) )

  call HistoryGet( &
    & file = 'phy_interpolate_test01.nc', & ! (in)
    & varname = 'TempM', &                  ! (in)
    & array = xyr_TempAns )                 ! (out)
  call HistoryGet( &
    & file = 'phy_interpolate_test01.nc', & ! (in)
    & varname = 'Press', &                  ! (in)
    & array = xyz_PressAns )                ! (out)
  call HistoryGet( &
    & file = 'phy_interpolate_test01.nc', & ! (in)
    & varname = 'PressM', &                 ! (in)
    & array = xyr_PressAns )                ! (out)
  call HistoryGet( &
    & file = 'phy_interpolate_test01.nc', & ! (in)
    & varname = 'GeoPot', &                 ! (in)
    & array = xyz_GeoPotAns )               ! (out)
  call HistoryGet( &
    & file = 'phy_interpolate_test01.nc', & ! (in)
    & varname = 'GeoPotM', &                ! (in)
    & array = xyr_GeoPotAns )               ! (out)

  !---------------------------------------------------------
  !  ٤Ⱦ $ \sigma $ ٥
  !  Interpolate temperature on half $ \sigma $ level
  !---------------------------------------------------------
  allocate( xyr_Temp (0:imax-1, 0:jmax-1, 0:kmax) )
  call InterpolateTemp( phy_intpol = phy_intpol00, &  ! (inout)
    & xyz_Temp   = xyz_Temp, &                        ! (in)
    & xyr_Temp   = xyr_Temp )                         ! (out)

  call AssertEqual( 'InterpolateTemp test 1', &
    & answer = xyr_TempAns, check = xyr_Temp, &
    & significant_digits = 13, ignore_digits = -13 )

  !---------------------------------------------------------
  !  ȥݥƥ󥷥λ
  !  Calculate pressure and geo-potential
  !---------------------------------------------------------
  allocate( xyz_Press (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyr_Press (0:imax-1, 0:jmax-1, 0:kmax) )
  allocate( xyz_GeoPot (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyr_GeoPot (0:imax-1, 0:jmax-1, 0:kmax) )

  call InterpolateGeoPot( phy_intpol = phy_intpol00, &   ! (inout)
    & xy_Ps      = xy_Ps, &                              ! (in)
    & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &  ! (in)
    & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, & ! (out)
    & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot ) ! (out)

  call AssertEqual( 'InterpolateGeoPot test 1', &
    & answer = xyz_PressAns, check = xyz_Press, &
    & significant_digits = 13, ignore_digits = -13 )
  call AssertEqual( 'InterpolateGeoPot test 2', &
    & answer = xyr_PressAns, check = xyr_Press, &
    & significant_digits = 13, ignore_digits = -13 )

  call AssertEqual( 'InterpolateGeoPot test 3', &
    & answer = xyz_GeoPotAns, check = xyz_GeoPot, &
    & significant_digits = 13, ignore_digits = -13 )
  call AssertEqual( 'InterpolateGeoPot test 4', &
    & answer = xyr_GeoPotAns, check = xyr_GeoPot, &
    & significant_digits = 13, ignore_digits = -13 )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_intpol = phy_intpol00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_intpol00) )
  call PutLine( phy_intpol = phy_intpol00 ) ! (in)

  call Close( phy_intpol = phy_intpol02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )


!!$  !----------------------------------------------------------------
!!$  !  ǡ
!!$  !  Output data
!!$  !----------------------------------------------------------------
!!$  call HistoryCreate( &
!!$    & history = gthist, &                            ! (out)
!!$    & file = 'phy_interpolate_test01.nc', &          ! (in)
!!$    & title = title, &                               ! (in)
!!$    & source = source, institution = institution, &  ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
!!$    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
!!$    & longnames = &
!!$    &  StoA('longitude', 'latitude', &
!!$    &       'sigma at layer midpoints', &
!!$    &       'sigma at layer end-points (half level)'), & ! (in)
!!$    & units = StoA('degree_east', 'degree_north', &
!!$    &              '1', '1') )                           ! (out)
!!$
!!$  call HistoryPut( &
!!$    & history = gthist, &               ! (out)
!!$    & varname = 'lon', array = x_Lon )  ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &               ! (out)
!!$    & varname = 'lat', array = y_Lat  ) ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                ! (out)
!!$    & varname = 'sig', array = z_Sigma ) ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                 ! (out)
!!$    & varname = 'sigm', array = r_Sigma ) ! (in)
!!$
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                    ! (inout)
!!$    & varname = 'lon', attrname = 'standard_name', & ! (in)
!!$    & value = 'longitude' )                          ! (in)
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                    ! (inout)
!!$    & varname = 'lat', attrname = 'standard_name', & ! (in)
!!$    & value = 'latitude' )                           ! (in)
!!$
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                              ! (inout)
!!$    & varname = 'sig', attrname = 'standard_name', &   ! (in)
!!$    & value = 'atmosphere_sigma_coordinate' )          ! (in)
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                              ! (inout)
!!$    & varname = 'sigm', attrname = 'standard_name', &  ! (in)
!!$    & value = 'atmosphere_sigma_coordinate' )          ! (in)
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                         ! (inout)
!!$    & varname = 'sig', attrname = 'positive', &   ! (in)
!!$    & value = 'down' )                            ! (in)
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                         ! (inout)
!!$    & varname = 'sigm', attrname = 'positive', &  ! (in)
!!$    & value = 'down' )                            ! (in)
!!$
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                           ! (inout)
!!$    & varname = 'Temp', &                           ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'temperature', &                   ! (in)
!!$    & units = 'K', xtype = 'double' )               ! (in)
!!$  call HistoryAddAttr(&
!!$    & history = gthist, &                             ! (inout)
!!$    & varname = 'Temp', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_temperature' )                     ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                     ! (inout)
!!$    & varname = 'Temp', array = xyz_Temp )    ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                            ! (inout)
!!$    & varname = 'TempM', &                           ! (in)
!!$    & dims = StoA('lon', 'lat', 'sigm'), &           ! (in)
!!$    & longname = 'temperature', &                    ! (in)
!!$    & units = 'K', xtype = 'double' )                ! (in)
!!$  call HistoryAddAttr(&
!!$    & history = gthist, &                              ! (inout)
!!$    & varname = 'TempM', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_temperature' )                      ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                      ! (inout)
!!$    & varname = 'TempM', array = xyr_Temp )    ! (in)
!!$
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                  ! (inout)
!!$    & varname = 'Press', &                 ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
!!$    & longname = 'air pressure', &         ! (in)
!!$    & units = 'Pa', xtype = 'double' )     ! (in)
!!$  call HistoryAddAttr(&
!!$    & history = gthist, &                              ! (inout)
!!$    & varname = 'Press', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_pressure' )                         ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                    ! (inout)
!!$    & varname = 'Press', array = xyz_Press ) ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                   ! (inout)
!!$    & varname = 'PressM', &                 ! (in)
!!$    & dims = StoA('lon', 'lat', 'sigm'), &  ! (in)
!!$    & longname = 'air pressure', &          ! (in)
!!$    & units = 'Pa', xtype = 'double' )      ! (in)
!!$  call HistoryAddAttr(&
!!$    & history = gthist, &                               ! (inout)
!!$    & varname = 'PressM', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_pressure' )                          ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                     ! (inout)
!!$    & varname = 'PressM', array = xyr_Press ) ! (in)
!!$
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                   ! (inout)
!!$    & varname = 'GeoPot', &                 ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &   ! (in)
!!$    & longname = 'air pressure', &          ! (in)
!!$    & units = 'Pa', xtype = 'double' )      ! (in)
!!$  call HistoryAddAttr(&
!!$    & history = gthist, &                               ! (inout)
!!$    & varname = 'GeoPot', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_pressure' )                          ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                      ! (inout)
!!$    & varname = 'GeoPot', array = xyz_GeoPot ) ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                    ! (inout)
!!$    & varname = 'GeoPotM', &                 ! (in)
!!$    & dims = StoA('lon', 'lat', 'sigm'), &   ! (in)
!!$    & longname = 'air pressure', &           ! (in)
!!$    & units = 'Pa', xtype = 'double' )       ! (in)
!!$  call HistoryAddAttr(&
!!$    & history = gthist, &                                ! (inout)
!!$    & varname = 'GeoPotM', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_pressure' )                           ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                       ! (inout)
!!$    & varname = 'GeoPotM', array = xyr_GeoPot ) ! (in)
!!$
!!$  call HistoryClose( history = gthist ) ! (inout)


end program phy_interpolate_test
