!= ̲ (SST), ɽ̤̽
!
!= Configure sea surface temperature (SST), and various values on surface
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_ground.f90,v 1.8 2007/10/11 03:46:20 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_ground
  !
  != ̲ (SST), ɽ̤̽
  !
  != Configure sea surface temperature (SST), and various values on surface
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤ɽ̤̽Ԥޤ. 
  ! NAMELIST եѤ뤳Ȥ NetCDF ե뤫
  ! ǡɤ߹ळȤǽǤ.
  !
  ! Sea surface temperature (SST), and various values on surface
  ! are configured.
  ! Using NAMELIST file, data can be loaded from NetCDF files.
  !
  !== Procedures List
  !
  ! Create        :: PHYGRD ѿν
  ! Get           :: ̲ (SST), ɽ̤̽μ
  ! Close         :: PHYGRD ѿνλ
  ! PutLine       :: PHYGRD ѿ˳ǼƤΰ
  ! initialized   :: PHYGRD ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYGRD"
  ! Get           :: Get sea surface temperature (SST), 
  !                  and various values on surface
  ! Close         :: Deconstructor of "PHYGRD"
  ! PutLine       :: Print information of "PHYGRD"
  ! initialized   :: Check initialization of "PHYGRD"
  !
  !== Usage
  !
  ! Ϥ, PHYGRD ѿ, Create ǽԤޤ.
  ! ̲ (SST), ɽ̤̽μˤ Get ѤƤ.
  ! PHYGRD ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYGRD" by "Create".
  ! Use "Get" in order to get sea surface temperature (SST), 
  ! and various values on surface.
  ! In order to terminate "PHYGRD", use "Close".
  !

  use dc_types, only: DP, TOKEN, STRING
  implicit none
  private
  public:: PHYGRD, Create, Close, PutLine, initialized
  public:: Get

  type PHYGRD
    !
    ! ޤ, Create  "PHYGRD" ѿꤷƲ.
    ! ꤵ줿 "PHYGRD" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYGRD" variable by "Create" before usage.
    ! If you reuse "PHYGRD" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    !-----------------------------------
    !  ѥǡե̾
    !  Data filename for input
    character(STRING):: ground_nc = ''
                              ! ̲ (SST), ɽ̥̽ǡ
                              ! Ǽ줿 NetCDF ե̾. 
                              ! NetCDF filename in which sea surface 
                              ! temperature (SST), 
                              ! and various values on surface Data
                              ! are stored.

    !-----------------------------------
    !  ɽ̥ǡ
    !  Data on surface
    real(DP), pointer:: xy_SurfTemp (:,:) =>null()
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), pointer:: xy_SurfAlbedo (:,:) =>null()
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), pointer:: xy_SurfHumidCoeff (:,:) =>null()
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), pointer:: xy_SurfRoughLength (:,:) =>null()
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), pointer:: xy_SurfHeatCapacity (:,:) =>null()
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), pointer:: xy_GroundTempFlux (:,:) =>null()
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer, pointer:: xy_SurfCondition (:,:) =>null()
                              ! ɽ. 
                              ! Surface condition

    !-----------------------------------
    !  ɽ̥ǡѿ̾
    !  Variable names of data on surface
    character(TOKEN):: SurfTemp_varname = ''
                              ! ɽ̲٤ѿ̾. 
                              ! Variable name of surface temperature
    character(TOKEN):: SurfAlbedo_varname = ''
                              ! ɽ٥ɤѿ̾. 
                              ! Variable name of surface albedo
    character(TOKEN):: SurfHumidCoeff_varname = ''
                              ! ɽ٤ѿ̾. 
                              ! Variable name of surface humidity coefficient
    character(TOKEN):: SurfRoughLength_varname = ''
                              ! ɽĹѿ̾. 
                              ! Variable name of surface rough length
    character(TOKEN):: SurfHeatCapacity_varname = ''
                              ! ɽǮ̤ѿ̾. 
                              ! Variable name of surface heat capacity
    character(TOKEN):: GroundTempFlux_varname = ''
                              ! Ǯեåѿ̾. 
                              ! Variable name of ground temperature flux
    character(TOKEN):: SurfCondition_varname = ''
                              ! ɽ֤ѿ̾. 
                              ! Variable name of surface condition
  end type PHYGRD

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: phy_ground.f90,v 1.8 2007/10/11 03:46:20 morikawa Exp $'

  interface Create
    module procedure PhyGroundCreate
  end interface

  interface Close
    module procedure PhyGroundClose
  end interface

  interface PutLine
    module procedure PhyGroundPutLine
  end interface

  interface initialized
    module procedure PhyGroundInitialized
  end interface

  interface Get
    module procedure PhyGroundGet
  end interface

  interface NmlRead
    module procedure PhyGroundNmlRead
  end interface

!!$  interface Sample
!!$    module procedure PhyGroundSample
!!$  end interface

contains

  subroutine PhyGroundCreate( phy_grd, &
    & imax, jmax, &
    & SurfTemp, SurfAlbedo, SurfHumidCoeff, SurfRoughLength, &
    & SurfHeatCapacity, GroundTempFlux, SurfCondition, &
    & ground_nc, &
    & SurfTemp_varname, SurfAlbedo_varname, SurfHumidCoeff_varname, &
    & SurfRoughLength_varname, SurfHeatCapacity_varname, &
    & GroundTempFlux_varname, SurfCondition_varname, &
    & nmlfile, err )
    !
    ! PHYGRD ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYGRD ѿꤷƤ.
    !
    !  *SurfTemp*, *SurfAlbedo*, *SurfHumidCoeff*, *SurfRoughLength*, 
    ! *SurfHeatCapacity*, *GroundTempFlux*, *SurfCondition* Ϳ뤳Ȥ, 
    ! ɽ˴ؤѥ᡼ͤǤޤ. 
    ! ͤʬۤͿ, NetCDF ե뤫ǡͿ
    ! Ȥˤʤޤ. ե̾ *ground_nc* , ѿ̾ 
    ! *SurfTemp_varname*, *SurfAlbedo_varname*, *SurfHumidCoeff_varname*, 
    ! *SurfRoughLength_varname*, *SurfHeatCapacity_varname*, 
    ! *GroundTempFlux_varname*, *SurfCondition_varname* ͿƤ. 
    ! ե̾ѿ̾ NAMELIST ե 
    ! *nmlfile* ǻꤹ뤳ȤǽǤ. 
    ! ξ *nmlfile*  NAMELIST եꤷƤ. 
    ! ե̾ѿ̾ꤹ NAMELIST ѿ˴ؤƤ, 
    ! NAMELIST#phy_ground_nml 򻲾ȤƤ.
    !
    ! ʤ, Ϳ줿 *phy_grd* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    !
    ! Constructor of "PHYGRD".
    ! Initialize *phy_grd* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Homogeneous global surface parameters can be specified with
    ! arguments *SurfTemp*, *SurfAlbedo*, *SurfHumidCoeff*, *SurfRoughLength*, 
    ! *SurfHeatCapacity*, *GroundTempFlux*, *SurfCondition*.
    ! If inhomogeneous profile is needed, input data from NetCDF files.
    ! Give the filename to *ground_nc*, and the variable names to
    ! *SurfTemp_varname*, *SurfAlbedo_varname*, *SurfHumidCoeff_varname*, 
    ! *SurfRoughLength_varname*, *SurfHeatCapacity_varname*, 
    ! *GroundTempFlux_varname*, *SurfCondition_varname*.
    ! The filename and the variable names can be specified from 
    ! NAMELIST file *nmlfile*.
    ! In this case, give *nmlfile*.
    ! See NAMELIST#phy_ground_nml about NAMELIST variables for 
    ! filename and variable names.
    !
    ! Note that if *phy_grd* is already initialized 
    ! by this procedure, error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use gt4_history, only: HistoryGet
    implicit none
    type(PHYGRD), intent(inout):: phy_grd
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    real(DP), intent(in), optional:: SurfTemp
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in), optional:: SurfAlbedo
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(in), optional:: SurfHumidCoeff
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(in), optional:: SurfRoughLength
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(in), optional:: SurfHeatCapacity
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(in), optional:: GroundTempFlux
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer, intent(in), optional:: SurfCondition
                              ! ɽ. 
                              ! Surface condition
    character(*), intent(in), optional:: ground_nc
                              ! ̲ (SST), ɽ̥̽ǡ
                              ! Ǽ줿 NetCDF ե̾. 
                              ! NetCDF filename in which sea surface 
                              ! temperature (SST), 
                              ! and various values on surface Data
                              ! are stored.
    character(*), intent(in), optional:: SurfTemp_varname
                              ! ɽ̲٤ѿ̾. 
                              ! Variable name of surface temperature
    character(*), intent(in), optional:: SurfAlbedo_varname
                              ! ɽ٥ɤѿ̾. 
                              ! Variable name of surface albedo
    character(*), intent(in), optional:: SurfHumidCoeff_varname
                              ! ɽ٤ѿ̾. 
                              ! Variable name of surface humidity coefficient
    character(*), intent(in), optional:: SurfRoughLength_varname
                              ! ɽĹѿ̾. 
                              ! Variable name of surface rough length
    character(*), intent(in), optional:: SurfHeatCapacity_varname
                              ! ɽǮ̤ѿ̾. 
                              ! Variable name of surface heat capacity
    character(*), intent(in), optional:: GroundTempFlux_varname
                              ! Ǯեåѿ̾. 
                              ! Variable name of ground temperature flux
    character(*), intent(in), optional:: SurfCondition_varname
                              ! ɽ֤ѿ̾. 
                              ! Variable name of surface condition
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_ground_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_ground_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyGroundCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_grd % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYGRD'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    phy_grd % imax = imax
    phy_grd % jmax = jmax

    !-----------------------------------------------------------------
    !  "PHYGRD" 
    !  Configure the settings for "PHYGRD"
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
    phy_grd % ground_nc = ''

    allocate( phy_grd % xy_SurfTemp (0:imax-1, 0:jmax-1) )
    allocate( phy_grd % xy_SurfAlbedo (0:imax-1, 0:jmax-1) )
    allocate( phy_grd % xy_SurfHumidCoeff (0:imax-1, 0:jmax-1) )
    allocate( phy_grd % xy_SurfRoughLength (0:imax-1, 0:jmax-1) )
    allocate( phy_grd % xy_SurfHeatCapacity (0:imax-1, 0:jmax-1) )
    allocate( phy_grd % xy_GroundTempFlux (0:imax-1, 0:jmax-1) )
    allocate( phy_grd % xy_SurfCondition (0:imax-1, 0:jmax-1) )

    phy_grd % xy_SurfTemp         = 273.0_DP
    phy_grd % xy_SurfAlbedo       = 0.3_DP
    phy_grd % xy_SurfHumidCoeff   = 0.0_DP
    phy_grd % xy_SurfRoughLength  = 0.0_DP
    phy_grd % xy_SurfHeatCapacity = 0.0_DP
    phy_grd % xy_GroundTempFlux   = 0.0_DP
    phy_grd % xy_SurfCondition    = 0.0_DP

    phy_grd % SurfTemp_varname         = ''
    phy_grd % SurfAlbedo_varname       = ''
    phy_grd % SurfHumidCoeff_varname   = ''
    phy_grd % SurfRoughLength_varname  = ''
    phy_grd % SurfHeatCapacity_varname = ''
    phy_grd % GroundTempFlux_varname   = ''
    phy_grd % SurfCondition_varname    = ''

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    if ( present(ground_nc) )  phy_grd % ground_nc = ground_nc

    if ( present(SurfTemp        ) ) phy_grd % xy_SurfTemp         = SurfTemp
    if ( present(SurfAlbedo      ) ) phy_grd % xy_SurfAlbedo       = SurfAlbedo
    if ( present(SurfHumidCoeff  ) ) phy_grd % xy_SurfHumidCoeff   = SurfHumidCoeff
    if ( present(SurfRoughLength ) ) phy_grd % xy_SurfRoughLength  = SurfRoughLength
    if ( present(SurfHeatCapacity) ) phy_grd % xy_SurfHeatCapacity = SurfHeatCapacity
    if ( present(GroundTempFlux  ) ) phy_grd % xy_GroundTempFlux   = GroundTempFlux
    if ( present(SurfCondition   ) ) phy_grd % xy_SurfCondition    = SurfCondition

    if ( present(SurfTemp_varname        ) ) phy_grd % SurfTemp_varname         = SurfTemp_varname        
    if ( present(SurfAlbedo_varname      ) ) phy_grd % SurfAlbedo_varname       = SurfAlbedo_varname      
    if ( present(SurfHumidCoeff_varname  ) ) phy_grd % SurfHumidCoeff_varname   = SurfHumidCoeff_varname  
    if ( present(SurfRoughLength_varname ) ) phy_grd % SurfRoughLength_varname  = SurfRoughLength_varname 
    if ( present(SurfHeatCapacity_varname) ) phy_grd % SurfHeatCapacity_varname = SurfHeatCapacity_varname
    if ( present(GroundTempFlux_varname  ) ) phy_grd % GroundTempFlux_varname   = GroundTempFlux_varname  
    if ( present(SurfCondition_varname   ) ) phy_grd % SurfCondition_varname    = SurfCondition_varname   


    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &        ! (in)
        & ground_nc_ = phy_grd % ground_nc, &  ! (inout)
        & SurfTemp_varname_         = phy_grd % SurfTemp_varname, &         ! (inout)
        & SurfAlbedo_varname_       = phy_grd % SurfAlbedo_varname, &       ! (inout)
        & SurfHumidCoeff_varname_   = phy_grd % SurfHumidCoeff_varname, &   ! (inout)
        & SurfRoughLength_varname_  = phy_grd % SurfRoughLength_varname, &  ! (inout)
        & SurfHeatCapacity_varname_ = phy_grd % SurfHeatCapacity_varname, & ! (inout)
        & GroundTempFlux_varname_   = phy_grd % GroundTempFlux_varname, &   ! (inout)
        & SurfCondition_varname_    = phy_grd % SurfCondition_varname, &    ! (inout)
        & err = err )                            ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    if ( present_and_not_empty(phy_grd % ground_nc) ) then
      if ( present_and_not_empty(phy_grd % SurfTemp_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % SurfTemp_varname, &
          & array   = phy_grd % xy_SurfTemp )
      end if

      if ( present_and_not_empty(phy_grd % SurfAlbedo_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % SurfAlbedo_varname, &
          & array   = phy_grd % xy_SurfAlbedo )
      end if

      if ( present_and_not_empty(phy_grd % SurfHumidcoeff_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % SurfHumidcoeff_varname, &
          & array   = phy_grd % xy_SurfHumidcoeff )
      end if

      if ( present_and_not_empty(phy_grd % SurfRoughLength_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % SurfRoughLength_varname, &
          & array   = phy_grd % xy_SurfRoughLength )
      end if

      if ( present_and_not_empty(phy_grd % SurfHeatCapacity_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % SurfHeatCapacity_varname, &
          & array   = phy_grd % xy_SurfHeatCapacity )
      end if

      if ( present_and_not_empty(phy_grd % GroundTempFlux_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % GroundTempFlux_varname, &
          & array   = phy_grd % xy_GroundTempFlux )
      end if

      if ( present_and_not_empty(phy_grd % SurfCondition_varname) ) then
        call HistoryGet( &
          & file    = phy_grd % ground_nc, &
          & varname = phy_grd % SurfCondition_varname, &
          & array   = phy_grd % xy_SurfCondition )
      end if

    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_grd % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyGroundCreate

  subroutine PhyGroundClose( phy_grd, err )
    !
    ! PHYGRD ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_grd*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYGRD".
    ! Note that if *phy_grd* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYGRD), intent(inout):: phy_grd
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyGroundClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_grd % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYGRD'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYGRD" ξõ
    !  Clear the settings for "PHYGRD"
    !-----------------------------------------------------------------


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_grd % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyGroundClose

  subroutine PhyGroundPutLine( phy_grd, unit, indent, err )
    !
    !  *phy_grd* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_grd*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(PHYGRD), intent(in):: phy_grd
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyGroundPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYGRD" ΰ
    !  Print the settings for "PHYGRD"
    !-----------------------------------------------------------------
    if ( phy_grd % initialized ) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYGRD:: @initialized=%y', &
        & l=(/phy_grd % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d', &
        & i=(/phy_grd % imax, phy_grd % jmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ground_nc=%c', &
        & c1=trim(phy_grd % ground_nc) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SurfTemp_varname=%c', &
        & c1=trim(phy_grd % SurfTemp_varname) )
      call PutLine( phy_grd % xy_SurfTemp, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_SurfTemp), &
        & ubounds = ubound(phy_grd % xy_SurfTemp), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfTemp=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SurfAlbedo_varname=%c', &
        & c1=trim(phy_grd % SurfAlbedo_varname) )
      call PutLine( phy_grd % xy_SurfAlbedo, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_SurfAlbedo), &
        & ubounds = ubound(phy_grd % xy_SurfAlbedo), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfAlbedo=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SurfHumidCoeff_varname=%c', &
        & c1=trim(phy_grd % SurfHumidCoeff_varname) )
      call PutLine( phy_grd % xy_SurfHumidCoeff, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_SurfHumidCoeff), &
        & ubounds = ubound(phy_grd % xy_SurfHumidCoeff), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfHumidCoeff=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SurfRoughLength_varname=%c', &
        & c1=trim(phy_grd % SurfRoughLength_varname) )
      call PutLine( phy_grd % xy_SurfRoughLength, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_SurfRoughLength), &
        & ubounds = ubound(phy_grd % xy_SurfRoughLength), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfRoughLength=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SurfHeatCapacity_varname=%c', &
        & c1=trim(phy_grd % SurfHeatCapacity_varname) )
      call PutLine( phy_grd % xy_SurfHeatCapacity, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_SurfHeatCapacity), &
        & ubounds = ubound(phy_grd % xy_SurfHeatCapacity), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfHeatCapacity=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @GroundTempFlux_varname=%c', &
        & c1=trim(phy_grd % GroundTempFlux_varname) )
      call PutLine( phy_grd % xy_GroundTempFlux, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_GroundTempFlux), &
        & ubounds = ubound(phy_grd % xy_GroundTempFlux), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_GroundTempFlux=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SurfCondition_varname=%c', &
        & c1=trim(phy_grd % SurfCondition_varname) )
      call PutLine( phy_grd % xy_SurfCondition, unit = out_unit, &
        & lbounds = lbound(phy_grd % xy_SurfCondition), &
        & ubounds = ubound(phy_grd % xy_SurfCondition), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfCondition=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYGRD:: @initialized=%y>', &
        & l=(/phy_grd % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyGroundPutLine

  logical function PhyGroundInitialized( phy_grd ) result(result)
    !
    ! *phy_grd* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_grd* is initialized, .true. is returned.
    ! If *phy_grd* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYGRD), intent(in):: phy_grd
  continue
    result = phy_grd % initialized
  end function PhyGroundInitialized

  subroutine PhyGroundNmlRead( nmlfile, &
    & ground_nc_, &
    & SurfTemp_varname_, &         
    & SurfAlbedo_varname_, &       
    & SurfHumidCoeff_varname_, &   
    & SurfRoughLength_varname_, &  
    & SurfHeatCapacity_varname_, & 
    & GroundTempFlux_varname_, &   
    & SurfCondition_varname_, &    
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    character(*), intent(inout):: ground_nc_
    character(STRING):: ground_nc
                              ! ̲ (SST), ɽ̥̽ǡ
                              ! Ǽ줿 NetCDF ե̾. 
                              ! NetCDF filename in which sea surface 
                              ! temperature (SST), 
                              ! and various values on surface Data
                              ! are stored.
    character(*), intent(inout):: SurfTemp_varname_
    character(TOKEN):: SurfTemp_varname = ''
                              ! ɽ̲٤ѿ̾. 
                              ! Variable name of surface temperature
    character(*), intent(inout):: SurfAlbedo_varname_
    character(TOKEN):: SurfAlbedo_varname = ''
                              ! ɽ٥ɤѿ̾. 
                              ! Variable name of surface albedo
    character(*), intent(inout):: SurfHumidCoeff_varname_
    character(TOKEN):: SurfHumidCoeff_varname = ''
                              ! ɽ٤ѿ̾. 
                              ! Variable name of surface humidity coefficient
    character(*), intent(inout):: SurfRoughLength_varname_
    character(TOKEN):: SurfRoughLength_varname = ''
                              ! ɽĹѿ̾. 
                              ! Variable name of surface rough length
    character(*), intent(inout):: SurfHeatCapacity_varname_
    character(TOKEN):: SurfHeatCapacity_varname = ''
                              ! ɽǮ̤ѿ̾. 
                              ! Variable name of surface heat capacity
    character(*), intent(inout):: GroundTempFlux_varname_
    character(TOKEN):: GroundTempFlux_varname = ''
                              ! Ǯեåѿ̾. 
                              ! Variable name of ground temperature flux
    character(*), intent(inout):: SurfCondition_varname_
    character(TOKEN):: SurfCondition_varname = ''
                              ! ɽ֤ѿ̾. 
                              ! Variable name of surface condition
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /phy_ground_nml/ &
      & ground_nc, &
      & SurfTemp_varname, &        
      & SurfAlbedo_varname, &      
      & SurfHumidCoeff_varname, &  
      & SurfRoughLength_varname, &
      & SurfHeatCapacity_varname, & 
      & GroundTempFlux_varname, &  
      & SurfCondition_varname
                              ! phy_ground ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_ground#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "phy_ground" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_ground#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyGroundNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
    ground_nc = ground_nc_
    if ( .not. trim(SurfTemp_varname_) == ''         ) &
      & SurfTemp_varname         = SurfTemp_varname_
    if ( .not. trim(SurfAlbedo_varname_) == ''       ) &
      & SurfAlbedo_varname       = SurfAlbedo_varname_
    if ( .not. trim(SurfHumidCoeff_varname_) == ''   ) &
      & SurfHumidCoeff_varname   = SurfHumidCoeff_varname_
    if ( .not. trim(SurfRoughLength_varname_) == ''  ) &
      & SurfRoughLength_varname  = SurfRoughLength_varname_
    if ( .not. trim(SurfHeatCapacity_varname_) == '' ) &
      & SurfHeatCapacity_varname = SurfHeatCapacity_varname_
    if ( .not. trim(GroundTempFlux_varname_) == ''   ) &
      & GroundTempFlux_varname   = GroundTempFlux_varname_
    if ( .not. trim(SurfCondition_varname_) == ''    ) &
      & SurfCondition_varname    = SurfCondition_varname_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = phy_ground_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='phy_ground_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = phy_ground_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='phy_ground_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
    ground_nc_ = ground_nc
    SurfTemp_varname_         = SurfTemp_varname
    SurfAlbedo_varname_       = SurfAlbedo_varname
    SurfHumidCoeff_varname_   = SurfHumidCoeff_varname
    SurfRoughLength_varname_  = SurfRoughLength_varname
    SurfHeatCapacity_varname_ = SurfHeatCapacity_varname
    GroundTempFlux_varname_   = GroundTempFlux_varname
    SurfCondition_varname_    = SurfCondition_varname

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyGroundNmlRead

  subroutine PhyGroundGet( phy_grd, &
    & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoeff, &
    & xy_SurfRoughLength, xy_SurfHeatCapacity, xy_GroundTempFlux, &
    & xy_SurfCondition, &
    & err )
    !
    ! ɽ̤̽ޤ.
    !
    ! ʤ, Ϳ줿 *phy_grd*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Get various values on surface.
    !
    ! If *phy_grd* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYGRD), intent(inout):: phy_grd
    real(DP), intent(out), optional:: xy_SurfTemp (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(out), optional:: xy_SurfAlbedo (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(out), optional:: xy_SurfHumidCoeff (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(out), optional:: xy_SurfRoughLength (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(out), optional:: xy_SurfHeatCapacity (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(out), optional:: xy_GroundTempFlux (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer, intent(out), optional:: xy_SurfCondition (0:phy_grd%imax-1, 0:phy_grd%jmax-1)
                              ! ɽ. 
                              ! Surface condition
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyGroundGet'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_grd % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYGRD'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_grd* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_grd*
    !-----------------------------------------------------------------
    if ( present(xy_SurfTemp        ) ) &
      & xy_SurfTemp         = phy_grd % xy_SurfTemp         
    if ( present(xy_SurfAlbedo      ) ) &
      & xy_SurfAlbedo       = phy_grd % xy_SurfAlbedo       
    if ( present(xy_SurfHumidCoeff  ) ) &
      & xy_SurfHumidCoeff   = phy_grd % xy_SurfHumidCoeff   
    if ( present(xy_SurfRoughLength ) ) &
      & xy_SurfRoughLength  = phy_grd % xy_SurfRoughLength  
    if ( present(xy_SurfHeatCapacity) ) &
      & xy_SurfHeatCapacity = phy_grd % xy_SurfHeatCapacity 
    if ( present(xy_GroundTempFlux  ) ) &
      & xy_GroundTempFlux   = phy_grd % xy_GroundTempFlux   
    if ( present(xy_SurfCondition   ) ) &
      & xy_SurfCondition    = phy_grd % xy_SurfCondition    

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyGroundGet

!!$  subroutine PhyGroundSample( phy_grd, err )
!!$    !--
!!$    ! PhyGroundSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_grd*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyGroundSample
!!$    !++
!!$    ! If *phy_grd* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYGRD), intent(inout):: phy_grd
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyGroundSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_grd % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYGRD'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_grd* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_grd*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_grd % param_i
!!$!!$    param_r = phy_grd % param_r
!!$!!$    param_c = phy_grd % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyGroundSample

end module phy_ground
