!= dyn_spectral ⥸塼Υƥȥץ
!
!= Test program for "dyn_spectral"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dyn_spectral_test.f90,v 1.9 2007/09/08 18:52:06 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! dyn_spectral ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "dyn_spectral" module.
! Confirm compilation and execution of this program.
!

program dyn_spectral_test
  use constants, only: CONST, Create, Get
  use dyn_spectral, only: DYNSP, Create, Close, PutLine, initialized, &
    & EqualAxes, GetAxes
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use gt4_history, only: HistoryGet
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'dyn_spectral_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "dyn_spectral" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(CONST):: const_earth
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
  real(DP):: Omega      ! $ \Omega $ . ž®.     Angular velocity
!!$  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
!!$  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  integer:: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
  real(DP):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber

  real(DP), allocatable:: x_Lon (:)
  real(DP), allocatable:: y_Lat (:)

  type(DYNSP) :: dyn_sp00, dyn_sp01, dyn_sp02, dyn_sp03, dyn_sp04, dyn_sp05
  real(DP) :: DelTime
  logical :: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './dyn_spectral_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )


  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 1800.0_DP

  call Get( constant = const_earth, &              ! (inout)
    & PI = PI, RPlanet = RPlanet, &                ! (out)
    & Omega = Omega, Cp = Cp, &                    ! (out)
    & VisOrder = VisOrder, EFoldTime = EFoldTime)  ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( dyn_sp00, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 10, & ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & nmlfile = VAL_namelist )                      ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(dyn_sp00) )
  call PutLine( dyn_sp00 ) ! (in)

  err = .false.
  call Create( dyn_sp00, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 10, & ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & err = err )                                   ! (out)
  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_sp01, &                          ! (inout)
    & nmax = 1, imax = 1, jmax = 1, kmax = 1, &     ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & err = err )                                   ! (out)

  call AssertEqual( 'twice initialization failue test 1', &
    & answer = .false., check = initialized(dyn_sp01) )

  call AssertEqual( 'twice initialization failue test 2', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_sp02, &                          ! (inout)
    & nmax = 0, imax = 64, jmax = 32, kmax = 10, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & err = err )                                   ! (out)

  call AssertEqual( 'invalid argument test 1', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_sp03, &                          ! (inout)
    & nmax = 21, imax = 0, jmax = 32, kmax = 10, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & err = err )                                   ! (out)

  call AssertEqual( 'invalid argument test 2', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_sp04, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 0, kmax = 10, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & err = err )                                   ! (out)

  call AssertEqual( 'invalid argument test 3', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_sp05, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 0, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, &                                    ! (in)
!!$    & Grav = Grav, RAir = RAir, &          ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & err = err )                                   ! (out)

  call AssertEqual( 'invalid argument test 4', &
    & answer = .true., check = err )

  !---------------------------------------------------------
  !  EqualAxes ƥ
  !  "EqualAxes" test
  !---------------------------------------------------------
  allocate( x_Lon (0:63) )
  allocate( y_Lat (0:31) )

  call HistoryGet ( &
    & file = 'dyn_spectral_test00.nc', varname = 'lon', & ! (in)
    & array = x_Lon, quiet=.true. )                       ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_test00.nc', varname = 'lat', & ! (in)
    & array = y_Lat, quiet=.true.  )                      ! (out)

  call EqualAxes( dyn_sp00, & ! (inout)
    & x_Lon = x_Lon, &        ! (in)
    & err = err )             ! (out)

  call AssertEqual( '"EqualAxes" test 1', &
    & answer = .false., check = err )

  call EqualAxes( dyn_sp00, & ! (inout)
    & y_Lat = y_Lat, &        ! (in)
    & err = err )             ! (out)

  call AssertEqual( '"EqualAxes" test 2', &
    & answer = .false., check = err )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( dyn_sp00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(dyn_sp00) )
  call PutLine( dyn_sp00 ) ! (in)

  err = .false.
  call Close( dyn_sp00, err ) ! (inout)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )


end program dyn_spectral_test
