!= dyn_spectral_as83 ⥸塼Υƥȥץ
!
!= Test program for "dyn_spectral_as83"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dyn_spectral_as83_test.f90,v 1.9 2007/10/13 07:48:03 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! dyn_spectral_as83 ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "dyn_spectral_as83" module.
! Confirm compilation and execution of this program.
!

program dyn_spectral_as83_test
  use constants, only: CONST, Create, Get
  use dc_types, only: DP, STRING
  use dc_message, only: MessageNotify
  use dyn_spectral_as83, only: DYNSPAS83, Create, Close, PutLine, &
    & initialized, EqualAxes, Dynamics
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  use gt4_history, only: GT_HISTORY, &
    & HistoryGet, HistoryCopy, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'dyn_spectral_as83_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "dyn_spectral_as83" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: nmax = 21
                              ! ȿ. 
                              ! Maximum truncated wavenumber
  integer, parameter:: imax = 64
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 32
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 20
                              ! ľؿ. 
                              ! Number of vertical level

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(CONST):: const_earth
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
  real(DP):: Omega      ! $ \Omega $ . ž®.     Angular velocity
!!$  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: EpsVT      ! $ 1/\epsilon_v - 1 $ .
  integer:: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
  real(DP):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber
  type(DYNSPAS83):: dyn_sp_as00, dyn_sp_as01, dyn_sp_as02
  real(DP):: DelTime
  logical:: err

  

  real(DP), allocatable:: x_Lon (:)
  real(DP), allocatable:: y_Lat (:)
  real(DP), allocatable:: z_Sigma (:)
  real(DP), allocatable:: r_Sigma (:)


  real(DP):: xyz_VorB (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
  real(DP):: xyz_DivB (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
  real(DP):: xyz_TempB (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T (t-\Delta t) $ .     . Temperature
  real(DP):: xy_PsB (0:imax-1, 0:jmax-1)
                              ! $ P_s (t-\Delta t) $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapB (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
  real(DP):: xyz_VorN (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \zeta (t) $ . . Vorticity
  real(DP):: xyz_DivN (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ D (t) $ .     ȯ. Divergence
  real(DP):: xyz_TempN (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T (t) $ .     . Temperature
  real(DP):: xy_PsN (0:imax-1, 0:jmax-1)
                              ! $ P_s (t) $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapN (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q (t) $ .     漾. Specific humidity

  real(DP):: xyz_VorA (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \zeta (t+\Delta t) $ . . Vorticity
  real(DP):: xyz_DivA (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ D (t+\Delta t) $ .     ȯ. Divergence
  real(DP):: xyz_TempA (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T (t+\Delta t) $ .     . Temperature
  real(DP):: xy_PsA (0:imax-1, 0:jmax-1)
                              ! $ P_s (t+\Delta t) $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapA (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q (t+\Delta t) $ .     漾. Specific humidity

  real(DP):: xyz_VorAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \zeta (t+\Delta t) $ . . Vorticity
  real(DP):: xyz_DivAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ D (t+\Delta t) $ .     ȯ. Divergence
  real(DP):: xyz_TempAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T (t+\Delta t) $ .     . Temperature
  real(DP):: xy_PsAns (0:imax-1, 0:jmax-1)
                              ! $ P_s (t+\Delta t) $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q (t+\Delta t) $ .     漾. Specific humidity

  real(DP):: xyz_VorAnsG (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \zeta (t+\Delta t) $ . . Vorticity
  real(DP):: xyz_DivAnsG (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ D (t+\Delta t) $ .     ȯ. Divergence
  real(DP):: xyz_TempAnsG (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T (t+\Delta t) $ .     . Temperature
  real(DP):: xy_PsAnsG (0:imax-1, 0:jmax-1)
                              ! $ P_s (t+\Delta t) $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapAnsG (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q (t+\Delta t) $ .     漾. Specific humidity

  real(DP):: xyz_VorAnsL (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \zeta (t+\Delta t) $ . . Vorticity
  real(DP):: xyz_DivAnsL (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ D (t+\Delta t) $ .     ȯ. Divergence
  real(DP):: xyz_TempAnsL (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T (t+\Delta t) $ .     . Temperature
  real(DP):: xy_PsAnsL (0:imax-1, 0:jmax-1)
                              ! $ P_s (t+\Delta t) $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapAnsL (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q (t+\Delta t) $ .     漾. Specific humidity

  character(*), parameter:: subname = 'dyn_spectral_as83_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './dyn_spectral_as83_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth, &
    & Omega = 7.292e-5_DP ) ! (inout)

  DelTime = 480.0_DP

  call Get( constant = const_earth, &              ! (inout)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, & ! (out)
!!$    & Grav = Grav, &   ! (out)
    & Cp = Cp, RAir = RAir, EpsVT = EpsVT, &       ! (out)
    & VisOrder = VisOrder, EFoldTime = EFoldTime ) ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( dyn_sp_as = dyn_sp_as00, &           ! (inout)
    & nmax = nmax, &                                ! (in)
    & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
    & PI = PI, RPlanet = RPlanet, &                 ! (in)
    & Omega = Omega, Cp = Cp, RAir = RAir, &        ! (in)
    & EpsVT = EpsVT, &                              ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTime = DelTime, &                          ! (in)
    & current_time_value = 0.0_DP, &                ! (in)
    & current_time_unit = 'sec', &                  ! (in)
    & history_varlist = 'SigmaDot, DPiDt', &        ! (in)
    & history_interval_value = 8.0_DP, &            ! (in)
    & history_interval_unit = 'min' )               ! (in)

  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(dyn_sp_as00) )
  call PutLine( dyn_sp_as00 ) ! (in)

  call Create( dyn_sp_as = dyn_sp_as01, &           ! (inout)
    & nmax = nmax, &                                ! (in)
    & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
    & PI = PI, RPlanet = RPlanet, &                 ! (in)
    & Omega = Omega, Cp = Cp, RAir = RAir, &        ! (in)
    & EpsVT = EpsVT, &                              ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTIme = DelTime, &                          ! (in)
    & time_integration_scheme = 'Explicit', &       ! (in)
    & wa_module_initialized = .true., &             ! (in)
    & current_time_value = 16.0_DP, &               ! (in)
    & current_time_unit = 'min', &                  ! (in)
    & nmlfile = VAL_namelist )                      ! (in)
  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = initialized(dyn_sp_as01) )
  call PutLine( dyn_sp_as01 ) ! (in)


  !---------------------------------------------------------
  !  EqualAxes ƥ
  !  "EqualAxes" test
  !---------------------------------------------------------
  allocate( x_Lon (0:63) )
  allocate( y_Lat (0:31) )
  allocate( z_Sigma (0:19) )
  allocate( r_Sigma (0:20) )

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test00.nc', varname = 'lon', & ! (in)
    & array = x_Lon, quiet = .true. )                          ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test00.nc', varname = 'lat', & ! (in)
    & array = y_Lat, quiet = .true. )                          ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test00.nc', varname = 'sig', & ! (in)
    & array = z_Sigma, quiet = .true. )                        ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test00.nc', varname = 'sigm', & ! (in)
    & array = r_Sigma, quiet = .true. )                         ! (out)

  call EqualAxes( dyn_sp_as = dyn_sp_as00, &  ! (inout)
    & x_Lon = x_Lon,     y_Lat = y_Lat, &     ! (in)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma, & ! (in)
    & err = err )                             ! (out)

  call AssertEqual( '"EqualAxes" test 1', &
    & answer = .false., check = err )

  !---------------------------------------------------------
  !  Dynamics ƥѤνͥǡɤ߹
  !  Load initial data for "Dynamics" test
  !---------------------------------------------------------
  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Vor', & ! (in)
    & array = xyz_VorB, range='time=253428', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Div', & ! (in)
    & array = xyz_DivB, range='time=253428', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Temp', & ! (in)
    & array = xyz_TempB, range='time=253428', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Ps', & ! (in)
    & array = xy_PsB, range='time=253428', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVapB, range='time=253428', quiet = .false. )  ! (out)


  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Vor', & ! (in)
    & array = xyz_VorN, range='time=253440', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Div', & ! (in)
    & array = xyz_DivN, range='time=253440', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Temp', & ! (in)
    & array = xyz_TempN, range='time=253440', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'Ps', & ! (in)
    & array = xy_PsN, range='time=253440', quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test01.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVapN, range='time=253440', quiet = .false. )  ! (out)


  !---------------------------------------------------------
  !  Dynamics ƥ (ߥץꥷåˡ)
  !  "Dynamics" test (Semi-implicit scheme)
  !---------------------------------------------------------
  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test02.nc', varname = 'Vor', & ! (in)
    & array = xyz_VorAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test02.nc', varname = 'Div', & ! (in)
    & array = xyz_DivAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test02.nc', varname = 'Temp', & ! (in)
    & array = xyz_TempAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test02.nc', varname = 'Ps', & ! (in)
    & array = xy_PsAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test02.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVapAns, quiet = .false. )  ! (out)


  call Dynamics ( dyn_sp_as = dyn_sp_as00, &
    & xyz_VorB  = xyz_VorB,  xyz_DivB  = xyz_DivB, &  ! (in)
    & xyz_TempB = xyz_TempB, xyz_QVapB = xyz_QVapB, & ! (in)
    & xy_PsB    = xy_PsB, &                           ! (in)
!
    & xyz_VorN  = xyz_VorN,  xyz_DivN  = xyz_DivN, &  ! (in)
    & xyz_TempN = xyz_TempN, xyz_QVapN = xyz_QVapN, & ! (in)
    & xy_PsN    = xy_PsN, &                           ! (in)
!
    & xyz_VorA  = xyz_VorA,  xyz_DivA  = xyz_DivA, &  ! (out)
    & xyz_TempA = xyz_TempA, xyz_QVapA = xyz_QVapA, & ! (out)
    & xy_PsA    = xy_PsA )                            ! (out)

!!$  call HistoryCreate( &
!!$    & file = 'dyn_spectral_as83_test02.nc', &               ! (in)
!!$    & title = 'Test data for ' // &
!!$    &   '"Dynamics#dyn_spectral_as83_test" ' // &
!!$    &   '(Semi-implicit scheme)', &                        ! (in)
!!$    & source = source, institution = institution, &         ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &           ! (in)
!!$    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &          ! (in)
!!$    & longnames = &
!!$    &   StoA('longitude', 'latitude', &
!!$    &        'sigma at layer midpoints', &
!!$    &        'sigma at layer end-points (half level))'), &  ! (in)
!!$    & units = StoA('degree_east', 'degree_north', &
!!$    &              '1', '1') )                              ! (in)
!!$
!!$  call HistoryPut( &
!!$    & varname = 'lon', array = x_Lon / PI * 180.0_DP )  ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'lat', array = y_Lat / PI * 180.0_DP )  ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'sig', array = z_Sigma )  ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'sigm', array = r_Sigma )  ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Vor', &                            ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'vorticity', &                     ! (in)
!!$    & units = 's-1', xtype = 'double' )             ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Div', &                            ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'divergence', &                    ! (in)
!!$    & units = 's-1', xtype = 'double' )             ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Temp', &                           ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'temperature', &                   ! (in)
!!$    & units = 'K', xtype = 'double' )               ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'QVap', &                           ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'specific humidity', &             ! (in)
!!$    & units = '1', xtype = 'double' )               ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Ps', &                       ! (in)
!!$    & dims = StoA('lon', 'lat'), &            ! (in)
!!$    & longname = 'surface pressure', &        ! (in)
!!$    & units = 'Pa', xtype = 'double' )        ! (in)
!!$
!!$  call HistoryPut( &
!!$    & varname = 'Vor', array = xyz_VorA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'Div', array = xyz_DivA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'Temp', array = xyz_TempA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'QVap', array = xyz_QVapA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'Ps', array = xy_PsA )   ! (in)
!!$
!!$  call HistoryClose

  call MessageNotify( 'M', subname, &
    & 'Testing "Dynamics" (Semi-implicit scheme) ...' )

  where ( xyz_VorAns < 0.0_DP )
    xyz_VorAnsG = xyz_VorAns + 1.0e-16_DP
    xyz_VorAnsL = xyz_VorAns - 1.0e-16_DP
  elsewhere
    xyz_VorAnsG = xyz_VorAns - 1.0e-16_DP
    xyz_VorAnsL = xyz_VorAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_Vor test 1-1', &
    & answer = xyz_VorAnsG * 0.999999999_DP, &
    & check = xyz_VorA )

  call AssertLessThan( &
    & 'xyz_Vor test 1-1', &
    & answer = xyz_VorAnsL * 1.000000001_DP, &
    & check = xyz_VorA )

  where ( xyz_DivAns < 0.0_DP )
    xyz_DivAnsG = xyz_DivAns + 1.0e-16_DP
    xyz_DivAnsL = xyz_DivAns - 1.0e-16_DP
  elsewhere
    xyz_DivAnsG = xyz_DivAns - 1.0e-16_DP
    xyz_DivAnsL = xyz_DivAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_Div test 1-1', &
    & answer = xyz_DivAnsG * 0.999999999_DP, &
    & check = xyz_DivA )

  call AssertLessThan( &
    & 'xyz_Div test 1-1', &
    & answer = xyz_DivAnsL * 1.000000001_DP, &
    & check = xyz_DivA )

  where ( xyz_TempAns < 0.0_DP )
    xyz_TempAnsG = xyz_TempAns + 1.0e-16_DP
    xyz_TempAnsL = xyz_TempAns - 1.0e-16_DP
  elsewhere
    xyz_TempAnsG = xyz_TempAns - 1.0e-16_DP
    xyz_TempAnsL = xyz_TempAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_Temp test 1-1', &
    & answer = xyz_TempAnsG * 0.999999999_DP, &
    & check = xyz_TempA )

  call AssertLessThan( &
    & 'xyz_Temp test 1-1', &
    & answer = xyz_TempAnsL * 1.000000001_DP, &
    & check = xyz_TempA )

  where ( xy_PsAns < 0.0_DP )
    xy_PsAnsG = xy_PsAns + 1.0e-16_DP
    xy_PsAnsL = xy_PsAns - 1.0e-16_DP
  elsewhere
    xy_PsAnsG = xy_PsAns - 1.0e-16_DP
    xy_PsAnsL = xy_PsAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xy_Ps test 1-1', &
    & answer = xy_PsAnsG * 0.999999999_DP, &
    & check = xy_PsA )

  call AssertLessThan( &
    & 'xy_Ps test 1-1', &
    & answer = xy_PsAnsL * 1.000000001_DP, &
    & check = xy_PsA )

  where ( xyz_QVapAns < 0.0_DP )
    xyz_QVapAnsG = xyz_QVapAns + 1.0e-16_DP
    xyz_QVapAnsL = xyz_QVapAns - 1.0e-16_DP
  elsewhere
    xyz_QVapAnsG = xyz_QVapAns - 1.0e-16_DP
    xyz_QVapAnsL = xyz_QVapAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_QVap test 1-1', &
    & answer = xyz_QVapAnsG * 0.999999999_DP, &
    & check = xyz_QVapA )

  call AssertLessThan( &
    & 'xyz_QVap test 1-1', &
    & answer = xyz_QVapAnsL * 1.000000001_DP, &
    & check = xyz_QVapA )



  !---------------------------------------------------------
  !  Dynamics ƥ (ץꥷåˡ)
  !  "Dynamics" test (Explicit scheme)
  !---------------------------------------------------------
  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test03.nc', varname = 'Vor', & ! (in)
    & array = xyz_VorAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test03.nc', varname = 'Div', & ! (in)
    & array = xyz_DivAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test03.nc', varname = 'Temp', & ! (in)
    & array = xyz_TempAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test03.nc', varname = 'Ps', & ! (in)
    & array = xy_PsAns, quiet = .false. )  ! (out)

  call HistoryGet ( &
    & file = 'dyn_spectral_as83_test03.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVapAns, quiet = .false. )  ! (out)

  call Dynamics ( dyn_sp_as = dyn_sp_as01, &
    & xyz_VorB  = xyz_VorB,  xyz_DivB  = xyz_DivB, &  ! (in)
    & xyz_TempB = xyz_TempB, xyz_QVapB = xyz_QVapB, & ! (in)
    & xy_PsB    = xy_PsB, &                           ! (in)
!
    & xyz_VorN  = xyz_VorN,  xyz_DivN  = xyz_DivN, &  ! (in)
    & xyz_TempN = xyz_TempN, xyz_QVapN = xyz_QVapN, & ! (in)
    & xy_PsN    = xy_PsN, &                           ! (in)
!
    & xyz_VorA  = xyz_VorA,  xyz_DivA  = xyz_DivA, &  ! (out)
    & xyz_TempA = xyz_TempA, xyz_QVapA = xyz_QVapA, & ! (out)
    & xy_PsA    = xy_PsA )                            ! (out)

!!$  call HistoryCreate( &
!!$    & file = 'dyn_spectral_as83_test03.nc', &               ! (in)
!!$    & title = 'Test data for ' // &
!!$    &   '"Dynamics#dyn_spectral_as83_test" ' // &
!!$    &   '(Explicit scheme)', &                              ! (in)
!!$    & source = source, institution = institution, &         ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &           ! (in)
!!$    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &          ! (in)
!!$    & longnames = &
!!$    &   StoA('longitude', 'latitude', &
!!$    &        'sigma at layer midpoints', &
!!$    &        'sigma at layer end-points (half level))'), &  ! (in)
!!$    & units = StoA('degree_east', 'degree_north', &
!!$    &              '1', '1') )                              ! (in)
!!$
!!$  call HistoryPut( &
!!$    & varname = 'lon', array = x_Lon / PI * 180.0_DP )  ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'lat', array = y_Lat / PI * 180.0_DP )  ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'sig', array = z_Sigma )  ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'sigm', array = r_Sigma )  ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Vor', &                            ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'vorticity', &                     ! (in)
!!$    & units = 's-1', xtype = 'double' )             ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Div', &                            ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'divergence', &                    ! (in)
!!$    & units = 's-1', xtype = 'double' )             ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Temp', &                           ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'temperature', &                   ! (in)
!!$    & units = 'K', xtype = 'double' )               ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'QVap', &                           ! (in)
!!$    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
!!$    & longname = 'specific humidity', &             ! (in)
!!$    & units = '1', xtype = 'double' )               ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & varname = 'Ps', &                       ! (in)
!!$    & dims = StoA('lon', 'lat'), &            ! (in)
!!$    & longname = 'surface pressure', &        ! (in)
!!$    & units = 'Pa', xtype = 'double' )        ! (in)
!!$
!!$  call HistoryPut( &
!!$    & varname = 'Vor', array = xyz_VorA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'Div', array = xyz_DivA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'Temp', array = xyz_TempA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'QVap', array = xyz_QVapA )   ! (in)
!!$  call HistoryPut( &
!!$    & varname = 'Ps', array = xy_PsA )   ! (in)
!!$
!!$  call HistoryClose

  call MessageNotify( 'M', subname, &
    & 'Testing "Dynamics" (Explicit scheme) ...' )

  where ( xyz_VorAns < 0.0_DP )
    xyz_VorAnsG = xyz_VorAns + 1.0e-16_DP
    xyz_VorAnsL = xyz_VorAns - 1.0e-16_DP
  elsewhere
    xyz_VorAnsG = xyz_VorAns - 1.0e-16_DP
    xyz_VorAnsL = xyz_VorAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_Vor test 1-1', &
    & answer = xyz_VorAnsG * 0.999999999_DP, &
    & check = xyz_VorA )

  call AssertLessThan( &
    & 'xyz_Vor test 1-1', &
    & answer = xyz_VorAnsL * 1.000000001_DP, &
    & check = xyz_VorA )

  where ( xyz_DivAns < 0.0_DP )
    xyz_DivAnsG = xyz_DivAns + 1.0e-16_DP
    xyz_DivAnsL = xyz_DivAns - 1.0e-16_DP
  elsewhere
    xyz_DivAnsG = xyz_DivAns - 1.0e-16_DP
    xyz_DivAnsL = xyz_DivAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_Div test 1-1', &
    & answer = xyz_DivAnsG * 0.999999999_DP, &
    & check = xyz_DivA )

  call AssertLessThan( &
    & 'xyz_Div test 1-1', &
    & answer = xyz_DivAnsL * 1.000000001_DP, &
    & check = xyz_DivA )

  where ( xyz_TempAns < 0.0_DP )
    xyz_TempAnsG = xyz_TempAns + 1.0e-16_DP
    xyz_TempAnsL = xyz_TempAns - 1.0e-16_DP
  elsewhere
    xyz_TempAnsG = xyz_TempAns - 1.0e-16_DP
    xyz_TempAnsL = xyz_TempAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_Temp test 1-1', &
    & answer = xyz_TempAnsG * 0.999999999_DP, &
    & check = xyz_TempA )

  call AssertLessThan( &
    & 'xyz_Temp test 1-1', &
    & answer = xyz_TempAnsL * 1.000000001_DP, &
    & check = xyz_TempA )

  where ( xy_PsAns < 0.0_DP )
    xy_PsAnsG = xy_PsAns + 1.0e-16_DP
    xy_PsAnsL = xy_PsAns - 1.0e-16_DP
  elsewhere
    xy_PsAnsG = xy_PsAns - 1.0e-16_DP
    xy_PsAnsL = xy_PsAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xy_Ps test 1-1', &
    & answer = xy_PsAnsG * 0.999999999_DP, &
    & check = xy_PsA )

  call AssertLessThan( &
    & 'xy_Ps test 1-1', &
    & answer = xy_PsAnsL * 1.000000001_DP, &
    & check = xy_PsA )

  where ( xyz_QVapAns < 0.0_DP )
    xyz_QVapAnsG = xyz_QVapAns + 1.0e-16_DP
    xyz_QVapAnsL = xyz_QVapAns - 1.0e-16_DP
  elsewhere
    xyz_QVapAnsG = xyz_QVapAns - 1.0e-16_DP
    xyz_QVapAnsL = xyz_QVapAns + 1.0e-16_DP
  end where

  call AssertGreaterThan( &
    & 'xyz_QVap test 1-1', &
    & answer = xyz_QVapAnsG * 0.999999999_DP, &
    & check = xyz_QVapA )

  call AssertLessThan( &
    & 'xyz_QVap test 1-1', &
    & answer = xyz_QVapAnsL * 1.000000001_DP, &
    & check = xyz_QVapA )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( dyn_sp_as00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(dyn_sp_as00) )
  call PutLine( dyn_sp_as00 )

  call Close( dyn_sp_as02, & ! (inout)
    & err )                  ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program dyn_spectral_as83_test
