!= ϳز (ڥȥˡ, Arakawa and Suarez (1983))
!
!= Dynamical Core (Spectral method, Arakawa and Suarez (1983))
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dyn_spectral_as83.f90,v 1.22 2007/10/10 19:44:29 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dyn_spectral_as83
  !
  != ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  !
  != Dynamical Core (Spectral method, Arakawa and Suarez (1983))
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϳز黻⥸塼Ǥ. 
  ! ʿΥ˥ڥȥˡ, ľΥˤ Arakawa and Suarez (1983)
  ! ѤƤޤ.
  !
  ! ʬˡˤϥ꡼ץեåѤƤޤ.
  ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
  ! ߥץꥷåˡŬѤƤޤ.
  ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
  ! ܤ Create  NAMELIST#dyn_as83_nml 򻲾ȤƤ.
  !
  ! This is a dynamical core module. Spectral method (for horizontal) and 
  ! Arakawa and Suarez (1983) method (for vertical) are used.
  !
  ! Leap-frog scheme is used as time integration. 
  ! By default, semi-implicit scheme is applied to gravitational terms 
  ! for extension of $ \Delta t $ . 
  ! Explicit scheme can be applied to gravitational terms. 
  ! For details, see "Create" or "NAMELIST#dyn_as83_nml". 
  !
  !== Procedures List
  !
  ! Create        :: DYNSPAS83 ѿν
  ! EqualAxes     :: DYNSPAS83 ѿ˳ǼƤɸͤγǧ
  ! GetAxes       :: ɸͤμ
  ! Dynamics      :: ϳزα黻
  ! Close         :: DYNSPAS83 ѿνλ
  ! PutLine       :: DYNSPAS83 ѿ˳ǼƤΰ
  ! initialized   :: DYNSPAS83 ѿꤵƤ뤫ݤ
  ! SetTime       :: 
  ! ------------  :: ------------
  ! Create        :: Constructor of "DYNSPAS83"
  ! EqualAxes     :: Confirm data of axes in "DYNSPAS83"
  ! GetAxes       :: Get data of axes
  ! Dynamics      :: Calculation of dynamical core
  ! Close         :: Deconstructor of "DYNSPAS83"
  ! PutLine       :: Print information of "DYNSPAS83"
  ! initialized   :: Check initialization of "DYNSPAS83"
  ! SetTime       :: Configure time
  !
  !== Usage
  !
  ! ץλϤ, DYNSPAS83 ѿ Create ǽޤ.
  ! , ʬ롼Ǳ, ȯ, , 漾, ɽ̵ 
  ! ( $ t $  $ t-\Delta t $ )  Dynamics ͿƤ. 
  ! ͤѤϳزα黻Ԥ, 
  ! $ t+\Delta t $ ®, ®, , ȯ, , 漾, 
  ! ɽ̵ޤ.
  ! Ǹ, DYNSPAS83 ѿνλ Close ˤƹԤޤ.
  ! ץǺɸͤɬפȤʤˤ, GetAxes Ѥ
  ! ɸͤƤ.
  !
  ! In the begging of program, initialize "DYNSPAS83" by "Create".
  ! Next, in the time integration loop, 
  ! provide vorticity, divergence, temperature, specific humidity,
  ! surface pressure on $ t $ and $ t-\Delta t $ to Dynamics.
  ! Then the physical values at $ t+\Delta t $ is returned.
  ! Finally, terminate "DYNSPAS83" by "Close".
  ! If you need data of axes, get that by GetAxes.
  !
  !== References
  !
  ! * Arakawa, A., Suarez, M. J., 1983:
  !   Vertical differencing of the primitive equations
  !   in sigma coordinates.
  !   <i>Mon. Wea. Rev.</i>, <b>111</b>, 34--35.

  use dc_types, only: DP, TOKEN, STRING
  use dyn_spectral, only: DYNSP
  use dyn_as83, only: DYNAS83
  use dc_date_types, only: DC_DIFFTIME
  use gt4_history, only: GT_HISTORY
  implicit none
  private
  public:: DYNSPAS83, DYNSPAS83_HISTNML, Create, Close, PutLine, initialized
  public:: EqualAxes
  public:: GetAxes, Dynamics, VorDiv2UV, UV2VorDiv

  type DYNSPAS83
    !
    ! ޤ, Create  "DYNSPAS83" ѿꤷƲ.
    ! 줿 "DYNSPAS83" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "DYNSPAS83" variable by "Create" before usage.
    ! If you reuse "DYNSPAS83" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag

    !-----------------------------------------------------------------
    !  ʻȿ
    !  Grid points and maximum truncated wavenumber
    !-----------------------------------------------------------------
    integer:: nmax ! ȿ. 
                   ! Maximum truncated wavenumber
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    type(DYNSP):: dyn_sp
    type(DYNAS83):: dyn_as

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
    type(DC_DIFFTIME):: current_time
                              ! ߻. Current time.
    type(DC_DIFFTIME):: delta_time
                              ! $ Delta t $ . ॹƥå. Time step

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------
    character(TOKEN), pointer:: history_varlist_array(:) =>null()
                              ! ҥȥǡνѿꥹ. 
                              ! List of variables output to history data. 
    character(STRING):: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames

    type(DYNSPAS83_HISTNML), pointer:: hist_nml(:) =>null()
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              !  1 ܤˤϥǥեȤ꤬Ǽ
                              ! , 2 ܰʹߤ˸̤꤬Ǽ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#dyn_spectral_as83_history_nml". 
                              ! Default settings are stored in 
                              ! the first element of this array, 
                              ! and individual settings are stored in 
                              ! the second or more.

    !-----------------------------------
    !  gt4_history ⥸塼ѹ¤
    !  Derived type for "gt4_history" module
    type(GT_HISTORY):: gthist_sigmadot
    type(GT_HISTORY):: gthist_dpidt
  end type DYNSPAS83

  type DYNSPAS83_HISTNML
    !
    ! NAMELIST#dyn_spectral_as83_history_nml ǡνϾ
    ! ̤˼뤿ι¤ǡǤ. λȤ
    ! ԤʤǤ. 
    !
    ! This derived type is worked for input information about 
    ! data output individually from 
    ! "NAMELIST#dyn_spectral_as83_history_nml" 
    ! Do not refer this derived type externally. 
    !
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    character(STRING):: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    type(DC_DIFFTIME):: history_interval_time
                              ! ҥȥǡνϴֳ. 
                              ! Interval of history data output
    real(DP):: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(TOKEN):: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical:: history_average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data.
    logical:: dummy0          ! 8 ӥåȶѤΥߡѿ. 
                              ! Dummy variable for 8 bit boundary
  end type DYNSPAS83_HISTNML

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: dyn_spectral_as83.f90,v 1.22 2007/10/10 19:44:29 morikawa Exp $'

  interface Create
    module procedure DynSpectralAS83Create
  end interface

  interface Close
    module procedure DynSpectralAS83Close
  end interface

  interface PutLine
    module procedure DynSpectralAS83PutLine
  end interface

  interface initialized
    module procedure DynSpectralAS83Initialized
  end interface

  interface NmlRead
    module procedure DynSpectralAS83NmlRead
  end interface

  interface HstNmlAssoc
    module procedure DynSpectralAS83HstNmlAssoc
  end interface

  interface SetTime
    module procedure DynSpectralAS83SetTime
  end interface

  interface EqualAxes
    module procedure DynSpectralAS83EqualAxes
  end interface

  interface GetAxes
    module procedure DynSpectralAS83GetAxes
  end interface

  interface Dynamics
    module procedure DynSpectralAS83Dynamics
  end interface

  interface VorDiv2UV
    module procedure DynSpectralAS83VorDiv2UV
  end interface

  interface UV2VorDiv
    module procedure DynSpectralAS83UV2VorDiv
  end interface

contains

  subroutine DynSpectralAS83Create( dyn_sp_as, &
    & nmax, imax, jmax, kmax, &
    & PI, RPlanet, Omega, Cp, RAir, EpsVT, VisOrder, EFoldTime, &
!!$    & Grav, &
    & DelTime, &
    & xy_Phis, &
    & openmp_threads, &
    & r_SigmaSet, &
    & wa_module_initialized, &
    & time_integration_scheme, &
    & current_time_value, current_time_unit, &
    & history_varlist, &
    & history_interval_value, history_interval_unit, &
    & history_precision, history_fileprefix, &
    & nmlfile, err)
    !
    !  *dyn_sp_as* ϳزԤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! DYNSPAS83 ѿꤷƤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#dyn_spectral_as83_nml 򻲾ȤƤ. 
    !
    ! Configure the settings for dynamical core to *dyn_sp_as*.
    ! Before other subroutines are used, initialize "DYNSPAS83"
    ! variable.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#dyn_spectral_as83_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: STRING, DP, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_date, only: Create, EvalSec, EvalByUnit
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use dyn_spectral, only: Create, &
      & GetCoriolis, GetSpectralCoeff, GetDiffCoeff, GetPhis, GetAxes
    use dyn_as83, only: Create, GetAxes
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, &
      & HistoryAddAttr
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    integer, intent(in):: nmax ! ȿ. 
                               ! Maximum truncated wavenumber
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in):: RPlanet   ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(in):: Omega     ! $ \Omega $ . ž®.     Angular velocity
!!$    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in):: EpsVT     ! $ 1/\epsilon_v - 1 $ .
    integer, intent(in):: VisOrder   ! ĶǴμ.  Order of hyper-viscosity
    real(DP), intent(in):: EFoldTime ! ȿФ e-folding time. E-folding time for maximum wavenumber
    real(DP), intent(in):: DelTime ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in), optional:: xy_Phis (0:imax-1, 0:jmax-1)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential
    integer, intent(in), optional:: openmp_threads
                              ! OPENMP Ǥκ祹åɿ.
                              ! openmp_threads  1 礭ͤꤹ 
                              ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
                              ! εĴȡѴ OPENMP ׻
                              ! 롼Ѥ. ׻¹Ԥˤ,
                              ! ¹Ի˴Ķѿ OMP_NUM_THREADS 
                              !  openmp_threads ʲοꤹ
                              ! Υƥ˱ɬפȤʤ.
                              !
                              ! openmp_threads  1 礭ͤ
                              ! ꤷʤ׻롼ϸƤФʤ.
                              !
                              ! Maximum number of threads in OPENMP. 
                              ! If integer more than 1 is given, 
                              ! spherical harmonics transration subroutines 
                              ! with OPENMP parallel computation in 
                              ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
                              ! is used. In practice, specify environment 
                              ! variable (OMP_NUM_THREADS etc.) for parallel
                              ! computation.
                              !
                              ! If number less than 2 is given, 
                              ! subroutines of parallel computation 
                              ! is not called.
    real(DP), intent(in), optional:: r_SigmaSet (:)
                              ! ǥեȤǤ, kmax ͤ˱,
                              ! ưŪ $ \sigma $ ٥ (Ⱦ) 
                              ! ꤵ (kmax ͤΤ).
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Ūꤹɬפ, 
                              ! ΰͿ.
                              !
                              ! By default, half $ \sigma $ level is 
                              ! specified automatically according to
                              ! the value of kmax (only the value is 
                              ! same as particular values).
                              ! If the half $ \sigma $ level is specified
                              ! manually, give this argument.
    logical, intent(in), optional :: wa_module_initialized
                              ! wa_module (SPMODEL 饤֥) ե饰. 
                              ! SPMODEL 饤֥ wa_module  
                              ! 
                              ! ˥ץ 
                              ! wa_Initial ˤäƽƤ, 
                              !  wa_Initial Ƥ֤ȥ顼ޤ.
                              ! ΰ .true. Ϳ뤳Ȥ, 
                              ! wa_Initial ƤФʤ褦ˤޤ.
                              ! 
                              ! "wa_module" (SPMODEL library) 
                              ! initialization flag. 
                              ! 
                              ! When "wa_module" (SPMODEL library) 
                              ! is initialized by
                              ! "wa_Initial" already, second "wa_Initial"
                              ! causes an error.
                              ! If .true. is specified to this argument,
                              ! "wa_Initial" is not called.
                              ! 
    character(*), intent(in), optional:: time_integration_scheme
                              ! ʬˡ. 
                              ! ʲˡǽ. 
                              !
                              ! Time integration scheme. 
                              ! Available schemes are as follows.
                              ! 
                              ! * "Semi-implicit"
                              ! * "Explicit"
                              ! 
    real(DP), intent(in), optional:: current_time_value
                              ! ߻ο. Numerical value of current time
    character(*), intent(in), optional:: current_time_unit
                              ! ߻ñ. Unit of current time
    character(*), intent(in), optional:: history_varlist
                              ! ҥȥǡνѿꥹ. 
                              ! ޤǶڤä¤٤. 
                              ! (: "Data1,Data2" ). 
                              ! 
                              ! List of variables output to history data. 
                              ! Delimiter is comma. 
                              ! (exp. "Data1,Data2" ). 
                              ! 
    real(DP), intent(in), optional:: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(*), intent(in), optional:: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(in), optional:: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    character(*), intent(in), optional:: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#dyn_spectral_as83_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#dyn_spectral_as83_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(DYNSPAS83_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#dyn_spectral_as83_history_nml" 
    character(STRING):: history_filename
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    character(STRING):: history_varlist_work

    real(DP):: x_Lon (0:imax-1)
                              ! . Longitude
    real(DP):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP):: x_Lon_Weight(0:imax-1)
                              ! ٺɸŤ. 
                              ! Weight of longitude
    real(DP):: y_Lat_Weight(0:jmax-1)
                              ! ٺɸŤ. 
                              ! Weight of latitude
    real(DP):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level


    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: xy_Cori (0:imax-1, 0:jmax-1)
                              ! $ f\equiv 2\Omega\sin\varphi $ . 
                              ! ꥪѥ᡼. Coriolis parameter
    integer:: nmo (1:2, 0:nmax, 0:nmax)
                              ! ڥȥź. 
                              ! Spectral subscript expression
    real(DP):: wz_rn ((nmax+1)**2, 0:kmax-1)
                              ! $ -n \times (n+1) $ . ץ饷η. 
                              ! Laplacian coefficient
    real(DP):: wz_DiffVorDiv ((nmax+1)**2, 0:kmax-1)
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion
    real(DP):: wz_DiffTherm ((nmax+1)**2, 0:kmax-1)
                              ! $ -(-1)^{N_D/2}K_{HD}\nabla^{N_D} $ . 
                              ! Ǯ, ʿȻ. 
                              ! Coefficient of horizontal thermal and water diffusion
    real(DP):: w_Phis ((nmax+1)**2)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83Create'
  continue
    call BeginSub(subname, version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (dyn_sp_as % initialized) then
      stat = DC_EALREADYINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (nmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'nmax'
      goto 999
    end if
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    dyn_sp_as % nmax = nmax
    dyn_sp_as % imax = imax
    dyn_sp_as % jmax = jmax
    dyn_sp_as % kmax = kmax

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
    if ( present(current_time_value) .and. present(current_time_unit) ) then
      call Create( &
        & diff = dyn_sp_as % current_time, & ! (out)
        & value = current_time_value, &    ! (in)
        & unit = current_time_unit )       ! (in)
    else
      call Create( &
        & diff = dyn_sp_as % current_time, & ! (out)
        & value = 0.0_DP, &    ! (in)
        & unit = 'sec' )       ! (in)
    end if

    call Create( &
      & diff = dyn_sp_as % delta_time, & ! (out)
      & value = DelTime, &             ! (in)
      & unit = 'sec' )                 ! (in)

    !-----------------------------------------------------------------
    !  ڥȥˡ
    !  Configure the settings for spectral method
    !-----------------------------------------------------------------
    call Create( dyn_sp = dyn_sp_as % dyn_sp, &                   ! (inout)
      & nmax = nmax, imax = imax, jmax = jmax, kmax = kmax, &     ! (in)
      & PI = PI, RPlanet = RPlanet, Omega = Omega, Cp = Cp, &     ! (in)
      & VisOrder = VisOrder, EFoldTime = EFoldTime, &             ! (in)
      & DelTime = DelTime, &                                      ! (in)
      & xy_Phis = xy_Phis, &                                      ! (in)
      & openmp_threads = openmp_threads, &                        ! (in)
      & wa_module_initialized = wa_module_initialized, &          ! (in)
      & nmlfile = nmlfile )                                       ! (in)

    !-----------------------------------------------------------------
    !  Arakawa and Suarez (1983) 
    !  Configure the settings for Arakawa and Suarez (1983)
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  ꥪѥ᡼μ
    !  Get Coriolis parameter
    call GetCoriolis( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & xy_Cori = xy_Cori ) ! (out)

    !---------------------------------------------
    !  ڥȥ뷸μ
    !  Get spectral coefficient
    call GetSpectralCoeff( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & nmo = nmo, wz_rn = wz_rn ) ! (out)

    !---------------------------------------------
    !  Ȼμ
    !  Get diffusion coefficient
    call GetDiffCoeff( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & wz_DiffVorDiv = wz_DiffVorDiv, wz_DiffTherm = wz_DiffTherm ) ! (out)

    !---------------------------------------------
    !  Ϸǡ (ɽ $ \Phi $ )μ
    !  Get geography data (surface $ \Phi $ )
    call GetPhis( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & w_Phis = w_Phis ) ! (out)

    call Create( dyn_as = dyn_sp_as % dyn_as, &                   ! (inout)
      & nmax = nmax, imax = imax, jmax = jmax, kmax = kmax, &     ! (in)
      & PI = PI, RPlanet = RPlanet, &                             ! (in)
      & Cp = Cp, RAir = RAir, EpsVT = EpsVT, &                    ! (in)
      & DelTime = DelTime, &                                      ! (in)
      & xy_Cori = xy_Cori, &                                      ! (in)
      & nmo = nmo, wz_rn = wz_rn, &                               ! (in)
      & wz_DiffVorDiv = wz_DiffVorDiv, &                          ! (in)
      & wz_DiffTherm = wz_DiffTherm, &                            ! (in)
      & r_SigmaSet = r_SigmaSet, w_Phis = w_Phis, &               ! (in)
      & time_integration_scheme = time_integration_scheme, &      ! (in)
      & nmlfile = nmlfile )                                       ! (in)


    !-----------------------------------------------------------------
    !  ٷٺɸͤμ
    !  Get data of latitude and longitude
    !-----------------------------------------------------------------
    call GetAxes( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & x_Lon = x_Lon, y_Lat = y_Lat, & ! (out)
      & x_Lon_Weight = x_Lon_Weight, &  ! (out)
      & y_Lat_Weight = y_Lat_Weight )   ! (out)

    !-----------------------------------------------------------------
    !  ľ٥ɸͤμ
    !  Get data of vertical level
    !-----------------------------------------------------------------
    call GetAxes( dyn_as = dyn_sp_as % dyn_as, &  ! (inout)
      & z_Sigma = z_Sigma, r_Sigma = r_Sigma ) ! (out)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------
    if ( associated( dyn_sp_as % hist_nml ) ) deallocate( dyn_sp_as % hist_nml )
    allocate( dyn_sp_as % hist_nml(1) )

    !-------------------------
    !  ǥե
    !  Default values
    history_varlist_work             = ''
    dyn_sp_as % history_fileprefix = ''
    dyn_sp_as % hist_nml(1) % name = ''
    dyn_sp_as % hist_nml(1) % file = ''
    dyn_sp_as % hist_nml(1) % history_interval_value = -1.0_DP
    dyn_sp_as % hist_nml(1) % history_interval_unit  = 'sec'
    dyn_sp_as % hist_nml(1) % history_precision      = 'float'
    dyn_sp_as % hist_nml(1) % history_average        = .false.

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    if ( present(history_varlist)        ) history_varlist_work                               = history_varlist       
    if ( present(history_fileprefix)     ) dyn_sp_as % history_fileprefix                   = history_fileprefix    
    if ( present(history_interval_value) ) dyn_sp_as % hist_nml(1) % history_interval_value = history_interval_value
    if ( present(history_interval_unit)  ) dyn_sp_as % hist_nml(1) % history_interval_unit  = history_interval_unit 
    if ( present(history_precision)      ) dyn_sp_as % hist_nml(1) % history_precision      = history_precision     

    !-----------------------------------------------------------------
    !  NAMELIST ͤɤ߹
    !  Load values from NAMELIST
    !-----------------------------------------------------------------
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1 = trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &      ! (in)
        & history_varlist_    = history_varlist_work, &             ! (inout)
        & history_fileprefix_ = dyn_sp_as % history_fileprefix, & ! (inout)
        & hist_nml            = dyn_sp_as % hist_nml, &           ! (inout)
        & err = err )                          ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1 = trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  ҥȥ꡼ǡ˴ؤ
    !  Time control for history data
    !-----------------------------------------------------------------
    call Create( &
      & diff = dyn_sp_as % hist_nml(1) % history_interval_time, & ! (out)
      & value = dyn_sp_as % hist_nml(1) % history_interval_value, & ! (in)
      & unit = dyn_sp_as % hist_nml(1) % history_interval_unit )    ! (in)

    !-----------------------------------------------------------------
    !  HistoryCreate ˤե
    !  Files are created by "HistoryCreate"
    !-----------------------------------------------------------------
    call Split( &
      & str = history_varlist_work, sep = ',', &       ! (in)
      & carray = dyn_sp_as % history_varlist_array ) ! (out)

    !-------------------------
    !  xyr_SigmaDot ν
    !  Configure the settings for "xyr_SigmaDot" output
    name = 'SigmaDot'
    history_filename = trim(dyn_sp_as % history_fileprefix) // 'SigmaDot.nc'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      call HistoryCreate( &
        & history = dyn_sp_as % gthist_sigmadot, &                   ! (out)
        & file = history_filename, & ! (in)
        & title = 'Dynamical core calculation', &  ! (in)
        & source = 'dcpam4 : ' // trim(version), &             ! (in)
        & institution = 'GFD Dennou Club', &                   ! (in)
        & dims = StoA('lon', 'lat', 'sig', 'sigm', 'time'), &  ! (in)
        & dimsizes = (/imax, jmax, kmax, kmax + 1, 0/), &      ! (in)
        & longnames = StoA('longitude', 'latitude', &
        &                  'sigma at layer midpoints', &
        &                  'sigma at layer end-points (half level)', &
        &                  'time'), &                           ! (in)
        & units = StoA('degree_east', 'degree_north', &
        &              '1', '1', hptr % history_interval_unit), & ! (in)
        & origin = real(EvalbyUnit(dyn_sp_as % current_time, &
        &                          hptr % history_interval_unit)), &   ! (in)
        & interval = real(EvalbyUnit(hptr % history_interval_time, &
        &                            hptr % history_interval_unit)) )  ! (in)

      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &             ! (inout)
        & varname = 'lon', attrname = 'standard_name', & ! (in)
        & value = 'longitude' )                          ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &             ! (inout)
        & varname = 'lat', attrname = 'standard_name', & ! (in)
        & value = 'latitude' )                           ! (in)

      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, &               ! (inout)
        & varname = 'lon', array = x_Lon / PI * 180.0_DP ) ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, &               ! (inout)
        & varname = 'lat', array = y_Lat / PI * 180.0_DP ) ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, & ! (inout)
        & varname = 'sig', array = z_Sigma ) ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, &  ! (inout)
        & varname = 'sigm', array = r_Sigma ) ! (in)

      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &             ! (inout)
        & varname = 'lon', attrname = 'standard_name', & ! (in)
        & value = 'longitude' )                          ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &             ! (inout)
        & varname = 'lat', attrname = 'standard_name', & ! (in)
        & value = 'latitude' )                           ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &               ! (inout)
        & varname = 'sig', attrname = 'standard_name', &   ! (in)
        & value = 'atmosphere_sigma_coordinate' )          ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &               ! (inout)
        & varname = 'sigm', attrname = 'standard_name', &  ! (in)
        & value = 'atmosphere_sigma_coordinate' )          ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &              ! (inout)
        & varname = 'time', attrname = 'standard_name', & ! (in)
        & value = 'time' )                                ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &          ! (inout)
        & varname = 'sig', attrname = 'positive', &   ! (in)
        & value = 'down' )                            ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &          ! (inout)
        & varname = 'sigm', attrname = 'positive', &  ! (in)
        & value = 'down' )                            ! (in)

      call HistoryAddVariable( &
        & history = dyn_sp_as % gthist_sigmadot, &                  ! (inout)
        & varname = 'lon_weight', &                           ! (in)
        & dims = StoA('lon'), &                               ! (in)
        & longname = 'weight for integration in longitude', & ! (in)
        & units = 'radian', xtype = 'double' )                ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &              ! (inout)
        & varname = 'lon', attrname = 'gt_calc_weight', & ! (in)
        & value = 'lon_weight' )                          ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, &             ! (inout)
        & varname = 'lon_weight', array = x_Lon_Weight ) ! (in)

      call HistoryAddVariable( &
        & history = dyn_sp_as % gthist_sigmadot, &                 ! (inout)
        & varname = 'lat_weight', &                          ! (in)
        & dims = StoA('lat'), &                              ! (in)
        & longname = 'weight for integration in latitude', & ! (in)
        & units = 'radian', xtype = 'double' )               ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_sigmadot, &              ! (inout)
        & varname = 'lat', attrname = 'gt_calc_weight', & ! (in)
        & value = 'lat_weight' )                          ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, &             ! (inout)
        & varname = 'lat_weight', array = y_Lat_Weight ) ! (in)

      call HistoryAddVariable( &
        & history = dyn_sp_as % gthist_sigmadot, & ! (inout)
        & varname = 'SigmaDot', &                    ! (in)
        & dims = StoA('lon', 'lat', 'sigm', 'time'), & ! (in)
        & longname = 'sigma-vertical velocity', &      ! (in)
        & units = '1/s', &                          ! (in)
        & xtype = hptr % history_precision )      ! (in)

    end if


    !-------------------------
    !  xy_DPiDt ν
    !  Configure the settings for "xy_DPiDt" output
    name = 'DPiDt'
    history_filename = trim(dyn_sp_as % history_fileprefix) // 'DPiDt.nc'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)
    if ( trim(hptr % file) /= '' ) history_filename = trim(hptr % file)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then

      call HistoryCreate( &
        & history = dyn_sp_as % gthist_dpidt, &                   ! (out)
        & file = history_filename, & ! (in)
        & title = 'Dynamical core calculation', &  ! (in)
        & source = 'dcpam4 : ' // trim(version), &             ! (in)
        & institution = 'GFD Dennou Club', &                   ! (in)
        & dims = StoA('lon', 'lat', 'time'), &  ! (in)
        & dimsizes = (/imax, jmax, 0/), &      ! (in)
        & longnames = StoA('longitude', 'latitude', 'time'), & ! (in)
        & units = StoA('degree_east', 'degree_north', &
        &              hptr % history_interval_unit), & ! (in)
        & origin = real(EvalbyUnit(dyn_sp_as % current_time, &
        &                          hptr % history_interval_unit)), &   ! (in)
        & interval = real(EvalbyUnit(hptr % history_interval_time, &
        &                            hptr % history_interval_unit)) )  ! (in)

      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &             ! (inout)
        & varname = 'lon', attrname = 'standard_name', & ! (in)
        & value = 'longitude' )                          ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &             ! (inout)
        & varname = 'lat', attrname = 'standard_name', & ! (in)
        & value = 'latitude' )                           ! (in)

      call HistoryPut( &
        & history = dyn_sp_as % gthist_dpidt, &               ! (inout)
        & varname = 'lon', array = x_Lon / PI * 180.0_DP ) ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_dpidt, &               ! (inout)
        & varname = 'lat', array = y_Lat / PI * 180.0_DP ) ! (in)

      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &             ! (inout)
        & varname = 'lon', attrname = 'standard_name', & ! (in)
        & value = 'longitude' )                          ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &             ! (inout)
        & varname = 'lat', attrname = 'standard_name', & ! (in)
        & value = 'latitude' )                           ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &              ! (inout)
        & varname = 'time', attrname = 'standard_name', & ! (in)
        & value = 'time' )                                ! (in)

      call HistoryAddVariable( &
        & history = dyn_sp_as % gthist_dpidt, &                  ! (inout)
        & varname = 'lon_weight', &                           ! (in)
        & dims = StoA('lon'), &                               ! (in)
        & longname = 'weight for integration in longitude', & ! (in)
        & units = 'radian', xtype = 'double' )                ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &              ! (inout)
        & varname = 'lon', attrname = 'gt_calc_weight', & ! (in)
        & value = 'lon_weight' )                          ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_dpidt, &             ! (inout)
        & varname = 'lon_weight', array = x_Lon_Weight ) ! (in)

      call HistoryAddVariable( &
        & history = dyn_sp_as % gthist_dpidt, &                 ! (inout)
        & varname = 'lat_weight', &                          ! (in)
        & dims = StoA('lat'), &                              ! (in)
        & longname = 'weight for integration in latitude', & ! (in)
        & units = 'radian', xtype = 'double' )               ! (in)
      call HistoryAddAttr( &
        & history = dyn_sp_as % gthist_dpidt, &              ! (inout)
        & varname = 'lat', attrname = 'gt_calc_weight', & ! (in)
        & value = 'lat_weight' )                          ! (in)
      call HistoryPut( &
        & history = dyn_sp_as % gthist_dpidt, &             ! (inout)
        & varname = 'lat_weight', array = y_Lat_Weight ) ! (in)

      call HistoryAddVariable( &
        & history = dyn_sp_as % gthist_dpidt, & ! (inout)
        & varname = 'DPiDt', &                    ! (in)
        & dims = StoA('lon', 'lat', 'time'), & ! (in)
        & longname = 'Pi (log Ps) tendency', & ! (in)
        & units = 'Pa/s', &                       ! (in)
        & xtype = hptr % history_precision )      ! (in)

    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    dyn_sp_as % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83Create

  subroutine DynSpectralAS83Close( dyn_sp_as, err )
    !
    ! DYNSPAS83 ѿνλԤޤ.
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "DYNSPAS83".
    ! Note that if *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dyn_spectral, only: Close
    use dyn_as83, only: Close
    use gt4_history, only: HistoryClose
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(DYNSPAS83_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#dyn_spectral_as83_history_nml" 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83Close'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp_as % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ڥȥˡ Arakawa and Suarez (1983) ξõ
    !  Clear the settings for spectral method and Arakawa and Suarez (1983)
    !-----------------------------------------------------------------
    call Close(dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & err = err) ! (out)
    call Close(dyn_as = dyn_sp_as % dyn_as, & ! (inout)
      & err = err) ! (out)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡϤνλ
    !  Terminate the settings for history data output
    !-----------------------------------------------------------------

    !-------------------------
    !  xyr_SigmaDot νϤνλ
    !  Terminate the settings for "xyr_SigmaDot" output
    name = 'SigmaDot'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = dyn_sp_as % gthist_sigmadot ) ! (inout)
    end if

    !-------------------------
    !  xy_DPiDt νϤνλ
    !  Terminate the settings for "xy_DPiDt" output
    name = 'DPiDt'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) &
      &  .and. hptr % history_interval_value > 0.0_DP ) then
      call HistoryClose( &
        & history = dyn_sp_as % gthist_dpidt ) ! (inout)
    end if

    nullify( hptr )
    deallocate( dyn_sp_as % hist_nml )
    deallocate( dyn_sp_as % history_varlist_array )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    dyn_sp_as % initialized = .false.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83Close

  subroutine DynSpectralAS83PutLine( dyn_sp_as, unit, indent, err )
    !
    !  *dyn_sp_as* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *dyn_sp_as*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dyn_spectral, only: PutLine
    use dyn_as83, only: PutLine
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    character(*), parameter:: subname = 'DynSpectralAS83PutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if

    !-----------------------------------------------------------------
    !  "DYNSPAS83" ΰ
    !  Print the settings for "DYNSPAS83"
    !-----------------------------------------------------------------
    if (dyn_sp_as % initialized) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<DYNSPAS83:: @initialized=%y', &
        & l=(/dyn_sp_as % initialized/))

      hmax = size( dyn_sp_as % hist_nml )

      do i = 1, hmax

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & ' #<DYNSPAS83_HISTNML:: @name=%c @file=%c', &
          & c1 = trim(dyn_sp_as % hist_nml(i) % name), &
          & c2 = trim(dyn_sp_as % hist_nml(i) % file) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @history_interval_value=%f @history_interval_unit=%c', &
          & d = (/dyn_sp_as % hist_nml(i) % history_interval_value/), &
          & c1 = trim(dyn_sp_as % hist_nml(i) % history_interval_unit) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @history_precision=%c @history_average=%c', &
          & c1 = trim(dyn_sp_as % hist_nml(i) % history_precision), &
          & l = (/ dyn_sp_as % hist_nml(i) % history_average /) )

      end do

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' >' )

    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<DYNSPAS83:: @initialized=%y', &
        & l=(/dyn_sp_as % initialized/))
    end if

    call PutLine(dyn_sp_as % dyn_sp, out_unit, &
      & indent_str(1:indent_len) // &
      & ' ', err)
    call PutLine(dyn_sp_as % dyn_as, out_unit, &
      & indent_str(1:indent_len) // &
      & ' ', err)

    call Printf(out_unit, &
      & indent_str(1:indent_len) // &
      & '>')

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83PutLine

  logical function DynSpectralAS83Initialized( dyn_sp_as ) result(result)
    !
    ! *dyn_sp_as* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *dyn_sp_as* is initialized, .true. is returned.
    ! If *dyn_sp_as* is not initialized, .false. is returned.
    !
    implicit none
    type(DYNSPAS83), intent(in):: dyn_sp_as
  continue
    result = dyn_sp_as % initialized
  end function DynSpectralAS83Initialized

  subroutine DynSpectralAS83NmlRead( nmlfile, &
    & history_varlist_, &
    & history_fileprefix_, &
    & hist_nml, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_date, only: Create
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD, DC_ENOASSOC
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    character(*), intent(inout):: history_varlist_
    character(STRING):: history_varlist
                              ! ҥȥǡνѿꥹ. 
                              ! ޤǶڤä¤٤. 
                              ! (: "Data1,Data2" ). 
                              ! 
                              ! List of variables output to history data. 
                              ! Delimiter is comma. 
                              ! (exp. "Data1,Data2" ). 
                              ! 
    character(*), intent(inout):: history_fileprefix_
    character(STRING):: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames
    type(DYNSPAS83_HISTNML), pointer:: hist_nml(:)
                              ! (inout)
                              ! 
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              !  1 ܤˤϥǥեȤ꤬Ǽ
                              ! , 2 ܰʹߤ˸̤꤬Ǽ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#dyn_spectral_as83_history_nml". 
                              ! Default settings are stored in 
                              ! the first element of this array, 
                              ! and individual settings are stored in 
                              ! the second or more.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /dyn_spectral_as83_nml/ &
!!$      & param_i, param_r, param_c
                              ! dyn_spectral_as83 ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! dyn_spectral_as83#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "dyn_spectral_as83" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "dyn_spectral_as83#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    namelist /dyn_spectral_as83_varlist_nml/ &
      & history_varlist
                              ! dyn_spectral_as83 ⥸塼
                              ! ҥȥǡϥꥹ
                              ! NAMELIST ѿ̾.
                              !
                              ! dyn_spectral_as83#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! output list of history data of 
                              ! "dyn_spectral_as83" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "dyn_spectral_as83#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    character(TOKEN):: name
                              ! ѿ̾. 
                              ! ξˤ, ¾ͤ
                              ! dyn_spectral_as83 ⥸塼ˤ
                              ! ϤǡƤ
                              ! ǥեͤȤʤޤ.
                              ! 
                              ! Variable name. 
                              ! If blank is given, other values are 
                              ! used as default values of output data 
                              ! in "dyn_spectral_as83"
    character(STRING):: file
                              ! ϥե̾. 
                              ! ϥǥեͤȤƤϻѤޤ. 
                              ! *name* ͤꤵƤΤͭǤ. 
                              ! 
                              ! Output file name. 
                              ! This is not used as default value. 
                              ! This value is valid only when *name* is 
                              ! specified. 

    real(DP):: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(TOKEN):: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data

    logical:: history_average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data.

    namelist /dyn_spectral_as83_history_nml/ &
      & name, &
      & file, &
      & history_interval_value, &
      & history_interval_unit, &
      & history_precision, &
      & history_fileprefix, &
      & history_average
                              ! dyn_spectral_as83 ⥸塼Υҥȥǡ
                              ! NAMELIST ѿ̾.
                              !
                              ! dyn_spectral_as83#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! history data of "dyn_spectral_as83" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "dyn_spectral_as83#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.


    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(TOKEN):: pos_nml
                              ! NAMELIST ɤ߹߻Υե. 
                              ! File position of NAMELIST read
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    type(DYNSPAS83_HISTNML), allocatable:: hist_nml_work(:)
    character(*), parameter:: subname = 'DynSpectralAS83NmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  վ֤γǧ
    !  Check allocation
    !-----------------------------------------------------------------
    if ( .not. associated( hist_nml ) ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    if ( size( hist_nml ) < 1 ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
    history_varlist       = history_varlist_
    history_fileprefix    = history_fileprefix_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    !-------------------------
    !  ʤɤμ
    !  Get coefficients etc.
!!$    rewind( unit_nml )
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = dyn_spectral_as83_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'dyn_spectral_as83_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = dyn_spectral_as83_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'dyn_spectral_as83_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    !-------------------------
    !  ѿꥹȼ
    !  Get list of output variables
    rewind( unit_nml )
    read( unit = unit_nml, & ! (in)
      & nml = dyn_spectral_as83_varlist_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dyn_spectral_as83_varlist_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = dyn_spectral_as83_varlist_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='dyn_spectral_as83_varlist_nml', c2=trim(nmlfile), &
        & i = (/iostat_nml/) )
    end if

    !-------------------------
    !  ϥǡθ̾μ
    !  Get individual information of output data
    rewind( unit_nml )
    iostat_nml = 0
    pos_nml = ''
    do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

      name                   = ''
      file                   = ''
      history_interval_value = hist_nml(1) % history_interval_value 
      history_interval_unit  = hist_nml(1) % history_interval_unit  
      history_precision      = hist_nml(1) % history_precision      
      history_average        = hist_nml(1) % history_average        

      read( unit = unit_nml, & ! (in)
        & nml = dyn_spectral_as83_history_nml, iostat = iostat_nml ) ! (out)
      inquire( unit_nml, &     ! (in)
        & position = pos_nml ) ! (out)

      if ( iostat_nml == 0 ) then
        call MessageNotify( 'M', subname, &
          & 'NAMELIST group "%c" is loaded from "%c".', &
          & c1='dyn_spectral_as83_history_nml', c2=trim(nmlfile) )
        write(STDOUT, nml = dyn_spectral_as83_history_nml)

        if ( name == '' ) then
          hist_nml(1) % name                   = name                   
          hist_nml(1) % file                   = ''
          hist_nml(1) % history_interval_value = history_interval_value 
          hist_nml(1) % history_interval_unit  = history_interval_unit  
          hist_nml(1) % history_precision      = history_precision      
          hist_nml(1) % history_average        = history_average        

          call Create( &
            & diff = hist_nml(1) % history_interval_time, & ! (out)
            & value = history_interval_value, &    ! (in)
            & unit = history_interval_unit )       ! (in)

        elseif ( file /= '' ) then
          hmax = size( hist_nml )
          allocate( hist_nml_work(hmax) )
          hist_nml_work = hist_nml
          deallocate( hist_nml )
          allocate( hist_nml(hmax+1) )
          hist_nml(1:hmax) = hist_nml_work
          deallocate( hist_nml_work )

          if ( trim(history_varlist) /= '' ) history_varlist = trim( history_varlist ) // ','
          history_varlist = trim( history_varlist ) // trim(name)

          hist_nml(hmax+1) % name                   = name                   
          hist_nml(hmax+1) % file                   = file                   
          hist_nml(hmax+1) % history_interval_value = history_interval_value 
          hist_nml(hmax+1) % history_interval_unit  = history_interval_unit  
          hist_nml(hmax+1) % history_precision      = history_precision      
          hist_nml(hmax+1) % history_average        = history_average        

          call Create( &
            & diff = hist_nml(hmax+1) % history_interval_time, & ! (out)
            & value = history_interval_value, &    ! (in)
            & unit = history_interval_unit )       ! (in)

        end if

      else
        call MessageNotify( 'W', subname, &
          & 'NAMELIST group "%c" is not found in "%c" any more (iostat=%d).', &
          & c1='dyn_spectral_as83_history_nml', c2=trim(nmlfile), &
          & i = (/iostat_nml/) )
      end if
    end do

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
    history_varlist_       = history_varlist
    history_fileprefix_    = history_fileprefix

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine DynSpectralAS83NmlRead

  subroutine DynSpectralAS83HstNmlAssoc( &
    & name, hist_nml, hptr, &
    & err )
    !
    ! ǡϾ󤬳Ǽ줿ݥ *hist_nml*  
    ! *name* ˳ǡξ *hptr* 礷֤ޤ. 
    !
    ! *hist_nml* դƤʤ, 顼֤ޤ. 
    !
    ! Associate *hptr* to information of data correspond to *name* 
    ! stored in pointer array *hist_nml*, and return it. 
    !
    ! If *hist_nml* is not allocated, error is occured. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOASSOC
    implicit none
    character(*), intent(in):: name
                              ! ѿ̾. Variable name
    type(DYNSPAS83_HISTNML), pointer:: hist_nml(:)
                              ! (in)
                              ! 
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              !  1 ܤˤϥǥեȤ꤬Ǽ
                              ! , 2 ܰʹߤ˸̤꤬Ǽ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#dyn_spectral_as83_history_nml". 
                              ! Default settings are stored in 
                              ! the first element of this array, 
                              ! and individual settings are stored in 
                              ! the second or more.
    type(DYNSPAS83_HISTNML), pointer:: hptr
                              ! (out)
                              ! 
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#dyn_spectral_as83_history_nml" 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    character(*), parameter:: subname = 'DynSpectralAS83HstNmlAssoc'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  վ֤γǧ
    !  Check allocation
    !-----------------------------------------------------------------
    if ( .not. associated( hist_nml ) ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    if ( size( hist_nml ) < 1 ) then
      stat = DC_ENOASSOC
      cause_c = 'hist_nml'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *hist_nml* ˳Ǽ, *name* ˳ǡط
    !  Associate information of data correspond to *name* 
    !  stored in pointer array *hist_nml*
    !-----------------------------------------------------------------
    hmax = size( hist_nml )

    if ( associated(hptr) ) nullify( hptr )
    do i = 1, hmax
      if ( trim(hist_nml(i) % name) == trim(name) ) &
        & hptr => hist_nml(i)
    end do
    if ( .not. associated(hptr) ) hptr => hist_nml(1)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine DynSpectralAS83HstNmlAssoc

  subroutine DynSpectralAS83SetTime( dyn_sp_as, &
    & current_time_value, current_time_unit, &
    & err )
    !
    ! *dyn_sp_as* ФƻԤޤ. 
    !
    !--
    ! ҥȥǡϤƤˤ, ҥȥǡ
    ! ϻꤷޤ. ٤Ǥ⤳Υ֥롼Ƥˤ, 
    ! ʸΥҥȥǡˤΥ֥롼ƤӽФ, 
    ! ԤäƤ. 
    ! ޤ, ǡϤ륵֥롼ФƤ 
    ! ץʥ historyput_flag  .true. ͿƤ. 
    !++
    !
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Set time to *dyn_sp_as*.
    !
    !--
    ! When history data are output, the output time of history data 
    ! are specified. 
    ! Once this subroutine is called, the time of history data must be
    ! specified by this routine before history data output
    ! In additional, give ".true." to an optional argument 
    ! "historyput_flag" of a data output subroutine. 
    !++
    !
    ! If *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_date, only: Create, EvalbyUnit
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gt4_history, only: HistorySetTime
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    real(DP), intent(in):: current_time_value
                              ! ߻ο. Numerical value of current time
    character(*), intent(in):: current_time_unit
                              ! ߻ñ. Unit of current time
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(DYNSPAS83_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#dyn_spectral_as83_history_nml" 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: hmax            ! hist_nml(:) Υ. 
                              ! Size of "hist_nml(:)"
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    character(*), parameter:: subname = 'DynSpectralAS83SetTime'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. dyn_sp_as % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  
    !  Configure time
    !-----------------------------------------------------------------
    call Create( &
      & diff = dyn_sp_as % current_time, & ! (out)
      & value = current_time_value, &    ! (in)
      & unit = current_time_unit )       ! (in)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡλ
    !  Configure the time of history data
    !-----------------------------------------------------------------
    hmax = size( dyn_sp_as % hist_nml )
    do i = 1, hmax
      dyn_sp_as % hist_nml(i) % history_interval_value = - 1.0_DP
      call Create( &
        & diff = dyn_sp_as % hist_nml(i) % history_interval_time, & ! (out)
        & value = dyn_sp_as % hist_nml(i) % history_interval_value, &    ! (in)
        & unit = dyn_sp_as % hist_nml(i) % history_interval_unit )       ! (in)
    end do

    !-------------------------
    !  xyr_SigmaDot λ
    !  Configure the time of "xyr_SigmaDot"
    name = 'SigmaDot'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = dyn_sp_as % gthist_sigmadot, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( dyn_sp_as % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-------------------------
    !  xy_DPiDt λ
    !  Configure the time of "xy_DPiDt"
    name = 'DPiDt'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) ) then
      call HistorySetTime( &
        & history = dyn_sp_as % gthist_dpidt, &    ! (inout)
        & time = &
        &   real( EvalbyUnit( dyn_sp_as % current_time, &
        &                     hptr % history_interval_unit) ) ) ! (in)
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine DynSpectralAS83SetTime

  subroutine DynSpectralAS83EqualAxes( dyn_sp_as, &
    & x_Lon, y_Lat, z_Sigma, r_Sigma, &
    & err )
    !
    ! Ϳ줿ɸǡ  *dyn_sp_as* 
    ! ݻɸǡȤǧޤ.
    ! ۤʤˤϥ顼ȯޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Confirm equality between given axes data and 
    ! axes data stored in *dyn_sp_as*. 
    ! If the equality is not confirmed, error is occurred.
    !
    ! If *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT, DCPAM_EAXISMISMATCH
    use dyn_spectral, only: EqualAxes
    use dyn_as83, only: EqualAxes
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    real(DP), intent(in), optional:: x_Lon (0:dyn_sp_as%imax-1)
                              ! . Longitude
    real(DP), intent(in), optional:: y_Lat (0:dyn_sp_as%jmax-1)
                              ! . Latitude
    real(DP), intent(in), optional:: z_Sigma (0:dyn_sp_as%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(in), optional:: r_Sigma (0:dyn_sp_as%kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83EqualAxes'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp_as % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ǡ
    !  Compare axes data
    !-----------------------------------------------------------------
    call EqualAxes( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & x_Lon = x_Lon, y_Lat = y_Lat, &            ! (in)
      & err = err )                                ! (out)

    call EqualAxes( dyn_as = dyn_sp_as % dyn_as, & ! (inout)
      & z_Sigma = z_Sigma, r_Sigma = r_Sigma, &    ! (in)
      & err = err )                                ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83EqualAxes

  subroutine DynSpectralAS83GetAxes( dyn_sp_as, &
    & x_Lon, y_Lat, z_Sigma, r_Sigma, z_DelSigma, &
    & err )
    !
    ! *dyn_sp_as* ˳ǼƤɸ֤ͤޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return data of axes stored in *dyn_sp_as*.
    !
    ! If *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dyn_spectral, only: GetAxes
    use dyn_as83, only: GetAxes
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    real(DP), intent(out):: x_Lon (0:dyn_sp_as%imax-1)
                              ! . Longitude
    real(DP), intent(out):: y_Lat (0:dyn_sp_as%jmax-1)
                              ! . Latitude
    real(DP), intent(out):: z_Sigma (0:dyn_sp_as%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(out):: r_Sigma (0:dyn_sp_as%kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), intent(out), optional:: z_DelSigma (0:dyn_sp_as%kmax-1)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83Sample'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp_as % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ٷٺɸͤμ
    !  Get data of latitude and longitude
    !-----------------------------------------------------------------
    call GetAxes( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & x_Lon = x_Lon, y_Lat = y_Lat ) ! (out)

    !-----------------------------------------------------------------
    !  ľ٥ɸͤμ
    !  Get data of vertical level
    !-----------------------------------------------------------------
    call GetAxes( dyn_as = dyn_sp_as % dyn_as, &  ! (inout)
      & z_Sigma = z_Sigma, r_Sigma = r_Sigma, & ! (out)
      & z_DelSigma = z_DelSigma ) ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83GetAxes


  subroutine DynSpectralAS83Dynamics( dyn_sp_as, &
    & xyz_VorB, xyz_DivB, xyz_TempB, xyz_QVapB, xy_PsB, &
    & xyz_VorN, xyz_DivN, xyz_TempN, xyz_QVapN, xy_PsN, &
    & xyz_VorA, xyz_DivA, xyz_TempA, xyz_QVapA, xy_PsA, &
    & historyput_flag, &
    & err )
    !
    ! ϳزα黻Ԥ, Ϳ줿 $ t-\Delta t $  $ t $ 
    ! , ȯ, , 漾, ɽ̵, 
    ! $ t+\Delta t $ 
    ! , ȯ, , 漾, ɽ̵ ֤ޤ.
    !
    ! ʬˡˤϥ꡼ץեåѤƤޤ.
    ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
    ! ߥץꥷåˡŬѤƤޤ.
    ! , Create  *time_integration_scheme* 
    ! "Explicit" ꤷˤϽȹ⥨ץꥷåˡˤä
    ! 򤭤ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculating dynamical core, 
    ! from vorticity, divergence, temperature, specific humidity,
    ! surface pressure at $ t-\Delta t $ and $ t $, the
    ! physical values at $ t+\Delta t $ are returned.
    !
    ! Leap-frog scheme is used as time integration. 
    ! By default, semi-implicit scheme is applied to gravitational terms 
    ! for extension of $ \Delta t $ . 
    ! If "Explicit" is specified to *time_integration_scheme* in "Create", 
    ! explicit scheme is applied to gravitational terms as well as 
    ! other terms.
    !
    ! If *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP, TOKEN
    use dc_string, only: LChar, PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_true
    use dc_date, only: mod, operator(+), operator(==), EvalbyUnit
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dyn_spectral, only: GradPi, VorDiv2UV, Tendency, TendencyExplicit, &
      & Spectral2Grid, Grid2Spectral, &
      & DiffusionCorrectTemp, DiffusionVorDiv
    use dyn_as83, only: NonLinearOnGrid, TimeIntegration, Inquire, &
      & WTplusGPiOnGrid, HDivOnGrid
    use gt4_history, only: HistoryPut
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    real(DP), intent(in):: xyz_VorB (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
    real(DP), intent(in):: xyz_DivB (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
    real(DP), intent(in):: xyz_TempB (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ T (t-\Delta t) $ .     . Temperature
    real(DP), intent(in):: xy_PsB (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1)
                              ! $ P_s (t-\Delta t) $ .   ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_QVapB (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_VorN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ \zeta (t) $ . . Vorticity
    real(DP), intent(in):: xyz_DivN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ D (t) $ .     ȯ. Divergence
    real(DP), intent(in):: xyz_TempN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xy_PsN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1)
                              ! $ P_s (t) $ .   ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_QVapN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(out):: xyz_VorA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ \zeta (t+\Delta t) $ . . Vorticity
    real(DP), intent(out):: xyz_DivA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ D (t+\Delta t) $ .     ȯ. Divergence
    real(DP), intent(out):: xyz_TempA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ T (t+\Delta t) $ .     . Temperature
    real(DP), intent(out):: xy_PsA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1)
                              ! $ P_s (t+\Delta t) $ .   ɽ̵. Surface pressure
    real(DP), intent(out):: xyz_QVapA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ q (t+\Delta t) $ .     漾. Specific humidity
    logical, intent(in), optional:: historyput_flag
                              ! ǡϤΥե饰. 
                              ! SetTime ˤäƻŪ
                              ! ꤷˤ, ΰ
                              ! .true. ޤ .false. ꤹ
                              ! ȤǥǡϤΥ󥪥դ
                              ! Ū˻ꤹɬפޤ. 
                              ! ǥեȤ .false. Ǥ.
                              ! 
                              ! Data output flag. 
                              ! When time is specified by "SetTime", 
                              ! explicit specification of data output
                              ! on/off by specifying ".true." or ".false."
                              ! to this argument.
                              ! Default value is ".false.". 
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: xy_GradLonPiN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1)
                              ! $ \DD{\pi}{x} (t) $
    real(DP):: xy_GradLatPiN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1)
                              ! $ \DD{\pi}{y} (t) $
    real(DP):: xyz_UN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ U (t) $ . ®. Zonal wind.
    real(DP):: xyz_VN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ V (t) $ . ®. Meridional wind.
    real(DP):: xyz_UA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                 ! $ U (t+\Delta t) $ . ®. Zonal wind
    real(DP):: xyz_VA (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ V (t+\Delta t) $ . ®. Meridional wind
    real(DP):: xyz_UAdvN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ UA (t) $ . ư̰ή. 
                              ! Zonal advection of momentum
    real(DP):: xyz_VAdvN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ VA (t) $ . ̱ư̰ή. 
                              ! Meridional advection of momentum
    real(DP):: xyz_DTempDtN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ H (t) $ . ٻѲ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ R (t) $ . 漾Ѳ. 
                              ! Specific humidity tendency
    real(DP):: xyz_KEN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ E (t) $ . ưͥ륮. 
                              ! Kinematic energy
    real(DP):: xyz_TempUAdvN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ UT (t) $ . ή. 
                              ! Zonal advection of temperature
    real(DP):: xyz_TempVAdvN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ VT (t) $ . ̰ή. 
                              ! Meridional advection of temperature
    real(DP):: xyr_SigmaDotN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή. Vertical flow
    real(DP):: xy_DPiDtN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1)
                              ! $ Z $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency
    real(DP):: xyz_QVapUAdvN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ Uq (t) $ . 漾ή. 
                              ! Zonal advection of specific humidity
    real(DP):: xyz_QVapVAdvN (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ Vq (t) $ . 漾̰ή. 
                              ! Meridional advection of specific humidity
    real(DP):: wz_DVorDtN ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \DD{\zeta}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP):: wz_DDivDtN ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \DD{D}{t} (t) $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP):: wz_DTempDtN ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP):: wz_DQVapDtN ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \DD{q}{t} (t) $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)
    real(DP):: w_DPiDtN ((dyn_sp_as%nmax+1)**2)
                              ! $ \DD{Ps}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP):: wz_VorB ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \zeta (t-\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP):: wz_DivB ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ D (t-\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP):: wz_TempB ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ T (t-\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP):: w_PiB ((dyn_sp_as%nmax+1)**2)
                              ! $ \pi = \ln P_s (t-\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP):: wz_QVapB ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ q (t-\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)
    real(DP):: wz_VorA ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \zeta (t+\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP):: wz_DivA ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ D (t+\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP):: wz_TempA ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ T (t+\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP):: w_PiA ((dyn_sp_as%nmax+1)**2)
                              ! $ \pi = \ln P_s (t+\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP):: wz_QVapA ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ q (t+\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)
    real(DP):: wz_VorDiffA ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \mathscr{D}(\zeta) $ . 
                              ! ư̿ʿȻˤ뱲Ѳ (ڥȥ). 
                              ! Vorticity tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP):: wz_DivDiffA ((dyn_sp_as%nmax+1)**2, 0:dyn_sp_as%kmax-1)
                              ! $ \mathscr{D}(D) $ . 
                              ! ư̿ʿȻˤȯѲ (ڥȥ). 
                              ! Divergence tendency by 
                              ! horizontal momentum diffusion (spectral)

    !-----------------------------------
    !  ץꥷåˡΤκѿ
    !  Work variables for explicit scheme
    real(DP):: xyz_exWTGPi (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ .

    real(DP):: xyz_exHDiv (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! $ \underline{h} \Dvect{D} $ .


    character(TOKEN):: time_integration_scheme
                              ! ʬˡ. 
                              ! ʲˡǽ. 
                              !
                              ! Time integration scheme. 
                              ! Available schemes are as follows.
                              ! 
                              ! * "Semi-implicit"
                              ! * "Explicit"
                              ! 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(TOKEN):: name
                              ! ѿ̾. Variable name
    type(DYNSPAS83_HISTNML), pointer:: hptr =>null()
                              ! NAMELIST#dyn_spectral_as83_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from
                              ! "NAMELIST#dyn_spectral_as83_history_nml" 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83Dynamics'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp_as % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if


    !-----------------------------------------------------------------
    !  ʬˡ䤤碌
    !  Inquire time integration scheme
    !-----------------------------------------------------------------
    call Inquire( dyn_as = dyn_sp_as % dyn_as, &            ! (in)
      & time_integration_scheme = time_integration_scheme ) ! (out)

    !-----------------------------------------------------------------
    !  Ѳη׻
    !  Calculate tendency terms
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  ɽ̵ζѲη׻
    !  Calculate spatial surface pressure tendency
    !
    call GradPi( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & xy_Ps = xy_PsN, &                        ! (in)
      & xy_GradLonPi = xy_GradLonPiN, &          ! (out)
      & xy_GradLatPi = xy_GradLatPiN )           ! (out)

    !---------------------------------------------
    !  ȯ®η׻
    !  Calculate wind velocity from vorticity and divergence
    !
    call VorDiv2UV( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & xyz_Vor = xyz_VorN, xyz_Div = xyz_DivN, &   ! (in)
      & xyz_U = xyz_UN, xyz_V = xyz_VN )            ! (out)

    !---------------------------------------------
    !  ʻǤϳعη׻
    !  Calculate non-linear dynamical terms on grid points
    !
    call NonLinearOnGrid( dyn_as = dyn_sp_as % dyn_as, &              ! (inout)
      & xyz_U = xyz_UN, xyz_V = xyz_VN, &                             ! (in)
      & xyz_Vor = xyz_VorN, xyz_Div = xyz_DivN, &                     ! (in)
      & xyz_Temp = xyz_TempN, xyz_QVap = xyz_QVapN, &                 ! (in)
      & xy_GradLonPi = xy_GradLonPiN, xy_GradLatPi = xy_GradLatPiN, & ! (in)
      & xyz_UAdv = xyz_UAdvN, xyz_VAdv = xyz_VAdvN, &                 ! (out)
      & xyz_DTempDt = xyz_DTempDtN, xyz_DQVapDt = xyz_DQVapDtN, &     ! (out)
      & xyz_KE = xyz_KEN, &                                           ! (out)
      & xyz_TempUAdv = xyz_TempUAdvN, xyz_TempVAdv = xyz_TempVAdvN, & ! (out)
      & xyr_SigmaDot = xyr_SigmaDotN, xy_DPiDt = xy_DPiDtN, &         ! (out)
      & xyz_QVapUAdv = xyz_QVapUAdvN, xyz_QVapVAdv = xyz_QVapVAdvN )  ! (out)

    !---------------------------------------------
    !  ڥȥѲη׻
    !  Calculate spectral tendency terms
    !
    call Tendency( dyn_sp = dyn_sp_as % dyn_sp, &                       ! (inout)
      & xyz_UAdv = xyz_UAdvN, xyz_VAdv = xyz_VAdvN, xyz_KE = xyz_KEN, & ! (in)
      & xyz_TempUAdv = xyz_TempUAdvN, &                                 ! (in)
      & xyz_TempVAdv = xyz_TempVAdvN, xyz_DTempDt = xyz_DTempDtN, &     ! (in)
      & xy_DPiDt = xy_DPiDtN, &                                         ! (in)
      & xyz_QVapUAdv = xyz_QVapUAdvN, xyz_QVapVAdv = xyz_QVapVAdvN, &   ! (in)
      & xyz_DQVapDt = xyz_DQVapDtN, &                                   ! (in)
      & wz_DVorDt = wz_DVorDtN, wz_DDivDt = wz_DDivDtN, &               ! (out)
      & wz_DTempDt = wz_DTempDtN, w_DPiDt = w_DPiDtN, &                 ! (out)
      & wz_DQVapDt = wz_DQVapDtN )                                      ! (out)

    !---------------------------------------------
    !  ץꥷåˡѤݤη׻
    !  Calculate for explicit scheme
    !
    select case ( LChar( trim( time_integration_scheme ) ) )
    case ('explicit')

      !---------------------------------------------
      !  $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ γʻͤη׻
      !  Calculate $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ on grid
      !
      call WTplusGPiOnGrid( dyn_as = dyn_sp_as % dyn_as, & ! (inout)
        & xyz_Temp = xyz_TempN,   xy_Ps = xy_PsN, &        ! (in)
        & xyz_exWTGPi = xyz_exWTGPi )                      ! (out)

      !---------------------------------------------
      !  $ \underline{h} \Dvect{D} $ γʻͤη׻
      !  Calculate $ \underline{h} \Dvect{D} $ on grid
      !
      call HDivOnGrid( dyn_as = dyn_sp_as % dyn_as, & ! (inout)
        & xyz_Div = xyz_DivN, &                       ! (in)
        & xyz_exHDiv = xyz_exHDiv )                   ! (out)

      !---------------------------------------------
      !  ȯ,  (ڥȥ) λѲν
      !  Modify divergence and temperature tencency (spectral)
      !
      call TendencyExplicit( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
        & xyz_exWTGPi = xyz_exWTGPi, &                      ! (in)
        & xyz_exHDiv = xyz_exHDiv, &                        ! (in)
        & wz_DDivDt = wz_DDivDtN, &                         ! (inout)
        & wz_DTempDt = wz_DTempDtN )                        ! (inout)

    end select


    !---------------------------------------------
    !  ʻͤ򥹥ڥȥͤ ( $ t-\Delta t$ )
    !  Exchange grid values to spectral values ( $ t-\Delta t$ )
    !
    call Grid2Spectral( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xyz_Data = xyz_VorB, &                         ! (in)
      & wz_Data = wz_VorB )                            ! (out)

    call Grid2Spectral( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xyz_Data = xyz_DivB, &                         ! (in)
      & wz_Data = wz_DivB )                            ! (out)

    call Grid2Spectral( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xyz_Data = xyz_TempB, &                        ! (in)
      & wz_Data = wz_TempB )                           ! (out)

    call Grid2Spectral( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xy_Data = xy_PsB, &                            ! (in)
      & math_func = 'log', &                           ! (in)
      & w_Data = w_PiB )                               ! (out)

    call Grid2Spectral( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xyz_Data = xyz_QVapB, &                        ! (in)
      & wz_Data = wz_QVapB )                           ! (out)

    !-----------------------------------------------------------------
    !  ʬ
    !  Time integration
    !-----------------------------------------------------------------

    call TimeIntegration( dyn_as = dyn_sp_as % dyn_as, &        ! (inout)
      & wz_DVorDtN = wz_DVorDtN,   wz_DDivDtN = wz_DDivDtN, &   ! (in)
      & wz_DTempDtN = wz_DTempDtN, wz_DQVapDtN = wz_DQVapDtN, & ! (in)
      & w_DPiDtN = w_DPiDtN, &                                  ! (in)
      & wz_VorB = wz_VorB,         wz_DivB = wz_DivB, &         ! (in)
      & wz_TempB = wz_TempB,       wz_QVapB = wz_QVapB, &       ! (in)
      & w_PiB = w_PiB, &                                        ! (in)
      & wz_VorA = wz_VorA,         wz_DivA = wz_DivA, &         ! (out)
      & wz_TempA = wz_TempA,       wz_QVapA = wz_QVapA, &       ! (out)
      & w_PiA = w_PiA )                                         ! (out)

    !---------------------------------------------
    !  ڥȥͤʻͤ ( $ t+\Delta t$ )
    !  Exchange spectral values to grid values ( $ t+\Delta t$ )
    !
    call Spectral2Grid( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & wz_Data = wz_VorA, &                           ! (in)
      & xyz_Data = xyz_VorA )                          ! (out)

    call Spectral2Grid( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & wz_Data = wz_DivA, &                           ! (in)
      & xyz_Data = xyz_DivA )                          ! (out)

    call Spectral2Grid( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & wz_Data = wz_TempA, &                          ! (in)
      & xyz_Data = xyz_TempA )                         ! (out)

    call Spectral2Grid( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & w_Data = w_PiA, &                              ! (in)
      & math_func = 'exp', &                           ! (in)
      & xy_Data = xy_PsA )                             ! (out)

    call Spectral2Grid( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & wz_Data = wz_QVapA, &                          ! (in)
      & xyz_Data = xyz_QVapA )                         ! (out)

    call VorDiv2UV( dyn_sp = dyn_sp_as % dyn_sp, &  ! (inout)
      & xyz_Vor = xyz_VorA, xyz_Div = xyz_DivA, &   ! (in)
      & xyz_U = xyz_UA, xyz_V = xyz_VA )            ! (out)

    !-----------------------------------------------------------------
    !  Ȼˤ
    !  Correction by diffusion
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  ư̿ʿȻˤ뱲ȯλѲ
    !  Vorticity and divergence tendency by 
    !  horizontal diffusion of momentum
    !
    call DiffusionVorDiv( dyn_sp = dyn_sp_as % dyn_sp, &     ! (inout)
      & wz_Vor = wz_VorA, wz_Div = wz_DivA, &                ! (in)
      & wz_VorDiff = wz_VorDiffA, wz_DivDiff = wz_DivDiffA ) ! (out)

    !---------------------------------------------
    !  ư̿ʿȻˤ໤Ǯ
    !  Frictional thermal correction by horizontal momentum diffusion
    !
    call DiffusionCorrectTemp( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & wz_VorDiff = wz_VorDiffA, wz_DivDiff = wz_DivDiffA, & ! (in)
      & xyz_U = xyz_UA, xyz_V = xyz_VA, &                     ! (in)
      & xyz_Temp = xyz_TempA )                                ! (inout)

    !----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  History data output
    !----------------------------------------------------------------

    !-------------------------
    !  xyr_SigmaDot ν
    !  Output "xyr_SigmaDot"
    name = 'SigmaDot'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) &
      &  .and. present_and_true( historyput_flag ) &
      &  .or. hptr % history_interval_value > 0.0_DP &
      &  .and. mod( dyn_sp_as % current_time, hptr % history_interval_time) == 0 ) then

      call HistoryPut( &
        & history = dyn_sp_as % gthist_sigmadot, &           ! (inout)
        & varname = 'SigmaDot', array = xyr_SigmaDotN, quiet = .false. ) ! (in)
    end if

    !-------------------------
    !  xy_DPiDt ν
    !  Output "xy_DPiDt"
    name = 'DPiDt'

    call HstNmlAssoc( &
      & hist_nml = dyn_sp_as % hist_nml, & ! (in)
      & name = name, &                       ! (in)
      & hptr = hptr )                        ! (out)

    if ( StrInclude( dyn_sp_as % history_varlist_array, name ) &
      &  .and. present_and_true( historyput_flag ) &
      &  .or. hptr % history_interval_value > 0.0_DP &
      &  .and. mod( dyn_sp_as % current_time, hptr % history_interval_time) == 0 ) then

      call HistoryPut( &
        & history = dyn_sp_as % gthist_dpidt, &           ! (inout)
        & varname = 'DPiDt', array = xy_DPiDtN, quiet = .false. ) ! (in)
    end if

    !-----------------------------------------------------------------
    !  ι
    !  Update time
    !-----------------------------------------------------------------
    dyn_sp_as % current_time = &
      & dyn_sp_as % current_time + dyn_sp_as % delta_time

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83Dynamics

  subroutine DynSpectralAS83VorDiv2UV( dyn_sp_as, &
    & xyz_Vor, xyz_Div, &
    & xyz_U, xyz_V, &
    & err )
    !
    ! Ϳ줿٤ȯ®®׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate zonal and meridional wind from given 
    ! vorticity and divergence.
    !
    ! If *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dyn_spectral, only: VorDiv2UV
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    real(DP), intent(in):: xyz_Vor (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              !  $ \zeta $
    real(DP), intent(in):: xyz_Div (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! ȯ $ D $
    real(DP), intent(out):: xyz_U (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! ® $ U $
    real(DP), intent(out):: xyz_V (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! ® $ V $
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83VorDiv2UV'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp_as % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȯ®η׻
    !  Calculate wind velocity from vorticity and divergence
    !-----------------------------------------------------------------
    call VorDiv2UV( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xyz_Vor = xyz_Vor, xyz_Div = xyz_Div, &    ! (in)
      & xyz_U = xyz_U, xyz_V = xyz_V )             ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83VorDiv2UV

  subroutine DynSpectralAS83UV2VorDiv( dyn_sp_as, &
    & xyz_Vor, xyz_Div, &
    & xyz_U, xyz_V, &
    & err )
    !
    ! Ϳ줿®®鱲٤ȯ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate vorticity and divergence
    ! from given zonal and meridional wind.
    !
    ! If *dyn_sp_as* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dyn_spectral, only: UV2VorDiv
    implicit none
    type(DYNSPAS83), intent(inout):: dyn_sp_as
    real(DP), intent(in):: xyz_U (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! ® $ U $
    real(DP), intent(in):: xyz_V (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! ® $ V $
    real(DP), intent(out):: xyz_Vor (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              !  $ \zeta $
    real(DP), intent(out):: xyz_Div (0:dyn_sp_as%imax-1, 0:dyn_sp_as%jmax-1, 0:dyn_sp_as%kmax-1)
                              ! ȯ $ D $
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralAS83UV2VorDiv'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp_as % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSPAS83'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ®鱲ȯη׻
    !  Calculate vorticity and divergence from wind velocity
    !-----------------------------------------------------------------
    call UV2VorDiv( dyn_sp = dyn_sp_as % dyn_sp, & ! (inout)
      & xyz_U = xyz_U, xyz_V = xyz_V, &            ! (in)
      & xyz_Vor = xyz_Vor, xyz_Div = xyz_Div )     ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralAS83UV2VorDiv


!!$  subroutine DynSpectralAS83Sample( dyn_sp_as, err )
!!$    !--
!!$    ! DynSpectralAS83Sample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *dyn_sp_as*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of DynSpectralAS83Sample
!!$    !++
!!$    ! If *dyn_sp_as* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: STRING, STDOUT
!!$    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
!!$    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
!!$    implicit none
!!$    type(DYNSPAS83), intent(inout):: dyn_sp_as
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'DynSpectralAS83Sample'
!!$  continue
!!$    call BeginSub(subname)
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if (.not. dyn_sp_as % initialized) then
!!$      stat = DCPAM_ENOTINIT
!!$      cause_c = 'DYNSPAS83'
!!$      goto 999
!!$    end if
!!$
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError(stat, subname, err, cause_c)
!!$    call EndSub(subname)
!!$  end subroutine DynSpectralAS83Sample


end module dyn_spectral_as83
