!= ϳز (ڥȥˡ)
!
!= Dynamical Core (Spectral method)
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dyn_spectral.f90,v 1.19 2007/10/10 19:43:20 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dyn_spectral
  !
  != ϳإ (ڥȥˡ)
  !
  != Dynamical Core (Spectral method)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϳإ⥸塼Ǥ. ʿΥˤϰʲμˡѤƤޤ.
  !
  ! * ڥȥˡ
  !   * ѷ
  !   * Ѵˡ
  !
  ! This is a dynamical core module. Used horizontal discretization
  ! method is as follows.
  !
  ! * Spectral Method
  !   * Triangle Truncation
  !   * Transform Method
  !
  !== Procedures List
  !
  ! Create               :: DYNSP ѿν
  ! Close                :: DYNSP ѿνλ
  ! PutLine              :: DYNSP ѿ˳ǼƤΰ
  ! initialized          :: DYNSP ѿꤵƤ뤫ݤ
  ! EqualAxes            :: DYNSP ѿ˳ǼƤɸͤγǧ
  ! GetAxes              :: DYNSP ѿ˳ǼƤɸͤμ
  ! GetCoriolis          :: ꥪѥ᡼μ
  ! GetSpectralCoeff     :: ڥȥźȥץ饷ημ
  ! GetDiffCoeff         :: ư̿ʿȻǮ, ʿȻμ
  ! GetPhis              :: Ϸǡ (ɽ $ \Phi $ ) Υڥȥͤ
  ! GradPi               :: ɽ̵ζѲη׻
  ! VorDiv2UV            :: ٤ȯ®®׻
  ! UV2VorDiv            :: ®®鱲٤ȯ׻
  ! Tendency             :: ٤ȯʤɤͽѿΥڥȥѲη׻
  ! TendencyExplicit     :: ȯ, ٤ΥڥȥѲϷ̤ʤɤɲ 
  !                         (ץꥷåˡǻ)
  ! Grid2Spectral        :: ʻͤ饹ڥȥͤ׻
  ! Spectral2Grid        :: ڥȥͤʻͤ׻
  ! DiffusionVorDiv      :: ư̿ʿȻˤ뱲ȯλѲη׻
  ! DiffusionCorrectTemp :: ư̿ʿȻˤ໤Ǯη׻
  ! ------------         :: ------------
  ! Create               :: Constructor of "DYNSP"
  ! Close                :: Deconstructor of "DYNSP"
  ! PutLine              :: Print information of "DYNSP"
  ! initialized          :: Check initialization of "DYNSP"
  ! EqualAxes            :: Confirm data of axes in "DYNSP"
  ! GetAxes              :: Get data of axes in "DYNSP"
  ! GetCoriolis          :: Get Coriolis parameter
  ! GetSpectralCoeff     :: Get spectral subscript expression, and 
  !                          Laplacian coefficient
  ! GetDiffCoeff         :: Get coefficient of horizontal momentum diffusion, 
  !                         and coefficient of horizontal thermal
  !                         and water diffusion.
  ! GetPhis              :: Get spectral geography data (surface $ \Phi $ )
  ! GradPi               :: Calculate spatial variations of surface pressure 
  ! VorDiv2UV            :: Calculate zonal and meridional wind from given 
  !                         vorticity and divergence
  ! UV2VorDiv            :: Calculate vorticity and divergence
  !                         from given zonal and meridional wind.
  ! Tendency             :: Calculate spectral tendency of predictive
  !                         variables like vorticity and divergence
  ! TendencyExplicit     :: Add surface effect etc. to divergence and
  !                         temperature tendency (For explicit scheme).
  ! Grid2Spectral        :: Calculate spectral values from given grid values
  ! Spectral2Grid        :: Calculate grid values from given spectral values
  ! DiffusionVorDiv      :: Caluculate vorticity and divergence tendency by 
  !                         horizontal diffusion of momentum
  ! DiffusionCorrectTemp :: Caluculate frictional thermal correction by 
  !                          horizontal momentum diffusion
  !
  !== Usage
  !
  ! Ϥ, DYNSP ѿ, Create ǽޤ.
  ! Υ⥸塼ǤϥڥȥѴˤ׻Ԥ
  ! ֥롼󷲤ѰդƤޤ. 嵭ǻѤƤ.
  ! DYNSP ѿνλˤ Close Ѥޤ.
  !
  ! First, initialize "DYNSP" by "Create".
  ! This module provides subroutines that calculate by spectral 
  ! transform. Select from above list.
  ! In order to terminate "DYNSP", use "Close".
  !

  !----- ѥ桼ƥƥ -----
  use dc_types, only: DP
  implicit none
  private
  public:: DYNSP, Create, Close, PutLine, initialized
  public:: EqualAxes
  public:: GetAxes, GetCoriolis, GradPi, VorDiv2UV, UV2VorDiv
  public:: Tendency, TendencyExplicit, Grid2Spectral, Spectral2Grid
  public:: DiffusionVorDiv, DiffusionCorrectTemp
  public:: GetSpectralCoeff, GetDiffCoeff, GetPhis

  type DYNSP
    !
    ! DYNSP ѿѤݤˤɬ Create ˤäƽ
    ! ԤäƤ.  Create ǽ줿ѿӺ
    ! ݤ, Close ˤäƽλԤäƤ.
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: nmax ! ȿ. 
                   ! Maximum truncated wavenumber
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
    real(DP):: Omega      ! $ \Omega $ . ž®.     Angular velocity
!!$    real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
!!$    real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
    integer:: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
    real(DP):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber 
    logical:: viscous_effect
                              ! Ǵ̤Υå. 
                              ! ǥեȤǤ *VisOrder*  *EFoldTime* 
                              ! ȤꤵʿǴθ̤
                              ! ư, Ǯ, ФƯޤ. 
                              ! ΰ .false. Ϳ뤳Ȥ
                              ! ʿǴ̵ˤޤ.
                              ! 
                              ! Switch of viscous effect. 
                              ! By default, horizontal diffusion set 
                              ! with *VisOrder* and *EFoldTime* make 
                              ! an effect on momentum, heating, and water. 
                              ! If .false. is specified to this argument, 
                              ! the horizontal diffusion becomes invalid.
                              ! 

    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
!!$    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
!!$                          ! 갵ǮФ. Ratio of gas constant to specific heat
    real(DP), pointer:: xy_Cori (:,:) =>null()
                              ! $ f\equiv 2\Omega\sin\varphi $ . 
                              ! ꥪѥ᡼. Coriolis parameter
    real(DP), pointer:: xy_UVFact (:,:) =>null()
                              ! $ \cos\varphi $ .  
                              ! $ u \rightarrow U, v \rightarrow V $ η. 
                              ! Coefficient for $ u \rightarrow U, v \rightarrow V $
    real(DP), pointer:: wz_DiffVorDiv (:,:) =>null()
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion
    real(DP), pointer:: wz_DiffTherm (:,:) =>null()
                              ! $ -(-1)^{N_D/2}K_{HD}\nabla^{N_D} $ . 
                              ! Ǯ, ʿȻ. 
                              ! Coefficient of horizontal thermal and water diffusion
    real(DP), pointer:: xy_Phis (:,:) =>null()
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential
    integer:: openmp_threads = 0 ! OPENMP Ǥκ祹åɿ. 
                                 ! Maximum number of threads in OPENMP
  end type DYNSP

  logical, save:: wa_module_initialized_stored = .false.

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: dyn_spectral.f90,v 1.19 2007/10/10 19:43:20 morikawa Exp $'

  interface Create
    module procedure DynSpectralCreate
  end interface

  interface Close
    module procedure DynSpectralClose
  end interface

  interface PutLine
    module procedure DynSpectralPutLine
  end interface

  interface initialized
    module procedure DynSpectralInitialized
  end interface

  interface NmlRead
    module procedure DynSpectralNmlRead
  end interface

  interface EqualAxes
    module procedure DynSpectralEqualAxes
  end interface

  interface GetAxes
    module procedure DynSpectralGetAxes
  end interface

  interface GetCoriolis
    module procedure DynSpectralGetCoriolis
  end interface

  interface GradPi
    module procedure DynSpectralGradPi
  end interface

  interface VorDiv2UV
    module procedure DynSpectralVorDiv2UV
  end interface

  interface UV2VorDiv
    module procedure DynSpectralUV2VorDiv
  end interface

  interface Tendency
    module procedure DynSpectralTendency
  end interface

  interface TendencyExplicit
    module procedure DynSpectralTendencyExplicit
  end interface

  interface Grid2Spectral
    module procedure DynSpectralGrid2Spectral2
    module procedure DynSpectralGrid2Spectral3
  end interface

  interface Spectral2Grid
    module procedure DynSpectralSpectral2Grid2
    module procedure DynSpectralSpectral2Grid3
  end interface

  interface DiffusionVorDiv
    module procedure DynSpectralDiffusionVorDiv
  end interface

  interface DiffusionCorrectTemp
    module procedure DynSpectralDiffusionCorrectTemp
  end interface

  interface GetSpectralCoeff
    module procedure DynSpectralGetSpectralCoeff
  end interface

  interface GetDiffCoeff
    module procedure DynSpectralGetDiffCoeff
  end interface

  interface GetPhis
    module procedure DynSpectralGetPhis
  end interface

contains

  subroutine DynSpectralCreate( dyn_sp, &
    & nmax, imax, jmax, kmax, &
    & PI, RPlanet, Omega, Cp, &
!!$    & Grav, RAir, &
    & VisOrder, EFoldTime, &
    & DelTime, &
    & viscous_effect, &
    & xy_Phis, &
    & openmp_threads, &
    & wa_module_initialized, &
    & nmlfile, err )
    !
    !  *dyn_sp* ˥ڥȥˡѤ黻Ԥޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! DYNSP ѿꤷƤ.
    ! ʤ, Ϳ줿 *dyn_sp* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#dyn_spectral_nml 򻲾ȤƤ. 
    !
    ! Configure the settings for spectral method to *dyn_sp*.
    ! Initialize *dyn_sp* by this subroutine, 
    ! before other procedures are used, 
    ! Note that if *dyn_sp* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#dyn_spectral_nml"
    ! for details about a NAMELIST group.
    !
    use wa_module, only: wa_Initial, xy_Lat
    use w_module, only: rn
    use dc_types, only: DP, STRING
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_string, only: PutLine
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_error, only: DC_ENOFILEREAD, DC_ENOTINIT
    use dcpam_error, only: StoreError, DC_NOERR, &
      & DCPAM_EALREADYINIT, DCPAM_ENEGATIVE
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    integer, intent(in):: nmax ! ȿ. 
                               ! Maximum truncated wavenumber
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(in):: Omega      ! $ \Omega $ . ž®.     Angular velocity
!!$    real(DP), intent(in):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
!!$    real(DP), intent(in):: RAir       ! $ R $ .      絤.   Gas constant of air
    integer, intent(in):: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
    real(DP), intent(in):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    logical, intent(in), optional:: viscous_effect
                              ! Ǵ̤Υå. 
                              ! ǥեȤǤ *VisOrder*  *EFoldTime* 
                              ! ȤꤵʿǴθ̤
                              ! ư, Ǯ, ФƯޤ. 
                              ! ΰ .false. Ϳ뤳Ȥ
                              ! ʿǴ̵ˤޤ.
                              ! 
                              ! Switch of viscous effect. 
                              ! By default, horizontal diffusion set 
                              ! with *VisOrder* and *EFoldTime* make 
                              ! an effect on momentum, heating, and water. 
                              ! If .false. is specified to this argument, 
                              ! the horizontal diffusion becomes invalid.
                              ! 
    real(DP), intent(in), optional:: xy_Phis (0:imax-1, 0:jmax-1)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential
    integer, intent(in), optional:: openmp_threads
                              ! OPENMP Ǥκ祹åɿ.
                              ! openmp_threads  1 礭ͤꤹ 
                              ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
                              ! εĴȡѴ OPENMP ׻
                              ! 롼Ѥ. ׻¹Ԥˤ,
                              ! ¹Ի˴Ķѿ OMP_NUM_THREADS 
                              !  openmp_threads ʲοꤹ
                              ! Υƥ˱ɬפȤʤ.
                              !
                              ! openmp_threads  1 礭ͤ
                              ! ꤷʤ׻롼ϸƤФʤ.

    logical, intent(in), optional :: wa_module_initialized
                              ! wa_module (SPMODEL 饤֥) ե饰. 
                              ! SPMODEL 饤֥ wa_module  
                              ! 
                              ! ˥ץ 
                              ! wa_Initial ˤäƽƤ, 
                              !  wa_Initial Ƥ֤ȥ顼ޤ.
                              ! ΰ .true. Ϳ뤳Ȥ, 
                              ! wa_Initial ƤФʤ褦ˤޤ.
                              ! 
                              ! "wa_module" (SPMODEL library) 
                              ! initialization flag. 
                              ! 
                              ! When "wa_module" (SPMODEL library) 
                              ! is initialized by
                              ! "wa_Initial" already, second "wa_Initial"
                              ! causes an error.
                              ! If .true. is specified to this argument,
                              ! "wa_Initial" is not called.
                              ! 
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#dyn_spectral_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#dyn_spectral_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    real(DP):: wz_rn ((nmax+1)**2, 0:kmax-1)
                              ! $ -n \times (n+1) $ . ץ饷η. 
                              ! Laplacian coefficient
    real(DP):: VisCoef        ! ĶǴ. Hyper-viscosity coefficient
    character(*), parameter:: subname = 'DynSpectralCreate'
  continue
    call BeginSub(subname, version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (dyn_sp % initialized) then
      stat = DCPAM_EALREADYINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (nmax < 1) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'nmax'
      goto 999
    end if
    if (imax < 1) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    dyn_sp % nmax = nmax
    dyn_sp % imax = imax
    dyn_sp % jmax = jmax
    dyn_sp % kmax = kmax

    !-----------------------------------------------------------------
    !  ʪ
    !  Configure physical constants
    !-----------------------------------------------------------------
    dyn_sp % PI = PI
    dyn_sp % RPlanet = RPlanet
    dyn_sp % Omega = Omega
!!$    dyn_sp % Grav = Grav
    dyn_sp % Cp = Cp
!!$    dyn_sp % RAir = RAir
    dyn_sp % VisOrder = VisOrder
    dyn_sp % EFoldTime = EFoldTime
    dyn_sp % DelTime = DelTime

    if ( present(viscous_effect) ) then
      dyn_sp % viscous_effect = viscous_effect
    else
      dyn_sp % viscous_effect = .true.
    end if

!!$    dyn_sp % Kappa = RAir / Cp

    !-----------------------------------------------------------------
    !  OpenMP 
    !  Configure OpenMP
    !-----------------------------------------------------------------
    if (present(openmp_threads)) then
      if (openmp_threads > 1) then
        dyn_sp % openmp_threads = openmp_threads
      end if
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ɤ߹
    !  Load NAMELIST
    !-----------------------------------------------------------------

    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &      ! (in)
        & VisOrder = dyn_sp % VisOrder, &   ! (inout)
        & EFoldTime = dyn_sp % EFoldTime, &   ! (inout)
        & viscous_effect = dyn_sp % viscous_effect, &   ! (inout)
        & openmp_threads = dyn_sp % openmp_threads, &   ! (inout)
        & err = err )                          ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  spml 饤֥ wa_module ν
    !  Initialization of "wa_module" of "spml" library
    !-----------------------------------------------------------------
    if ( .not. present_and_true(wa_module_initialized) ) then
      if (wa_module_initialized_stored) then
        call MessageNotify('W', subname, &
          & 'spml library wa_module can not be initialized more than once.' // &
          & ' Object (DYNSP) was not initialized.')
        stat = DC_ENOTINIT
        cause_c = 'DYNSP'
        goto 999
      else
        if (dyn_sp % openmp_threads < 2) then
          call wa_Initial(nmax, imax, jmax, kmax)
        else
          call wa_Initial(nmax, imax, jmax, kmax, openmp_threads)
        end if
        wa_module_initialized_stored = .true.
      end if
    elseif ( present_and_true(wa_module_initialized) ) then
      wa_module_initialized_stored = .true.
    end if


    !-----------------------------------------------------------------
    !  ꥪ, $ u \rightarrow U, v \rightarrow V $ η׻
    !  Calculate Coriolis force, coefficients for 
    !  $ u \rightarrow U, v \rightarrow V $
    !-----------------------------------------------------------------
    allocate( dyn_sp % xy_Cori (0:imax-1, 0:jmax-1) )
    dyn_sp % xy_Cori = 2.0_DP * Omega * sin(xy_Lat)

    allocate( dyn_sp % xy_UVFact (0:imax-1, 0:jmax-1) )
    dyn_sp % xy_UVFact = cos( xy_Lat )

    !-----------------------------------------------------------------
    !  ڥȥ黻ѷ
    !  Calculate coefficients for spectral calculation
    !-----------------------------------------------------------------
    allocate( dyn_sp % wz_DiffVorDiv ((nmax+1)**2, 0:kmax-1) )
    allocate( dyn_sp % wz_DiffTherm ((nmax+1)**2, 0:kmax-1) )
    do k = 0, kmax-1
      wz_rn(:,k) = rn(:,1)
    enddo

    ! Ǵη׻ (ȿ e-folding time  EFoldTime Ȥʤ褦)
    ! Calculate viscosity coefficient
    if ( dyn_sp % viscous_effect ) then
      VisCoef = (real((nmax*(nmax+1)), DP) / RPlanet**2 )**(-VisOrder / 2) &
        &        / EFoldTime
    else
      VisCoef = 0.0_DP
    end if

    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))

    dyn_sp % wz_DiffTherm = &
      &   VisCoef * ( (-wz_rn / RPlanet**2)**(VisOrder / 2) )

    dyn_sp % wz_DiffVorDiv = dyn_sp % wz_DiffTherm &
      & + VisCoef * ( - (2.0_DP / RPlanet**2)**(VisOrder / 2))

    !-------------------------------------------------------------------
    !  Ϸǡ (ɽ $ \Phi $ ) 
    !  Configure geography data (surface $ \Phi $ )
    !-------------------------------------------------------------------
    allocate( dyn_sp % xy_Phis (0:imax-1, 0:jmax-1) )
    if (present(xy_Phis)) then
      dyn_sp % xy_Phis = xy_Phis
    else
      dyn_sp % xy_Phis = 0.0_DP
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    dyn_sp % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralCreate


  subroutine DynSpectralClose( dyn_sp, err )
    !
    !  *dyn_sp* ꤵ줿Ƥˤޤ. DYNSP 
    ! ѿ˴ؤƺѤݤ˻Ѥޤ. μ³ˤä
    ! ȤʤäѿϺ Create ˤäƽƻѤޤ.
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "DYNSP".
    ! Note that if *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralClose'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "DYNSP" ξõ
    !  Clear the settings for "DYNSP"
    !-----------------------------------------------------------------
    deallocate( dyn_sp % xy_Cori )
    deallocate( dyn_sp % xy_UVFact )
    deallocate( dyn_sp % wz_DiffVorDiv )
    deallocate( dyn_sp % wz_DiffTherm )
    deallocate( dyn_sp % xy_Phis )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    dyn_sp % initialized = .false.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralClose

  subroutine DynSpectralPutLine( dyn_sp, unit, indent, err )
    !
    !  *dyn_sp* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *dyn_sp*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_types, only: STRING, STDOUT
    use dc_date, only: toChar
    use dc_trace, only: BeginSub, EndSub
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(DYNSP), intent(in):: dyn_sp
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    integer:: xy_minpos(1:2), xy_maxpos(1:2)
    integer:: xy_lbound(1:2), xy_ubound(1:2)
    integer:: wz_minpos(1:2), wz_maxpos(1:2)
    integer:: wz_lbound(1:2), wz_ubound(1:2)
    character(len = *), parameter:: subname = 'DynSpectralPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if

    !-----------------------------------------------------------------
    !  "DYNSP" ΰ
    !  Print the settings for "DYNSP"
    !-----------------------------------------------------------------
    if (dyn_sp % initialized) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<DYNSP:: @initialized=%y @nmax=%d @imax=%d @jmax=%d @kmax=%d', &
        & i=(/dyn_sp % nmax, dyn_sp % imax, dyn_sp % jmax, dyn_sp % kmax/), &
        & l=(/dyn_sp % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @PI=%f @RPlanet=%f @Omega=%f @Cp=%f', &
        & d=(/dyn_sp % PI, dyn_sp % RPlanet, dyn_sp % Omega, dyn_sp % Cp/))

!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @Grav=%f @RAir=%f @Kappa=%f ', &
!!$        & d=(/dyn_sp % Grav, dyn_sp % RAir, dyn_sp % Kappa/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @VisOrder=%d @EFoldTime=%f @DelTime=%f', &
        & i=(/dyn_sp % VisOrder/), &
        & d=(/dyn_sp % EFoldTime, dyn_sp % DelTime/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @openmp_threads=%d', &
        & i=(/dyn_sp % openmp_threads/))

      xy_lbound = lbound(dyn_sp % xy_Cori)
      xy_ubound = ubound(dyn_sp % xy_Cori)
      xy_minpos = minloc(dyn_sp % xy_Cori)
      xy_maxpos = maxloc(dyn_sp % xy_Cori)

      xy_minpos(1) = xy_minpos(1) + xy_lbound(1) - 1
      xy_minpos(2) = xy_minpos(2) + xy_lbound(2) - 1
      xy_maxpos(1) = xy_maxpos(1) + xy_lbound(1) - 1
      xy_maxpos(2) = xy_maxpos(2) + xy_lbound(2) - 1

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @xy_Cori(%d:%d,%d:%d)=' // &
        &  '[min:%f, max:%f]', &
        & i=(/xy_lbound(1), xy_ubound(1), xy_lbound(2), xy_ubound(2)/), &
        & d=(/dyn_sp % xy_Cori(xy_minpos(1), xy_minpos(2)), &
        &     dyn_sp % xy_Cori(xy_maxpos(1), xy_maxpos(2))/))

      xy_lbound = lbound(dyn_sp % xy_UVFact)
      xy_ubound = ubound(dyn_sp % xy_UVFact)
      xy_minpos = minloc(dyn_sp % xy_UVFact)
      xy_maxpos = maxloc(dyn_sp % xy_UVFact)

      xy_minpos(1) = xy_minpos(1) + xy_lbound(1) - 1
      xy_minpos(2) = xy_minpos(2) + xy_lbound(2) - 1
      xy_maxpos(1) = xy_maxpos(1) + xy_lbound(1) - 1
      xy_maxpos(2) = xy_maxpos(2) + xy_lbound(2) - 1

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @xy_UVFact(%d:%d,%d:%d)=' // &
        &  '[min:%f, max:%f]', &
        & i=(/xy_lbound(1), xy_ubound(1), xy_lbound(2), xy_ubound(2)/), &
        & d=(/dyn_sp % xy_UVFact(xy_minpos(1), xy_minpos(2)), &
        &     dyn_sp % xy_UVFact(xy_maxpos(1), xy_maxpos(2))/))


      wz_lbound = lbound(dyn_sp % wz_DiffVorDiv)
      wz_ubound = ubound(dyn_sp % wz_DiffVorDiv)
      wz_minpos = minloc(dyn_sp % wz_DiffVorDiv)
      wz_maxpos = maxloc(dyn_sp % wz_DiffVorDiv)

      wz_minpos(1) = wz_minpos(1) + wz_lbound(1) - 1
      wz_minpos(2) = wz_minpos(2) + wz_lbound(2) - 1
      wz_maxpos(1) = wz_maxpos(1) + wz_lbound(1) - 1
      wz_maxpos(2) = wz_maxpos(2) + wz_lbound(2) - 1

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @wz_DiffVorDiv(%d:%d,%d:%d)=' // &
        &   '[min:%f, max:%f]', &
        & i=(/wz_lbound(1), wz_ubound(1), wz_lbound(2), wz_ubound(2)/), &
        & d=(/dyn_sp % wz_DiffVorDiv(wz_lbound(1), wz_lbound(2)), &
        &     dyn_sp % wz_DiffVorDiv(wz_ubound(1), wz_ubound(2))/))


      wz_lbound = lbound(dyn_sp % wz_DiffTherm)
      wz_ubound = ubound(dyn_sp % wz_DiffTherm)
      wz_minpos = minloc(dyn_sp % wz_DiffTherm)
      wz_maxpos = maxloc(dyn_sp % wz_DiffTherm)

      wz_minpos(1) = wz_minpos(1) + wz_lbound(1) - 1
      wz_minpos(2) = wz_minpos(2) + wz_lbound(2) - 1
      wz_maxpos(1) = wz_maxpos(1) + wz_lbound(1) - 1
      wz_maxpos(2) = wz_maxpos(2) + wz_lbound(2) - 1

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @wz_DiffTherm(%d:%d,%d:%d)=' // &
        &   '[min:%f, max:%f]', &
        & i=(/wz_lbound(1), wz_ubound(1), wz_lbound(2), wz_ubound(2)/), &
        & d=(/dyn_sp % wz_DiffTherm(wz_lbound(1), wz_lbound(2)), &
        &     dyn_sp % wz_DiffTherm(wz_ubound(1), wz_ubound(2))/))

      call Printf(out_unit, indent_str(1:indent_len) // '>')

    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<DYNSP:: @initialized=%y>', l=(/dyn_sp % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralPutLine

  logical function DynSpectralInitialized( dyn_sp ) result(result)
    !
    ! *dyn_sp* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *dyn_sp* is initialized, .true. is returned.
    ! If *dyn_sp* is not initialized, .false. is returned.
    !
    implicit none
    type(DYNSP), intent(in):: dyn_sp
  continue
    result = dyn_sp % initialized
  end function DynSpectralInitialized

  subroutine DynSpectralNmlRead( nmlfile, &
    & VisOrder, &
    & EFoldTime, &
    & viscous_effect, &
    & openmp_threads, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_string, only: PutLine
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    integer, intent(inout):: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
    real(DP), intent(inout):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber 
    logical, intent(inout):: viscous_effect
                              ! Ǵ̤Υå. 
                              ! ǥեȤǤ *VisOrder*  *EFoldTime* 
                              ! ȤꤵʿǴθ̤
                              ! ư, Ǯ, ФƯޤ. 
                              ! ΰ .false. Ϳ뤳Ȥ
                              ! ʿǴ̵ˤޤ.
                              ! 
                              ! Switch of viscous effect. 
                              ! By default, horizontal diffusion set 
                              ! with *VisOrder* and *EFoldTime* make 
                              ! an effect on momentum, heating, and water. 
                              ! If .false. is specified to this argument, 
                              ! the horizontal diffusion becomes invalid.
                              ! 
    integer, intent(inout):: openmp_threads
                              ! OPENMP Ǥκ祹åɿ.
                              ! openmp_threads  1 礭ͤꤹ 
                              ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
                              ! εĴȡѴ OPENMP ׻
                              ! 롼Ѥ. ׻¹Ԥˤ,
                              ! ¹Ի˴Ķѿ OMP_NUM_THREADS 
                              !  openmp_threads ʲοꤹ
                              ! Υƥ˱ɬפȤʤ.
                              !
                              ! openmp_threads  1 礭ͤ
                              ! ꤷʤ׻롼ϸƤФʤ.

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /dyn_spectral_nml/ &
      & VisOrder, &
      & EFoldTime, &
      & viscous_effect, &
      & openmp_threads
                              ! dyn_spectral ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! dyn_spectral#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "dyn_spectral" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "dyn_spectral#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'DynSpectralNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = dyn_spectral_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dyn_spectral_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = dyn_spectral_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='dyn_spectral_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine DynSpectralNmlRead

  subroutine DynSpectralEqualAxes( dyn_sp, &
    & x_Lon, y_Lat, &
    & err )
    !
    ! Ϳ줿 *x_Lon*  *y_Lat*  *dyn_sp* 
    ! ݻٷ٥ǡȤǧޤ.
    ! ۤʤˤϥ顼ȯޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Confirm equality between given *x_Lon*, *y_lat* and 
    ! longitude and latitude data stored in *dyn_sp*.
    ! If the equality is not confirmed, error is occurred.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT, DCPAM_EAXISMISMATCH
    use dc_message, only: MessageNotify
    use dc_string, only: JoinChar, toChar, PutLine
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in), optional:: x_Lon (0:dyn_sp%imax-1)
                              ! . Longitude
    real(DP), intent(in), optional:: y_Lat (0:dyn_sp%jmax-1)
                              ! . Latitude
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: x_LonStored (0:dyn_sp%imax-1)
                              ! . Longitude
    real(DP):: y_LatStored (0:dyn_sp%jmax-1)
                              ! . Latitude

    logical:: lon_gt_check (0:dyn_sp%imax-1), lon_lt_check (0:dyn_sp%imax-1)
    logical:: lat_gt_check (0:dyn_sp%jmax-1), lat_lt_check (0:dyn_sp%jmax-1)
    real(DP), parameter:: check_accuracy = 1.0e-6_DP
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralEqualAxes'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ǡ
    !  Compare axes data
    !-----------------------------------------------------------------
    call GetAxes ( dyn_sp = dyn_sp, &              ! (inout)
      & x_Lon = x_LonStored, y_Lat = y_LatStored ) ! (out)

    if ( present(x_Lon) ) then
      lon_gt_check = x_Lon > ( x_LonStored - check_accuracy )
      lon_lt_check = x_Lon < ( x_LonStored + check_accuracy )
      if ( any(.not. lon_gt_check) .or. any(.not. lon_lt_check) ) then
!!$        call MessageNotify ( 'W', subname, &
!!$          & '%c (argument)=%*f', &
!!$          & c1 = 'x_Lon', d = x_Lon, n = (/dyn_sp % imax/) )
!!$        call MessageNotify ( 'W', subname, &
!!$          & 'dyn_sp %% %c =%*f', &
!!$          & c1 = 'x_Lon', d = x_LonStored, n = (/dyn_sp % imax/) )
        stat = DCPAM_EAXISMISMATCH
        cause_c = 'x_Lon'
        goto 999
      end if
    end if

    if ( present(y_Lat) ) then
      lat_gt_check = y_Lat > ( y_LatStored - check_accuracy )
      lat_lt_check = y_Lat < ( y_LatStored + check_accuracy )
      if ( any(.not. lat_gt_check) .or. any(.not. lat_lt_check) ) then
!!$        call MessageNotify ( 'W', subname, &
!!$          & '%c (argument)=%*f', &
!!$          & c1 = 'y_Lat', d = y_Lat, n = (/dyn_sp % jmax/) )
!!$        call MessageNotify ( 'W', subname, &
!!$          & 'dyn_sp %% %c =%*f', &
!!$          & c1 = 'y_Lat', d = y_LatStored, n = (/dyn_sp % jmax /) )
        stat = DCPAM_EAXISMISMATCH
        cause_c = 'y_Lat'
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralEqualAxes

  subroutine DynSpectralGetAxes( dyn_sp, &
    & x_Lon, y_Lat, &
    & x_Lon_Weight, y_Lat_Weight, &
    & err )
    !
    ! *dyn_sp* ˳ǼƤɸ֤ͤޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return data of axes stored in *dyn_sp*.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: x_Lon_spml => x_Lon, y_Lat_spml => y_Lat, &
      &                  x_Lon_Weight_spml => x_Lon_Weight, &
      &                  y_Lat_Weight_spml => y_Lat_Weight
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(out):: x_Lon (0:dyn_sp%imax-1)
                              ! . Longitude
    real(DP), intent(out):: y_Lat (0:dyn_sp%jmax-1)
                              ! . Latitude
    real(DP), intent(out), optional:: x_Lon_Weight(0:dyn_sp%imax-1)
                              ! ٺɸŤ. 
                              ! Weight of longitude
    real(DP), intent(out), optional:: y_Lat_Weight(0:dyn_sp%jmax-1)
                              ! ٺɸŤ. 
                              ! Weight of latitude
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGetAxes'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ٷٺɸͤ
    !  Configure data of latitude and longitude
    !-----------------------------------------------------------------
    x_Lon = x_Lon_spml
    y_Lat = y_Lat_spml

    if ( present( x_Lon_Weight ) ) x_Lon_Weight = x_Lon_Weight_spml
    if ( present( y_Lat_Weight ) ) y_Lat_Weight = y_Lat_Weight_spml

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGetAxes

  subroutine DynSpectralGetCoriolis( dyn_sp, &
    & xy_Cori, &
    & err )
    !
    ! ꥪѥ᡼ $ f\equiv 2\Omega\sin\varphi $ ֤ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return Coriolis parameter $ f\equiv 2\Omega\sin\varphi $ .
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(out):: xy_Cori (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ f\equiv 2\Omega\sin\varphi $ . 
                              ! ꥪѥ᡼. Coriolis parameter
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGetCoriolis'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳Ǽ륳ꥪѥ᡼μФ
    !  Fetch Coriolis parameter from *dyn_sp*
    !-----------------------------------------------------------------
    xy_Cori = dyn_sp % xy_Cori

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGetCoriolis


  subroutine DynSpectralGradPi( dyn_sp, &
    & xy_Ps, &
    & xy_GradLonPi, xy_GradLatPi, &
    & err )
    !
    ! Ϳ줿ɽ̵ $ P_s $ , 
    ! ɽ̵ζѲ $ \DD{\pi}{x} $  $ \DD{\pi}{y} $ ֤. 
    ! ʤ, $ \pi = \ln P_s $ Ǥ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! From given surface presure $ P_s $, 
    ! spatial variations of surface pressure 
    ! $ \DD{\pi}{x} $ and $ \DD{\pi}{y} $ are returned, where
    ! $ \pi = \ln P_s $.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: xy_GradLon_w, xy_GradLat_w, w_xy
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: xy_Ps (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ P_s $ ɽ̵. 
                              ! Surface pressure
    real(DP), intent(out):: xy_GradLonPi (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ \DD{\pi}{x} $
    real(DP), intent(out):: xy_GradLatPi (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ \DD{\pi}{y} $
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    real(DP):: xy_Pi (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ \pi = \ln P_s $
    real(DP):: w_Pi ((dyn_sp%nmax+1)**2)
                              ! $ \pi $ ڥȥ

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGradPi'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ɽ̵ζѲη׻
    !  Calculate spatial surface pressure tendency
    !-----------------------------------------------------------------
    xy_Pi = log( xy_Ps )
    w_Pi = w_xy( xy_Pi )
    xy_GradLonPi = xy_GradLon_w( w_Pi )
    xy_GradLatPi = xy_GradLat_w( w_Pi )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGradPi


  subroutine DynSpectralVorDiv2UV( dyn_sp, &
    & xyz_Vor, xyz_Div, &
    & xyz_U, xyz_V, &
    & err )
    !
    ! Ϳ줿٤ȯ®®׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate zonal and meridional wind from given 
    ! vorticity and divergence.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: wa_xya, wa_LaplaInv_wa, xya_GradLon_wa, xya_GradLat_wa
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: xyz_Vor (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ \zeta $ . . 
                              ! Vorticity
    real(DP), intent(in):: xyz_Div (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ D $ . ȯ. 
                              ! Divergence
    real(DP), intent(out):: xyz_U (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ U $ . ®. 
                              ! Zonal wind
    real(DP), intent(out):: xyz_V (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ V $ . ®. 
                              ! Meridional wind
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    real(DP):: RPlanet        ! $ a $ . Ⱦ. Radius of planet
    real(DP):: wz_Psi ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! ήؿ $ \psi $ ڥȥ
    real(DP):: wz_Chi ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! ݥƥ󥷥 $ \chi $ ڥȥ
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralVorDiv2UV'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼʪμФ
    !  Fetch physical constants from *dyn_sp*
    !-----------------------------------------------------------------
    RPlanet = dyn_sp % RPlanet

    !-----------------------------------------------------------------
    !  ® $ U $ ® $ V $ η׻
    !  Caluculate zonal wind $ U $ and meridional wind $ V $
    !-----------------------------------------------------------------
    wz_Psi = wa_LaplaInv_wa(  wa_xya( xyz_Vor )  ) * RPlanet**2
    wz_Chi = wa_LaplaInv_wa(  wa_xya( xyz_Div )  ) * RPlanet**2

    xyz_U = &
      & ( xya_GradLon_wa( wz_Chi ) - xya_GradLat_wa( wz_Psi )  ) / RPlanet

    xyz_V = &
      & ( xya_GradLon_wa( wz_Psi ) + xya_GradLat_wa( wz_Chi )  ) / RPlanet

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralVorDiv2UV


  subroutine DynSpectralUV2VorDiv( dyn_sp, &
    & xyz_U, xyz_V, &
    & xyz_Vor, xyz_Div, &
    & err )
    !
    ! Ϳ줿®®鱲٤ȯ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate vorticity and divergence
    ! from given zonal and meridional wind.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: xya_wa, wa_Div_xya_xya
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: xyz_U (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ U $ . ®. 
                              ! Zonal wind
    real(DP), intent(in):: xyz_V (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ V $ . ®. 
                              ! Meridional wind
    real(DP), intent(out):: xyz_Vor (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ \zeta $ . . 
                              ! Vorticity
    real(DP), intent(out):: xyz_Div (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ D $ . ȯ. 
                              ! Divergence
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    real(DP):: RPlanet        ! Ⱦ
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralUV2VorDiv'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼʪμФ
    !  Fetch physical constants from *dyn_sp*
    !-----------------------------------------------------------------
    RPlanet = dyn_sp % RPlanet

    !-----------------------------------------------------------------
    !   $ \zeta $ ȯ $ D $ η׻
    !  Caluculate vorticity $ \zeta $ and divergence $ D $
    !-----------------------------------------------------------------
    xyz_Vor = &
      & xya_wa( &
      &   wa_Div_xya_xya( xyz_V , - xyz_U ) / RPlanet &
      & )

    xyz_Div = &
      & xya_wa( &
      &   wa_Div_xya_xya( xyz_U ,   xyz_V ) / RPlanet &
      & )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralUV2VorDiv


  subroutine DynSpectralTendency( dyn_sp, &
    & xyz_UAdv, xyz_VAdv, xyz_KE, &
    & xyz_TempUAdv, xyz_TempVAdv, xyz_DTempDt, &
    & xy_DPiDt, &
    & xyz_QVapUAdv, xyz_QVapVAdv, xyz_DQVapDt, &
    & wz_DVorDt, wz_DDivDt, wz_DTempDt, w_DPiDt, wz_DQVapDt, &
    & err )
    !
    ! Ϳ줿ʻ (ή, ưͥ륮, 
    ! Ѳ $ H $ , 漾Ѳ $ R $ ) , 
    ! ڥȥλѲ (, ȯ, , ɽ̵, 漾) 
    ! ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate spectral tendency terms (vorticity, divergence, 
    ! temperature, surface pressure, specific humidity) from 
    ! grid points values (advection, kinetic energy, and 
    ! temperature tendency $ H $ , specific humidity tendency $ R $ ).
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: wa_Div_xya_xya, wa_Lapla_wa, wa_xya, w_xy
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    real(DP), intent(in):: xyz_UAdv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ UA $ . ư̰ή. 
                              ! Zonal advection of momentum
    real(DP), intent(in):: xyz_VAdv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ VA $ . ̱ư̰ή. 
                              ! Meridional advection of momentum
    real(DP), intent(in):: xyz_KE (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ E $ . ưͥ륮. 
                              ! Kinematic energy
    real(DP), intent(in):: xyz_TempUAdv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ UT $ . ή. 
                              ! Zonal advection of temperature
    real(DP), intent(in):: xyz_TempVAdv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ VT $ . ̰ή. 
                              ! Meridional advection of temperature
    real(DP), intent(in):: xyz_DTempDt (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ H $ . ٻѲ. 
                              ! Temperature tendency
    real(DP), intent(in):: xy_DPiDt (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ Z $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency
    real(DP), intent(in):: xyz_QVapUAdv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ Uq $ . 漾ή. 
                              ! Zonal advection of specific humidity
    real(DP), intent(in):: xyz_QVapVAdv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ Vq $ . 漾̰ή. 
                              ! Meridional advection of specific humidity
    real(DP), intent(in):: xyz_DQVapDt (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ R $ . 漾Ѳ. 
                              ! Specific humidity tendency
    real(DP), intent(out):: wz_DVorDt ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \DD{\zeta}{t} $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP), intent(out):: wz_DDivDt ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \DD{D}{t} $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP), intent(out):: wz_DTempDt ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \DD{T}{t} $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP), intent(out):: w_DPiDt ((dyn_sp%nmax+1)**2)
                              ! $ \DD{Ps}{t} $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP), intent(out):: wz_DQVapDt ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \DD{q}{t} $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)

    real(DP):: RPlanet        ! $ a $ . Ⱦ. Radius of planet
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralTendency'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼʪμФ
    !  Fetch physical constants from *dyn_sp*
    !-----------------------------------------------------------------
    RPlanet = dyn_sp % RPlanet

    !-------------------------------------------------------------------
    !  ٤λѲ (ڥȥ) η׻
    !  Calculate vorticity tendency (spectral)
    !-------------------------------------------------------------------
    wz_DVorDt = wa_Div_xya_xya( xyz_VAdv, - xyz_UAdv ) / RPlanet

    !-------------------------------------------------------------------
    !  ȯλѲ (ڥȥ) η׻
    !  Calculate divergence tendency (spectral)
    !-------------------------------------------------------------------
    wz_DDivDt = &
      & wa_Div_xya_xya( xyz_UAdv, xyz_VAdv ) / RPlanet &
      & - wa_Lapla_wa( wa_xya(xyz_KE) ) / RPlanet**2

    !-------------------------------------------------------------------
    !  ٤λѲ (ڥȥ) η׻
    !  Calculate temperature tendency (spectral)
    !-------------------------------------------------------------------
    wz_DTempDt = &
      & - wa_Div_xya_xya( xyz_TempUAdv, xyz_TempVAdv ) / RPlanet &
      & + wa_xya( xyz_DTempDt )

    !-------------------------------------------------------------------
    !  ɽ̵λѲ (ڥȥ) η׻
    !  Calculate surface pressure tendency (spectral)
    !-------------------------------------------------------------------
    w_DPiDt = w_xy( xy_DPiDt )

    !-------------------------------------------------------------------
    !  漾λѲ (ڥȥ) η׻
    !  Calculate specific humidity tendency (spectral)
    !-------------------------------------------------------------------
    wz_DQVapDt = &
      & - wa_Div_xya_xya( xyz_QVapUAdv, xyz_QVapVAdv ) / RPlanet &
      & + wa_xya( xyz_DQVapDt )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralTendency

  subroutine DynSpectralTendencyExplicit( dyn_sp, &
    & xyz_exWTGPi, &
    & xyz_exHDiv, &
    & wz_DDivDt, &
    & wz_DTempDt, &
    & err )
    !
    ! ȯ (ڥȥ) λѲ 
    ! $ \Phi_s \underline{W} \Dvect{T} + \Dvect{G} \pi $ θ̤, 
    ! ȯ (ڥȥ) λѲ $ \underline{h} \Dvect{D} $ 
    ! θ̤ɲäޤ.
    ! ʬˡ˥ץꥷåˡѤƤ˸ƤӽФޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Add effect of $ \Phi_s + \underline{W} \Dvect{T} + \Dvect{G} \pi $ to 
    ! divergence (spectral) tendency, and 
    ! add effect of $ \underline{h} \Dvect{D} $ to 
    ! temperature (spectral) tendency.
    ! This routine called then explicit scheme is used as 
    ! time integration scheme.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: wa_Lapla_wa, wa_xya, w_Lapla_w, w_xy
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: xyz_exWTGPi (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ .
    real(DP), intent(in):: xyz_exHDiv (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ \underline{h} \Dvect{D} $ .

    real(DP), intent(inout):: wz_DDivDt ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \DD{D}{t} $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP), intent(inout):: wz_DTempDt ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \DD{T}{t} $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: kmax            ! ľؿ. 
                              ! Number of vertical level
    real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
    real(DP):: xy_Phis (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralTendencyExplicit'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼʻμФ
    !  Fetch grid point from *dyn_sp*
    !-----------------------------------------------------------------
    kmax = dyn_sp % kmax

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼʪμФ
    !  Fetch physical constants from *dyn_sp*
    !-----------------------------------------------------------------
    RPlanet = dyn_sp % RPlanet

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳Ǽɽݥƥ󥷥μФ
    !  Fetch surface geo-potential from *dyn_sp*
    !-----------------------------------------------------------------
    xy_Phis = dyn_sp % xy_Phis

    !-------------------------------------------------------------------
    !  ȯλѲ (ڥȥ) η׻
    !  Calculate divergence tendency (spectral)
    !-------------------------------------------------------------------
    wz_DDivDt = wz_DDivDt &
      & - wa_Lapla_wa( wa_xya( xyz_exWTGPi ) ) / RPlanet**2

    do k = 0, kmax - 1
      wz_DDivDt(:,k) = wz_DDivDt(:,k) &
        & - w_Lapla_w( w_xy( xy_Phis ) ) / RPlanet**2
    end do


    !-------------------------------------------------------------------
    !  ٤λѲ (ڥȥ) η׻
    !  Calculate temperature tendency (spectral)
    !-------------------------------------------------------------------
    wz_DTempDt = wz_DTempDt - wa_xya( xyz_exHDiv )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralTendencyExplicit

  subroutine DynSpectralGrid2Spectral2( dyn_sp, &
    & xy_Data, &
    & w_Data, &
    & math_func, &
    & err )
    !
    ! Ϳ줿ʻͤ饹ڥȥͤ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate spectral values from given grid values.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT, &
      & DCPAM_EBADMATHFUNC
    use wa_module, only: w_xy
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: xy_Data (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! ʻǡ. Grid data
    real(DP), intent(out):: w_Data ((dyn_sp%nmax+1)**2)
                              ! ڥȥǡ. Spectral Data
    character(*), intent(in), optional:: math_func
                              ! شؿ. 
                              ! ʲοشؿǽ. 
                              !
                              ! Mathematical function.
                              ! Available functions are as follows.
                              ! 
                              ! * "log"
                              ! * "exp"
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGrid2Spectral2'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-------------------------------------------------------------------
    !  ڥȥѴ
    !  Forward spectral transformation
    !-------------------------------------------------------------------
    if ( present(math_func) ) then
      select case ( trim(math_func) )
      case ('log')
        w_Data = w_xy( log( xy_Data ) )
      case ('exp')
        w_Data = exp( w_xy( xy_Data ) )
      case default
        stat = DCPAM_EBADMATHFUNC
        cause_c = trim(math_func)
        goto 999
      end select
    else
      w_Data = w_xy( xy_Data )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGrid2Spectral2

  subroutine DynSpectralGrid2Spectral3( dyn_sp, &
    & xyz_Data, &
    & wz_Data, &
    & math_func, &
    & err )
    !
    ! Ϳ줿ʻͤ饹ڥȥͤ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate spectral values from given grid values.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT, &
      & DCPAM_EBADMATHFUNC
    use wa_module, only: wa_xya
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: xyz_Data (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! ʻǡ. Grid data
    real(DP), intent(out):: wz_Data ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! ڥȥǡ. Spectral Data
    character(*), intent(in), optional:: math_func
                              ! شؿ. 
                              ! ʲοشؿǽ. 
                              !
                              ! Mathematical function.
                              ! Available functions are as follows.
                              ! 
                              ! * "log"
                              ! * "exp"
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGrid2Spectral3'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-------------------------------------------------------------------
    !  ڥȥѴ
    !  Forward spectral transformation
    !-------------------------------------------------------------------
    if ( present(math_func) ) then
      select case ( trim(math_func) )
      case ('log')
        wz_Data = wa_xya( log( xyz_Data ) )
      case ('exp')
        wz_Data = exp( wa_xya( xyz_Data ) )
      case default
        stat = DCPAM_EBADMATHFUNC
        cause_c = trim(math_func)
        goto 999
      end select
    else
      wz_Data = wa_xya( xyz_Data )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGrid2Spectral3

  subroutine DynSpectralSpectral2Grid2( dyn_sp, &
    & w_Data, &
    & xy_Data, &
    & math_func, &
    & err )
    !
    ! Ϳ줿ڥȥͤʻͤ׻ޤ. 
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate grid values from given spectral values. 
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT, &
      & DCPAM_EBADMATHFUNC
    use wa_module, only: xy_w
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: w_Data ((dyn_sp%nmax+1)**2)
                              ! ڥȥǡ. Spectral Data
    real(DP), intent(out):: xy_Data (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1)
                              ! ʻǡ. Grid data
    character(*), intent(in), optional:: math_func
                              ! شؿ. 
                              ! ʲοشؿǽ. 
                              !
                              ! Mathematical function.
                              ! Available functions are as follows.
                              ! 
                              ! * "log"
                              ! * "exp"
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralSpectral2Grid2'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-------------------------------------------------------------------
    !  ڥȥѴ
    !  Backward spectral transformation
    !-------------------------------------------------------------------
    if ( present(math_func) ) then
      select case ( trim(math_func) )
      case ('log')
        xy_Data = xy_w( log( w_Data ) )
      case ('exp')
        xy_Data = exp( xy_w( w_Data ) )
      case default
        stat = DCPAM_EBADMATHFUNC
        cause_c = trim(math_func)
        goto 999
      end select
    else
      xy_Data = xy_w( w_Data )
    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralSpectral2Grid2

  subroutine DynSpectralSpectral2Grid3( dyn_sp, &
    & wz_Data, &
    & xyz_Data, &
    & math_func, &
    & err )
    !
    ! Ϳ줿ڥȥͤʻͤ׻ޤ. 
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate grid values from given spectral values. 
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT, &
      & DCPAM_EBADMATHFUNC
    use wa_module, only: xya_wa
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: wz_Data ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! ڥȥǡ. Spectral Data
    real(DP), intent(out):: xyz_Data (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! ʻǡ. Grid data
    character(*), intent(in), optional:: math_func
                              ! شؿ. 
                              ! ʲοشؿǽ. 
                              !
                              ! Mathematical function.
                              ! Available functions are as follows.
                              ! 
                              ! * "log"
                              ! * "exp"
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralSpectral2Grid3'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-------------------------------------------------------------------
    !  ڥȥѴ
    !  Backward spectral transformation
    !-------------------------------------------------------------------
    if ( present(math_func) ) then
      select case ( trim(math_func) )
      case ('log')
        xyz_Data = xya_wa( log( wz_Data ) )
      case ('exp')
        xyz_Data = exp( xya_wa( wz_Data ) )
      case default
        stat = DCPAM_EBADMATHFUNC
        cause_c = trim(math_func)
        goto 999
      end select
    else
      xyz_Data = xya_wa( wz_Data )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralSpectral2Grid3

  subroutine DynSpectralDiffusionVorDiv( dyn_sp, &
    & wz_Vor, wz_Div, &
    & wz_VorDiff, wz_DivDiff, &
    & err )
    !
    ! ư̿ʿȻˤ뱲ȯλѲ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Caluculate vorticity and divergence tendency by 
    ! horizontal diffusion of momentum
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: wz_Vor ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \zeta $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP), intent(in):: wz_Div ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ D $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP), intent(out):: wz_VorDiff ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \mathscr{D}(\zeta) $ . 
                              ! ư̿ʿȻˤ뱲Ѳ (ڥȥ). 
                              ! Vorticity tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP), intent(out):: wz_DivDiff ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \mathscr{D}(D) $ . 
                              ! ư̿ʿȻˤȯѲ (ڥȥ). 
                              ! Divergence tendency by 
                              ! horizontal momentum diffusion (spectral)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: wz_DiffVorDiv((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralDiffusionVorDiv'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼȻμФ
    !  Fetch diffusion coefficients from *dyn_sp*
    !-----------------------------------------------------------------
    wz_DiffVorDiv = dyn_sp % wz_DiffVorDiv

    !-----------------------------------------------------------------
    !  ư̿ʿȻˤ뱲ȯλѲη׻
    !  Caluculate vorticity and divergence tendency by 
    !  horizontal diffusion of momentum
    !-----------------------------------------------------------------
    wz_VorDiff = - wz_Vor * wz_DiffVorDiv
    wz_DivDiff = - wz_Div * wz_DiffVorDiv

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralDiffusionVorDiv


  subroutine DynSpectralDiffusionCorrectTemp( dyn_sp, &
    & wz_VorDiff, wz_DivDiff, xyz_U, xyz_V, &
    & xyz_Temp, &
    & err )
    !
    ! ư̿ʿȻˤ໤Ǯ׻ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Caluculate frictional thermal correction by horizontal 
    ! momentum diffusion
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: xya_wa
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(in):: wz_VorDiff ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \mathscr{D}(\zeta) $ . 
                              ! ư̿ʿȻˤ뱲Ѳ (ڥȥ). 
                              ! Vorticity tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP), intent(in):: wz_DivDiff ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ \mathscr{D}(D) $ . 
                              ! ư̿ʿȻˤȯѲ (ڥȥ). 
                              ! Divergence tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP), intent(in):: xyz_U (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ U $ . ®. Zonal wind.
    real(DP), intent(in):: xyz_V (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ V $ . ®. Meridional wind.
    real(DP), intent(inout):: xyz_Temp (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! $ T $ . . Temperature
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: xyz_UDiff (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! ư̿ʿȻˤѲ. 
                              ! Zonal wind tendency by 
                              ! horizontal momentum diffusion
    real(DP):: xyz_VDiff (0:dyn_sp%imax-1, 0:dyn_sp%jmax-1, 0:dyn_sp%kmax-1)
                              ! ư̿ʿȻˤѲ. 
                              ! Meridional wind tendency by 
                              ! horizontal momentum diffusion
    real(DP):: Cp      ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: DelTime ! $ \Delta t $ . ॹƥå. Time step

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralDiffusionCorrectTemp'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳Ǽʪ, $ \Delta t $ μФ
    !  Fetch physical constant, $ \Delta t $ from *dyn_sp*
    !-----------------------------------------------------------------
    Cp = dyn_sp % Cp
    DelTime = dyn_sp % DelTime

    !-----------------------------------------------------------------
    !  ư̿ʿȻˤ®, ®λѲη׻
    !  Caluculate zonal and meridional wind tendency by 
    !  horizontal diffusion of momentum
    !-----------------------------------------------------------------
    call VorDiv2UV( dyn_sp, & ! (inout)
      & xya_wa( wz_VorDiff ), xya_wa( wz_DivDiff ), & ! (in)
      & xyz_UDiff, xyz_VDiff ) ! (out)

    !-----------------------------------------------------------------
    !  ư̿ʿȻˤ໤Ǯη׻
    !  Caluculate frictional thermal correction by 
    !  horizontal diffusion of momentum
    !-----------------------------------------------------------------
    xyz_Temp = xyz_Temp &
      & - (   xyz_U * xyz_UDiff &
      &     + xyz_V * xyz_VDiff ) &
      &   / Cp * 2.0_DP * DelTime

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralDiffusionCorrectTemp

  subroutine DynSpectralGetSpectralCoeff( dyn_sp, &
    & nmo, wz_rn, &
    & err )
    !
    ! ڥȥźȥץ饷η֤ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return spectral subscript expression, and 
    ! Laplacian coefficient.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: l_nm
    use w_module, only: rn
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    integer, intent(out):: nmo (1:2, 0:dyn_sp%nmax, 0:dyn_sp%nmax)
                              ! ڥȥź. 
                              ! Spectral subscript expression
    real(DP), intent(out):: wz_rn ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ -n \times (n+1) $ . ץ饷η. 
                              ! Laplacian coefficient
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax            ! ľؿ. 
                              ! Number of vertical level
    integer:: nmax            ! ȿ. 
                              ! Maximum truncated wavenumber
    integer:: mmax            ! ȿ. 
                              ! Maximum truncated zonal wavenumber
    integer:: lmax            ! ȿ. 
                              ! Maximum truncated meridional wavenumber
    integer:: k, l, m         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGetSpectralCoeff'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ڥȥź֤μФ
    !  Fetch spectral subscript expression
    !-----------------------------------------------------------------
    nmax = dyn_sp % nmax
    mmax = dyn_sp % nmax
    lmax = dyn_sp % nmax

    nmo = 0
    do l = 0, lmax
      do m = 0, min(mmax, nmax-l)
        nmo(1,m,l) = l_nm(m+l,  m)
        nmo(2,m,l) = l_nm(m+l, -m)
      enddo
    enddo

    !-----------------------------------------------------------------
    !  ץ饷η $ -n \times (n+1) $ μФ
    !  Fetch Laplacian coefficient $ -n \times (n+1) $
    !-----------------------------------------------------------------
    kmax = dyn_sp % kmax
    do k = 0, kmax-1
      wz_rn(:,k) = rn(:,1)
    enddo

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGetSpectralCoeff


  subroutine DynSpectralGetDiffCoeff( dyn_sp, &
    & wz_DiffVorDiv, wz_DiffTherm, &
    & err )
    !
    ! ư̿ʿȻǮ, ʿȻ֤ޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return coefficient of horizontal momentum diffusion, 
    ! and coefficient of horizontal thermal and water diffusion.
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(out):: wz_DiffVorDiv ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion
    real(DP), intent(out):: wz_DiffTherm ((dyn_sp%nmax+1)**2, 0:dyn_sp%kmax-1)
                              ! $ -(-1)^{N_D/2}K_{HD}\nabla^{N_D} $ . 
                              ! Ǯ, ʿȻ. 
                              ! Coefficient of horizontal thermal and water diffusion

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGetDiffCoeff'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *dyn_sp* ˳ǼȻμФ
    !  Fetch diffusion coefficients from *dyn_sp*
    !-----------------------------------------------------------------
    wz_DiffVorDiv = dyn_sp % wz_DiffVorDiv
    wz_DiffTherm = dyn_sp % wz_DiffTherm

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGetDiffCoeff

  subroutine DynSpectralGetPhis( dyn_sp, &
    & w_Phis, &
    & err )
    !
    ! Ϸǡ (ɽ $ \Phi $ ) Υڥȥ֤ͤޤ.
    !
    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return spectral geography data (surface $ \Phi $ ).
    !
    ! If *dyn_sp* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use wa_module, only: w_xy
    implicit none
    type(DYNSP), intent(inout):: dyn_sp
    real(DP), intent(out):: w_Phis ((dyn_sp%nmax+1)**2)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynSpectralGetPhis'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_sp % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNSP'
      goto 999
    end if

    !-------------------------------------------------------------------
    !  Ϸǡ (ɽ $ \Phi $ ) Υڥȥͤη׻
    !  Calculate spectral geography data (surface $ \Phi $ )
    !-------------------------------------------------------------------
    w_Phis = w_xy( dyn_sp % xy_Phis )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynSpectralGetPhis


!!$  subroutine DynSpectralSample( dyn_sp, err )
!!$    !--
!!$    ! DynSpectralSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *dyn_sp*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of DynSpectralSample
!!$    !++
!!$    ! If *dyn_sp* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: STRING, STDOUT
!!$    use dc_string, only: PutLine
!!$    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
!!$    implicit none
!!$    type(DYNSP), intent(inout):: dyn_sp
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'DynSpectralSample'
!!$  continue
!!$    call BeginSub(subname)
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if (.not. dyn_sp % initialized) then
!!$      stat = DCPAM_ENOTINIT
!!$      cause_c = 'DYNSP'
!!$      goto 999
!!$    end if
!!$
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError(stat, subname, err, cause_c)
!!$    call EndSub(subname)
!!$  end subroutine DynSpectralSample


end module dyn_spectral
