#!/bin/sh
#
#= Operation test program of "dcmodel_f90sample_maker.rb"
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: dcmodel_f90sample_maker-test.sh,v 1.3 2007/10/11 19:53:14 morikawa Exp $
# Tag Name::  $Name: dcpam4-20071012 $
# Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
# License::   See COPYRIGHT[link:../../COPYRIGHT]
#
######################################################################
#
#== Settings

PROGRAM=./dcmodel_f90sample_maker.rb
test -n "$TESTDIR"  || TESTDIR=testdir_tmp
STDINTXT=stdin.txt
FILE1=dcmodel_sample_code
FILE2=hoge_hero
NCFILES="AP_Data2.nc NPI_Data1.nc NP_Data2.nc"
CLEANFILES="*.mod *.o"

test -n "$RUBY"  || RUBY=ruby
test -n "$SH"    || SH=sh
test -n "$MKDIR" || MKDIR=mkdir
test -n "$RM"    || RM=rm
if [ -n "${RUBYSCRIPTDIR}" ]; then
    RUBYLIB=${RUBYSCRIPTDIR}/rsed
else
    RUBYLIB=`pwd`/../rsed
fi
RSED=${RUBYLIB}/rsed.rb

# End Settings
######################################################################

set -e

case `echo "testing\c"; echo 1,2,3`,`echo -n testing; echo 1,2,3` in
  *c*,-n*) ECHO_N= ECHO_C='
' ECHO_T='      ' ;;
  *c*,*  ) ECHO_N=-n ECHO_C= ECHO_T= ;;
  *)       ECHO_N= ECHO_C='\c' ECHO_T= ;;
esac

echo ""
echo "****** ${PROGRAM} Test ******"
echo " in \"`pwd`\""

echo " Prepare directory for test ... "
test -d ${TESTDIR} || ${MKDIR} ${TESTDIR}
cd ${TESTDIR}
echo " done . "

echo " Generate sample source code (1)... "
${RUBY} ../${PROGRAM} -E module -q -f
echo " done . "

echo " Generate sample source code (2)... "
cat <<STDIN > ${STDINTXT}
${FILE2}
Title
ȥ
HogeHero
HOGHER
${USER}
GFD Dennou Club

STDIN
${RUBY} ../${PROGRAM} -E module -f < ${STDINTXT}
echo " done . "

if [ "$CROSS_COMPILING" = "yes" ] || [ "$CROSS_COMPILING" = "maybe" ] ; then
    echo ""
    echo "   ERROR: Cross compile mode will be used."
    echo "          So following tests can not be tried."
    echo ""
    exit 1
fi

echo " Compiling and Linking and Execute generated simple programs (1)... "
LINKF=${LINKF} ${SH} ${FILE1}_test.sh
${RM} ${CLEANFILES} ${FILE1}_test || true
echo " done . "

echo " Compiling and Linking and Execute generated simple programs (2)... "
LINKF=${LINKF} ${SH} ${FILE2}_test.sh
${RM} ${CLEANFILES} ${FILE2}_test || true
echo " done . "

echo " Compiling and Linking and Execute generated full programs (1)... "
RUBYLIB=${RUBYLIB} ${RUBY} ${RSED} -f '^!!\$' '' ${FILE1}* > /dev/null
LINKF=${LINKF} ${SH} ${FILE1}_test.sh
ls ${NCFILES}
${RM} ${CLEANFILES} ${FILE1}_test ${NCFILES} || true
echo " done . "

echo " Compiling and Linking and Execute generated full programs (2)... "
RUBYLIB=${RUBYLIB} ${RUBY} ${RSED} -f '^!!\$' '' ${FILE2}* > /dev/null
LINKF=${LINKF} ${SH} ${FILE1}_test.sh
ls ${NCFILES}
${RM} ${CLEANFILES} ${FILE1}_test ${NCFILES} || true
echo " done . "

echo "  *** Test program \"`basename ${PROGRAM} .rb`-test.rb\" becomes successful ***"
exit 0
