= 履歴

* 2015/07/01 yot


= 概要

DCPAM を用いて計算した空間 3 次元データを密度で重みを付けて鉛直積分する. 


= 使い方

== 必要なライブラリ

* NetCDF

== コンパイル

* Makefile を編集
  * 以下を指定
    * Fortran コンパイラ
    * NetCDF ライブラリのディレクトリ
* make の実行
  % make

== 実行

* 設定ファイル vi.nml を用意
* 実行
  % a.out


= 設定ファイル

設定ファイル vi.nml には, 
* 重力加速度
* ファイル・変数情報
  * 入力ファイル名
  * 出力ファイル名 (のランク番号を除いたもの)
  * 変数名
を namelist によって設定する. 


== 重力加速度

密度の重みを書けた鉛直積分に用いる重力加速度は下のように設定する. 

  &const
    Grav = 9.80665
  /

ここで, 単位は m s-2 である.


== ファイル・変数情報

ファイル・変数情報は以下のように設定する

一つの変数ごとに下のように一項目設定する.

  &file
    ncfn_ps     = '../Ps.nc',
    varname_ps  = 'Ps',
    ncfn        = '../Var1.nc',
    varname     = 'Var1',
    ncfn_out    = './out/VIVar1.nc'
    varname_out = 'VIVar1',
  &end
  &file
    ncfn_ps     = '../Ps.nc',
    varname_ps  = 'Ps',
    ncfn        = '../Var2.nc',
    varname     = 'Var2',
    ncfn_out    = './out/VIVar2.nc'
    varname_out = 'VIVar2',
  &end

ここで, それぞれの変数の意味は下の通り.
* ncfn_ps
  密度の重みをかけた鉛直積分のために使用する地表面気圧の NetCDF ファイル名.
* varname_ps
  密度の重みをかけた鉛直積分のために使用する地表面気圧の変数名.
* ncfn
  密度の重みをかけた鉛直積分する変数の入った NetCDF ファイル名.
* varname
  密度の重みをかけた鉛直積分する変数名.
* ncfn_out
  密度の重みをかけた鉛直積分した結果の NetCDF ファイル名.
* varname_out
  密度の重みをかけた鉛直積分した結果の変数名.

