!= ھǮƳ
!
!= set soil thermal diffusion coefficient
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: soil_thermdiffcoef.f90,v 1.1 2015/01/29 12:12:21 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module soil_thermdiffcoef

  !== References
  !
!!$  !  Matthews, E.,
!!$  !    Global vegetation and land use: New high-resolution data bases for climate 
!!$  !    studies, 
!!$  !    J. Clim. Appl. Meteor., 22, 474, 1983. 
!!$  !
!!$  !  Matthews, E., 
!!$  !    Prescription of land-surface boundary conditions in GISS GCM II:
!!$  !    A simple method based on fine-resolution data bases, 
!!$  !    NASA Technical memorandum #86096, 1984.

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetSoilThermDiffCoefSimple
  public:: SoilThermDiffCoefInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: soil_thermdiffcoef_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  real(DP), save:: SoilThermDiffCoefMin
  real(DP), save:: SoilThermDiffCoefMax

  real(DP), save:: SoilMoistCritAmnt

  character(*), parameter:: module_name = 'soil_thermdiffcoef'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: soil_thermdiffcoef.f90,v 1.1 2015/01/29 12:12:21 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetSoilThermDiffCoefSimple( &
    & xy_SurfType, xy_SoilMoist,         & ! (in )
    & xy_SoilThermDiffCoef               & ! (out)
    & )

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ʸ ; Declaration statements
    !
    integer , intent(in ) :: xy_SurfType         ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SoilMoist        ( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SoilThermDiffCoef( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ǧ
    ! Initialization check
    !
    if ( .not. soil_thermdiffcoef_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    !
    ! land
    !
    do j = 1, jmax
      do i = 0, imax-1
        if( xy_SurfType( i, j ) >= 1 ) then
          xy_SoilThermDiffCoef(i,j) =                           &
            &   ( SoilThermDiffCoefMax - SoilThermDiffCoefMin ) &
            & / ( SoilMoistCritAmnt    - 0.0_DP               ) &
            & * ( xy_SoilMoist(i,j)    - 0.0_DP               ) &
            & + SoilThermDiffCoefMin
          xy_SoilThermDiffCoef(i,j) =                           &
            & min( max( xy_SoilThermDiffCoef(i,j), SoilThermDiffCoefMin ), &
            &      SoilThermDiffCoefMax )
        else
          xy_SoilThermDiffCoef(i,j) = 1.0e100_DP
        end if
      end do
    end do


  end subroutine SetSoilThermDiffCoefSimple

  !--------------------------------------------------------------------------------------

  subroutine SoilThermDiffCoefInit( &
    & FlagSnow &
    & )

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! Хĥǥ
    ! Bucket model
    !
    use Bucket_Model, only : &
      & BucketGetSoilMoistCritAmnt, &
      & BucketModelInit


    logical, intent(in) :: FlagSnow


    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /soil_thermdiffcoef_nml/ &
      & SoilThermDiffCoefMin, &
      & SoilThermDiffCoefMax

    ! ¹ʸ ; Executable statement
    !

    if ( soil_thermdiffcoef_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

    SoilThermDiffCoefMin = 0.2_DP
    SoilThermDiffCoefMax = 2.0_DP
                     !   thermal conductivity (W m-1 K-1)


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                   &  ! (in)
        & nml = soil_thermdiffcoef_nml, &  ! (out)
        & iostat = iostat_nml           &  ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = soil_thermdiffcoef_nml )
    end if


    ! Хĥǥ
    ! Bucket model
    !
    call BucketModelInit( &
      & FlagSnow          & ! (in)
      & )
    SoilMoistCritAmnt = BucketGetSoilMoistCritAmnt()


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'SoilThermDiffCoefMin = %f', d = (/SoilThermDiffCoefMin/) )
    call MessageNotify( 'M', module_name, 'SoilThermDiffCoefMax = %f', d = (/SoilThermDiffCoefMax/) )
    call MessageNotify( 'M', module_name, 'SoilMoistCritAmnt    = %f', d = (/SoilMoistCritAmnt/) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    soil_thermdiffcoef_inited = .true.

  end subroutine SoilThermDiffCoefInit

  !--------------------------------------------------------------------------------------

end module soil_thermdiffcoef
