!= 
!
!= Time control
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: timeset.f90,v 1.24 2012-01-20 00:17:14 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved. 
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module timeset
  !
  != 
  !
  != Time control
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! δԤޤ. 
  !
  ! Information of time is controlled. 
  !
  !== Variables List
  !
  ! TimeB                  :: ƥå $ t - \Delta t $ λ
  ! TimeN                  :: ƥå $ t $ λ
  ! TimeA                  :: ƥå $ t + \Delta t $ λ
  ! DelTime                :: $ \Delta t $ [s] (¿ο)
  ! RestartTime            :: ꥹȳϻ
  ! EndTime                :: ׻λ
  ! InitialDate            :: ׻
  ! ------------           :: ------------
  ! TimeB                  :: Time of step $ t - \Delta t $
  ! TimeN                  :: Time of step $ t $
  ! TimeA                  :: Time of step $ t + \Delta t $
  ! DelTime                :: $ \Delta t $ [s] (numerical value of float type)
  ! RestartTime            :: Restart time of calculation
  ! EndTime                :: End time of calculation
  ! InitialDate            :: Start date of calculation
  !
  !== Procedures List
  !
  ! TimesetInit           :: timeset ⥸塼ν
  ! TimesetDelTimeHalf    :: t ŪȾʬ
  ! TimesetProgress       :: οʹ
  ! TimesetSetTimeN       :: TimeN 
  ! TimesetSetInitialDate :: ׻
  ! TimesetClockStart     :: ׻ַ¬
  ! TimesetClockStop      :: ׻ַװ
  ! TimesetClose          :: timeset ⥸塼νλ
  ! ------------          :: ------------
  ! TimesetInit           :: Initialize "timeset" module
  ! TimesetDelTimeHalf    :: Reduce delta t to half temporarily
  ! TimesetProgress       :: Progress time
  ! TimesetSetTimeN       :: Set TimeN
  ! TimesetSetInitialDate :: Set start date
  ! TimesetClockStart     :: Start measurement of computation time
  ! TimesetClockStop      :: Pause measurement of computation time
  ! TimesetClose          :: Terminate "timeset" module
  !
  !== NAMELIST
  !
  ! NAMELIST#timeset_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &  ! ټ¿. Double precision. 
    &                 TOKEN  ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! CPU ַ¬
  ! CPU time monitor
  !
  use dc_clock, only: CLOCK

  ! μ갷
  ! Calendar and Date handler
  !
  use dc_calendar, only: &
    & DC_CAL, &               ! ɽǡ. 
                              ! Data type for calendar 
    & DC_CAL_DATE             ! ɽǡ. 
                              ! Data type for date and time

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵.
                              ! Maximum size of arrays loaded from NAMELIST

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: TimesetInit, TimesetClose, TimesetProgress, TimesetDelTimeHalf
  public:: TimesetClockStart, TimesetClockStop
  public:: TimesetSetTimeN, TimesetSetInitialDate, TimesetSetCalendar

  ! ѿ
  ! Public variables
  !
  logical, save, public:: timeset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  real(DP), save, public:: TimeB
                              ! ƥå $ t - \Delta t $ λ. 
                              ! Time of step $ t - \Delta t $. 
  real(DP), save, public:: TimeN
                              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
  real(DP), save, public:: TimeA
                              ! ƥå $ t + \Delta t $ λ. 
                              ! Time of step $ t + \Delta t $. 
  real(DP), save, public:: DelTime
                              ! $ \Delta t $ [s]
  real(DP), save:: IntegPeriod
                              ! ʬ. ñ̤. 
                              ! Unit is second. 
  real(DP), save, public:: RestartTime
                              ! ꥹȳϻ. 
                              ! Restart time of calculation
                              !--
                              ! : 
                              ! 
                              ! ¼Ūʷ׻ϻϽͥǡѻʤ
                              ! 0, ꥹȥǡѻǤХꥹ
                              ! ǡ˳Ǽ줿ΤѤ. 
                              ! DelTime ͤˤäƻ郎ɬڤΡ
                              ! ɤˤʤʤȤꤷƤˡ
                              ! 
                              ! ͤϥǥư桼׻Ϥ
                              ! ԤƤǤꡢͤ򸵤
                              ! ׻λ郎ꤵ, ޤͤꥹ
                              ! եνϳϻȤƤѤ. 
                              !++
  real(DP), save, public:: EndTime
                              ! ׻λ. 
                              ! End time of calculation

  type(DC_CAL_DATE), save, public:: InitialDate
                              ! ׻. 
                              ! Start date of calculation
  type(DC_CAL_DATE), save, public:: EndDate
                              ! ׻λ

  ! ѿ
  ! Private variables
  !
  character(TOKEN), save:: cal_type
                              ! . 
                              ! Type of calendar used for an experiment

  integer         , save:: month_in_year
                              ! Number of months in a year which is used
                              ! when cal_type = "user_defined"
  integer         , save:: day_in_month(1:MaxNmlArySize)
                              ! Number of days in a month which is used
                              ! when cal_type = "user_defined"
  integer         , save:: hour_in_day
                              ! Number of hours in a day which is used
                              ! when cal_type = "user_defined"
  integer         , save:: min_in_hour
                              ! Number of minutes in a hour which is used
                              ! when cal_type = "user_defined"
  real(DP)        , save:: sec_in_min
                              ! Number of seconds in a minute which is used
                              ! when cal_type = "user_defined"

  real(DP)        , save:: RestartTimeValue
                              ! ꥹȳϻ. 
                              ! Restart time of calculation
  character(TOKEN), save:: RestartTimeUnit
                              ! ꥹȳϻñ. 
                              ! Unit of restart time of calculation
  real(DP)        , save:: DelTimeValue
                              ! $ \Delta t $ .  ñ̤ DelTimeUnit ˤƻ.
                              ! Unit is specified by "DelTimeUnit". 
  character(TOKEN), save:: DelTimeUnit
                              ! $ \Delta t $ ñ. 
                              ! Unit of $ \Delta t $ 

  logical         , save:: flag_half
                              ! TimesetDelTimeHalf ˤä $ \Delta t $ 
                              ! ȾʬˤʤäƤ뤳Ȥ򼨤ե饰. 
                              ! 
                              ! Flag that shows $ \Delta t $ is reduced to 
                              ! half by "TimesetDelTimeHalf"
  real(DP)        , save:: DelTimeSave
                              ! $ \Delta t $ [s] Υǥե. 
                              ! ("TimesetDelTimeHalf" ǻѤ)
                              ! 
                              ! Default value of $ \Delta t $ [s]. 
                              ! (for "TimesetDelTimeHalf")

  real(DP)        , save:: PredictIntTime
                              ! λͽ¬ɽֳִ. 
                              ! Interval time of predicted end time output
  real(DP)        , save:: PredictPrevTime
                              ! νλͽ¬ɽ. 
                              ! Time when predicted end time is output previously
  real(DP)        , save:: PredictIntValue
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output
  character(TOKEN), save:: PredictIntUnit
                              ! λͽ¬ɽֳ (ñ). 
                              ! Unit for interval of predicted end time output

  logical         , save:: CpuTimeMoniter
                              ! CPU ַ¬Υ󥪥
                              ! On/off of CPU time monitoring

  integer         , parameter:: clkmax = 64
                              ! CPU ַ¬Ԥץκ. 
                              ! Maximum number of processes monitored CPU time
  integer         , save:: clk_proc_num = 0
                              ! CPU ַ¬ԤäƤץο. 
                              ! Number of processes monitored CPU time
  type(CLOCK)     , save:: clocks(1:clkmax)
                              ! CPU ַ¬ѹ¤
                              ! Derived type for monitoring CPU time
  character(TOKEN), save:: clocks_name(1:clkmax) = ''
                              ! CPU ַ¬ԤäƤץ̾
                              ! Names of processes monitored CPU time


  character(*), parameter:: module_name = 'timeset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: timeset.f90,v 1.24 2012-01-20 00:17:14 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !-------------------------------------------------------------------

  subroutine TimesetInit
    !
    ! timeset ⥸塼νԤޤ. 
    ! NAMELIST#timeset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "timeset" module is initialized. 
    ! NAMELIST#timeset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalCreate, DCCalConvertByUnit, DCCalToChar, DCCalInquire, &
      & DCCalDateCreate, DCCalDateDifference, DCCalDateToChar, DCCalDateInquire, &
      & DCCalDefault

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockCreate, DCClockStart

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar


    ! ʸ ; Declaration statements
    !

    integer:: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
                              ! ׻ (ǯʬ)
                              ! Start date of calculation (year, month, day, hour, minute)
    real(DP):: InitialSec
                              ! ׻ ()
                              ! Start date of calculation (second)
    real(DP):: IntegPeriodValue
                              ! ʬ. 
                              ! Integral time. 
    character(TOKEN):: IntegPeriodUnit
                              ! "IntegPeriodValue" ñ. 
                              ! Unit of "IntegPeriodValue". 
    integer:: EndYear, EndMonth, EndDay, EndHour, EndMin
                              ! ׻λ (ǯʬ). 
                              ! "IntegPeriodValue" ξˤ餬Ѥ. 
                              ! 
                              ! End date of calculation (year, month, day, hour, minute)
                              ! These are used when "IntegPeriodValue" is negative
    real(DP):: EndSec
                              ! ׻λ (). 
                              ! "IntegPeriodValue" ξˤ餬Ѥ. 
                              ! 
                              ! End date of calculation (second)
                              ! These are used when "IntegPeriodValue" is negative

    ! Ѻѿ
    ! Work variables for print
    !
    type(DC_CAL):: cal_print
    real(DP):: EndTimeValue_print
    character(TOKEN):: date_print

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /timeset_nml/ &
      & cal_type, &
      & month_in_year, day_in_month, hour_in_day, min_in_hour, sec_in_min, &
      !
      & DelTimeValue,    DelTimeUnit, &
      & RestartTimeValue,  RestartTimeUnit, &
      & InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin, InitialSec, &
      & EndYear, EndMonth, EndDay, EndHour, EndMin, EndSec, &
      & IntegPeriodValue, IntegPeriodUnit, &
      !
      & PredictIntValue,  PredictIntUnit, &
      & CpuTimeMoniter
          !
          ! ǥեͤˤĤƤϽ³ "timeset#TimesetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "timeset#TimesetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( timeset_inited ) return
    call InitCheck


    ! ǥեͤ
    ! Default values settings
    !
    cal_type                      = 'noleap'
    month_in_year                 =   -1
    day_in_month(1:MaxNmlArySize) =   -1
    hour_in_day                   =   -1
    min_in_hour                   =   -1
    sec_in_min                    =   -1.0_DP

    ! Sample value for the Earth
    !
!!$    cal_type                      = 'gregorian'
!!$    month_in_year                 =   -1
!!$    day_in_month(1:MaxNmlArySize) =   -1
!!$    hour_in_day                   =   -1
!!$    min_in_hour                   =   -1
!!$    sec_in_min                    =   -1.0_DP

    ! Sample value for the Mars
    !   Number of days in a year and Mars solar day in second are obtained from 
    !   Allison (1997). 
    !   Allison, M, Geophys. Res. Lett., 24, 1967-1970, 1997.
    !
!!$    cal_type                      = 'user_defined'
!!$    month_in_year                 =    1
!!$    day_in_month(1:MaxNmlArySize) =  669
!!$    hour_in_day                   =   24
!!$    min_in_hour                   =    1
!!$    sec_in_min                    = 3700.0_DP    ! 3699.0_DP


    DelTimeValue                  =   30.0_DP
    DelTimeUnit                   = 'min'
    flag_half                     = .false.

    RestartTimeValue              =    0.0_DP
    RestartTimeUnit               = 'sec'

    InitialYear                   = 2000
    InitialMonth                  =    1
    InitialDay                    =    1
    InitialHour                   =    0
    InitialMin                    =    0
    InitialSec                    =    0.0

    IntegPeriodValue              =   -1.0
                                   ! If IntegPeriodValue is negative, EndXXX are used.
    IntegPeriodUnit               = 'sec'

    EndYear                       = 2000
    EndMonth                      =    1
    EndDay                        =    2
    EndHour                       =    0
    EndMin                        =    0
    EndSec                        =    0.0

    PredictIntValue               =    1.0_DP
    PredictIntUnit                = 'day'

    CpuTimeMoniter                 = .true.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = timeset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = timeset_nml )
    end if


    ! ξ
    ! Set calendar
    !
    if ( cal_type == "user_defined" ) then
      call DCCalCreate(                                                &
        &               month_in_year = month_in_year                , & ! (in)
        &               day_in_month  = day_in_month(1:month_in_year), & ! (in)
        &               hour_in_day   = hour_in_day                  , & ! (in)
        &               min_in_hour   = min_in_hour                  , & ! (in)
        &               sec_in_min    = sec_in_min                     & ! (in)
        & )
    else
      call DCCalCreate( cal_type = cal_type ) ! (in)
    end if


    ! Lines below will be deleted. (yot, 2010/08/12)
    !

    ! ξ (ץȤƤĤ case 򵭺)
    !
    ! case 1:
    ! dc_calendar ѰդŵŪǥեȤȤ
    !
!!$    call DCCalCreate( cal_type = 'gregorian' ) ! (in)  ! 쥴ꥪ
!!$    call DCCalCreate( cal_type = 'julian'    ) ! (in)  ! ꥦ
!!$    call DCCalCreate( cal_type = 'noleap'    ) ! (in)  ! ǯ̵
!!$    call DCCalCreate( cal_type = '360day'    ) ! (in)  ! 1 30 
!!$    call DCCalCreate( cal_type = 'cyclic'    ) ! (in)  !  30.6    ޤǤפξʲڼΤȤ 

!!$    ! case 2:
!!$    ! ޤڤä (ʲϥꥦ) 
!!$    !
!!$    call DCCalCreate( cal_type = 'Julian' ) ! (in)
!!$
!!$    ! case 3:
!!$    ! ϵäݤѼԤŪ˻
!!$    !
!!$    call DCCalCreate( month_in_year = 12 , &   ! (in)
!!$      &               day_in_month  = (/31, 28, 31, 30, 31, 30,   &
!!$      &                                 31, 31, 30, 31, 30, 31/), & ! (in) 
!!$      &               hour_in_day = 24,     &  ! (in) 
!!$      &               min_in_hour = 60 ,    &  ! (in) 
!!$      &               sec_in_min  = 60.0d0 )   ! (in) 
!!$
!!$    ! case 3:
!!$    ! äݤѼԤŪ˻. 
!!$    !  ˷ʤ׾ˤ, month_in_year = 1 Ȥ. 
!!$    !
!!$    call DCCalCreate( month_in_year = 1 , &      ! (in)
!!$      &               day_in_month  = (/669/), & ! (in)
!!$      &               hour_in_day = 24, &        ! (in)
!!$      &               min_in_hour = 1 , &        ! (in)
!!$      &               sec_in_min  = 3694.0d0  )  ! (in)


    ! ѿ () 
    ! Calculate time variable (sec)
    !
    DelTime        = DCCalConvertByUnit( DelTimeValue,     DelTimeUnit,     'sec' ) !(in)
    RestartTime    = DCCalConvertByUnit( RestartTimeValue, RestartTimeUnit, 'sec' ) !(in)


    ! ξ
    !
    ! Ʒ׻ˤ restart_file_io ⥸塼ˤ TimesetSetInitialDate 
    ! ƤӽФˤäƾ񤭤뤳Ȥ. 
    !
    if ( ( .not. ( InitialMonth < 0      ) ) .and. &
      &  ( .not. ( InitialDay   < 0      ) ) .and. &
      &  ( .not. ( InitialHour  < 0      ) ) .and. &
      &  ( .not. ( InitialMin   < 0      ) ) .and. &
      &  ( .not. ( InitialSec   < 0.0_DP ) ) ) then

      call DCCalDateCreate( &
        & year  = InitialYear,   & ! (in)
        & month = InitialMonth,  & ! (in)
        & day   = InitialDay,    & ! (in)
        & hour  = InitialHour,   & ! (in)
        & min   = InitialMin,    & ! (in)
        & sec   = InitialSec,    & ! (in)
        & date  = InitialDate )  ! (out) optional
    else
      call MessageNotify('W', module_name, 'InitialMonth/Day/Hour/Min/Sec is negative.' )
    end if


    ! λ (ηв֤ɽ) 
    !
    if ( IntegPeriodValue < 0.0 ) then

      IntegPeriod = IntegPeriodValue

      ! case 1
      ! λȤ
      !
      call DCCalDateCreate( &
        & year  = EndYear,   & ! (in)
        & month = EndMonth,  & ! (in)
        & day   = EndDay,    & ! (in)
        & hour  = EndHour,   & ! (in)
        & min   = EndMin,    & ! (in)
        & sec   = EndSec,    & ! (in)
        & date  = EndDate )    ! (out) optional

      EndTime = DCCalDateDifference( &
        &         start_date = InitialDate, &  ! (in)
        &         end_date   = EndDate )       ! (in)

      if ( .not. EndTime > 0.0 ) then
        call DCCalDateInquire( date_print, date = InitialDate )
        call MessageNotify('W', module_name, 'InitialDate=<%c>', c1 = trim(date_print) )
        call DCCalDateInquire( date_print, date = EndDate )
        call MessageNotify('W', module_name, 'EndDate=<%c>', c1 = trim(date_print) )
        call MessageNotify('E', module_name, '"EndTime" must be positive.')
      end if

    else
      ! case 2
      ! ʬ֤Ȥ
      !
      IntegPeriod = DCCalConvertByUnit( IntegPeriodValue, IntegPeriodUnit, 'sec' ) !(in)

      EndTime = RestartTime + IntegPeriod
    end if


    ! λͽ¬ɽ֤ν
    ! Initialize Time when predicted end time is output
    !
    PredictIntTime  = DCCalConvertByUnit( PredictIntValue, PredictIntUnit, 'sec' ) !(in)
    PredictPrevTime = RestartTime - DelTime


    ! Υå
    ! Check validation of time
    !
    call TimeValidCheck( RestartTime, EndTime, DelTime, PredictIntTime ) ! (in)


    ! ƥॹƥåפλ
    ! Configure time on each time step
    !
    ! Ʒ׻ˤ restart_file_io ⥸塼ˤ TimesetSetTimeN
    ! ƤӽФˤäƾ񤭤뤳Ȥ. 
    ! 
    TimeN = RestartTime
    TimeB = TimeN - DelTime
    TimeA = TimeN + DelTime


    ! $ \Delta t $ [s] ¸
    ! Save $ \Delta t $ [s]
    !
    DelTimeSave = DelTime


    ! CPU ַ¬ (ǥ)
    ! Start CPU time monitoring (for entire model)
    !
    if ( CpuTimeMoniter ) then
      call DCClockCreate( clocks(clk_proc_num + 1), 'total' ) ! (in)
      call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
      clocks_name(clk_proc_num + 1) = 'total'
      clk_proc_num = clk_proc_num + 1
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  RestartTime  = %f [%c]', &
      & d = (/ RestartTimeValue /), c1 = trim(RestartTimeUnit) )
    call DCCalDateInquire( date_print, date = InitialDate )
    call MessageNotify( 'M', module_name, '  InitialDate  = %c', &
      & c1 = trim(date_print) )
    if ( IntegPeriodValue < 0.0 ) then
      call DCCalDateInquire( date_print, date = EndDate )
      call MessageNotify( 'M', module_name, '  EndDate      = %c', &
        & c1 = trim(date_print) )
    end if
    EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
    call MessageNotify( 'M', module_name, '  EndTime      = %f [%c]', &
      & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
    call MessageNotify( 'M', module_name, '  DelTime      = %f [%c]', &
      & d = (/ DelTimeValue /), c1 = trim(DelTimeUnit) )
    call MessageNotify( 'M', module_name, '               = %f [%c]', &
      & d = (/ DelTime /), c1 = 'sec' )
    if ( cal_type /= 'user_defined' ) then
      call MessageNotify( 'M', module_name, '  Calendar     = %c', &
        & c1 = trim(cal_type) )
    else
      call DCCalDefault( cal_print ) ! (out) 
      call MessageNotify( 'M', module_name, '  Calendar     = %c', &
        & c1 = trim(DCCalToChar(cal_print)) )
    end if
    call MessageNotify( 'M', module_name, '  PredictInt = %f [%c]', &
      & d = (/ PredictIntValue /), c1 = trim(PredictIntUnit) )
    call MessageNotify( 'M', module_name, '  CpuTimeMoniter = %b', &
      & l = (/ CpuTimeMoniter /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    timeset_inited = .true.
  end subroutine TimesetInit

  !-------------------------------------------------------------------

  subroutine TimesetDelTimeHalf
    ! 
    ! ׻νϥ顼ˡѤ뤿, 
    ! Ū t Ⱦʬˤޤ. 
    ! TimesetProgress ƤФ줿ʳ t ϸޤ. 
    ! 
    ! Delta t is reduced to half temporarily 
    ! in order to use Euler method at initial step. 
    ! Delta t is returned to default, when "TimesetProgress" is called. 
    !

    ! ʸ ; Declaration statements
    !

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( flag_half ) return
    DelTime = DelTime / 2.0_DP
    flag_half = .true.

  end subroutine TimesetDelTimeHalf

  !-------------------------------------------------------------------

  subroutine TimesetProgress
    !
    ! timeset ⥸塼λʤޤ. 
    ! ޤ, TimesetProgress#PredictIntStep ꤵ줿ͤ˱, 
    ! ߤޤǤη׻֤ȷ׻λͽ¬ɽޤ. 
    !
    ! Progress time configured in "timeset" module. 
    ! And, computation time until now and 
    ! predicted end of computation time are printed 
    ! according to configured "TimesetProgress#PredictIntStep"
    !

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockPredict, DCClockStop, DCClockClose, &
      & operator(+), operator(-)

    ! ʸ ; Declaration statements
    !

    ! ѿ
    ! Work variables
    !
    type(CLOCK):: clock_tmp

    ! ¹ʸ ; Executable statement
    !

    ! t 򸵤᤹. 
    ! Delta t is returned to default
    !
    if ( flag_half ) then
      DelTime = DelTimeSave
      flag_half = .false.
    end if

    ! λͽ¬ɽ
    ! Print predicted end time
    !
    if ( .not. TimeA - PredictPrevTime < PredictIntTime ) then
      PredictPrevTime = PredictPrevTime + PredictIntTime
      if ( CpuTimeMoniter ) then
        clock_tmp = clocks(1)
        call DCClockStop( clock_tmp ) ! (in)
        call DCClockPredict( &
          & clock_tmp, &
          & real( ( TimeA - RestartTime ) / ( ( EndTime + DelTimeSave ) - RestartTime ) ) ) ! (in)
        call DCClockClose( clock_tmp ) ! (in)
      end if
    end if

    ! οʹ
    ! Progress time
    !
    TimeB = TimeB + DelTime
    TimeN = TimeN + DelTime
    TimeA = TimeA + DelTime
  end subroutine TimesetProgress

  !-------------------------------------------------------------------

  subroutine TimesetClose
    !
    ! ׻֤פɽޤ. 
    !
    ! Total computation time is printed. 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockStop, DCClockResult, DCClockSetName, &
      & operator(+), operator(-)

    ! ʸ ; Declaration statements
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    ! CPU ַ¬λ (ǥ)
    ! Stop CPU time monitoring (for entire model)
    !
    call DCClockStop( clocks(1) ) ! (in)

    ! ֤¾פ CPU ֤򻻽
    ! Calculate CPU time of "Others"
    !
    clocks(clk_proc_num + 1) = clocks(1)
    do i = 2, clk_proc_num
      clocks(clk_proc_num + 1) = clocks(clk_proc_num + 1) - clocks(i)
    end do
    call DCClockSetName( clocks(clk_proc_num + 1), 'others' )

    ! CPU ֤פɽ
    ! Print total CPU time
    !
    call DCClockResult( &
      & clocks(2:clk_proc_num + 1), total_auto = .true. ) ! (in)

  end subroutine TimesetClose

  !-------------------------------------------------------------------

  subroutine TimesetSetTimeN(TimeNSet)
    !
    ! TimeN κԤޤ. 
    ! ưŪ TimeB, TimeA, EndTime ˤĤƤ
    ! Ԥޤ. 
    !
    ! TimesetInit ˸ƤФ뤳ȤǤ. 
    ! TimesetInit ƤФˤΥ֥롼󤬸ƤФ줿,
    ! ⤻ˤΥ֥롼Ͻλޤ. 
    !
    ! "TimeN" is reconfigured. 
    ! "TimeB", "TimeA", "EndTime" are reconfigured automatically. 
    !
    ! "TimesetInit" must be called before this subroutine is called. 
    ! If "TimesetInit" is not called previously, this subroutine 
    ! is finished with no changes. 
    !

    ! ⥸塼 ; USE statements
    !

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !

    real(DP), intent(in):: TimeNSet
                              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
    
    ! ѿ
    ! Work variables
    !
    real(DP):: EndTimeValue_print

    ! ¹ʸ ; Executable statement
    !

    if ( .not. timeset_inited ) return

    ! TimeN ξ硢顼ȯ
    ! Cause an error, if TimeN is negative
    !
    if ( TimeN < 0.0 ) then
      call MessageNotify( 'E', module_name, &
        & 'TimeN=<%f [sec]> must be positive', &
        & d = (/ TimeNSet /) )
    end if

    ! ƥॹƥåפλ
    ! Reconfigure time on each time step
    !
    TimeN = TimeNSet
    TimeB = TimeN - DelTime
    TimeA = TimeN + DelTime

    ! νλͽ¬ɽ֤κ
    ! Reconfigure Time when predicted end time is output previously
    !
    PredictPrevTime = TimeN - DelTime

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Reconfigure Time Messages -----' )
    call MessageNotify( 'M', module_name, '  TimeB  = %f [sec]', &
      & d = (/ TimeB /) )
    call MessageNotify( 'M', module_name, '  TimeN  = %f [sec]', &
      & d = (/ TimeN /) )
    call MessageNotify( 'M', module_name, '  TimeA  = %f [sec]', &
      & d = (/ TimeA /) )
    if ( IntegPeriod > 0.0 ) then
      EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
      call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
        & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
    end if

  end subroutine TimesetSetTimeN

  !-------------------------------------------------------------------

  subroutine TimesetSetInitialDate( &
    & InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin, InitialSec )
    !
    ! κԤޤ. 
    !
    ! TimesetInit ˸ƤФ뤳ȤǤ. 
    ! TimesetInit ƤФˤΥ֥롼󤬸ƤФ줿,
    ! ⤻ˤΥ֥롼Ͻλޤ. 
    !
    ! Start date is reconfigured. 
    !
    ! "TimesetInit" must be called before this subroutine is called. 
    ! If "TimesetInit" is not called previously, this subroutine 
    ! is finished with no changes. 
    !

    ! ⥸塼 ; USE statements
    !

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalCreate, DCCalConvertByUnit, DCCalToChar, DCCalInquire, &
      & DCCalDateCreate, DCCalDateDifference, DCCalDateToChar, DCCalDateInquire

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !

    integer, intent(in):: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
                              ! ׻Ϥǯʬ
    real(DP), intent(in):: InitialSec
                              ! ׻Ϥ

    ! ѿ
    ! Work variables
    !
    real(DP):: EndTimeValue_print
    character(TOKEN):: date_print

    ! ¹ʸ ; Executable statement
    !

    if ( .not. timeset_inited ) return

    ! "InitialDate" 
    ! Reconfigure "InitialDate"
    !
    call DCCalDateCreate( &
      & year  = InitialYear,   & ! (in)
      & month = InitialMonth,  & ! (in)
      & day   = InitialDay,    & ! (in)
      & hour  = InitialHour,   & ! (in)
      & min   = InitialMin,    & ! (in)
      & sec   = InitialSec,    & ! (in)
      & date  = InitialDate )  ! (out) optional

    ! "EndTime" κ
    ! Reconfigure "EndTime"
    !
    if ( IntegPeriod < 0.0 ) then
      EndTime = DCCalDateDifference( &
        &         start_date = InitialDate, &  ! (in)
        &         end_date = EndDate )         ! (in)

      if ( .not. EndTime > 0.0 ) then
        call DCCalDateInquire( date_print, date = InitialDate )
        call MessageNotify('W', module_name, 'InitialDate=<%c>', c1 = trim(date_print) )
        call DCCalDateInquire( date_print, date = EndDate )
        call MessageNotify('W', module_name, 'EndDate=<%c>', c1 = trim(date_print) )
        call MessageNotify('E', module_name, '"EndTime" must be positive.')
      end if

    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Reconfigure InitialDate Messages -----' )
    call DCCalDateInquire( date_print, date = InitialDate )
    call MessageNotify( 'M', module_name, '  InitialDate  = %c', &
      & c1 = trim(date_print) )
    if ( IntegPeriod < 0.0 ) then
      call DCCalDateInquire( date_print, date = EndDate )
      call MessageNotify( 'M', module_name, '  EndDate    = %c', &
        & c1 = trim(date_print) )

      EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
      call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
        & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
    end if

  end subroutine TimesetSetInitialDate

  !-------------------------------------------------------------------

  subroutine TimesetSetCalendar( cal_type, &       ! (in)
    & month_in_year, day_in_month, &               ! (in)
    & hour_in_day, min_in_hour, sec_in_min )       ! (in)
    !
    ! κԤޤ. 
    !
    ! TimesetInit ˸ƤФ뤳ȤǤ. 
    ! TimesetInit ƤФˤΥ֥롼󤬸ƤФ줿,
    ! ⤻ˤΥ֥롼Ͻλޤ. 
    !
    ! Calendar is reconfigured. 
    !
    ! "TimesetInit" must be called before this subroutine is called. 
    ! If "TimesetInit" is not called previously, this subroutine 
    ! is finished with no changes. 
    !

    ! ⥸塼 ; USE statements
    !

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalCreate, DCCalInquire, DCCalDefault, DCCalToChar

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !

    character(*), intent(in):: cal_type
                              ! Υ. 
    integer, intent(in):: month_in_year, day_in_month(:), hour_in_day, min_in_hour
    real(DP), intent(in):: sec_in_min
                              ! . 
                              ! Information of Calendar. 

    ! ѿ
    ! Work variables
    !
    character(TOKEN):: cal_type_print
    type(DC_CAL):: cal_print

    ! ¹ʸ ; Executable statement
    !

    if ( .not. timeset_inited ) return

    ! ξ
    !
    if ( cal_type /= 'user_defined' ) then
      call DCCalCreate( cal_type = cal_type )  ! (in)
    else
      call DCCalCreate( month_in_year, & ! (in)
        &               day_in_month , & ! (in) 
        &               hour_in_day,   & ! (in) 
        &               min_in_hour ,  & ! (in) 
        &               sec_in_min )     ! (in) 
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Reconfigure Calendar Messages -----' )
    call DCCalInquire( cal_type = cal_type_print ) ! (out) optional
    if ( cal_type_print /= 'user_defined' ) then
      call MessageNotify( 'M', module_name, '  Calendar   = %c', &
        & c1 = trim(cal_type_print) )
    else
      call DCCalDefault( cal_print ) ! (out) 
      call MessageNotify( 'M', module_name, '  Calendar   = %c', &
        & c1 = trim(DCCalToChar(cal_print)) )
    end if

  end subroutine TimesetSetCalendar

  !-------------------------------------------------------------------

  subroutine TimesetClockStart( name & ! (in)
    & )
    !
    ! ץñ (˥⥸塼) Ȥλַ¬򳫻Ϥޤ. 
    !
    ! Start measurement of computation time by program unit
    ! (expected modules). 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockCreate, DCClockStart

    ! ʸ ; Declaration statements
    !
    character(*), intent(in):: name
                              ! ⥸塼̾. 
                              ! Name of module

    ! ѿ
    ! Work variables
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    do i = 1, clk_proc_num
      if ( trim(clocks_name(i)) == trim(name) ) then
        call DCClockStart( clocks(i) ) ! (in)
        return
      end if
    end do

    call DCClockCreate( clocks(clk_proc_num + 1), name ) ! (in)
    call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
    clocks_name(clk_proc_num + 1) = name
    clk_proc_num = clk_proc_num + 1

  end subroutine TimesetClockStart

  !-------------------------------------------------------------------

  subroutine TimesetClockStop( name & ! (in)
    & )
    !
    ! ץñ (˥⥸塼) Ȥλַ¬ߤޤ.
    !
    ! Pause measurement of computation time by program unit
    ! (expected modules). 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockStop

    ! ʸ ; Declaration statements
    !
    character(*), intent(in):: name
                              ! ⥸塼̾. 
                              ! Name of module

    ! ѿ
    ! Work variables
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    do i = 1, clk_proc_num
      if ( trim(clocks_name(i)) == trim(name) ) then
        call DCClockStop( clocks(i) ) ! (in)
        return
      end if
    end do

    call MessageNotify( 'W', module_name, ' name "%c" is not found in "TimesetClockStop"', c1 = trim(name) )

  end subroutine TimesetClockStop

  !-------------------------------------------------------------------

  subroutine TimeValidCheck( &
    & RestartTimeChk, EndTimeChk, DelTimeChk, PredictIntTimeChk & ! (in)
    & )
    !
    ! ˤĤƤͭåޤ. 
    !
    ! Check validation about infomation time
    !

    ! ⥸塼 ; USE statements
    !

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    real(DP), intent(in):: RestartTimeChk
                              ! ꥹȳϻ. 
                              ! Restart time of calculation
    real(DP), intent(in):: EndTimeChk
                              ! ׻λ. 
                              ! End time of calculation
    real(DP), intent(in):: DelTimeChk
                              ! $ \Delta t $ [s]
    real(DP), intent(in):: PredictIntTimeChk
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output

    ! Ѻѿ
    ! Work variables for print
    !
    real(DP):: RestartTimeValue_print
    real(DP):: EndTimeValue_print
    real(DP):: DelTimeValue_print
    real(DP):: PredictIntValue_print

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( .not. 0.0_DP < ( EndTimeChk - RestartTimeChk ) ) then
      RestartTimeValue_print = DCCalConvertByUnit( RestartTimeChk, 'sec', RestartTimeUnit ) ! (in)
      EndTimeValue_print = DCCalConvertByUnit( EndTimeChk, 'sec', RestartTimeUnit ) ! (in)
      
      call MessageNotify( 'E', module_name, &
        & 'RestartTime=<%f[%c]> is later than EndTime=<%f[%c]>', &
        & d = (/ RestartTimeValue_print, EndTimeValue_print /), &
        & c1 = trim(RestartTimeUnit), c2 = trim(RestartTimeUnit) )
    end if

    if ( DelTimeChk > ( EndTimeChk - RestartTimeChk ) ) then
      RestartTimeValue_print = DCCalConvertByUnit( RestartTimeChk, 'sec', RestartTimeUnit ) ! (in)
      EndTimeValue_print = DCCalConvertByUnit( EndTimeChk, 'sec', RestartTimeUnit ) ! (in)
      DelTimeValue_print = DCCalConvertByUnit( DelTimeChk, 'sec', DelTimeUnit ) ! (in)
      call MessageNotify( 'E', module_name, &
        & 'DelTime=<%f[%c]> is larger than ' // &
        & 'EndTime=<%f[%c]> - RestartTime=<%f[%c]>.', &
        & d = (/ DelTimeValue_print, EndTimeValue_print, RestartTimeValue_print /), &
        & c1 = trim(DelTimeUnit), &
        & c2 = trim(RestartTimeUnit), c3 = trim(RestartTimeUnit) )
    end if

    if ( .not. DelTimeChk > 0.0_DP ) then
      DelTimeValue_print = DCCalConvertByUnit( DelTimeChk, 'sec', DelTimeUnit ) ! (in)
      call MessageNotify( 'E', module_name, &
        & 'DelTime=<%f[%c]> must be more than 0.', &
        & d = (/ DelTimeValue_print /), &
        & c1 = trim(DelTimeUnit) )
    end if

    if ( .not. PredictIntTimeChk > 0.0_DP ) then
      PredictIntValue_print = DCCalConvertByUnit( PredictIntTimeChk, 'sec', PredictIntUnit ) ! (in)
      call MessageNotify( 'E', module_name, &
        & 'PredictInt=<%f[%c]> must be more than 0.', &
        & d = (/ PredictIntValue_print /), &
        & c1 = trim(PredictIntUnit) )
    end if

  end subroutine TimeValidCheck

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module timeset
