!= ޥɥ饤Ͻ
!
!= Command line option parser
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: option_parser.f90,v 1.3 2010-08-30 01:54:45 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module option_parser
  !
  != ޥɥ饤Ͻ
  !
  != Command line option parser
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ޥɥ饤βϽԤޤ. 
  !
  ! Command line options are parsed
  !
  !== Procedures List
  !
  ! OptParseInit  :: ޥɥ饤βϽ
  ! ------------  :: ------------
  ! OptParseInit  :: Parse of command line options

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: STRING  ! ʸ. Strings. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: OptParseInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: option_parser_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  logical, save:: namelist_flag = .false.
                              ! NAMELIST ե̵ͭ򼨤ե饰. 
                              ! Flag of NAMELIST file specification

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'option_parser'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: option_parser.f90,v 1.3 2010-08-30 01:54:45 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine OptParseInit( &
    & namelist_filename,   & ! (out)
    & exec_name, brief     & ! (in ) optional
    & )
    !
    ! option_parser ⥸塼νԤޤ. 
    !
    ! Initialize "option_parser" module. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ޥɥ饤
    ! Command line option parser subcontractor
    !
    use dc_args, only: ARGS, &
      & DCArgsOpen,  DCArgsHelpMsg, DCArgsOption, &
      & DCArgsDebug, DCArgsHelp,    DCArgsStrict, DCArgsClose

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_not_empty

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), intent(out)          :: namelist_filename
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    character(*), intent(in ), optional:: exec_name
                              ! ¹ԥե̾. 
                              ! Executable file name
    character(*), intent(in ), optional:: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

    character(STRING):: ename
                              ! ¹ԥե̾. 
                              ! Executable file name
    character(STRING):: brief_msg
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

    type(ARGS):: arg          ! ޥɥ饤. 
                              ! Command line options

    ! ¹ʸ ; Executable statement
    !

    if ( option_parser_inited ) return
    call InitCheck

    ! ץʥν. 
    ! Handling of optional arguments 
    !
    if ( present_and_not_empty(exec_name) ) then
      ename = exec_name
    else
      ename = 'dcpam'
    end if

    if ( present_and_not_empty(brief) ) then
      brief_msg = brief
    else
      brief_msg = 'dcpam main program'
    end if

    ! ޥɥ饤βϽ
    ! Parse command line arguments
    !
    call DCArgsOpen( arg )               ! (out)

    call DCArgsHelpMsg( arg, &                          ! (inout)
      & category = 'Title', &                           ! (in)
      & msg = trim(ename) // ': ' // trim(brief_msg) )  ! (in)
    call DCArgsHelpMsg( arg, &                      ! (inout)
      & category = 'Usage', &                       ! (in)
      & msg = './' // trim(ename) // ' [Options]' ) ! (in)

    call DCArgsOption( arg, &                 ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = namelist_flag, &               ! (out)
      & value = namelist_filename, &          ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg )  ! (inout)
    call DCArgsHelp( arg )   ! (inout)
    call DCArgsStrict( arg ) ! (inout)

    call DCArgsClose( arg )  ! (inout)

    option_parser_inited = .true.
  end subroutine OptParseInit

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ¹ʸ ; Executable statement
    !


  end subroutine InitCheck


end module option_parser
