!= ʬѲ
!
!= Phase change of atmospheric major component
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: major_comp_phase_change.f90,v 1.3 2014/05/07 09:39:21 murashin Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module major_comp_phase_change
  !
  != ʬѲ
  !
  != Phase change of atmospheric major component
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  ! 
!!$  ! DryConvAdjust :: ήĴ
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#major_comp_phase_change_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private


  ! ³
  ! Public procedure
  !
  public :: MajorCompPhaseChangeInAtm
  public :: MajorCompPhaseChangeInit


  ! ѿ
  ! Public variables
  !
  logical, save, public:: major_comp_phase_change_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  logical, save :: FlagMajCompPhaseChange


  character(*), parameter:: module_name = 'major_comp_phase_change'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: major_comp_phase_change.f90,v 1.3 2014/05/07 09:39:21 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !-------------------------------------------------------------------

  subroutine MajorCompPhaseChangeInAtmTest(  &
    & xyr_Press, xyz_Press, xyz_Height,      &  ! (in)
    & xy_Ps, xyz_Temp, xy_SurfMajCompIce     &  ! (inout)
    & )
    !
    ! CO2 Ѳ
    !
    ! CO2 phase change
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & CpDry
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure

    ! ʬѲ
    ! Phase change of atmospheric major component
    !
    use saturate_major_comp, only :     &
      & SaturateMajorCompCalcCondTemp,  &
      & SaturateMajorCompInqLatentHeat


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in   ):: xyz_Height(0:imax-1, 1:jmax, 1:kmax)
                              ! 
                              ! 
    real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
                              !
                              ! Surface major component ice amount

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjustment
    real(DP):: xyz_DelAtmMass      (0:imax-1, 1:jmax, 1:kmax)
                              !
                              ! Atmospheric mass in a layer
    real(DP):: xy_FallingIce       (0:imax-1, 1:jmax)
                              !
                              !
    real(DP):: xyz_DelMajCompIce   (0:imax-1, 1:jmax, 1:kmax)
                              !
                              !
    real(DP):: xy_DelSurfMajCompIce(0:imax-1, 1:jmax)
                              !
                              !
    real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
                              ! 
                              ! Surface major component ice tendency

    real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
    real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
    real(DP):: SpecHeatCO2Ice

    real(DP):: LatentHeatMajCompSubl

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    logical :: FlagCheckPs


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. major_comp_phase_change_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( .not. FlagMajCompPhaseChange ) return


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Set latent heat
    LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()


    FlagCheckPs = .false.
    do j = 1, jmax
      do i = 0, imax-1
        if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
          FlagCheckPs = .true.
        end if
      end do
    end do
    if ( FlagCheckPs ) then
      call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
    end if


    ! Ĵ "Temp" ¸
    ! Store "Temp" before adjustment
    !
    xyz_TempB    = xyz_Temp


    call SaturateMajorCompCalcCondTemp(  &
      & xyz_Press,                       & ! (in)
      & xyz_TempCond                     & ! (inout)
      & )


    do k = 1, kmax
      xyz_DelAtmMass(:,:,k) = ( xyr_Press(i,j,k-1) - xyr_Press(i,j,k) ) / Grav
    end do


    k = kmax
    do j = 1, jmax
      do i = 0, imax-1
        if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
          xyz_DelMajCompIce(i,j,k) =                                 &
            &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )    &
            &   * xyz_DelAtmMass(i,j,k)                              &
            &   / LatentHeatMajCompSubl
          xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
        else
          xyz_DelMajCompIce(i,j,k) = 0.0_DP
        end if
      end do
    end do
    !
    xy_FallingIce = 0.0_DP
    do k = kmax-1, 1, -1
      xy_FallingIce = xy_FallingIce + xyz_DelMajCompIce(:,:,k+1)
      do j = 1, jmax
        do i = 0, imax-1
          SpecHeatCO2Ice = 349.0_DP + 4.8_DP * xyz_TempCond(i,j,k)
          !                                            Forget et al. (1998)
          xyz_DelMajCompIce(i,j,k) =                                     &
            &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )        &
            &   * xyz_DelAtmMass(i,j,k)                                  &
            &   / LatentHeatMajCompSubl                                  &
            & - (   Grav * ( xyz_Height(i,j,k+1) - xyz_Height(i,j,k) )   &
            &     + SpecHeatCO2Ice                                       &
            &       * ( xyz_TempCond(i,j,k+1) - xyz_TempCond(i,j,k) ) )  &
            &   / LatentHeatMajCompSubl                                  &
            &   * xy_FallingIce(i,j)
          if ( ( xy_FallingIce(i,j) + xyz_DelMajCompIce(i,j,k) ) >= 0.0_DP ) then
            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
          else
            xyz_DelMajCompIce(i,j,k) = - xy_FallingIce(i,j)
            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                                &
              & + ( - LatentHeatMajCompSubl                                  &
              &     + Grav * ( xyz_Height(i,j,k+1) - xyz_Height(i,j,k) )     &
              &     + SpecHeatCO2Ice                                         &
              &         * ( xyz_TempCond(i,j,k+1) - xyz_TempCond(i,j,k) ) )  &
              &     / ( CpDry * xyz_DelAtmMass(i,j,k) )                      &
              &     * xy_FallingIce(i,j)
          end if
        end do
      end do
    end do


    ! Ice falling on the surface
    !   This may result in supersaturation in the lowest level.
    !
    xy_FallingIce = xy_FallingIce + xyz_DelMajCompIce(:,:,1)
    k = 1
    do j = 1, jmax
      do i = 0, imax-1
        xy_DelSurfMajCompIce(i,j) =                                    &
          & - (   Grav * ( xyz_Height(i,j,1) - 0.0_DP ) )              &
          &   / LatentHeatMajCompSubl                                  &
          &   * xy_FallingIce(i,j)



          SpecHeatCO2Ice = 349.0_DP + 4.8_DP * xy_SurfTempCond(i,j)
          !                                            Forget et al. (1998)
          xy_DelSurfMajCompIce(i,j) =                                    &
!!$            &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )        &
!!$            &   * xyz_DelAtmMass(i,j,k)                                  &
!!$            &   / LatentHeatMajCompSubl                                  &
            & - (   Grav * ( xyz_Height(i,j,1) - 0.0_DP )                &
            &     + SpecHeatCO2Ice                                       &
            &       * ( xyz_TempCond(i,j,1) - xy_SurfTempCond(i,j) ) )   &
            &   / LatentHeatMajCompSubl                                  &
            &   * xy_FallingIce(i,j)


        if ( ( xy_FallingIce(i,j) + xy_DelSurfMajCompIce(i,j) ) >= 0.0_DP ) then
          ! Part of ice sublimes.
          ! NOTE: In this case, temperature in the lowest layer should be 
          ! condensation temperature. So, actually, the set of temperature is 
          ! meaningless.
          xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
        else
          ! All falling ice sublimes.
          ! NOTE: The formulation below is different from that by Forget et al.
          ! (1998). The latent heat and heat by potential energy release and 
          ! heating ice is distributed in the lowest layer in this model, not
          ! to the soil.
          xy_DelSurfMajCompIce(i,j) = - xy_FallingIce(i,j)
          xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                                &
            & + ( - LatentHeatMajCompSubl                                  &
            &     + Grav * ( xyz_Height(i,j,1) - 0.0_DP )                  &
            &     + SpecHeatCO2Ice                                         &
            &         * ( xyz_TempCond(i,j,1) - xy_SurfTempCond(i,j) ) )   &
            &     / ( CpDry * xyz_DelAtmMass(i,j,k) )                      &
            &     * xy_FallingIce(i,j)
       end if
       end do
    end do


    ! ѲΨ
    ! Calculate temperature tendency
    !
    xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )


    !
    ! Surface major component ice adjustment
    !
    xy_DSurfMajCompIceDt = 0.0_DP
    do k = kmax, 1, -1
      xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt + xyz_DelMajCompIce(:,:,k)
    end do
    xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt + xy_DelSurfMajCompIce(i,j)
    !
    xy_SurfMajCompIce = xy_SurfMajCompIce &
      & + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )


    !
    ! Surface pressure adjustment
    !
    xy_Ps = xy_Ps - xy_DSurfMajCompIceDt * Grav * ( 2.0_DP * DelTime )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine MajorCompPhaseChangeInAtmTest

  !--------------------------------------------------------------------------------------

  subroutine MajorCompPhaseChangeInAtm(   &
    & xyr_Press, xyz_Press,               &  ! (in)
    & xy_Ps, xyz_Temp, xy_SurfMajCompIce  &  ! (inout)
    & )
    !
    ! CO2 Ѳ
    !
    ! CO2 phase change
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & CpDry
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure

    ! ʬѲ
    ! Phase change of atmospheric major component
    !
    use saturate_major_comp, only :    &
      & SaturateMajorCompCalcCondTemp, &
      & SaturateMajorCompInqLatentHeat


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
                              !
                              ! Surface major component ice amount

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjustment
    real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
                              ! 
                              ! Surface major component ice tendency

    real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)

    real(DP):: LatentHeatMajCompSubl

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    logical :: FlagCheckPs


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. major_comp_phase_change_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( .not. FlagMajCompPhaseChange ) return


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Set latent heat
    LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()


    FlagCheckPs = .false.
    do j = 1, jmax
      do i = 0, imax-1
        if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
          FlagCheckPs = .true.
        end if
      end do
    end do
    if ( FlagCheckPs ) then
      call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
    end if


    ! Ĵ "Temp" ¸
    ! Store "Temp" before adjustment
    !
    xyz_TempB    = xyz_Temp


    call SaturateMajorCompCalcCondTemp( &
      & xyz_Press,                      & ! (in)
      & xyz_TempCond                    & ! (inout)
      & )


    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
          end if
        end do
      end do
    end do

    ! ѲΨ
    ! Calculate temperature tendency
    !
    xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )


    !
    ! Surface major component ice adjustment
    !
    xy_DSurfMajCompIceDt = 0.0_DP
    do k = kmax, 1, -1
      xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt                    &
        & + CpDry * xyz_DTempDt(:,:,k)                               &
        &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav       &
        &   / LatentHeatMajCompSubl
    end do
    xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )


    !
    ! Surface pressure adjustment
    !
    xy_Ps = xy_Ps - xy_DSurfMajCompIceDt * Grav * ( 2.0_DP * DelTime )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine MajorCompPhaseChangeInAtm

  !--------------------------------------------------------------------------------------

!!$  subroutine MajorCompPhaseChangeLimitTemp( &
!!$    & xyr_Press, xyz_Press,  &  ! (in)
!!$    & xy_SurfTemp, xyz_Temp  &  ! (inout)
!!$    & )
!!$    !
!!$    ! CO2 Ѳ
!!$    !
!!$    ! CO2 phase change
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: &
!!$      & DelTime, &            ! $ \Delta t $
!!$      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
!!$      & TimesetClockStart, TimesetClockStop
!!$
!!$    ! ҥȥǡ
!!$    ! History data output
!!$    !
!!$    use gtool_historyauto, only: HistoryAutoPut
!!$
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! $ \hat{p} $ .  (Ⱦ٥). 
!!$                              ! Air pressure (half level)
!!$    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ p $ .  (٥). 
!!$                              ! Air pressure (full level)
!!$    real(DP), intent(inout):: xy_SurfTemp(0:imax-1, 1:jmax)
!!$                              ! $ T_s $ .   ɽ̲. Surface temperature
!!$    real(DP), intent(inout):: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T $ .     . Temperature
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP):: xy_SurfTempB  (0:imax-1, 1:jmax)
!!$                              ! Ĵɽ̲. 
!!$                              ! Surface temperature before adjustment
!!$    real(DP):: xyz_TempB     (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Ĵβ. 
!!$                              ! Temperature before adjustment
!!$    real(DP):: xy_DSurfTempDt(0:imax-1, 1:jmax)
!!$                              ! ɽ̲ѲΨ. 
!!$                              ! Surface temperature tendency
!!$    real(DP):: xyz_DTempDt   (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! ѲΨ. 
!!$                              ! Temperature tendency
!!$
!!$    real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
!!$    real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
!!$
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    logical :: FlagCheckPs
!!$
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! ׻ַ¬
!!$    ! Start measurement of computation time
!!$    !
!!$    call TimesetClockStart( module_name )
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. major_comp_phase_change_inited ) call MajorCompPhaseChangeInit
!!$
!!$    if ( .not. FlagUse ) return
!!$
!!$
!!$    FlagCheckPs = .false.
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if ( xyr_Press(i,j,0) > 1.0d4 ) then
!!$          FlagCheckPs = .true.
!!$        end if
!!$      end do
!!$    end do
!!$    if ( FlagCheckPs ) then
!!$      call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
!!$    end if
!!$
!!$
!!$    ! Ĵ "Temp" ¸
!!$    ! Store "Temp" before adjustment
!!$    !
!!$    xy_SurfTempB = xy_SurfTemp
!!$    xyz_TempB    = xyz_Temp
!!$
!!$
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        xy_SurfTempCond(i,j) = &
!!$          & 149.2d0 + 6.48d0 * log( 0.135d0 * xyr_Press(i,j,0) * 1.0d-2 )
!!$      end do
!!$    end do
!!$    do k = 1, kmax
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          xyz_TempCond(i,j,k) = &
!!$            & 149.2d0 + 6.48d0 * log( 0.135d0 * xyz_Press(i,j,k) * 1.0d-2 )
!!$        end do
!!$      end do
!!$    end do
!!$
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if ( xy_SurfTemp(i,j) < xy_SurfTempCond(i,j) ) then
!!$          xy_SurfTemp(i,j) = xy_SurfTempCond(i,j)
!!$        end if
!!$      end do
!!$    end do
!!$    do k = 1, kmax
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
!!$            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
!!$          end if
!!$        end do
!!$      end do
!!$    end do
!!$
!!$
!!$    ! ѲΨ
!!$    ! Calculate temperature tendency
!!$    !
!!$    xy_DSurfTempDt = ( xy_SurfTemp - xy_SurfTempB ) / ( 2.0_DP * DelTime )
!!$    xyz_DTempDt    = ( xyz_Temp    - xyz_TempB    ) / ( 2.0_DP * DelTime )
!!$
!!$
!!$    ! ҥȥǡ
!!$    ! History data output
!!$    !
!!$    call HistoryAutoPut( TimeN, 'DSurfTempDtCO2PhaseChange', xy_DSurfTempDt )
!!$    call HistoryAutoPut( TimeN, 'DTempDtCO2PhaseChange'    , xyz_DTempDt    )
!!$
!!$
!!$    ! ׻ַ¬
!!$    ! Pause measurement of computation time
!!$    !
!!$    call TimesetClockStop( module_name )
!!$
!!$  end subroutine MajorCompPhaseChangeLimitTemp

  !--------------------------------------------------------------------------------------

  subroutine MajorCompPhaseChangeInit(             &
    & ArgFlagMajCompPhaseChange, CondMajCompName   & ! (in)
    & )
    !
    ! major_comp_phase_change ⥸塼νԤޤ. 
    ! NAMELIST#major_comp_phase_change_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "major_comp_phase_change" module is initialized. 
    ! "NAMELIST#major_comp_phase_change_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
!!$
!!$    ! ե
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! ̷ѥ᥿
!!$    ! Kind type parameter
!!$    !
!!$    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʬѲ
    ! Phase change of atmospheric major component
    !
    use saturate_major_comp, only : &
      & SaturateMajorCompInit


    ! ʸ ; Declaration statements
    !
    implicit none

    logical     , intent(in) :: ArgFlagMajCompPhaseChange
    character(*), intent(in) :: CondMajCompName


!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /major_comp_phase_change_nml/ &
!!$      & FlagUse

          ! ǥեͤˤĤƤϽ³ "major_comp_phase_change#MajorCompPhaseChangeInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "major_comp_phase_change#MajorCompPhaseChangeInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( major_comp_phase_change_inited ) return


    FlagMajCompPhaseChange = ArgFlagMajCompPhaseChange


    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                        &  ! (in)
!!$        & nml = major_comp_phase_change_nml, &  ! (out)
!!$        & iostat = iostat_nml )                 ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
!!$    end if


    if ( FlagMajCompPhaseChange ) then
      ! ʬѲ
      ! Phase change of atmospheric major component
      !
      call SaturateMajorCompInit(  &
        & CondMajCompName          & ! (in)
        & )
    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DSurfTempDtMajCompPhaseChange', &
      & (/ 'lon ', 'lat ', 'time' /),                             &
      & 'heating by major component phase change', 'K s-1' )
    call HistoryAutoAddVariable( 'DTempDtMajCompPhaseChange',     &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /),                 &
      & 'heating by major component phase change', 'K s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    major_comp_phase_change_inited = .true.

  end subroutine MajorCompPhaseChangeInit

  !-------------------------------------------------------------------

end module major_comp_phase_change
