!= ̵뤷ã
!
!= Radiative transfer equation without considering scattering
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: rad_rte_nonscat.f90,v 1.6 2014/06/29 07:48:29 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_rte_nonscat
  !
  != ̵뤷ã
  !
  != Radiative transfer equation without considering scattering
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
!!$  ! RadDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadFluxOutput     :: ͥեåν
!!$  ! ------------            :: ------------
!!$  ! RadDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadFluxOutput     :: Output radiation fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_rte_nonscat_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI, &
                            ! $ \pi $ .
                            ! ߼Ψ.  Circular constant
    & StB
                            ! $ \sigma_{SB} $ .
                            ! ƥեܥĥޥ.
                            ! Stefan-Boltzmann constant

  ! ʪ
  ! Physical constants settings
  !
  use constants, only: &
    & Grav, &
                            ! $ g $ [m s-2]. 
                            ! ϲ®. 
                            ! Gravitational acceleration
    & CpDry
                            ! $ C_p $ [J kg-1 K-1]. 
                            ! 絤갵Ǯ. 
                            ! Specific heat of air at constant pressure


  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: RadRTENonScat
!!$  public :: RadRTENonScatAnotherForm
!!$  public :: RadRTENonScatMonoWithDiffFact
  public :: RadRTENonScatMonoSemiAnal
  public :: RadRTENonScatWrapper
  public :: RadRTENonScatInit


  ! ѿ
  ! Public variables
  !
  logical, save, public:: rad_rte_nonscat_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  integer , save              :: NumGaussNodeZAInt
  real(DP), save              :: DiffFact
  real(DP), save, allocatable :: a_CosZA( : )
  real(DP), save, allocatable :: a_GaussWeight( : )


  character(*), parameter:: module_name = 'rad_rte_nonscat'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: rad_rte_nonscat.f90,v 1.6 2014/06/29 07:48:29 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadRTENonScat(                                    &
    & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
    & xyrr_Trans,                                              & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative


    ! ѿ
    ! Work variables
    !
    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    ! ͥեå׻
    ! Calculate radiation flux
    !

    !   Initialization
    !
    xyr_RadLDwFlux = 0.0_DP
    xyr_RadLUwFlux = 0.0_DP
    !
    !   Downward flux
    !
    do k = kmax, 0, -1

      do kk = kmax, k+1, -1
        xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k)          &
          & + xyz_IntPF(:,:,kk)                                &
          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
      end do

    end do
    !
    !   Upward flux
    !
    !     Set upward flux
    !
    do k = 0, kmax

      xyr_RadLUwFlux(:,:,k) = xy_SurfIntPF * xyrr_Trans(:,:,k,0)

      do kk = 1, k
        xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k)          &
          & - xyz_IntPF(:,:,kk)                                &
          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
      end do

    end do


    ! ͥեåѲΨη׻
    ! Calculate rate of change of radiative flux
    !
    do k = 0, kmax
      xyra_DelRadLUwFlux(:,:,k,0) =                         &
        & xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
    end do
    k = 0
    xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
    do k = 1, kmax
      xyra_DelRadLUwFlux(:,:,k,1) =                         &
        & - xy_IntDPFDT1(:,:)                               &
        &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
    end do
    do k = 0, kmax
      xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
    end do
    k = 0
    xyra_DelRadLDwFlux(:,:,k,1) =                         &
      & + xy_IntDPFDT1(:,:)                               &
      &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
    do k = 1, kmax
      xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
    end do


  end subroutine RadRTENonScat

  !--------------------------------------------------------------------------------------
  ! This is a test version, and now (2014/06/29), this is not used because of 
  ! not good performance. So, this will be deleted in future, probably. 
  ! This routine calculates radiative flux by solving a radiative transfer 
  ! equation without including scattering. 
  ! The difference between this routine and RadRTENonScat is that this 
  ! routine solves a radiative transfer equation of a form integrated by parts.

  subroutine RadRTENonScatAnotherForm(                         &
    & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
    & xyrr_Trans,                                              & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative


    ! ѿ
    ! Work variables
    !
    real(DP) :: xyr_IntPF(0:imax-1, 1:jmax, 0:kmax)

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    ! 
    ! Calculate integrated Planck function at layer interface
    !
    xyr_IntPF(:,:,0   ) = xyz_IntPF(:,:,1   )
    do k = 1, kmax-1
      xyr_IntPF(:,:,k) = ( xyz_IntPF(:,:,k) + xyz_IntPF(:,:,k+1) ) / 2.0_DP
    end do
    xyr_IntPF(:,:,kmax) = xyz_IntPF(:,:,kmax)


    ! ͥեå׻
    ! Calculate radiation flux
    !

    !   Initialization
    !
    xyr_RadLDwFlux = 0.0_DP
    xyr_RadLUwFlux = 0.0_DP
    !
    !   Downward flux
    !
    do k = kmax, 0, -1

      xyr_RadLDwFlux(:,:,k) =   &
        &   xyr_IntPF(:,:,k   ) &
        & - xyr_IntPF(:,:,kmax) * xyrr_Trans(:,:,k,kmax)
      !
      do kk = kmax, k+1, -1
        xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k)                    &
          & - ( xyrr_Trans(:,:,k,kk-1) + xyrr_Trans(:,:,k,kk) ) / 2.0_DP &
          &   * ( xyr_IntPF(:,:,kk-1) - xyr_IntPF(:,:,kk) )
      end do

    end do
    !
    !   Upward flux
    !
    !     Set upward flux
    !
    do k = 0, kmax

      xyr_RadLUwFlux(:,:,k) =                                         &
        &   ( xy_SurfIntPF - xyr_IntPF(:,:,0) ) * xyrr_Trans(:,:,k,0) &
        & + xyr_IntPF(:,:,k)
      !
      do kk = 1, k
        xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k)                    &
          & + ( xyrr_Trans(:,:,k,kk-1) + xyrr_Trans(:,:,k,kk) ) / 2.0_DP &
          &   * ( xyr_IntPF(:,:,kk-1) - xyr_IntPF(:,:,kk) )
      end do

    end do


    ! ͥեåѲΨη׻
    ! Calculate rate of change of radiative flux
    !
    do k = 0, kmax
      xyra_DelRadLUwFlux(:,:,k,0) =                         &
        & xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
    end do
    k = 0
    xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
    k = 1
    xyra_DelRadLUwFlux(:,:,k,1) =                         &
      &   xy_IntDPFDT1                                    &
      &   * ( - xyrr_Trans(:,:,k,0) + 1.0_DP / 2.0_DP     &
      &       + ( xyrr_Trans(:,:,k,0) + xyrr_Trans(:,:,k,1) ) / 2.0_DP / 2.0_DP )
    do k = 2, kmax
      xyra_DelRadLUwFlux(:,:,k,1) =                         &
        &   xy_IntDPFDT1                                    &
        &   * ( - xyrr_Trans(:,:,k,0)                       &
        &       + ( xyrr_Trans(:,:,k,0) + xyrr_Trans(:,:,k,1) ) / 2.0_DP / 2.0_DP &
        &       + ( xyrr_Trans(:,:,k,1) + xyrr_Trans(:,:,k,2) ) / 2.0_DP / 2.0_DP )
    end do
    do k = 0, kmax
      xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
    end do
    if ( kmax <= 1 ) then
      k = 0
      xyra_DelRadLDwFlux(:,:,k,1) =                         &
        & + xy_IntDPFDT1                                    &
        &   * (   1.0_DP - xyrr_Trans(:,:,k,k+1) )
      k = 1
      xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
    else
      k = 0
      xyra_DelRadLDwFlux(:,:,k,1) =                         &
        & + xy_IntDPFDT1                                    &
        &   * (   1.0_DP                                      &
        &       - ( xyrr_Trans(:,:,k,k  ) + xyrr_Trans(:,:,k,k+1) ) / 2.0_DP / 2.0_DP &
        &       - ( xyrr_Trans(:,:,k,k+1) + xyrr_Trans(:,:,k,k+2) ) / 2.0_DP / 2.0_DP )
      k = 1
      xyra_DelRadLDwFlux(:,:,k,1) =                         &
        & + xy_IntDPFDT1                                    &
        &   * (   1.0_DP / 2.0_DP                           &
        &       - ( xyrr_Trans(:,:,k,k  ) + xyrr_Trans(:,:,k,k+1) ) / 2.0_DP / 2.0_DP )
    end if
    do k = 2, kmax
      xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
    end do


  end subroutine RadRTENonScatAnotherForm

  !--------------------------------------------------------------------------------------
  ! This calculation method may not be good. Numerical integration over zenith 
  ! angle should be performed.
  subroutine RadRTENonScatMonoWithDiffFact(                    &
    & DiffFact,                                                & ! (in)
    & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
    & xyz_OptDep,                                              & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: DiffFact
                              ! Diffusivity factor
    real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature
    real(DP), intent(in ) :: xyz_OptDep   (0:imax-1, 1:jmax, 1:kmax)
                              ! Ū. 
                              ! Optical depth
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative


    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_TransEachLayer(0:imax-1, 1:jmax, 1:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP) :: xyr_Trans0(0:imax-1, 1:jmax, 0:kmax)
                              ! 
                              ! Transmission coefficient from surface to layer interfaces
    real(DP) :: xyr_Trans1(0:imax-1, 1:jmax, 0:kmax)
                              ! 
                              ! Transmission coefficient from top of the lowest layer to layer interfaces

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    ! ͥեå׻
    ! Calculate radiation flux
    !

    xyz_TransEachLayer = exp( - DiffFact * xyz_OptDep )
    !
    xyr_Trans0(:,:,0) = 1.0_DP
    do k = 1, kmax
      xyr_Trans0(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
    end do
    xyr_Trans1(:,:,0) = xyz_TransEachLayer(:,:,1)
    xyr_Trans1(:,:,1) = 1.0_DP
    do k = 2, kmax
      xyr_Trans1(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
    end do

    !   Initialization
    !
    xyr_RadLDwFlux = 0.0_DP
    xyr_RadLUwFlux = 0.0_DP
    !
    !   Downward flux
    !
    k = kmax
    xyr_RadLDwFlux(:,:,k) = 0.0_DP
    do k = kmax-1, 0, -1
      xyr_RadLDwFlux(:,:,k) =                                     &
        &   xyr_RadLDwFlux(:,:,k+1) * xyz_TransEachLayer(:,:,k+1) &
        & + xyz_IntPF(:,:,k+1) * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
    end do
    !
    !   Upward flux
    !
    k = 0
    xyr_RadLUwFlux(:,:,k) = xy_SurfIntPF
    do k = 1, kmax
      xyr_RadLUwFlux(:,:,k) =                                   &
        &   xyr_RadLUwFlux(:,:,k-1) * xyz_TransEachLayer(:,:,k) &
        & - xyz_IntPF(:,:,k) * ( xyz_TransEachLayer(:,:,k) - 1.0_DP )
    end do


    ! ͥեåѲΨη׻
    ! Calculate rate of change of radiative flux
    !
    do k = 0, kmax
      xyra_DelRadLUwFlux(:,:,k,0) =                         &
        & xy_SurfIntDPFDT * xyr_Trans0(:,:,k)
    end do
    k = 0
    xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
    do k = 1, kmax
      xyra_DelRadLUwFlux(:,:,k,1) =                         &
        & - xy_IntDPFDT1 * ( xyr_Trans0(:,:,k) - xyr_Trans1(:,:,k) )
    end do
    do k = 0, kmax
      xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
    end do
    k = 0
    xyra_DelRadLDwFlux(:,:,k,1) =                         &
      & + xy_IntDPFDT1 * ( xyr_Trans0(:,:,k) - xyr_Trans1(:,:,k) )
    do k = 1, kmax
      xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
    end do


  end subroutine RadRTENonScatMonoWithDiffFact

  !--------------------------------------------------------------------------------------
  ! ###This memo should be checked.###
  ! It should be noted that IntPF is Planck function integrated over 
  ! wavenumber and azimuthal angle and divided by 2. 
!!$  ! So, pi is multiplied after integrated over wavenumber. 
  !
  subroutine RadRTENonScatMonoSemiAnal(                        &
    & xy_SurfAlbedo,                                           & ! (in)
    & xyr_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
    & xyz_OptDep,                                              & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xyr_IntPF        (0:imax-1, 1:jmax, 0:kmax)
                              ! Integrated Planck function
    real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature
    real(DP), intent(in ) :: xyz_OptDep   (0:imax-1, 1:jmax, 1:kmax)
                              ! Ū. 
                              ! Optical depth
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative


    ! ѿ
    ! Work variables
    !
    real(DP) :: CosZA
    real(DP) :: GaussWeight

    real(DP) :: xyz_TransEachLayer0(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_TransEachLayer (0:imax-1, 1:jmax, 1:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP) :: xyr_Trans0(0:imax-1, 1:jmax, 0:kmax)
                              ! 
                              ! Transmission coefficient from surface to layer interfaces
    real(DP) :: xyr_Trans1(0:imax-1, 1:jmax, 0:kmax)
                              ! 
                              ! Transmission coefficient from top of the lowest layer to layer interfaces

    real(DP) :: xyz_DPFDOptDep(0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xyr_UwFlux (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_DwFlux (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyra_DelUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP) :: xyra_DelDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)

    real(DP) :: IntFact

    integer:: i
    integer:: j
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    ! ͥեå׻
    ! Calculate radiation flux
    !

    xyz_TransEachLayer0 = exp( - xyz_OptDep )
    !  This is ad hoc treatment to avoid underflow.
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_TransEachLayer0(i,j,k) < 1.0e-50_DP ) then
            xyz_TransEachLayer0(i,j,k) = 0.0_DP
          end if
        end do
      end do
    end do

    do k = 1, kmax
      xyz_DPFDOptDep(:,:,k) =                      &
        &   ( xyr_IntPF(:,:,k-1) - xyr_IntPF(:,:,k) ) &
        & / max( xyz_OptDep(:,:,k), 1.0d-100 )
    end do

    if ( NumGaussNodeZAInt > 0 ) then
      ! for case with Gaussian quadrature
      IntFact = 2.0_DP
    else
      ! for two-stream approximation or case with diffusivity factor
      IntFact = 1.0_DP
    end if


    !   Initialization
    !
    xyr_RadLUwFlux     = 0.0_DP
    xyr_RadLDwFlux     = 0.0_DP
    xyra_DelRadLUwFlux = 0.0_DP
    xyra_DelRadLDwFlux = 0.0_DP


    !   Loop for Gaussian quadrature
    !
    loop_gq : do n = 1, max( NumGaussNodeZAInt, 1 )

      ! Preparetion
      !
      if ( NumGaussNodeZAInt > 0 ) then
        CosZA = a_CosZA(n)
      else
        CosZA = 1.0_DP / DiffFact
      end if
      !
      xyz_TransEachLayer = ( xyz_TransEachLayer0 )**(1.0d0/CosZA)
      !
      xyr_Trans0(:,:,0) = 1.0_DP
      do k = 1, kmax
        xyr_Trans0(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
      end do
      xyr_Trans1(:,:,0) = xyz_TransEachLayer(:,:,1)
      xyr_Trans1(:,:,1) = 1.0_DP
      do k = 2, kmax
        xyr_Trans1(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
      end do

      !
      !   Downward flux
      !
      k = kmax
      xyr_DwFlux(:,:,k) = 0.0_DP
      do k = kmax-1, 0, -1
        xyr_DwFlux(:,:,k) =                                          &
          &   ( xyr_DwFlux(:,:,k+1) - IntFact * xyr_IntPF(:,:,k+1) ) &
          & * xyz_TransEachLayer(:,:,k+1)                            &
          & + IntFact * xyr_IntPF(:,:,k)                             &
          & - IntFact * CosZA * xyz_DPFDOptDep(:,:,k+1)              &
          &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
      end do
      !
      !   Upward flux
      !
      k = 0
      xyr_UwFlux(:,:,k) =                       &
        &   IntFact * xy_SurfIntPF              &
        & + xy_SurfAlbedo * xyr_DwFlux(:,:,0)
      do k = 1, kmax
        xyr_UwFlux(:,:,k) =                                          &
          &   ( xyr_UwFlux(:,:,k-1) - IntFact * xyr_IntPF(:,:,k-1) ) &
          & * xyz_TransEachLayer(:,:,k)                              &
          & + IntFact * xyr_IntPF(:,:,k)                             &
          & + IntFact * CosZA * xyz_DPFDOptDep(:,:,k)                &
          &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k) )
      end do


      ! ͥեåѲΨη׻
      ! Calculate rate of change of radiative flux
      !
      do k = 0, kmax
        xyra_DelUwFlux(:,:,k,0) = IntFact * xy_SurfIntDPFDT * xyr_Trans0(:,:,k)
      end do
      do k = 0, kmax
        xyra_DelDwFlux(:,:,k,0) = 0.0_DP
      end do
      xyra_DelUwFlux(:,:,:,1) = 0.0_DP
      xyra_DelDwFlux(:,:,:,1) = 0.0_DP


      ! Sum over zenith angle
      !
      if ( NumGaussNodeZAInt > 0 ) then
        GaussWeight = a_GaussWeight( n )

        xyr_RadLUwFlux = xyr_RadLUwFlux &
          & + xyr_UwFlux * CosZA * GaussWeight
        xyr_RadLDwFlux = xyr_RadLDwFlux &
          & + xyr_DwFlux * CosZA * GaussWeight

        xyra_DelRadLUwFlux = xyra_DelRadLUwFlux &
          & + xyra_DelUwFlux * CosZA * GaussWeight
        xyra_DelRadLDwFlux = xyra_DelRadLDwFlux &
          & + xyra_DelDwFlux * CosZA * GaussWeight
      else
        xyr_RadLUwFlux = xyr_UwFlux
        xyr_RadLDwFlux = xyr_DwFlux

        xyra_DelRadLUwFlux = xyra_DelUwFlux
        xyra_DelRadLDwFlux = xyra_DelDwFlux
      end if

    end do loop_gq


  end subroutine RadRTENonScatMonoSemiAnal

  !--------------------------------------------------------------------------------------

  subroutine RadRTENonScatWrapper(                    &
    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,         & ! (out)
    & WNs, WNe, NumGaussNode                          & ! (in ) optional
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ץ󥯴ؿη׻
    ! Calculate Planck function
    !
    use planck_func, only :                            &
      & Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D

    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in ) :: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in ) :: xy_SurfEmis (0:imax-1, 1:jmax)
                              ! ɽ̼ͽΨ. 
                              ! Surface emissivity
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative
    real(DP), intent(in ), optional :: WNs
    real(DP), intent(in ), optional :: WNe
    integer , intent(in ), optional :: NumGaussNode


    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP):: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Check arguments
    !
    if ( present( WNs ) .or. present( WNe ) .or. present( NumGaussNode ) ) then
      if ( .not. ( present( WNs ) .and. present( WNe ) .and. present( NumGaussNode ) ) ) then
        call MessageNotify( 'E', module_name, &
          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
      end if
    end if


    if ( present( WNs ) ) then
      ! Case for non-grey atmosphere
      !

      ! Integrate Planck function and temperature derivative of it
      !
      call Integ_PF_GQ_Array3D( &
        & WNs, WNe, NumGaussNode, &
        & 0, imax-1, 1, jmax, 1, kmax, &
        & xyz_Temp, &
        & xyz_IntPF &
        & )
      call Integ_PF_GQ_Array2D( &
        & WNs, WNe, NumGaussNode, &
        & 0, imax-1, 1, jmax, &
        & xy_SurfTemp, &
        & xy_SurfIntPF &
        & )
      call Integ_DPFDT_GQ_Array2D(             &
        & WNs, WNe, NumGaussNode,              & ! (in )
        & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
        & xy_IntDPFDT1                         & ! (out)
        & )
      call Integ_DPFDT_GQ_Array2D(         &
        & WNs, WNe, NumGaussNode,          & ! (in )
        & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
        & xy_SurfIntDPFDT                  & ! (out)
        & )

      xyz_IntPF       =               PI * xyz_IntPF
      xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
      xy_IntDPFDT1    =               PI * xy_IntDPFDT1
      xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT

    else

      ! Case for grey atmosphere
      !
      xyz_IntPF       =                        StB * xyz_Temp**4
      xy_SurfIntPF    = xy_SurfEmis          * StB * xy_SurfTemp**4
      xy_IntDPFDT1    =               4.0_DP * StB * xyz_Temp(:,:,1)**3
      xy_SurfIntDPFDT = xy_SurfEmis * 4.0_DP * StB * xy_SurfTemp**3

    end if


    call RadRTENonScat(                                         &
      & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT, & ! (in)
      & xyrr_Trans,                                             & ! (in)
      & xyr_RadLUwFlux, xyr_RadLDwFlux,                         & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                  & ! (out)
      & )


  end subroutine RadRTENonScatWrapper

  !--------------------------------------------------------------------------------------

  subroutine RadRTENonScatInit
    !
    ! rad_rte_nonscat ⥸塼νԤޤ. 
    ! NAMELIST#rad_rte_nonscat_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_rte_nonscat" module is initialized. 
    ! "NAMELIST#rad_rte_nonscat_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! Ť, ʬη׻
    ! Calculate Gauss node and Gaussian weight
    !
    use gauss_quad, only : GauLeg

    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_rte_nonscat_nml/ &
      & DiffFact,                  &
      & NumGaussNodeZAInt
          !
          ! ǥեͤˤĤƤϽ³ "rad_rte_nonscat#RadRTENonScatInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_rte_nonscat#RadRTENonScatInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_rte_nonscat_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    NumGaussNodeZAInt = 3
    DiffFact          = 1.66_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = rad_rte_nonscat_nml,      & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    if ( NumGaussNodeZAInt > 0 ) then
      allocate( a_CosZA      ( NumGaussNodeZAInt ) )
      allocate( a_GaussWeight( NumGaussNodeZAInt ) )
      call GauLeg( 0.0_DP, 1.0_DP, NumGaussNodeZAInt, a_CosZA, a_GaussWeight )
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'NumGaussNodeZAInt = %d', i = (/ NumGaussNodeZAInt /) )
    call MessageNotify( 'M', module_name, 'DiffFact          = %f', d = (/ DiffFact /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_rte_nonscat_inited = .true.

  end subroutine RadRTENonScatInit

  !-------------------------------------------------------------------

end module rad_rte_nonscat
