!= ͥեå (GFD Ǿȯͥǥ)
!
!= Radiation flux (radiation model developed by GFD Dennou Club)
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA
! Version::   $Id: rad_DennouAGCM.f90,v 1.3 2012-02-01 05:19:53 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_DennouAGCM
  !
  != ͥեå (GFD Ǿȯͥǥ)
  !
  != Radiation flux (radiation model developed by GFD Dennou Club)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! , 漾, , ͥեå׻ͥǥǤ. 
  !
  ! This is a radiation model that calculates radiation flux from
  ! temperature, specific humidity, and air pressure.
  !
  !== References
  !
  !  Numaguti, Atusi, 1992: 
  !    ǮӤˤѱư絬Ϲ¤˴ؤͼ¸. Doctor thesis, 218pp. (Japanese)
  !
  !== Procedures List
  !
  ! RadDennouAGCMFlux     :: ͥեåη׻
  ! RadDennouAGCMFinalize :: λ (⥸塼ѿγդ)
  ! ------------                :: ------------
  ! RadDennouAGCMFlux     :: Calculate radiation flux
  ! RadDennouAGCMFinalize :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_DennouAGCM_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: &
    & RstFileIntValue => IntValue, &
                              ! ꥹȥǡνϴֳ (). 
                              ! Interval of restart data output (numerical value)
    & RstFileIntUnit  => IntUnit, &
                              ! ꥹȥǡνϴֳ (ñ). 
                              ! Interval of restart data output (unit)
    & RstFileIntTime  => IntTime
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ꥹȥǡ
  ! Restart data output
  !
  use gtool_history, only: GT_HISTORY

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RadDennouAGCMFlux
  public:: RadDennouAGCMInit
  public:: RadDennouAGCMFinalize

  ! ѿ
  ! Public variables
  !
  logical, save :: rad_DennouAGCM_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  logical, save:: Old_Flux_saved = .false.
                              ! ٷ׻եå¸Ȥ򼨤ե饰. 
                              ! Flag for saving of flux calculated once

  type(GT_HISTORY), save:: gthst_rst
                              ! ꥹȥǡ gtool_history#GT_HISTORY ѿ. 
                              ! "gtool_history#GT_HISTORY" variable for restart data
  real(DP), save:: PrevRstOutputTime
                              ! Υꥹȥեνϻ. 
                              ! Previous output time of a restart file
  logical, save:: flag_rst_output_end
                              ! ׻ǽνϴλΥե饰. 
                              ! Flag for completion of output at the end time of calculation
  logical, save:: flag_rst_input = .false.
                              ! ߤ¸ͤꥹȥե뤫ɤ߹ޤ줿Ȥ򼨤ե饰. 
                              ! Flag that indicates that saved value is input from a restart file. 

  ! ĹȥեåѾ
  ! Information for long wave flux
  !
  real(DP), save:: IntTimeLong
                              ! Ĺȥեå׻ֳִ. 
                              ! Interval time of long wave flux calculation
  real(DP), save:: PrevTimeLong
                              ! Ĺȥեå׻. 
                              ! Time when long wave flux is calculated
  real(DP), save:: DelTimeLongValue
                              ! Ĺȥեå׻ֳִ֤ο. 
                              ! Value of interval step of long wave flux calculation
  character(STRING), save:: DelTimeLongUnit
                              ! Ĺȥեå׻ֳִ֤ñ. 
                              ! Unit of interval step of long wave flux calculation

  integer, save:: LongBandNum
                              ! ĹȥХɿ. 
                              ! Number of long wave band
  real(DP), save:: LongAbsorpCoefQVap (1:MaxNmlArySize)
                              ! $ k_R $ . εۼ. 
                              ! Absorption coefficient of water. 
  real(DP), save:: LongAbsorpCoefDryAir (1:MaxNmlArySize)
                              ! $ \bar{k}_R $ . εۼ. 
                              ! Absorption coefficient of air. 
  real(DP), save:: LongBandWeight (1:MaxNmlArySize)
                              ! Хɥ. 
                              ! Band weight. 
  real(DP), save:: LongPathLengthFact
                              ! ϩĹΥե. 
                              ! Factor of optical length

  real(DP), allocatable, save:: xy_TempSave (:,:)
                              ! $ T $ .      (¸). Temperature (for save)
  real(DP), allocatable, save:: xyr_RadLUwFluxSave (:,:,:)
                              ! Ĺȥեå (¸). 
                              ! Upward long wave flux (for save)
  real(DP), allocatable, save:: xyr_RadLDwFluxSave (:,:,:)
                              ! Ĺȥեå (¸). 
                              ! Downward long wave flux (for save)
  real(DP), allocatable, save:: xyra_DelRadLUwFluxSave (:,:,:,:)
                              ! ĹɽѲ (¸). 
                              ! 
  real(DP), allocatable, save:: xyra_DelRadLDwFluxSave (:,:,:,:)
                              ! ĹɽѲ (¸). 
                              ! 

  ! ûȥեåѾ
  ! Information for short wave flux
  !
  real(DP), save:: SolarConst
                              ! . 
                              ! Solar constant.
  real(DP), save:: IntTimeShort
                              ! ûȥեå׻ֳִ. 
                              ! Interval time of short wave flux calculation
  real(DP), save:: PrevTimeShort
                              ! ûȥեå׻
                              ! Time when short wave flux is calculated
  real(DP), save:: DelTimeShortValue
                              ! û () եå׻ֳִ֤ο. 
                              ! Value of interval step of short wave (insolation) flux calculation
  character(STRING), save:: DelTimeShortUnit
                              ! û () եå׻ֳִ֤ñ. 
                              ! Unit of interval step of short wave (insolation) flux calculation


  integer, save:: ShortBandNum
                              ! ûȥХɿ. 
                              ! Number of short wave band
  real(DP), save:: ShortAbsorpCoefQVap (1:MaxNmlArySize)
                              ! $ k_S $ . εۼ. 
                              ! Absorption coefficient of water. 
  real(DP), save:: ShortAbsorpCoefDryAir (1:MaxNmlArySize)
                              ! $ \bar{k}_S $ . εۼ. 
                              ! Absorption coefficient of air. 
  real(DP), save:: ShortBandWeight (1:MaxNmlArySize)
                              ! Хɥ. 
                              ! Band weight. 
  real(DP), save:: ShortSecScat
                              !  $ \sec \zeta $ .
                              ! $ \sec \zeta $ of scattering
  real(DP), save:: ShortAtmosAlbedo
                              ! 絤٥. 
                              ! Albedo of air.

  real(DP), allocatable, save:: xyr_RadSUwFluxSave (:,:,:)
                              ! û () եå (¸). 
                              ! Upward short wave (insolation) flux (for save)
  real(DP), allocatable, save:: xyr_RadSDwFluxSave (:,:,:)
                              ! û () եå (¸). 
                              ! Downward short wave (insolation) flux (for save)

  ! ûѾ
  ! Information for short wave incoming
  !
  real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux
  real(DP), allocatable, save:: xy_InAngle (:,:)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)


  character(*), parameter:: module_name = 'rad_DennouAGCM'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: rad_DennouAGCM.f90,v 1.3 2012-02-01 05:19:53 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadDennouAGCMFlux(                  &
    & xyz_Temp, xyz_QVap, xyr_Press,             & ! (in)
    & xy_SurfTemp, xy_SurfAlbedo,                & ! (in)
    & xyr_RadSUwFlux, xyr_RadSDwFlux,            & ! (out)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,            & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux     & ! (out)
    & )
    !
    ! , 漾, , ͥեå׻ޤ. 
    !
    ! Calculate radiation flux from temperature, specific humidity, and 
    ! air pressure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only: RadShortIncome

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime, &            ! ׻λ. 
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    ! ꥹȥǡ
    ! Restart data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo

    real(DP), intent(out):: xyr_RadSUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Upward shortwave (insolation) flux
    real(DP), intent(out):: xyr_RadSDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Downward shortwave (insolation) flux

    real(DP), intent(out):: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out):: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 
    real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 



    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho q \, dz $ . 
                              ! ľ k οΥ̩. 
                              ! Column density of water vapor above vertical level k. 
    real(DP):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho \, dz $ . 
                              ! ľ k ζΥ̩. 
                              ! Column density of air above vertical level k. 
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    logical:: flag_rst_output
                              ! ꥹȥեϤΥե饰. 
                              ! Flag for output of a restart file

    real(DP) :: xy_CosSZA(0:imax-1, 1:jmax)
    real(DP) :: DistFromStarScld
    real(DP) :: DiurnalMeanFactor

    integer:: i
    integer:: j


    real(DP) :: MaxError


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_DennouAGCM_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ľ k Υ̩٤η׻
    ! Calculate column density above vertical level k
    !
    xyr_ColDenQVap  (:,:,kmax) = 0.
    xyr_ColDenDryAir(:,:,kmax) = 0.

    do k = kmax-1, 0, -1
      xyr_ColDenQVap(:,:,k) = &
        &   xyr_ColDenQVap(:,:,k+1) &
        & + xyz_QVap(:,:,k+1) &
        &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav

      xyr_ColDenDryAir(:,:,k) = &
        &   xyr_ColDenDryAir(:,:,k+1) &
        & + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do

    ! Ĺȥեåλ
    ! Calculate long wave flux
    !
    if ( ( TimeN - PrevTimeLong >= IntTimeLong ) .or. ( .not. Old_Flux_saved ) ) then

      if ( .not. Old_Flux_saved ) then
        PrevTimeLong = TimeN
      else
        PrevTimeLong = PrevTimeLong + IntTimeLong
      end if


      call LongFlux( &
        & xyz_Temp, xy_SurfTemp, xyr_ColDenQVap, xyr_ColDenDryAir,                & ! (in)
        & xyr_RadLUwFlux, xyr_RadLDwFlux, xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
        & )


    ! ͤ
    ! Use values in last time
    !
    else

      xyr_RadLUwFlux     = xyr_RadLUwFluxSave
      xyr_RadLDwFlux     = xyr_RadLDwFluxSave
      xyra_DelRadLUwFlux = xyra_DelRadLUwFluxSave
      xyra_DelRadLDwFlux = xyra_DelRadLDwFluxSave

      if ( .not. flag_rst_input ) then
        do k = 0, kmax
          xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k) &
            & + xyra_DelRadLUwFlux(:,:,k,1) * ( xyz_Temp(:,:,1) - xy_TempSave )
          xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k) &
            & + xyra_DelRadLDwFlux(:,:,k,1) * ( xyz_Temp(:,:,1) - xy_TempSave )

          xyra_DelRadLUwFlux(:,:,k,1) = xyra_DelRadLUwFlux(:,:,k,1) &
            &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
          xyra_DelRadLDwFlux(:,:,k,1) = xyra_DelRadLDwFlux(:,:,k,1) &
            &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
        end do
      else
        flag_rst_input = .false.
        call DbgMessage( '%c: restart data is used. ', c1 = module_name )
      end if

    end if



    ! û () եåλ
    ! Calculate short wave (insolation)
    !
    if ( ( TimeN - PrevTimeShort >= IntTimeShort ) .or. ( .not. Old_Flux_saved ) ) then

      if ( .not. Old_Flux_saved ) then
        PrevTimeShort = TimeN
      else
        PrevTimeShort = PrevTimeShort + IntTimeShort
      end if

      ! ûͤη׻
      ! Calculate short wave (insolation) incoming radiation
      !
      call RadShortIncome(                       &
        & xy_CosZet         = xy_CosSZA,         & ! (out) optional
        & xy_InAngle        = xy_InAngle,        & ! (out) optional
        & DistFromStarScld  = DistFromStarScld,  &
        & DiurnalMeanFactor = DiurnalMeanFactor  &
        & )


      ! ûȥեåη׻
      ! Calculate short wave (insolation) flux
      !

      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_CosSZA(i,j) > 0.0_DP ) then
            xy_IncomRadSFlux(i,j) = SolarConst / DistFromStarScld**2 * xy_CosSZA(i,j)
          else
            xy_IncomRadSFlux(i,j) = 0.0_DP
          end if
        end do
      end do
      ! Correction of incoming solar flux when diurnal mean insolation is assumed.
      ! If diurnal mean insolation is assumed, DiurnalMeanFactor = 1 / PI.
      ! If diurnal mean insolation is not assumed, DiurnalMeanFactor = 1.
      xy_IncomRadSFlux = xy_IncomRadSFlux * DiurnalMeanFactor


      ! 絤٥ɤιθ
      ! Taking atmospheric albedo into consideration
      !
      xy_IncomRadSFlux = xy_IncomRadSFlux * ( 1.0d0 - ShortAtmosAlbedo )


      call ShortFlux(                                      &
        & xyr_ColDenQVap, xyr_ColDenDryAir, xy_SurfAlbedo, & ! (in)
        & xy_IncomRadSFlux,                                & ! (in)
        & xyr_RadSUwFlux, xyr_RadSDwFlux                   & ! (out)
        & )


    else
      ! ͤ
      ! Use values in last time

      xyr_RadSUwFlux = xyr_RadSUwFluxSave
      xyr_RadSDwFlux = xyr_RadSDwFluxSave
    end if



    ! ׻ͤ¸
    ! Save calculated values in this time
    !
    xy_TempSave            = xyz_Temp (:,:,1)

    xyr_RadSUwFluxSave     = xyr_RadSUwFlux
    xyr_RadSDwFluxSave     = xyr_RadSDwFlux

    xyr_RadLUwFluxSave     = xyr_RadLUwFlux
    xyr_RadLDwFluxSave     = xyr_RadLDwFlux
    xyra_DelRadLUwFluxSave = xyra_DelRadLUwFlux
    xyra_DelRadLDwFluxSave = xyra_DelRadLDwFlux

    if ( .not. Old_Flux_saved ) Old_Flux_saved = .true.

    ! ꥹȥեνϥߥ󥰤Υå
    ! Check output timing of a restart file
    !
!!
!! old code to be deleted
!! 
!    flag_rst_output = ( TimeN - PrevRstOutputTime >= RstFileIntTime )
!    if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
!      flag_rst_output = .true.
!      flag_rst_output_end = .true.
!    end if
!    flag_rst_output = ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output


    if ( TimeN - PrevRstOutputTime >= RstFileIntTime ) then
       flag_rst_output = .true.
    else
       flag_rst_output = .false.
    end if
    if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
      flag_rst_output = .true.
      flag_rst_output_end = .true.
    end if
    if ( ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output ) then
       flag_rst_output = .true.
    else
       flag_rst_output = .false.
    end if


    if ( flag_rst_output ) then
      ! Ѥ, ν (˾)  ¸
      ! Save output time (expected) in this time, for next time
      !
      PrevRstOutputTime = PrevRstOutputTime + RstFileIntTime

      ! 
      ! Set time
      !
      call HistorySetTime( timed = TimeN, history = gthst_rst )

      ! ǡ
      ! Data output
      !
      call HistoryPut( &
        & 'PrevTimeLong', PrevTimeLong, & ! (in)
        & history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'PrevTimeShort', PrevTimeShort, & ! (in)
        & history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'SurfTemp', xy_TempSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'RadLUwFlux', xyr_RadLUwFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'RadLDwFlux', xyr_RadLDwFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'RadSUwFlux', xyr_RadSUwFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'RadSDwFlux', xyr_RadSDwFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'DelRadLUwFlux', xyra_DelRadLUwFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'DelRadLDwFlux', xyra_DelRadLDwFluxSave, history = gthst_rst ) ! (in)

    end if

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadDennouAGCMFlux

  !--------------------------------------------------------------------------------------

  subroutine LongFlux( &
    & xyz_Temp, xy_SurfTemp, xyr_ColDenQVap, xyr_ColDenDryAir,                & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux, xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
    & )
    !
    ! Ĺȥեåη׻
    !
    ! Calculate long wave flux
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & StB                   ! $ \sigma_{SB} $ . 
                              ! ƥեܥĥޥ. 
                              ! Stefan-Boltzmann constant

    ! ̵뤷ã
    ! Radiative transfer equation without considering scattering
    !
    use rad_rte_nonscat, only : RadRTENonScat


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature

    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho q \, dz $ . 
                              ! ľ k οΥ̩. 
                              ! Column density of water vapor above vertical level k. 
    real(DP), intent(in):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho \, dz $ . 
                              ! ľ k ζΥ̩. 
                              ! Column density of air above vertical level k. 
    real(DP), intent(out):: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out):: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 
    real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 

    ! ѿ
    ! Work variables
    !
    real(DP):: xyrr_Trans(0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP):: xyz_PiB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \pi B = \sigma T^{4} $
    real(DP):: xy_SurfPiB (0:imax-1, 1:jmax)
                              ! ɽ̤ $ \pi B $ . 
                              ! $ \pi B $ on surface
    real(DP):: xy_PiDBDT1    (0:imax-1, 1:jmax)
                              ! $ \pi DBDT = 4 \sigma T^{3} at lowest level$
    real(DP):: xy_SurfPiDBDT (0:imax-1, 1:jmax)
                              ! ɽ̤ $ \pi DBDT $ . 
                              ! $ \pi B $ on surface

    real(DP):: BandWeightSum  ! ХɥȤ
                              ! Sum of band weights

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: bn              ! ĹˤĤƲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber bands

    ! ¹ʸ ; Executable statement
    !


    ! Ʃؿ׻
    ! Calculate transmission functions
    !
    !   Initialization
    !
    xyrr_Trans = 0.
    !
    do bn = 1, LongBandNum

      do k = 0, kmax
        do kk = k, kmax
          xyrr_Trans(:,:,k,kk) = &
            &   xyrr_Trans(:,:,k,kk) &
            & + LongBandWeight(bn) &
            &   * exp( - LongPathLengthFact &
            &            * (   LongAbsorpCoefQVap(bn) &
            &                  * abs(   xyr_ColDenQVap(:,:,kk) &
            &                         - xyr_ColDenQVap(:,:,k)  ) &
            &                + LongAbsorpCoefDryAir(bn) &
            &                  * abs(   xyr_ColDenDryAir(:,:,kk) &
            &                         - xyr_ColDenDryAir(:,:,k)  ) ) )
        end do
      end do

    end do

    do k = 0, kmax
      do kk = 0, k-1
        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
      end do
    end do


    ! $ \pi B $, $ \pi DBDT $ η׻
    ! Calculate $ \pi B $ and $ \pi DBDT $
    !
    xyz_PiB       = StB * ( xyz_Temp**4 )
    xy_SurfPiB    = StB * ( xy_SurfTemp**4 )
    xy_PiDBDT1    = 4.0_DP * xyz_PiB(:,:,1) / xyz_Temp(:,:,1)
    xy_SurfPiDBDT = 4.0_DP * xy_SurfPiB / xy_SurfTemp



    call RadRTENonScat(                                 &
      & xyz_PiB, xy_SurfPiB, xy_PiDBDT1, xy_SurfPiDBDT, & ! (in)
      & xyrr_Trans,                                     & ! (in)
      & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux          & ! (out)
      & )


  end subroutine LongFlux

  !--------------------------------------------------------------------------------------

  subroutine ShortFlux(                                &
    & xyr_ColDenQVap, xyr_ColDenDryAir, xy_SurfAlbedo, & ! (in)
    & xy_TOARadSDwFlux,                                & ! (in)
    & xyr_RadSUwFlux, xyr_RadSDwFlux                   & ! (out)
    & )
    !
    ! ûȥեå׻ޤ.
    !
    ! Calculate short wave flux. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho q \, dz $ . 
                              ! ľ k οΥ̩. 
                              ! Column density of water vapor above vertical level k. 
    real(DP), intent(in):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho \, dz $ . 
                              ! ľ k ζΥ̩. 
                              ! Column density of air above vertical level k. 
    real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(in):: xy_TOARadSDwFlux (0:imax-1, 1:jmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux at the top of the atmosphere
    real(DP), intent(out):: xyr_RadSUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Upward shortwave (insolation) flux
    real(DP), intent(out):: xyr_RadSDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Downward shortwave (insolation) flux

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyr_TransForDwFlux(0:imax-1, 1:jmax, 0:kmax)
                              ! 
                              ! Transmittance from level k to top of the atmosphere
    real(DP) :: xyr_TransForUwFlux(0:imax-1, 1:jmax, 0:kmax)
                              ! 
                              ! Transmittance from surface to level k
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: bn              ! ĹˤĤƲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber bands

    ! ¹ʸ ; Executable statement
    !

    xyr_TransForDwFlux = 0.0_DP
    do k = 0, kmax
      do bn = 1, ShortBandNum
        xyr_TransForDwFlux(:,:,k) = xyr_TransForDwFlux(:,:,k)                      &
          & + ShortBandWeight(bn)                                                  &
          &   * exp( - xy_InAngle                                                  &
          &            * (   ShortAbsorpCoefQVap  (bn) * xyr_ColDenQVap  (:,:,k)   &
          &                + ShortAbsorpCoefDryAir(bn) * xyr_ColDenDryAir(:,:,k) ) &
          &        )
      end do
    end do
    !
    xyr_TransForUwFlux = 0.0_DP
    do k = 0, kmax
      do bn = 1, ShortBandNum
        xyr_TransForUwFlux(:,:,k) = xyr_TransForUwFlux(:,:,k)                        &
          & + ShortBandWeight(bn)                                                    &
          &   * exp( - xy_InAngle                                                    &
          &            * (   ShortAbsorpCoefQVap  (bn) * xyr_ColDenQVap  (:,:,0)     &
          &                + ShortAbsorpCoefDryAir(bn) * xyr_ColDenDryAir(:,:,0) )   &
          &        )                                                                 &
          &   * xy_SurfAlbedo                                                        &
          &   * exp( - ShortSecScat                                                  &
          &            * (   ShortAbsorpCoefQVap(bn)                                 &
          &                  * ( xyr_ColDenQVap  (:,:,0) - xyr_ColDenQVap  (:,:,k) ) &
          &                + ShortAbsorpCoefDryAir(bn)                               &
          &                  * ( xyr_ColDenDryAir(:,:,0) - xyr_ColDenDryAir(:,:,k) ) &
          &              )                                                           &
          &        )
      end do
    end do

    do k = 0, kmax
      xyr_RadSDwFlux(:,:,k) = xy_TOARadSDwFlux * xyr_TransForDwFlux(:,:,k)
      xyr_RadSUwFlux(:,:,k) = xy_TOARadSDwFlux * xyr_TransForUwFlux(:,:,k)
    end do


  end subroutine ShortFlux

  !--------------------------------------------------------------------------------------

  subroutine RadDennouAGCMInit( flag_rst )
    !
    ! rad_DennouAGCM ⥸塼νԤޤ. 
    ! NAMELIST#rad_DennouAGCM_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_DennouAGCM" module is initialized. 
    ! "NAMELIST#rad_DennouAGCM_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ.
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: &
      & RestartTime           ! ꥹȳϻ. 
                              ! Retart time of calculation


    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use gtool_history, only: HistoryCreate, HistoryAddAttr, &
      & HistoryAddVariable, HistoryPut, &
      & HistoryGet, HistoryGetAttr

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit

    ! ̵뤷ã
    ! Radiative transfer equation without considering scattering
    !
    use rad_rte_nonscat, only : RadRTENonScatInit

    ! ʸ ; Declaration statements
    !
    implicit none
    logical, intent(in), optional:: flag_rst
                              ! ꥹȤǤ뤳Ȥ򼨤ե饰. 
                              ! .true. Ϳ, 
                              ! Ĺ, ûͤ˴ؤꥹ
                              ! ե뤬ɬפˤʤޤ. 
                              ! ꥹȥե˴ؤ
                              ! NAMELIST#rad_DennouAGCM_nml
                              ! ǻꤵޤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! Flag for restart. 
                              ! If .true. is given, 
                              ! a restart file for long radiation 
                              ! and short radiation is needed. 
                              ! Information about the restart file 
                              ! is specified by "NAMELIST#rad_DennouAGCM_nml".
                              ! Default value is .false.
                              ! 

    character(STRING):: RstInputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of input restart data

    character(STRING):: RstOutputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of output restart data
    character(STRING):: time_range
                              ! λ. 
                              ! Specification of time

    character(TOKEN):: dummy_str
                              ! ϥåѤΥߡѿ
                              ! Dummy variable for check of input
    logical:: get_err
                              ! ϻΥ顼ե饰. 
                              ! Error flag for input

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    character(STRING):: title_msg
                              ! ɽղäå. 
                              ! Message added to title

    real(DP):: origin_time
                              ! ׻ϻ. 
                              ! Start time of calculation
    character(12):: time_unit
                              ! ñ. Units of date and time

    logical:: flag_mpi_init

    real(DP):: BandWeightSum  ! ХɥȤ
                              ! Sum of band weights
    integer:: bn              ! ĹˤĤƲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber bands


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_DennouAGCM_nml/ &
      & SolarConst, &
!
      & DelTimeLongValue, DelTimeLongUnit, &
      & DelTimeShortValue, DelTimeShortUnit, &
!
      & LongBandNum, &
      & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
      & LongBandWeight, LongPathLengthFact, &
!
      & ShortBandNum, &
      & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
      & ShortBandWeight, ShortSecScat, &
      & ShortAtmosAlbedo, &
!
      & RstInputFile, RstOutputFile
          !
          ! ǥեͤˤĤƤϽ³ "rad_DennouAGCM#RadInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_DennouAGCM#RadInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_DennouAGCM_inited ) return


!    flag_mpi_init = .false.
    flag_mpi_init = .true.

    ! ǥեͤ
    ! Default values settings
    !

    ! ĹȥեåѾ
    ! Information for long wave flux
    !
    PrevTimeLong = RestartTime

    DelTimeLongValue = 3.0_DP
    DelTimeLongUnit  = 'hrs.'

    LongBandNum      = 4
    LongAbsorpCoefQVap     = -999.9_DP
    LongAbsorpCoefDryAir   = -999.9_DP
    LongBandWeight         = -999.9_DP
    LongAbsorpCoefQVap    (1:LongBandNum) = (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /)
    LongAbsorpCoefDryAir  (1:LongBandNum) = (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
    LongBandWeight        (1:LongBandNum) = (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
    LongPathLengthFact = 1.5_DP

    ! ûȥեåѾ
    ! Information for short wave flux
    !
    SolarConst             = 1380.0_DP

    PrevTimeShort = RestartTime

    DelTimeShortValue = 1.0_DP
    DelTimeShortUnit  = 'hrs.'

    ShortBandNum = 1
    ShortAbsorpCoefQVap    = -999.9_DP
    ShortAbsorpCoefDryAir  = -999.9_DP
    ShortBandWeight        = -999.9_DP
    ShortAbsorpCoefQVap   (1:ShortBandNum) = (/ 0.002_DP /)
    ShortAbsorpCoefDryAir (1:ShortBandNum) = (/ 0.0_DP /)
    ShortBandWeight       (1:ShortBandNum) = (/ 1.0_DP /)
    ShortSecScat           = 1.66_DP
    ShortAtmosAlbedo       = 0.2_DP

    ! ꥹȥե
    ! Information about a restart file
    !
    RstInputFile  = ''
    RstOutputFile = 'rst_rad.nc'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = rad_DennouAGCM_nml,       & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    if ( LongBandNum <= 0 ) then
      call MessageNotify( 'E', module_name, 'LongBandNum has to be positive.' )
    end if
    if ( ShortBandNum <= 0 ) then
      call MessageNotify( 'E', module_name, 'ShortBandNum has to be positive.' )
    end if


    ! ХɥȤ
    ! Configure band weight
    !
    BandWeightSum = 0.
    do bn = 1, LongBandNum
      BandWeightSum =  BandWeightSum + LongBandWeight(bn)
    end do
    do bn = 1, LongBandNum
      LongBandWeight(bn) = LongBandWeight(bn) / BandWeightSum
    end do
    !
    BandWeightSum = 0.
    do bn = 1, ShortBandNum
      BandWeightSum = BandWeightSum + ShortBandWeight(bn)
    end do
    do bn = 1, ShortBandNum
      ShortBandWeight(bn) = ShortBandWeight(bn) / BandWeightSum
    end do



    ! ֳִ֤ν
    ! Handle interval time
    !
    IntTimeLong  = DCCalConvertByUnit( DelTimeLongValue,  DelTimeLongUnit,  'sec' ) ! (in)
    IntTimeShort = DCCalConvertByUnit( DelTimeShortValue, DelTimeShortUnit, 'sec' ) ! (in)

    ! Хɿ, ۼ, ХɥȤΥå
    ! Check number of band, absorption coefficients, band weight
    !
    call NmlutilAryValid( module_name, &            ! (in)
      & LongAbsorpCoefQVap, 'LongAbsorpCoefQVap', & ! (in)
      & LongBandNum,        'LongBandNum' )         ! (in)

    call NmlutilAryValid( module_name, &                ! (in)
      & LongAbsorpCoefDryAir, 'LongAbsorpCoefDryAir', & ! (in)
      & LongBandNum,          'LongBandNum' )           ! (in)

    call NmlutilAryValid( module_name, &     ! (in)
      & LongBandWeight, 'LongBandWeight', &  ! (in)
      & LongBandNum,    'LongBandNum' )      ! (in)

    call NmlutilAryValid( module_name, &              ! (in)
      & ShortAbsorpCoefQVap, 'ShortAbsorpCoefQVap', & ! (in)
      & ShortBandNum,        'ShortBandNum' )         ! (in)

    call NmlutilAryValid( module_name, &                  ! (in)
      & ShortAbsorpCoefDryAir, 'ShortAbsorpCoefDryAir', & ! (in)
      & ShortBandNum,          'ShortBandNum' )           ! (in)

    call NmlutilAryValid( module_name, &       ! (in)
      & ShortBandWeight, 'ShortBandWeight', &  ! (in)
      & ShortBandNum,    'ShortBandNum' )      ! (in)

    ! ûѿγ
    ! Allocate variables for short wave (insolation) incoming radiation
    !
    allocate( xy_IncomRadSFlux (0:imax-1, 1:jmax) )
    allocate( xy_InAngle (0:imax-1, 1:jmax) )

    ! ¸Ѥѿγդ
    ! Allocate variables for saving
    !
    allocate( xy_TempSave            (0:imax-1, 1:jmax) )
    allocate( xyr_RadSUwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_RadSDwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_RadLUwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_RadLDwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyra_DelRadLUwFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )
    allocate( xyra_DelRadLDwFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )

    ! ꥹȥե
    ! Input restart file
    !
    if ( present_and_true( flag_rst ) ) then

      if ( trim(RstInputFile) == '' ) then
        call MessageNotify( 'E', module_name, &
          & 'a restart file is needed. ' // &
          & 'Specify the restart file to "RstInputFile" in NAMELIST "rad_DennouAGCM_nml"' )
      end if

      ! μ
      ! Get time information
      !
      time_range = 'time=' // toChar( RestartTime )

      ! ե̵ͭǧ
      ! Conform an existence of an input file
      ! 
      call HistoryGetAttr( RstInputFile, 'lon', 'units', & ! (in)
        & dummy_str, &                                     ! (out)
        & flag_mpi_split = flag_mpi_init, &                ! (in) optional
        & err = get_err )                                  ! (out)

      if ( get_err ) then
        call MessageNotify( 'E', module_name, &
          & 'restart/initial data file "%c" is not found.', &
          & c1 = trim(RstInputFile) )
      end if

      ! 
      ! Input
      !
      call HistoryGet( &
        & RstInputFile, 'SurfTemp', &      ! (in)
        & xy_TempSave, &                   ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'RadSUwFlux', &    ! (in)
        & xyr_RadSUwFluxSave, &            ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'RadSDwFlux', &    ! (in)
        & xyr_RadSDwFluxSave, &            ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'RadLUwFlux', &    ! (in)
        & xyr_RadLUwFluxSave, &            ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'RadLDwFlux', &    ! (in)
        & xyr_RadLDwFluxSave, &            ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'DelRadLUwFlux', & ! (in)
        & xyra_DelRadLUwFluxSave, &        ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'DelRadLDwFlux', & ! (in)
        & xyra_DelRadLDwFluxSave, &        ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional

      call HistoryGet( &
        & RstInputFile, 'PrevTimeLong', &  ! (in)
        & PrevTimeLong, &                  ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional

      call HistoryGet( &
        & RstInputFile, 'PrevTimeShort', & ! (in)
        & PrevTimeShort, &                 ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional

      flag_rst_input = .true.
      Old_Flux_saved = .true.
    else
      RstInputFile = ''
      flag_rst_input = .false.
      Old_Flux_saved = .false.
    end if

    ! ϻֳִ֤
    ! Configure time interval of output
    !
    PrevRstOutputTime = RestartTime

    ! ꥹȥեκ
    ! Create a restart file
    !
    title_msg = ' restart data for "' // module_name // '" module'
!!$    origin_time = EvalByUnit( RestartTime, RstFileIntUnit )
!!$    time_unit = RstFileIntUnit
    time_unit = 'sec'

    call HistoryCreate( &
      &      file = RstOutputFile, &                                ! (in)
      &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
      &    source = FileSource, institution = FileInstitution, &    ! (in)
      &      dims = (/ 'lon  ', 'lat  ', 'sig  ', 'sigm ', &
      &                'sorbl', 'time ' /), &                       ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 2, 0 /), &       ! (in)
      & longnames = (/ 'longitude                             ', &
      &                'latitude                              ', &
      &                'sigma at layer midpoints              ', &
      &                'sigma at layer end-points (half level)', &
      &                'surface or bottom layer               ', &
      &                'time                                  ' /), & ! (in)
      &     units = (/ 'degree_east ', 'degree_north', &
      &                '1           ', '1           ', &
      &                '1           ', time_unit /), &                ! (in)
      & xtypes = (/'double', 'double', 'double', &
      &            'double', 'int   ', 'double'/), &                  ! (in)
      &        origind = RestartTime, &         ! (in) optional
      &      intervald = RstFileIntValue, &     ! (in) optional
      & flag_mpi_split = flag_mpi_init, &       ! (in) optional
      &        history = gthst_rst )            ! (out) optional

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAddAttr( &
      & 'lon', attrname = 'standard_name', &     ! (in)
      & value = 'longitude', &                   ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'standard_name', &     ! (in)
      & value = 'latitude', &                    ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'standard_name', &     ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'standard_name', &    ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'standard_name', &    ! (in)
      & value = 'time', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'positive', &          ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'positive', &         ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)

    call HistoryPut( &
      & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'sig', z_Sigma, &               ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( & 
      & 'sigm', r_Sigma, &              ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( & 
      & 'sorbl', (/ 0, 1 /), &          ! (in)
      & history = gthst_rst )           ! (inout)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAddVariable( 'lon_weight', &               ! (in)
      & (/'lon'/), &                                       ! (in)
      & 'weight for integration in longitude', 'radian', & ! (in)
      & xtype = 'double', &                                ! (in)
      & history = gthst_rst )                              ! (inout)
    call HistoryAddAttr( &
      & 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lon_weight', x_Lon_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'lat_weight', &                      ! (in)
      & (/'lat'/), &                                              ! (in)
      & 'weight for integration in latitude', units = 'radian', & ! (in)
      & xtype = 'double', &                                       ! (in)
      & history = gthst_rst )                                     ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lat_weight', y_Lat_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'sig_weight', &      ! (in)
      & (/'sig'/), &                              ! (in)
      & 'weight for integration in sigma', '1', & ! (in)
      & xtype = 'double', &                       ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'sig_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'sig_weight', z_DelSigma, &               ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'PrevTimeLong', &      ! (in)
      & (/ 'time' /), &                             ! (in)
      & 'previous time at which longwave flux is calculated', & ! (in)
      & 'sec', &                                    ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'PrevTimeShort', &     ! (in)
      & (/ 'time' /), &                             ! (in)
      & 'previous time at which shortwave flux is calculated', & ! (in)
      & 'sec', &                                    ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)

    call HistoryAddVariable( 'SurfTemp', &          ! (in)
      & (/ 'lon ', 'lat ', 'time' /), &             ! (in)
      & 'surface temperature', 'K', &               ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'RadSUwFlux', &        ! (in)
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
      & 'upward shortwave flux', 'W m-2', &         ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'RadSDwFlux', &        ! (in)
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
      & 'downward shortwave flux', 'W m-2', &       ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'RadLUwFlux', &        ! (in)
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
      & 'upward longwave flux', 'W m-2', &          ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'RadLDwFlux', &        ! (in)
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
      & 'downward longwave flux', 'W m-2', &        ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'DelRadLUwFlux', &                           ! (in)
      & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
      & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
      & xtype = 'double', &                                               ! (in)
      & history = gthst_rst )                                             ! (inout)
    call HistoryAddVariable( 'DelRadLDwFlux', &                           ! (in)
      & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
      & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
      & xtype = 'double', &                                               ! (in)
      & history = gthst_rst )                                             ! (inout)



    ! Initialization of modules used in this module
    !

    ! û ()
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit

    ! ̵뤷ã
    ! Radiative transfer equation without considering scattering
    !
    call RadRTENonScatInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Restart:' )

    if ( trim(RstInputFile) == '' ) then
      call MessageNotify( 'M', module_name, '  InputFile  = <no input>', c1 = trim( RstInputFile ) )
    else
      call MessageNotify( 'M', module_name, '  InputFile       = %c', c1 = trim( RstInputFile ) )
      call MessageNotify( 'M', module_name, '    PrevTimeLong  = %f [%c]', &
      & d = (/ PrevTimeLong /), c1 = 'sec' )
      call MessageNotify( 'M', module_name, '    PrevTimeShort = %f [%c]', &
      & d = (/ PrevTimeShort /), c1 = 'sec' )
    end if

    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim( RstOutputFile ) )
    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c] (same as IntTime in "restart_file_io" module)', &
      & d = (/ RstFileIntValue /), c1 = trim( RstFileIntUnit ) )
!
    call MessageNotify( 'M', module_name, '  SolarConst   = %f', d = (/ SolarConst /) )
    call MessageNotify( 'M', module_name, 'DelTime:' )
    call MessageNotify( 'M', module_name, '  DelTimeLong  = %f [%c]', &
      & d = (/ DelTimeLongValue /), c1 = trim( DelTimeLongUnit ) )
    call MessageNotify( 'M', module_name, '  DelTimeShort = %f [%c]', &
      & d = (/ DelTimeShortValue /), c1 = trim( DelTimeShortUnit ) )
!
    call MessageNotify( 'M', module_name, 'LongFlux:' )
    call MessageNotify( 'M', module_name, '  LongBandNum            = %d', i = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongAbsorpCoefQVap     = (/ %*r /)', &
      & r = real( LongAbsorpCoefQVap(1:LongBandNum) ), n = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongAbsorpCoefDryAir   = (/ %*r /)', &
      & r = real( LongAbsorpCoefDryAir(1:LongBandNum) ), n = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongBandWeight         = (/ %*r /)', &
      & r = real( LongBandWeight(1:LongBandNum) ), n = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongPathLengthFact     = %f', d = (/ LongPathLengthFact /) )
!
    call MessageNotify( 'M', module_name, 'ShortFlux:' )
    call MessageNotify( 'M', module_name, '  ShortBandNum           = %d', i = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortAbsorpCoefQVap    = (/ %*r /)', &
      & r = real( ShortAbsorpCoefQVap(1:ShortBandNum) ), n = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortAbsorpCoefDryAir  = (/ %*r /)', &
      & r = real( ShortAbsorpCoefDryAir(1:ShortBandNum) ), n = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortBandWeight        = (/ %*r /)', &
      & r = real( ShortBandWeight(1:ShortBandNum) ), n = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortSecScat           = %f', d = (/ ShortSecScat /) )
    call MessageNotify( 'M', module_name, '  ShortAtmosAlbedo       = %f', d = (/ ShortAtmosAlbedo /) )

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_DennouAGCM_inited = .true.

  end subroutine RadDennouAGCMInit

  !--------------------------------------------------------------------------------------

  subroutine RadDennouAGCMFinalize
    !
    ! ꥹȥեΥ, 
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Close a restart file, and 
    ! deallocate variables in this module. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use gtool_history, only: HistoryClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. rad_DennouAGCM_inited ) return


    ! ǥե᤹ͤ
    ! Return to default values
    !
    Old_Flux_saved = .false.

    ! ꥹȥեΥ
    ! close a restart file
    !
    call HistoryClose( history = gthst_rst ) ! (inout)

    ! դ
    ! Deallocation
    !
    if ( allocated( xy_IncomRadSFlux       ) ) deallocate( xy_IncomRadSFlux       )
    if ( allocated( xy_InAngle             ) ) deallocate( xy_InAngle             )
    if ( allocated( xy_TempSave            ) ) deallocate( xy_TempSave            )
    if ( allocated( xyr_RadSUwFluxSave     ) ) deallocate( xyr_RadSUwFluxSave     )
    if ( allocated( xyr_RadSDwFluxSave     ) ) deallocate( xyr_RadSDwFluxSave     )
    if ( allocated( xyr_RadLUwFluxSave     ) ) deallocate( xyr_RadLUwFluxSave     )
    if ( allocated( xyr_RadLDwFluxSave     ) ) deallocate( xyr_RadLDwFluxSave     )
    if ( allocated( xyra_DelRadLUwFluxSave ) ) deallocate( xyra_DelRadLUwFluxSave )
    if ( allocated( xyra_DelRadLDwFluxSave ) ) deallocate( xyra_DelRadLDwFluxSave )

    rad_DennouAGCM_inited = .false.


  end subroutine RadDennouAGCMFinalize

  !--------------------------------------------------------------------------------------

end module rad_DennouAGCM
